/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.isisfish.simulator.launcher;

import fr.ifremer.isisfish.IsisConfig;
import fr.ifremer.isisfish.IsisFishRuntimeException;
import fr.ifremer.isisfish.datastore.SimulationStorage;
import fr.ifremer.isisfish.entities.Observation;
import fr.ifremer.isisfish.export.ExportInfo;
import fr.ifremer.isisfish.simulator.Objective;
import fr.ifremer.isisfish.simulator.Optimization;
import fr.ifremer.isisfish.simulator.OptimizationContextInternal;
import fr.ifremer.isisfish.simulator.SimulationControl;
import fr.ifremer.isisfish.simulator.SimulationParameter;
import fr.ifremer.isisfish.simulator.launcher.SimulationItem;
import fr.ifremer.isisfish.simulator.launcher.SimulationJob;
import fr.ifremer.isisfish.simulator.launcher.SimulationService;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.zip.GZIPInputStream;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;
import org.nuiton.math.matrix.MatrixND;

public class OptimizationPrepareJob
implements Runnable,
SimulationJob.PostAction {
    private static final Log log = LogFactory.getLog(OptimizationPrepareJob.class);
    protected SimulationService simulationService;
    protected OptimizationContextInternal optimizationContext;
    protected SimulationJob job;
    protected String id;
    protected SimulationControl control;
    protected SimulationParameter param;
    protected Objective objective;
    protected Optimization optimization;
    protected int simNumber = 0;
    protected int done = 0;
    protected boolean exception = false;

    public OptimizationPrepareJob(SimulationService simulationService, SimulationJob job) {
        this.simulationService = simulationService;
        this.job = job;
        this.id = job.getItem().getControl().getId();
        this.control = job.getItem().getControl();
        this.param = job.getItem().getParameter();
        this.objective = this.param.getObjective();
        this.optimization = this.param.getOptimization();
        this.optimizationContext = new OptimizationContextInternal(this.id, this.param, job);
    }

    @Override
    public void run() {
        try {
            this.optimization.init(this.optimizationContext);
            this.optimization.firstSimulation(this.optimizationContext);
            List<SimulationStorage> sims = this.optimizationContext.clearNextSimulation();
            while (!this.exception && !this.control.isStopSimulationRequest() && CollectionUtils.isNotEmpty(sims)) {
                for (SimulationStorage s : sims) {
                    if (this.exception || this.control.isStopSimulationRequest()) continue;
                    String simId = s.getName();
                    File zip = s.createZip();
                    s.closeStorage();
                    SimulationParameter childParam = s.getParameter();
                    int childNumber = childParam.getSimulationPlanNumber();
                    SimulationControl childControl = new SimulationControl(simId);
                    SimulationItem item = new SimulationItem(childControl, childParam);
                    item.setStandaloneSimulation(true);
                    item.setSimulationNumber(childNumber);
                    item.setSimulationZip(zip);
                    SimulationJob subJob = new SimulationJob(this.simulationService, this.job, item, this.job.getPriority());
                    subJob.setLauncher(this.job.getLauncher());
                    subJob.addPostAction(this);
                    this.simulationService.submitSubJob(subJob);
                    ++this.simNumber;
                }
                this.control.setProgressMax(this.simNumber);
                while (!this.exception && !this.control.isStopSimulationRequest() && this.simNumber > this.done) {
                    Thread.sleep(2000L);
                }
                if (this.exception || this.control.isStopSimulationRequest()) continue;
                this.optimization.endSimulation(this.optimizationContext);
                this.optimizationContext.incGenerationNumber();
                for (SimulationStorage sim : sims) {
                    sim.closeStorage();
                    sim.closeMemStorage();
                }
                this.optimization.nextSimulation(this.optimizationContext);
                sims = this.optimizationContext.clearNextSimulation();
            }
            if (!this.exception && !this.control.isStopSimulationRequest()) {
                this.optimization.finish(this.optimizationContext);
            }
        }
        catch (Exception eee) {
            if (log.isErrorEnabled()) {
                log.error((Object)I18n.t((String)"isisfish.error.evaluate.optimization.script", (Object[])new Object[0]), (Throwable)eee);
            }
            throw new IsisFishRuntimeException(I18n.t((String)"isisfish.error.evaluate.optimization.script", (Object[])new Object[0]), eee);
        }
        finally {
            this.simulationService.fireStopEvent(this.job);
        }
    }

    @Override
    public void finished(SimulationJob job, SimulationStorage sim) {
        if (this.objective != null) {
            try {
                ArrayList<MatrixND> exports = new ArrayList<MatrixND>();
                ArrayList<MatrixND> observations = new ArrayList<MatrixND>();
                Map<ExportInfo, Observation> exportsObservations = sim.getParameter().getOptimizationExportsObservations();
                for (Map.Entry<ExportInfo, Observation> exportObservation : exportsObservations.entrySet()) {
                    String fullFilename;
                    ExportInfo export = exportObservation.getKey();
                    Observation observation = exportObservation.getValue();
                    File rootDirectory = sim.getDirectory();
                    File resultExportDirectory = SimulationStorage.getResultExportDirectory(rootDirectory);
                    File exportFile = new File(resultExportDirectory, fullFilename = export.getExportFilename() + export.getExtensionFilename());
                    if (!exportFile.isFile() && !StringUtils.endsWithIgnoreCase((CharSequence)fullFilename, (CharSequence)".gz")) {
                        fullFilename = fullFilename + ".gz";
                        exportFile = new File(resultExportDirectory, fullFilename);
                    }
                    BufferedReader reader = StringUtils.endsWithIgnoreCase((CharSequence)fullFilename, (CharSequence)".gz") ? new BufferedReader(new InputStreamReader((InputStream)new GZIPInputStream(new FileInputStream(exportFile)), IsisConfig.charset)) : new BufferedReader(new FileReader(exportFile));
                    MatrixND exportMatrix = null;
                    if (observation.getValue() != null) {
                        exportMatrix = observation.getValue().clone();
                        exportMatrix.importCSV((Reader)reader, new int[]{0, 0});
                    }
                    exports.add(exportMatrix);
                    observations.add(observation.getValue());
                }
                double obj = this.objective.eval(this.optimizationContext, exports, observations);
                sim.setObjective(obj);
            }
            catch (IOException eee) {
                throw new IsisFishRuntimeException("Can't evaluate objective", eee);
            }
        }
        ++this.done;
        this.control.setProgress(this.done);
    }

    @Override
    public void exception(SimulationJob job, Throwable eee) {
        this.exception = true;
    }
}

