/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.isisfish.simulator;

import fr.ifremer.isisfish.datastore.SimulationStorage;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.math.matrix.MatrixFactory;
import org.nuiton.math.matrix.MatrixIterator;
import org.nuiton.math.matrix.MatrixND;

public class Historic {
    private static Log log = LogFactory.getLog(Historic.class);
    protected String id;
    protected Map<Integer, Experience> experiences = new LinkedHashMap<Integer, Experience>();

    public Historic(String id) {
        this.id = id;
    }

    public Experience get(SimulationStorage sim) {
        int simNumber = sim.getParameter().getSimulationPlanNumber();
        Experience result = this.experiences.get(simNumber);
        if (result == null) {
            result = new Experience();
            this.experiences.put(simNumber, result);
            result.set("SimulationNumnber", simNumber);
            result.set("Generation", sim.getParameter().getOptimizationGeneration());
            result.set("Individual", sim.getParameter().getOptimizationGenerationIndividual());
        }
        return result;
    }

    public MatrixND toMatrix(String ... fieldNames) {
        ArrayList<String> semVar = new ArrayList<String>();
        semVar.add("Generation");
        semVar.add("Individual");
        for (String f : fieldNames) {
            semVar.add(f);
        }
        ArrayList<Double> semExp = new ArrayList<Double>();
        for (Experience e : this.experiences.values()) {
            semExp.add(e.get("SimulationNumnber"));
        }
        List[] sems = new List[]{semExp, semVar};
        String[] dimNames = new String[]{"Experience", "Variables"};
        MatrixND result = MatrixFactory.getInstance().create(this.id, sems, dimNames);
        MatrixIterator i = result.iterator();
        while (i.hasNext()) {
            i.next();
            Object[] s = i.getSemanticsCoordinates();
            Object exp = s[0];
            String var = (String)s[1];
            Double v = this.experiences.get(exp).get(var);
            if (v == null) continue;
            i.setValue(v.doubleValue());
        }
        return result;
    }

    public String toCSV(String ... fieldNames) {
        StringBuilder result = new StringBuilder();
        String sep = ";";
        result.append("SimulationNumber");
        result.append(sep);
        result.append("Generation");
        result.append(sep);
        result.append("Individual");
        for (String field : fieldNames) {
            result.append(sep).append(field);
        }
        for (Map.Entry entry : this.experiences.entrySet()) {
            Experience exp = (Experience)entry.getValue();
            result.append(entry.getKey());
            result.append(sep);
            result.append(exp.get("Generation"));
            result.append(sep);
            result.append(exp.get("Individual"));
            for (String field : fieldNames) {
                result.append(sep);
                Double value = exp.get(field);
                if (value != null) {
                    result.append(value);
                    continue;
                }
                result.append("NA");
            }
        }
        return result.toString();
    }

    public static class Experience {
        Map<String, Double> values = new HashMap<String, Double>();

        public Double get(String fieldName) {
            Double result = this.values.get(fieldName);
            return result;
        }

        public void set(String fieldName, double value) {
            this.values.put(fieldName, value);
        }
    }
}

