/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.isisfish.logging.console;

import fr.ifremer.isisfish.logging.console.LogConsoleHandler;
import fr.ifremer.isisfish.logging.console.LogConsoleModel;
import fr.ifremer.isisfish.ui.logging.console.LogConsoleUI;
import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.io.File;
import java.io.IOException;
import javax.swing.JCheckBox;
import javax.swing.JScrollBar;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;
import org.nuiton.widget.IconFactory;

public class LogConsole
extends LogConsoleUI
implements ChangeListener {
    private static final long serialVersionUID = 3534645407010584861L;
    private static Log log = LogFactory.getLog(LogConsole.class);
    public static final String EDITOR_SIZE_CHANGED_PROPERTY = "editorSize";
    public static final String DISPOSE_CHANGED_PROPERTY = "dispose";
    public static final String RESET_CHANGED_PROPERTY = "reset";
    public static final String TEXT_CHANGED_PROPERTY = "text";
    public static final String LEVEL_FATAL_CHANGED_PROPERTY = "FATAL";
    public static final String LEVEL_ERROR_CHANGED_PROPERTY = "ERROR";
    public static final String LEVEL_WARN_CHANGED_PROPERTY = "WARN";
    public static final String LEVEL_INFO_CHANGED_PROPERTY = "INFO";
    public static final String LEVEL_DEBUG_CHANGED_PROPERTY = "DEBUG";
    public static final String LEVEL_TRACE_CHANGED_PROPERTY = "TRACE";
    protected LogConsoleModel model;
    private UpdateUI uiUpdater;
    protected boolean disableScroll = true;

    public static LogConsole newConsole(File logFile, String smtpServer, String defaultFrom, String defaultTo, String title) throws IOException, IllegalArgumentException {
        if (!logFile.exists()) {
            String message1 = I18n.t((String)"could not found log file %1$s", (Object[])new Object[]{logFile});
            log.warn((Object)message1);
            throw new IllegalArgumentException(message1);
        }
        LogConsoleModel model = new LogConsoleModel(logFile, 30, smtpServer, defaultFrom, defaultTo);
        LogConsoleHandler handler = new LogConsoleHandler(model);
        long t0 = System.currentTimeMillis();
        handler.start();
        log.info((Object)("handler start in " + (System.currentTimeMillis() - t0)));
        LogConsole ui = new LogConsole(handler, title);
        ui.firePropertyChange(EDITOR_SIZE_CHANGED_PROPERTY, null, ui.getContent());
        handler.read(model.nbLines - (long)model.nbLinesInEditor);
        return ui;
    }

    protected LogConsole(LogConsoleHandler handler, String title) {
        this.model = handler.model;
        this.setTitle(title);
        this.content.setAutoscrolls(false);
        this.scroll.setHorizontalScrollBarPolicy(31);
        this.scroll.setVerticalScrollBarPolicy(21);
        this.reset.setIcon(IconFactory.getIcon((Object)"RESET"));
        this.sendMail.setIcon(IconFactory.getIcon((Object)"MAIL"));
        if (this.sendMail.getIcon() != null) {
            this.sendMail.setText("");
        }
        if (this.reset.getIcon() != null) {
            this.reset.setText("");
        }
        this.initEvents(handler);
        this.uiUpdater = new UpdateUI(this);
        log.info((Object)this);
    }

    @Override
    public void dispose() {
        super.dispose();
        this.firePropertyChange(DISPOSE_CHANGED_PROPERTY, false, true);
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        EventQueue.invokeLater(this.uiUpdater);
    }

    protected void initEvents(final LogConsoleHandler handler) {
        this.setDefaultCloseOperation(2);
        this.addPropertyChangeListener(handler);
        this.model.addChangeListener(this);
        this.content.addMouseWheelListener(handler);
        this.scrollbar.addMouseWheelListener(handler);
        this.scrollbar.addAdjustmentListener(handler);
        this.scroll.addComponentListener(new ComponentListener(){

            @Override
            public void componentResized(ComponentEvent e) {
                LogConsole.this.firePropertyChange(LogConsole.EDITOR_SIZE_CHANGED_PROPERTY, null, LogConsole.this.content);
            }

            @Override
            public void componentMoved(ComponentEvent e) {
            }

            @Override
            public void componentShown(ComponentEvent e) {
            }

            @Override
            public void componentHidden(ComponentEvent e) {
            }
        });
        this.setLevelActionListener(this.levelFatal, LEVEL_FATAL_CHANGED_PROPERTY);
        this.setLevelActionListener(this.levelError, LEVEL_ERROR_CHANGED_PROPERTY);
        this.setLevelActionListener(this.levelWarn, LEVEL_WARN_CHANGED_PROPERTY);
        this.setLevelActionListener(this.levelInfo, LEVEL_INFO_CHANGED_PROPERTY);
        this.setLevelActionListener(this.levelDebug, LEVEL_DEBUG_CHANGED_PROPERTY);
        this.setLevelActionListener(this.levelTrace, LEVEL_TRACE_CHANGED_PROPERTY);
        this.apply.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LogConsole.this.firePropertyChange(LogConsole.TEXT_CHANGED_PROPERTY, null, ".*" + LogConsole.this.message.getText() + ".*");
                LogConsole.this.reset.setEnabled(LogConsole.this.model.canReset());
            }
        });
        this.reset.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LogConsole.this.message.setText("");
                LogConsole.this.levelFatal.setSelected(false);
                LogConsole.this.levelError.setSelected(false);
                LogConsole.this.levelWarn.setSelected(false);
                LogConsole.this.levelInfo.setSelected(false);
                LogConsole.this.levelDebug.setSelected(false);
                LogConsole.this.levelTrace.setSelected(false);
                LogConsole.this.firePropertyChange(LogConsole.RESET_CHANGED_PROPERTY, null, (Object)true);
                LogConsole.this.reset.setEnabled(false);
            }
        });
        this.sendMail.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                handler.openLogMail(LogConsole.this);
            }
        });
    }

    protected void setLevelActionListener(final JCheckBox button, final String property) {
        button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LogConsole.this.firePropertyChange(property, null, (Object)button.isSelected());
                LogConsole.this.reset.setEnabled(LogConsole.this.model.canReset());
            }
        });
    }

    protected class UpdateUI
    implements Runnable {
        private JScrollBar scrollbar;
        protected LogConsole console;
        protected long nbLines;
        protected int increment;

        public UpdateUI(LogConsole logConsole) {
            this.console = logConsole;
            this.scrollbar = logConsole.getScrollbar();
        }

        @Override
        public void run() {
            LogConsole.this.content.setText(this.console.model.getText());
            long nbLines1 = this.console.model.getNbLines();
            if (this.nbLines != nbLines1) {
                this.scrollbar.setMaximum((int)nbLines1 - this.scrollbar.getModel().getExtent());
                this.nbLines = nbLines1;
            }
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (UpdateUI.this.console.model.isBOF()) {
                        UpdateUI.this.console.getContent().setCaretPosition(0);
                        UpdateUI.this.scrollbar.setValue(0);
                        return;
                    }
                    UpdateUI.this.scrollbar.setValue((int)UpdateUI.this.console.model.getFirstLinePosition());
                }
            });
        }
    }
}

