package fr.ifremer.isisfish.ui.input.strategy;

/*
 * #%L
 * ISIS-Fish
 * %%
 * Copyright (C) 1999 - 2015 Ifremer, Codelutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import fr.ifremer.isisfish.entities.Strategy;
import fr.ifremer.isisfish.ui.input.InputContentUI;
import java.awt.LayoutManager;
import javax.swing.JTabbedPane;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.binding.SimpleJAXXObjectBinding;
import jaxx.runtime.swing.TabInfo;
import jaxx.runtime.swing.TabInfoPropertyChangeListener;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import static org.nuiton.i18n.I18n.t;

public class StrategyUI extends InputContentUI<fr.ifremer.isisfish.entities.Strategy> {

    /*-----------------------------------------------------------------------*/
    /*---------------- Constants for all javaBean properties ----------------*/
    /*-----------------------------------------------------------------------*/

    public static final String PROPERTY_BEAN = "bean";

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_STRATEGY_MONTH_INFO_UI_ACTIVE = "strategyMonthInfoUI.active";
    public static final String BINDING_STRATEGY_MONTH_INFO_UI_BEAN = "strategyMonthInfoUI.bean";
    public static final String BINDING_STRATEGY_MONTH_INFO_UI_SENSITIVITY = "strategyMonthInfoUI.sensitivity";
    public static final String BINDING_STRATEGY_TAB_UI_ACTIVE = "strategyTabUI.active";
    public static final String BINDING_STRATEGY_TAB_UI_BEAN = "strategyTabUI.bean";
    public static final String BINDING_STRATEGY_TAB_UI_SENSITIVITY = "strategyTabUI.sensitivity";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAKVUQU8TQRR+rbRYKooQEBQTVEw8mClqNDE1isE0lBQ1VhJiL07ZKR2ynR1nZmF7Mf4Ef4LevZh482Q8ePbgxfgXjPHg1fhm2+62sgqEHnY3773ve998nffefIeMVnBuiwYBUb4wvMXIyt319Qf1LbZh7jG9obg0noLOL5WGdA3yThTXBi7UKhZe6MILS15LeoKJPnSxAiPatF2mm4wZA2cHERtaF6pRuhhIX/VYI1FJrK9+/ki/dF68TgMEEtXl8Chze6HikwxVIM0dA+PYaZsWXCo2UYbiYhP1jtrYkku1vk9b7Bk8h+EKZCVVSGbg/P6PHHKE+EAaGJsvC+mbJU8YLF8rLxhYaCjCG4q1GL411w2um8TnhNtCoo2ihm22SbX7sVaWMuTLGhiqMyoMXExiQHpuONMRMIYNN6lwXKYMXD9Y7+UOrl+A57TRQWtWQPQOekdWHlLB3Lgm36N5TOsGTg2UYqjOHAuwxeMRZrQPs1Y2cO1gOkOUpZqMGCd6RatofbMsGp7lvXkw3j7sIHtuHlvaBP6fpwduYOeg3azcDbhiA3OYUHBmAIhDQeKhiG9tqgYZ5WPYwHRt9xw9wlRngqb/miBLGGZ/T018ef/tXak3NlnsPZlY2jf1eJ2l8iReGm5bn+jMjG+4W1ilsljD4WMuroxwJcwmCKt20ygO+520cGLhZJnqJlJkhr9++Dj19PMRSJdgxPWoU6K2vgw501Toguc6gbyzGCo6tnMUn2NWm4Es1vFt9Oj4LYcaOlfnwkHTbwdowmyCCZGSeu7Tr4nq28WeESkUNvPP8tiMzBPIcuFywcIN0l0OiRsjLzXzHS9eAklrIWXfM7J7Oy6Fz8tJJw3n3WYLgW9fC6Fo+3V13xx5zYTGzbDNTftQVDZM/sMwuy+GG4dmKO7B8AfPj6GD5AYAAA==";
    private static final Log log = LogFactory.getLog(StrategyUI.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    private boolean allComponentsCreated;

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected Strategy bean;
    protected StrategyHandler handler;
    protected StrategyMonthInfoUI strategyMonthInfoUI;
    protected JTabbedPane strategyTab;
    protected StrategyTabUI strategyTabUI;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private StrategyUI $InputContentUI0 = this;
    private TabInfo $TabInfo0;
    private TabInfo $TabInfo1;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/

    protected void $afterCompleteSetup() {
            handler.afterInit();
        }
    
        @Override
        public void setLayer(boolean active) {
            super.setLayer(active);
            strategyTabUI.setLayer(active);
            strategyMonthInfoUI.setLayer(active);
        }
        
        @Override
        public void resetChangeModel() {
            strategyTabUI.resetChangeModel();
            strategyMonthInfoUI.resetChangeModel();
        }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public StrategyUI(LayoutManager param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public StrategyUI(JAXXContext param0, LayoutManager param1, boolean param2) {
        super(param0 ,param1 ,param2);
        $initialize();
    }

    public StrategyUI(LayoutManager param0) {
        super(param0);
        $initialize();
    }

    public StrategyUI(JAXXContext param0, LayoutManager param1) {
        super(param0 ,param1);
        $initialize();
    }

    public StrategyUI() {
        $initialize();
    }

    public StrategyUI(JAXXContext param0) {
        super(param0);
        $initialize();
    }

    public StrategyUI(boolean param0) {
        super(param0);
        $initialize();
    }

    public StrategyUI(JAXXContext param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public Strategy getBean() {
        return bean;
    }

    public StrategyHandler getHandler() {
        return handler;
    }

    public StrategyMonthInfoUI getStrategyMonthInfoUI() {
        return strategyMonthInfoUI;
    }

    public JTabbedPane getStrategyTab() {
        return strategyTab;
    }

    public StrategyTabUI getStrategyTabUI() {
        return strategyTabUI;
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public mutator methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public void setBean(Strategy bean) {
        Strategy oldValue = this.bean;
        this.bean = bean;
        firePropertyChange(PROPERTY_BEAN, oldValue, bean);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected TabInfo get$TabInfo0() {
        return $TabInfo0;
    }

    protected TabInfo get$TabInfo1() {
        return $TabInfo1;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToBody() {
        if (!allComponentsCreated) {
            return;
        }
        body.add(strategyTab);
    }

    protected void addChildrenToStrategyTab() {
        if (!allComponentsCreated) {
            return;
        }
        strategyTab.add(strategyTabUI);
        strategyTab.add(strategyMonthInfoUI);
        $TabInfo0.addPropertyChangeListener(new TabInfoPropertyChangeListener(strategyTab, 0));
        strategyTab.setTitleAt(0, t("isisfish.strategy.title"));
        $TabInfo1.addPropertyChangeListener(new TabInfoPropertyChangeListener(strategyTab, 1));
        strategyTab.setTitleAt(1, t("isisfish.strategyMonthInfo.title"));
    }

    protected void createBean() {
        $objectMap.put("bean", bean = null);
    }

    @Override
    protected void createBody() {
        super.createBody();
        body.setName("body");
    }

    protected void createHandler() {
        $objectMap.put("handler", handler = new StrategyHandler(this));
    }

    protected void createStrategyMonthInfoUI() {
        $objectMap.put("strategyMonthInfoUI", strategyMonthInfoUI = new StrategyMonthInfoUI(this));
        
        strategyMonthInfoUI.setName("strategyMonthInfoUI");
    }

    protected void createStrategyTab() {
        $objectMap.put("strategyTab", strategyTab = new JTabbedPane());
        
        strategyTab.setName("strategyTab");
    }

    protected void createStrategyTabUI() {
        $objectMap.put("strategyTabUI", strategyTabUI = new StrategyTabUI(this));
        
        strategyTabUI.setName("strategyTabUI");
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        addChildrenToBody();
        addChildrenToStrategyTab();
        
        // apply 6 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
        
        $afterCompleteSetup();
    }

    private void $initialize() {
        if (allComponentsCreated) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        $objectMap.put("$InputContentUI0", $InputContentUI0);
        createBean();
        createHandler();
        createStrategyTab();
        createStrategyTabUI();
        createStrategyMonthInfoUI();
        // inline creation of $TabInfo0
        $objectMap.put("$TabInfo0", $TabInfo0 = new TabInfo());
        
        $TabInfo0.setTitle(t("isisfish.strategy.title"));
        // inline creation of $TabInfo1
        $objectMap.put("$TabInfo1", $TabInfo1 = new TabInfo());
        
        $TabInfo1.setTitle(t("isisfish.strategyMonthInfo.title"));
        // inline creation of $InputContentUI0
        setName("$InputContentUI0");
        
        // registers 6 data bindings
        $registerDefaultBindings();
        $completeSetup();
    }

    private void $registerDefaultBindings() {
        // register 6 data bindings
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_STRATEGY_TAB_UI_ACTIVE, true ,"active") {
        
            @Override
            public void processDataBinding() {
                strategyTabUI.setActive(isActive());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_STRATEGY_TAB_UI_BEAN, true ,"bean") {
        
            @Override
            public void processDataBinding() {
                strategyTabUI.setBean(getBean());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_STRATEGY_TAB_UI_SENSITIVITY, true ,"sensitivity") {
        
            @Override
            public void processDataBinding() {
                strategyTabUI.setSensitivity(isSensitivity());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_STRATEGY_MONTH_INFO_UI_ACTIVE, true ,"active") {
        
            @Override
            public void processDataBinding() {
                strategyMonthInfoUI.setActive(isActive());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_STRATEGY_MONTH_INFO_UI_BEAN, true ,"bean") {
        
            @Override
            public void processDataBinding() {
                strategyMonthInfoUI.setBean(getBean());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_STRATEGY_MONTH_INFO_UI_SENSITIVITY, true ,"sensitivity") {
        
            @Override
            public void processDataBinding() {
                strategyMonthInfoUI.setSensitivity(isSensitivity());
            }
        });
    }

}