/*
 * #%L
 * $Id: EffortDescriptionHandler.java 4237 2015-05-27 13:00:56Z echatellier $
 * $HeadURL: http://svn.codelutin.com/isis-fish/trunk/src/main/java/fr/ifremer/isisfish/ui/input/setofvessels/EffortDescriptionHandler.java $
 * %%
 * Copyright (C) 2015 Ifremer, Codelutin, Chatellier Eric
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

package fr.ifremer.isisfish.ui.input.setofvessels;

import static org.nuiton.i18n.I18n.t;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import fr.ifremer.isisfish.IsisFishDAOHelper;
import fr.ifremer.isisfish.entities.EffortDescription;
import fr.ifremer.isisfish.entities.EffortDescriptionDAO;
import fr.ifremer.isisfish.entities.Metier;
import fr.ifremer.isisfish.entities.SetOfVessels;
import fr.ifremer.isisfish.ui.input.InputContentHandler;
import fr.ifremer.isisfish.ui.models.common.GenericListModel;
import fr.ifremer.isisfish.ui.util.ErrorHelper;

/**
 * set of vessels handler.
 */
public class EffortDescriptionHandler extends InputContentHandler<EffortDescriptionUI> {

    /** Class logger. */
    private static final Log log = LogFactory.getLog(EffortDescriptionHandler.class);

    protected EffortDescriptionHandler(EffortDescriptionUI inputContentUI) {
        super(inputContentUI);
    }

    protected void afterInit() {

        inputContentUI.addPropertyChangeListener(EffortDescriptionUI.PROPERTY_BEAN, new PropertyChangeListener() {
            public void propertyChange(PropertyChangeEvent evt) {
                GenericListModel<Metier> metierModel = (GenericListModel<Metier>)inputContentUI.fieldEffortDescriptionMetierList.getModel();
                if (evt.getNewValue() == null) {
                    metierModel.setElementList(null);
                }
                if (evt.getNewValue() != null) {
                    metierModel.setElementList(inputContentUI.getFisheryRegion().getMetier());
                    setEffortDescriptionEffortDescriptionList();
                }
            }
        });
    }
    
    protected void onFieldEffortDescriptionMetierListValueChanged() {
        // active le bouton seulement si l'interface est active
        // dans le cas de sensitivity par exemple
        if (inputContentUI.isActive()) {
            inputContentUI.buttonEffortDescriptionAdd.setEnabled(inputContentUI.fieldEffortDescriptionMetierList.getSelectedIndex() != -1);
        }
    }

    protected void onFieldEffortDescriptionEffortDescriptionListValueChanged() {
        // active le bouton seulement si l'interface est active
        // dans le cas de sensitivity par exemple
        if (inputContentUI.isActive()) {
            inputContentUI.removeEffortDescriptionButton.setEnabled(inputContentUI.fieldEffortDescriptionEffortDescriptionList.getSelectedIndex() != -1);
        }
    }

    protected void setEffortDescriptionEffortDescriptionList() {
        GenericListModel<EffortDescription> model = new GenericListModel<>();
        if (inputContentUI.getBean() != null && inputContentUI.getBean().getPossibleMetiers() != null) {
            List<EffortDescription> effortDescriptions = new ArrayList<>(inputContentUI.getBean().getPossibleMetiers());
            model.setElementList(effortDescriptions);
        }
        inputContentUI.fieldEffortDescriptionEffortDescriptionList.setModel(model);
    }

    protected void addEffortDescriptions() {
         List<Metier> selectedValues = inputContentUI.fieldEffortDescriptionMetierList.getSelectedValuesList();
         for (Metier selectedMetier : selectedValues) {
            addEffortDescription(inputContentUI.getBean(), selectedMetier);
         }
         setEffortDescriptionEffortDescriptionList();
    }

    protected void removeEffortDescriptions() {
         List<EffortDescription> selectedValues = inputContentUI.fieldEffortDescriptionEffortDescriptionList.getSelectedValuesList();
         for (EffortDescription selectedEffortDescription : selectedValues) {
            removeEffortDescription(inputContentUI.getBean(), selectedEffortDescription);
         }
         setEffortDescriptionEffortDescriptionList();
    }
    
    public void addEffortDescription(SetOfVessels setOfVessels, Metier metier) {
        if (log.isDebugEnabled()) {
            log.debug("addEffortDescription called: " + setOfVessels
                    + " metier: " + metier);
        }
        try {
            EffortDescriptionDAO effortDescriptionPS = IsisFishDAOHelper
                    .getEffortDescriptionDAO(metier.getTopiaContext());
            EffortDescription effortDescription = effortDescriptionPS.create();
            // EC20090715 : c'est la classe d'association
            // qui en étant sauvee, sauve les relations en base
            // il faut bien faire les set des deux cotes
            effortDescription.setSetOfVessels(setOfVessels);
            effortDescription.setPossibleMetiers(metier);
            effortDescription.update();
            setOfVessels.addPossibleMetiers(effortDescription);
            setOfVessels.update();
        } catch (Exception eee) {
            if (log.isErrorEnabled()) {
                log.error("Can't create EffortDescription", eee);
            }
            ErrorHelper.showErrorDialog(t("isisfish.error.input.addentity",
                    "EffortDescription"), eee);
        }
    }

    public void removeEffortDescription(SetOfVessels sov,
            EffortDescription effort) {
        if (log.isTraceEnabled()) {
            log.trace("removeEffortDescription called");
        }
        try {
            sov.removePossibleMetiers(effort);
            // EC-20091112 : commit() twice cause hibernate error:
            // Found two representations of same collection:
            //sov.getTopiaContext().commitTransaction();
        } catch (Exception eee) {
            if (log.isErrorEnabled()) {
                log.error("Can't remove entity: " + effort, eee);
            }
            ErrorHelper.showErrorDialog(t("isisfish.error.input.removeentity",
                    "EffortDescription"), eee);
        }
    }
}
