package fr.ifremer.isisfish.ui.input.port;

/*
 * #%L
 * ISIS-Fish
 * %%
 * Copyright (C) 1999 - 2015 Ifremer, Codelutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import com.bbn.openmap.InformationDelegator;
import fr.ifremer.isisfish.entities.Cell;
import fr.ifremer.isisfish.entities.Port;
import fr.ifremer.isisfish.map.IsisMapBean;
import fr.ifremer.isisfish.ui.input.InputContentUI;
import java.awt.BorderLayout;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.JAXXValidator;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.binding.DefaultJAXXBinding;
import jaxx.runtime.binding.SimpleJAXXObjectBinding;
import jaxx.runtime.swing.Table;
import jaxx.runtime.validator.swing.SwingValidator;
import jaxx.runtime.validator.swing.SwingValidatorUtil;
import jaxx.runtime.validator.swing.meta.Validator;
import jaxx.runtime.validator.swing.meta.ValidatorField;
import jaxx.runtime.validator.swing.ui.ImageValidationUI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import static org.nuiton.i18n.I18n.t;

public class PortUI extends InputContentUI<Port> implements JAXXValidator {

    /*-----------------------------------------------------------------------*/
    /*---------------- Constants for all javaBean properties ----------------*/
    /*-----------------------------------------------------------------------*/

    public static final String PROPERTY_BEAN = "bean";
    public static final String PROPERTY_PORT_MAP = "portMap";

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_CANCEL_ENABLED = "cancel.enabled";
    public static final String BINDING_CREATE_ENABLED = "create.enabled";
    public static final String BINDING_DELETE_ENABLED = "delete.enabled";
    public static final String BINDING_FIELD_PORT_COMMENT_ENABLED = "fieldPortComment.enabled";
    public static final String BINDING_FIELD_PORT_COMMENT_TEXT = "fieldPortComment.text";
    public static final String BINDING_FIELD_PORT_NAME_ENABLED = "fieldPortName.enabled";
    public static final String BINDING_FIELD_PORT_NAME_TEXT = "fieldPortName.text";
    public static final String BINDING_PORT_CELL_ENABLED = "portCell.enabled";
    public static final String BINDING_PORT_MAP_ENABLED = "portMap.enabled";
    public static final String BINDING_PORT_MAP_FISHERY_REGION = "portMap.fisheryRegion";
    public static final String BINDING_PORT_MAP_SELECTED_CELLS = "portMap.selectedCells";
    public static final String BINDING_SAVE_ENABLED = "save.enabled";
    public static final String BINDING_VALIDATOR_BEAN = "validator.bean";

    /*-----------------------------------------------------------------------*/
    /*--------------- Constants for all none public bindings  ---------------*/
    /*-----------------------------------------------------------------------*/

    private static final String BINDING_$JLABEL0_ENABLED = "$JLabel0.enabled";
    private static final String BINDING_$JLABEL1_ENABLED = "$JLabel1.enabled";
    private static final String BINDING_$JLABEL2_ENABLED = "$JLabel2.enabled";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAKVWz28bRRSeuEncJA2ERklTNYi0dasK1HWKQAgl9FdKVEcOTesUVfjC7O7Ynmo8M8zMppsL6p/AnwB3LkjcOCEOnDn0UvEvIMSBK+LNrr3rTbb2SuvD2p73vW++9/bNt/vjX2hGK3T5OQ5DRwXc0D5x9u49e/bIfU4884BoT1FphELxZ6qCKm204Cfr2qCr7aZNrw/S6zuiLwUnfCR7q4nmtTlmRPcIMQa9m83wtK63kvBWKAM1ZE1E5bF+/8/fle/8lz9UEAolqFuFUjYmZaWVTDdRhfoGnYedjnCdYd4FGYryLuhdtGs7DGv9Be6Tb9C3qNpEsxIrIDPoSvGSI44oP5QGLdUaXAZmR3AD8KeNTYNudJRDO4r0CXxrqjtU95yAOtQCHSmUcQ7g8rQhZcQza9C0SzA36HJeJtBSQ4mOktKUag9znxFl0M1i+z2M8SnD3BFm1MdQm0EfZLqcBBz9ArrntOz1y+HiqGzhH0O/bWvDAXbvAHPCUsy52l5LMmrsMjRnNYNNIha8ktZWO8Qus/C1jK44K4pZ5FqScLa218QuYZsnxUSrFnQpwS52KGG+7YgdhJOKDklodi0gmzTc4Jb9v5GNzWtp2XYIYwZdyNbnKcHYsMAROpkkvJPVS7WxmOundv4wZ+fF2sgOm3bxRhawlNQKE92PJn3lVLn3FMEW76T3VeMj6MxyBno/MEbwLP+sh7kXN/jjkxFgNSQv4hNGciNn+ljanxeyN7dqm7WP4bBdzZt0SHIa8AcQ9+EU2aTtJHdhkNvgHWFQzRN9x3W5IyThUR4sqz42VPAHoKprx3tAoNClzOyBpzmpp6WmM9VGMyqAZRjW9mkbfAKh2ADXThigJYyi/60uv/rlz593h663Dnuv5EJHTBvcSCooQ1lrMOjt2PICQ1kdyt1qozkNBXmxo6/nCGsNwiAO9oum0LHpzkOse0AxU33962+rX/9xBlV20TwT2N/FFt9Ac6anoAuC+aG8czdSdO7FWbguWW2gxadH1CeqKbyos3AmtylnlJMNbMCO3cCQ2yF0ZD2nI4ksd+73f5dbP90ddmUKVF58IzztzMxXaDbeLXoaDIw+1/0XpCaBL1JDz7P4Kft9UQ4MrRFd9/PKPg8PjEMReL3PQwlWOzSpgzCwX4+jEuyvVmHGBaEonNmoiSWpqoRbQfBwfGsbTBxvuJT7cKxv51O+V4By2oB3jJE1mcMuR87j5jNcKcTQLc0wTsO14hre0IdiDOM0vF/gbizGxx0mZV/4pBTZJDk3S7ekGMM4DbdKj0YxhnEaPirdh2IM4zR8UlpDMYZxGj4traEYwzgNW6U1TGaAVxeGj0Vgxuj4rHQld4ocdvviQ9TxE9IdPBrKkMXOQXz7PqpLkdnllxMY/gdy+SlMog4AAA==";
    private static final Log log = LogFactory.getLog(PortUI.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    private boolean allComponentsCreated;

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected Port bean;
    protected JButton cancel;
    protected JButton create;
    protected JButton delete;
    protected JTextArea fieldPortComment;
    @ValidatorField( validatorId = "validator",  propertyName = "name",  editorName = "fieldPortName")
    protected JTextField fieldPortName;
    protected PortHandler handler;
    protected JPanel map;
    protected JList<Cell> portCell;
    protected IsisMapBean portMap;
    protected InformationDelegator portMapInfo;
    protected JButton save;
    @ValidatorField( validatorId = "validator",  propertyName = "cell",  editorName = "spPortCell")
    protected JScrollPane spPortCell;
    @Validator( validatorId = "validator")
    protected SwingValidator<Port> validator;
    protected List<String> validatorIds = new ArrayList<String>();

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private PortUI $InputContentUI0 = this;
    private JLabel $JLabel0;
    private JLabel $JLabel1;
    private JLabel $JLabel2;
    private JScrollPane $JScrollPane0;
    private JSplitPane $JSplitPane0;
    private Table $Table0;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/

    protected void $afterCompleteSetup() {
            handler.afterInit();
        }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public PortUI(LayoutManager param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public PortUI(JAXXContext param0, LayoutManager param1, boolean param2) {
        super(param0 ,param1 ,param2);
        $initialize();
    }

    public PortUI(LayoutManager param0) {
        super(param0);
        $initialize();
    }

    public PortUI(JAXXContext param0, LayoutManager param1) {
        super(param0 ,param1);
        $initialize();
    }

    public PortUI() {
        $initialize();
    }

    public PortUI(JAXXContext param0) {
        super(param0);
        $initialize();
    }

    public PortUI(boolean param0) {
        super(param0);
        $initialize();
    }

    public PortUI(JAXXContext param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*-------------------- JAXXValidator implementation  --------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public SwingValidator<?> getValidator(String validatorId) {
        return (SwingValidator<?>) (validatorIds.contains(validatorId) ? getObjectById(validatorId) : null);
    }

    @Override
    public List<String> getValidatorIds() {
        return validatorIds;
    }

    @Override
    public void registerValidatorFields() {
        SwingValidatorUtil.detectValidatorFields(this);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doActionPerformed__on__cancel(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getSaveVerifier().cancel();
    }

    public void doActionPerformed__on__create(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getSaveVerifier().create(Port.class);
    }

    public void doActionPerformed__on__delete(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getSaveVerifier().delete();
    }

    public void doActionPerformed__on__save(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getSaveVerifier().save();validator.setChanged(false);
    }

    public void doKeyReleased__on__fieldPortComment(KeyEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getBean().setComment(fieldPortComment.getText());
    }

    public void doKeyReleased__on__fieldPortName(KeyEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getBean().setName(fieldPortName.getText());
    }

    public void doValueChanged__on__portCell(ListSelectionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.portChanged();
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public Port getBean() {
        return bean;
    }

    public JButton getCancel() {
        return cancel;
    }

    public JButton getCreate() {
        return create;
    }

    public JButton getDelete() {
        return delete;
    }

    public JTextArea getFieldPortComment() {
        return fieldPortComment;
    }

    public JTextField getFieldPortName() {
        return fieldPortName;
    }

    public PortHandler getHandler() {
        return handler;
    }

    public JPanel getMap() {
        return map;
    }

    public JList<Cell> getPortCell() {
        return portCell;
    }

    public IsisMapBean getPortMap() {
        return portMap;
    }

    public InformationDelegator getPortMapInfo() {
        return portMapInfo;
    }

    public JButton getSave() {
        return save;
    }

    public JScrollPane getSpPortCell() {
        return spPortCell;
    }

    public SwingValidator<Port> getValidator() {
        return validator;
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public mutator methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public void setBean(Port bean) {
        Port oldValue = this.bean;
        this.bean = bean;
        firePropertyChange(PROPERTY_BEAN, oldValue, bean);
    }

    public void setPortMap(IsisMapBean portMap) {
        IsisMapBean oldValue = this.portMap;
        this.portMap = portMap;
        firePropertyChange(PROPERTY_PORT_MAP, oldValue, portMap);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected JLabel get$JLabel0() {
        return $JLabel0;
    }

    protected JLabel get$JLabel1() {
        return $JLabel1;
    }

    protected JLabel get$JLabel2() {
        return $JLabel2;
    }

    protected JScrollPane get$JScrollPane0() {
        return $JScrollPane0;
    }

    protected JSplitPane get$JSplitPane0() {
        return $JSplitPane0;
    }

    protected Table get$Table0() {
        return $Table0;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToBody() {
        if (!allComponentsCreated) {
            return;
        }
        body.add($JSplitPane0);
    }

    protected void addChildrenToMap() {
        if (!allComponentsCreated) {
            return;
        }
        map.add(SwingUtil.boxComponentWithJxLayer(portMap), BorderLayout.CENTER);
        map.add(portMapInfo, BorderLayout.SOUTH);
    }

    protected void addChildrenToSpPortCell() {
        if (!allComponentsCreated) {
            return;
        }
        spPortCell.getViewport().add(SwingUtil.boxComponentWithJxLayer(portCell));
    }

    protected void addChildrenToValidator() {
        if (!allComponentsCreated) {
            return;
        }
        validator.setUiClass(ImageValidationUI.class);
    }

    protected void createBean() {
        $objectMap.put("bean", bean = null);
    }

    @Override
    protected void createBody() {
        super.createBody();
        body.setName("body");
    }

    protected void createCancel() {
        $objectMap.put("cancel", cancel = new JButton());
        
        cancel.setName("cancel");
        cancel.setText(t("isisfish.common.cancel"));
        cancel.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__cancel"));
    }

    protected void createCreate() {
        $objectMap.put("create", create = new JButton());
        
        create.setName("create");
        create.setText(t("isisfish.common.new"));
        create.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__create"));
    }

    protected void createDelete() {
        $objectMap.put("delete", delete = new JButton());
        
        delete.setName("delete");
        delete.setText(t("isisfish.common.remove"));
        delete.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__delete"));
    }

    protected void createFieldPortComment() {
        $objectMap.put("fieldPortComment", fieldPortComment = new JTextArea());
        
        fieldPortComment.setName("fieldPortComment");
        fieldPortComment.setColumns(15);
        fieldPortComment.setLineWrap(true);
        fieldPortComment.setWrapStyleWord(true);
        fieldPortComment.addKeyListener(JAXXUtil.getEventListener(KeyListener.class, "keyReleased", this, "doKeyReleased__on__fieldPortComment"));
    }

    protected void createFieldPortName() {
        $objectMap.put("fieldPortName", fieldPortName = new JTextField());
        
        fieldPortName.setName("fieldPortName");
        fieldPortName.setColumns(15);
        fieldPortName.addKeyListener(JAXXUtil.getEventListener(KeyListener.class, "keyReleased", this, "doKeyReleased__on__fieldPortName"));
    }

    protected void createHandler() {
        $objectMap.put("handler", handler = new PortHandler(this));
    }

    protected void createMap() {
        $objectMap.put("map", map = new JPanel());
        
        map.setName("map");
        map.setLayout(new BorderLayout());
    }

    protected void createPortCell() {
        $objectMap.put("portCell", portCell = new JList<Cell>());
        
        portCell.setName("portCell");
        portCell.addListSelectionListener(JAXXUtil.getEventListener(ListSelectionListener.class, "valueChanged", this, "doValueChanged__on__portCell"));
    }

    protected void createPortMap() {
        $objectMap.put("portMap", portMap = new fr.ifremer.isisfish.map.IsisMapBean());
        
        portMap.setName("portMap");
    }

    protected void createPortMapInfo() {
        $objectMap.put("portMapInfo", portMapInfo = new InformationDelegator());
        
        portMapInfo.setName("portMapInfo");
    }

    protected void createSave() {
        $objectMap.put("save", save = new JButton());
        
        save.setName("save");
        save.setText(t("isisfish.common.save"));
        save.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__save"));
    }

    protected void createSpPortCell() {
        $objectMap.put("spPortCell", spPortCell = new JScrollPane());
        
        spPortCell.setName("spPortCell");
    }

    protected void createValidator() {
        $objectMap.put("validator", validator = SwingValidator.newValidator(Port.class, null));
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        addChildrenToValidator();
        addChildrenToBody();
        // inline complete setup of $JSplitPane0
        $JSplitPane0.add($Table0, JSplitPane.LEFT);
        $JSplitPane0.add(map, JSplitPane.RIGHT);
        // inline complete setup of $Table0
        $Table0.add($JLabel0, new GridBagConstraints(0, 0, 2, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(SwingUtil.boxComponentWithJxLayer(SwingUtil.boxComponentWithJxLayer(fieldPortName)), new GridBagConstraints(0, 1, 2, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add($JLabel1, new GridBagConstraints(0, 2, 2, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(SwingUtil.boxComponentWithJxLayer(spPortCell), new GridBagConstraints(0, 3, 2, 1, 1.0, 0.7, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add($JLabel2, new GridBagConstraints(0, 4, 2, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add($JScrollPane0, new GridBagConstraints(0, 5, 2, 1, 1.0, 0.3, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(SwingUtil.boxComponentWithJxLayer(save), new GridBagConstraints(0, 6, 1, 1, 0.5, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(SwingUtil.boxComponentWithJxLayer(cancel), new GridBagConstraints(1, 6, 1, 1, 0.5, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(SwingUtil.boxComponentWithJxLayer(create), new GridBagConstraints(0, 7, 1, 1, 0.5, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(SwingUtil.boxComponentWithJxLayer(delete), new GridBagConstraints(1, 7, 1, 1, 0.5, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        addChildrenToSpPortCell();
        // inline complete setup of $JScrollPane0
        $JScrollPane0.getViewport().add(SwingUtil.boxComponentWithJxLayer(fieldPortComment));
        addChildrenToMap();
        
        // apply 16 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
        
        // apply 3 property setters
        portCell.setSelectionMode(javax.swing.ListSelectionModel.SINGLE_SELECTION);
        portMap.setSelectionMode(fr.ifremer.isisfish.map.CellSelectionLayer.SINGLE_SELECTION);
        // late initializer
        // register 1 validator(s)
        validatorIds = SwingValidatorUtil.detectValidators(this);
        SwingValidatorUtil.installUI(this);
        
        $afterCompleteSetup();
    }

    private void $initialize() {
        if (allComponentsCreated) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        $objectMap.put("$InputContentUI0", $InputContentUI0);
        createBean();
        createHandler();
        createValidator();
        // inline creation of $JSplitPane0
        $objectMap.put("$JSplitPane0", $JSplitPane0 = new JSplitPane());
        
        $JSplitPane0.setName("$JSplitPane0");
        $JSplitPane0.setDividerLocation(270);
        $JSplitPane0.setOneTouchExpandable(true);
        $JSplitPane0.setOrientation(1);
        // inline creation of $Table0
        $objectMap.put("$Table0", $Table0 = new Table());
        
        $Table0.setName("$Table0");
        // inline creation of $JLabel0
        $objectMap.put("$JLabel0", $JLabel0 = new JLabel());
        
        $JLabel0.setName("$JLabel0");
        $JLabel0.setText(t("isisfish.port.name"));
        createFieldPortName();
        // inline creation of $JLabel1
        $objectMap.put("$JLabel1", $JLabel1 = new JLabel());
        
        $JLabel1.setName("$JLabel1");
        $JLabel1.setText(t("isisfish.port.cell"));
        createSpPortCell();
        createPortCell();
        // inline creation of $JLabel2
        $objectMap.put("$JLabel2", $JLabel2 = new JLabel());
        
        $JLabel2.setName("$JLabel2");
        $JLabel2.setText(t("isisfish.port.comments"));
        // inline creation of $JScrollPane0
        $objectMap.put("$JScrollPane0", $JScrollPane0 = new JScrollPane());
        
        $JScrollPane0.setName("$JScrollPane0");
        createFieldPortComment();
        createSave();
        createCancel();
        createCreate();
        createDelete();
        createMap();
        createPortMap();
        createPortMapInfo();
        // inline creation of $InputContentUI0
        setName("$InputContentUI0");
        
        // registers 16 data bindings
        $registerDefaultBindings();
        $completeSetup();
    }

    private void $registerDefaultBindings() {
        // register 16 data bindings
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_VALIDATOR_BEAN, true ,"bean") {
        
            @Override
            public void processDataBinding() {
                validator.setBean(getBean());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_$JLABEL0_ENABLED, true ,"active") {
        
            @Override
            public void processDataBinding() {
                $JLabel0.setEnabled(isActive());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_FIELD_PORT_NAME_ENABLED, true ,"active") {
        
            @Override
            public void processDataBinding() {
                fieldPortName.setEnabled(isActive());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_FIELD_PORT_NAME_TEXT, true ,"bean") {
        
            @Override
            public void processDataBinding() {
                if (getBean() != null) {
                    SwingUtil.setText(fieldPortName, SwingUtil.getStringValue(getBean().getName()));
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_$JLABEL1_ENABLED, true ,"active") {
        
            @Override
            public void processDataBinding() {
                $JLabel1.setEnabled(isActive());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_PORT_CELL_ENABLED, true ,"active") {
        
            @Override
            public void processDataBinding() {
                portCell.setEnabled(isActive());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_$JLABEL2_ENABLED, true ,"active") {
        
            @Override
            public void processDataBinding() {
                $JLabel2.setEnabled(isActive());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_FIELD_PORT_COMMENT_ENABLED, true ,"active") {
        
            @Override
            public void processDataBinding() {
                fieldPortComment.setEnabled(isActive());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_FIELD_PORT_COMMENT_TEXT, true ,"bean") {
        
            @Override
            public void processDataBinding() {
                if (getBean() != null) {
                    SwingUtil.setText(fieldPortComment, SwingUtil.getStringValue(getBean().getComment()));
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_SAVE_ENABLED, true, true) {
        
            @Override
            public void applyDataBinding() {
                if (validator != null) {
                    validator.addPropertyChangeListener("valid", this);
                }
                if (validator != null) {
                    validator.addPropertyChangeListener("changed", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (validator != null) {
                    save.setEnabled(validator.isValid() && validator.isChanged());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (validator != null) {
                    validator.removePropertyChangeListener("valid", this);
                }
                if (validator != null) {
                    validator.removePropertyChangeListener("changed", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_CANCEL_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (validator != null) {
                    validator.addPropertyChangeListener("changed", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (validator != null) {
                    cancel.setEnabled(validator.isChanged());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (validator != null) {
                    validator.removePropertyChangeListener("changed", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_CREATE_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (validator != null) {
                    validator.addPropertyChangeListener("changed", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (validator != null) {
                    create.setEnabled(!validator.isChanged());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (validator != null) {
                    validator.removePropertyChangeListener("changed", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_DELETE_ENABLED, true, true) {
        
            @Override
            public void applyDataBinding() {
                if (validator != null) {
                    validator.addPropertyChangeListener("changed", this);
                }
                addPropertyChangeListener("bean", this);
            }
        
            @Override
            public void processDataBinding() {
                if (validator != null) {
                    delete.setEnabled(!validator.isChanged() && getBean() != null);
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (validator != null) {
                    validator.removePropertyChangeListener("changed", this);
                }
                removePropertyChangeListener("bean", this);
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_PORT_MAP_ENABLED, true ,"bean") {
        
            @Override
            public void processDataBinding() {
                portMap.setEnabled(getBean() != null);
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_PORT_MAP_FISHERY_REGION, true ,"fisheryRegion") {
        
            @Override
            public void processDataBinding() {
                portMap.setFisheryRegion(getFisheryRegion());
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_PORT_MAP_SELECTED_CELLS, true, true) {
        
            @Override
            public void applyDataBinding() {
                addPropertyChangeListener("bean", this);
                if (bean != null) {
                    bean.addPropertyChangeListener("cell", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (bean != null) {
                    portMap.setSelectedCells(getBean() == null ? null : bean.getCell());
                }
            }
        
            @Override
            public void removeDataBinding() {
                removePropertyChangeListener("bean", this);
                if (bean != null) {
                    bean.removePropertyChangeListener("cell", this);
                }
            }
        });
    }

}