package fr.ifremer.isisfish.ui.input.population;

/*
 * #%L
 * ISIS-Fish
 * %%
 * Copyright (C) 1999 - 2015 Ifremer, Codelutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import fr.ifremer.isisfish.entities.Population;
import fr.ifremer.isisfish.ui.input.InputContentUI;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JTextField;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.JAXXValidator;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.binding.DefaultJAXXBinding;
import jaxx.runtime.binding.SimpleJAXXObjectBinding;
import jaxx.runtime.swing.Table;
import jaxx.runtime.validator.swing.SwingValidator;
import jaxx.runtime.validator.swing.SwingValidatorUtil;
import jaxx.runtime.validator.swing.meta.Validator;
import jaxx.runtime.validator.swing.meta.ValidatorField;
import jaxx.runtime.validator.swing.ui.ImageValidationUI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import static org.nuiton.i18n.I18n.t;

public class PopulationStockUI extends InputContentUI<Population> implements JAXXValidator {

    /*-----------------------------------------------------------------------*/
    /*---------------- Constants for all javaBean properties ----------------*/
    /*-----------------------------------------------------------------------*/

    public static final String PROPERTY_BEAN = "bean";

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_CANCEL_ENABLED = "cancel.enabled";
    public static final String BINDING_FIELD_POPULATION_ABUNDANCE_REFERENCE_MONTH_ENABLED = "fieldPopulationAbundanceReferenceMonth.enabled";
    public static final String BINDING_FIELD_POPULATION_COMPUTE_FON_LANDINGS_ENABLED = "fieldPopulationComputeFOnLandings.enabled";
    public static final String BINDING_FIELD_POPULATION_COMPUTE_FON_LANDINGS_SELECTED = "fieldPopulationComputeFOnLandings.selected";
    public static final String BINDING_FIELD_POPULATION_FBAR_GROUP_MAX_ENABLED = "fieldPopulationFbarGroupMax.enabled";
    public static final String BINDING_FIELD_POPULATION_FBAR_GROUP_MAX_TEXT = "fieldPopulationFbarGroupMax.text";
    public static final String BINDING_FIELD_POPULATION_FBAR_GROUP_MIN_ENABLED = "fieldPopulationFbarGroupMin.enabled";
    public static final String BINDING_FIELD_POPULATION_FBAR_GROUP_MIN_TEXT = "fieldPopulationFbarGroupMin.text";
    public static final String BINDING_SAVE_ENABLED = "save.enabled";
    public static final String BINDING_VALIDATOR_BEAN = "validator.bean";

    /*-----------------------------------------------------------------------*/
    /*--------------- Constants for all none public bindings  ---------------*/
    /*-----------------------------------------------------------------------*/

    private static final String BINDING_$JLABEL0_ENABLED = "$JLabel0.enabled";
    private static final String BINDING_$JLABEL1_ENABLED = "$JLabel1.enabled";
    private static final String BINDING_$JLABEL2_ENABLED = "$JLabel2.enabled";
    private static final String BINDING_$JLABEL3_ENABLED = "$JLabel3.enabled";
    private static final String BINDING_$JLABEL4_ENABLED = "$JLabel4.enabled";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAKVVzU8TQRQfKuXTTwgEBCMgQaNhC4oxBkX5sAopghSNsRdnu1M6sJ0Zd2ZhvRj/BP8EvXsx8ebJePDswYvxXzDGg1fjm21pu7AuK+1hdjvvvd/7vfdmfvv2B0pKBw1vYs8zHJcpWiLG0uzjxyvmJsmrBSLzDhWKO6j8a0qgRA51WtV9qdC5XEaHpyrhqXleEpwRVhc9nUEdUj23iSwSohQ6E4zIS5nKVs3TnnCdXdQqqTDU179+Jl5ZL98kEPIEsOuCUoYOiqpV0pxBCWop1AWZtnHKxmwDaDiUbQDfY3pv3sZS3scl8gy9QK0Z1CKwA2AKjcQv2cfw4z2h0MnRRSZcNc+ZAveHixMKXS84Bi04pETgKaksUFk0XGpQ7WgILlwbK8qZsVp9zSqe33q4KIQP3KJQs0kwU+h8GBTkoYoSWRdfC2wtYmbZxFFo5pA07pUBapDt29imFoYeKHQpMI2qwZA70GUjq9dHu5v11XDrOcxFj8Cr+C6tYkbsOuKj69i0CfSvL5Cj7O3btGdPNaBtdCmDTWJP7AX2d7VT3z7fSf3/TNA2UKDEtmpNSJvYuetwVyxTmEBvAHqdeCqt3cPhL/8XPPa0y0g41JUQqLE9ULOmyyzM8mSNFAic4zxZhmNYVKgnQBoOs8nnuBeeaCok0fCeRPo6uIqkV1gGDgeAyn05iiS/tS9HZaZ+108HTc0SbxOFugMoc65SnGmPyapjS15X6M/zasXioIHAEQG5MWpyU9ODphxKOi5sw5nK7VeoNTCVtalvjzZpQN/6p7f764fv79O7gtQPuXtCXev0FIRCOFzAHaQ69YmyGrmK2qllLKZzqF0SG8TYF9vBEGLZihnIQb5TOtzQ4cY9LIsAkWz99vFT79MvR1AijTpsjq001v6LqF0VHegCty1P3LrtMzq60wbrSc0NBkKYHgho5PEbcEfxkEn9ec540IXBkC5UqZjtn393Z9/d3u1EEzDr/6d7rRvJJ6iFMpsy4otzRXdDxbhTSOJavKavYYrbpJ+DoqIbN/11NqzUzgLchfEdQjeKoO9dN8okhrCCD4IJhxlK1rF3/Fr0293Y0M0KZEBbM4fF0NvzelkIRzgbC+FBBId4CFEchuNzaAghisNow32IhxDFYazhPsRDiOJwoeE+HIwAV0Zxbq9TsR59vOORiSrnYgwyyRK3yrJ/aJCDaIw33NV4CFEcUjFa0Vb+XhCrIZyDaomHEFXLVMMc4iFEcbjWMAeN8Bc/jhwHRw0AAA==";
    private static final Log log = LogFactory.getLog(PopulationStockUI.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    private boolean allComponentsCreated;

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected Population bean;
    protected JButton cancel;
    protected JComboBox fieldPopulationAbundanceReferenceMonth;
    protected JCheckBox fieldPopulationComputeFOnLandings;
    protected JTextField fieldPopulationFbarGroupMax;
    protected JTextField fieldPopulationFbarGroupMin;
    protected PopulationStockHandler handler;
    protected JButton save;
    @Validator( validatorId = "validator")
    protected SwingValidator<Population> validator;
    protected List<String> validatorIds = new ArrayList<String>();

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private PopulationStockUI $InputContentUI0 = this;
    private JLabel $JLabel0;
    private JLabel $JLabel1;
    private JLabel $JLabel2;
    private JLabel $JLabel3;
    private JLabel $JLabel4;
    private Table $Table0;
    private Table $Table1;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/

    protected void $afterCompleteSetup() {
            handler.afterInit();
        }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public PopulationStockUI(LayoutManager param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public PopulationStockUI(JAXXContext param0, LayoutManager param1, boolean param2) {
        super(param0 ,param1 ,param2);
        $initialize();
    }

    public PopulationStockUI(LayoutManager param0) {
        super(param0);
        $initialize();
    }

    public PopulationStockUI(JAXXContext param0, LayoutManager param1) {
        super(param0 ,param1);
        $initialize();
    }

    public PopulationStockUI() {
        $initialize();
    }

    public PopulationStockUI(JAXXContext param0) {
        super(param0);
        $initialize();
    }

    public PopulationStockUI(boolean param0) {
        super(param0);
        $initialize();
    }

    public PopulationStockUI(JAXXContext param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*-------------------- JAXXValidator implementation  --------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public SwingValidator<?> getValidator(String validatorId) {
        return (SwingValidator<?>) (validatorIds.contains(validatorId) ? getObjectById(validatorId) : null);
    }

    @Override
    public List<String> getValidatorIds() {
        return validatorIds;
    }

    @Override
    public void registerValidatorFields() {
        SwingValidatorUtil.detectValidatorFields(this);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doActionPerformed__on__cancel(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getSaveVerifier().cancel();
    }

    public void doActionPerformed__on__fieldPopulationAbundanceReferenceMonth(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.onRepresentativeAbundanceMonthChanged();
    }

    public void doActionPerformed__on__fieldPopulationComputeFOnLandings(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getBean().setComputeFOnLandings(fieldPopulationComputeFOnLandings.isSelected());
    }

    public void doActionPerformed__on__save(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getSaveVerifier().save();validator.setChanged(false);
    }

    public void doKeyReleased__on__fieldPopulationFbarGroupMax(KeyEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getBean().setFbarGroupMax(Integer.parseInt(fieldPopulationFbarGroupMax.getText()));
    }

    public void doKeyReleased__on__fieldPopulationFbarGroupMin(KeyEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getBean().setFbarGroupMin(Integer.parseInt(fieldPopulationFbarGroupMin.getText()));
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public Population getBean() {
        return bean;
    }

    public JButton getCancel() {
        return cancel;
    }

    public JComboBox getFieldPopulationAbundanceReferenceMonth() {
        return fieldPopulationAbundanceReferenceMonth;
    }

    public JCheckBox getFieldPopulationComputeFOnLandings() {
        return fieldPopulationComputeFOnLandings;
    }

    public JTextField getFieldPopulationFbarGroupMax() {
        return fieldPopulationFbarGroupMax;
    }

    public JTextField getFieldPopulationFbarGroupMin() {
        return fieldPopulationFbarGroupMin;
    }

    public PopulationStockHandler getHandler() {
        return handler;
    }

    public JButton getSave() {
        return save;
    }

    public SwingValidator<Population> getValidator() {
        return validator;
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public mutator methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public void setBean(Population bean) {
        Population oldValue = this.bean;
        this.bean = bean;
        firePropertyChange(PROPERTY_BEAN, oldValue, bean);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected JLabel get$JLabel0() {
        return $JLabel0;
    }

    protected JLabel get$JLabel1() {
        return $JLabel1;
    }

    protected JLabel get$JLabel2() {
        return $JLabel2;
    }

    protected JLabel get$JLabel3() {
        return $JLabel3;
    }

    protected JLabel get$JLabel4() {
        return $JLabel4;
    }

    protected Table get$Table0() {
        return $Table0;
    }

    protected Table get$Table1() {
        return $Table1;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToBody() {
        if (!allComponentsCreated) {
            return;
        }
        body.add($Table0);
    }

    protected void addChildrenToValidator() {
        if (!allComponentsCreated) {
            return;
        }
        validator.setUiClass(ImageValidationUI.class);
    }

    protected void createBean() {
        $objectMap.put("bean", bean = null);
    }

    @Override
    protected void createBody() {
        super.createBody();
        body.setName("body");
    }

    protected void createCancel() {
        $objectMap.put("cancel", cancel = new JButton());
        
        cancel.setName("cancel");
        cancel.setText(t("isisfish.common.cancel"));
        cancel.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__cancel"));
    }

    protected void createFieldPopulationAbundanceReferenceMonth() {
        $objectMap.put("fieldPopulationAbundanceReferenceMonth", fieldPopulationAbundanceReferenceMonth = new JComboBox());
        
        fieldPopulationAbundanceReferenceMonth.setName("fieldPopulationAbundanceReferenceMonth");
        fieldPopulationAbundanceReferenceMonth.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__fieldPopulationAbundanceReferenceMonth"));
    }

    protected void createFieldPopulationComputeFOnLandings() {
        $objectMap.put("fieldPopulationComputeFOnLandings", fieldPopulationComputeFOnLandings = new JCheckBox());
        
        fieldPopulationComputeFOnLandings.setName("fieldPopulationComputeFOnLandings");
        fieldPopulationComputeFOnLandings.setText(t("isisfish.populationStock.computeFOnLandings"));
        fieldPopulationComputeFOnLandings.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__fieldPopulationComputeFOnLandings"));
    }

    protected void createFieldPopulationFbarGroupMax() {
        $objectMap.put("fieldPopulationFbarGroupMax", fieldPopulationFbarGroupMax = new JTextField());
        
        fieldPopulationFbarGroupMax.setName("fieldPopulationFbarGroupMax");
        fieldPopulationFbarGroupMax.setColumns(15);
        fieldPopulationFbarGroupMax.addKeyListener(JAXXUtil.getEventListener(KeyListener.class, "keyReleased", this, "doKeyReleased__on__fieldPopulationFbarGroupMax"));
        fieldPopulationFbarGroupMax.putClientProperty("sensitivityBean", Population.class);
        fieldPopulationFbarGroupMax.putClientProperty("sensitivityMethod", "FbarGroupMax");
    }

    protected void createFieldPopulationFbarGroupMin() {
        $objectMap.put("fieldPopulationFbarGroupMin", fieldPopulationFbarGroupMin = new JTextField());
        
        fieldPopulationFbarGroupMin.setName("fieldPopulationFbarGroupMin");
        fieldPopulationFbarGroupMin.setColumns(15);
        fieldPopulationFbarGroupMin.addKeyListener(JAXXUtil.getEventListener(KeyListener.class, "keyReleased", this, "doKeyReleased__on__fieldPopulationFbarGroupMin"));
        fieldPopulationFbarGroupMin.putClientProperty("sensitivityBean", Population.class);
        fieldPopulationFbarGroupMin.putClientProperty("sensitivityMethod", "FbarGroupMin");
    }

    protected void createHandler() {
        $objectMap.put("handler", handler = new PopulationStockHandler(this));
    }

    protected void createSave() {
        $objectMap.put("save", save = new JButton());
        
        save.setName("save");
        save.setText(t("isisfish.common.save"));
        save.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__save"));
    }

    protected void createValidator() {
        $objectMap.put("validator", validator = SwingValidator.newValidator(Population.class, "basics"));
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        addChildrenToValidator();
        addChildrenToBody();
        // inline complete setup of $Table0
        $Table0.add($JLabel0, new GridBagConstraints(0, 0, 2, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add($JLabel1, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(SwingUtil.boxComponentWithJxLayer(fieldPopulationFbarGroupMin), new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add($JLabel2, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(SwingUtil.boxComponentWithJxLayer(fieldPopulationFbarGroupMax), new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add($JLabel3, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(SwingUtil.boxComponentWithJxLayer(fieldPopulationAbundanceReferenceMonth), new GridBagConstraints(1, 3, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add($JLabel4, new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(SwingUtil.boxComponentWithJxLayer(fieldPopulationComputeFOnLandings), new GridBagConstraints(1, 4, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add($Table1, new GridBagConstraints(0, 5, 2, 1, 1.0, 1.0, 15, 2, new Insets(3, 3, 3, 3), 0, 0));
        // inline complete setup of $Table1
        $Table1.add(SwingUtil.boxComponentWithJxLayer(save), new GridBagConstraints(0, 0, 1, 1, 0.5, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add(SwingUtil.boxComponentWithJxLayer(cancel), new GridBagConstraints(1, 0, 1, 1, 0.5, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        
        // apply 15 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
        
        // apply 1 property setters
        fieldPopulationAbundanceReferenceMonth.setModel(new fr.ifremer.isisfish.ui.models.misc.MonthComboModel());
        // late initializer
        // register 1 validator(s)
        validatorIds = SwingValidatorUtil.detectValidators(this);
        SwingValidatorUtil.installUI(this);
        
        $afterCompleteSetup();
    }

    private void $initialize() {
        if (allComponentsCreated) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        $objectMap.put("$InputContentUI0", $InputContentUI0);
        createBean();
        createHandler();
        createValidator();
        // inline creation of $Table0
        $objectMap.put("$Table0", $Table0 = new Table());
        
        $Table0.setName("$Table0");
        // inline creation of $JLabel0
        $objectMap.put("$JLabel0", $JLabel0 = new JLabel());
        
        $JLabel0.setName("$JLabel0");
        if ($JLabel0.getFont() != null) {
            $JLabel0.setFont($JLabel0.getFont().deriveFont($JLabel0.getFont().getStyle() | Font.BOLD));
        }
        $JLabel0.setText(t("isisfish.populationStock.desc"));
        // inline creation of $JLabel1
        $objectMap.put("$JLabel1", $JLabel1 = new JLabel());
        
        $JLabel1.setName("$JLabel1");
        $JLabel1.setText(t("isisfish.populationStock.fbarGroupMin"));
        createFieldPopulationFbarGroupMin();
        // inline creation of $JLabel2
        $objectMap.put("$JLabel2", $JLabel2 = new JLabel());
        
        $JLabel2.setName("$JLabel2");
        $JLabel2.setText(t("isisfish.populationStock.fbarGroupMax"));
        createFieldPopulationFbarGroupMax();
        // inline creation of $JLabel3
        $objectMap.put("$JLabel3", $JLabel3 = new JLabel());
        
        $JLabel3.setName("$JLabel3");
        $JLabel3.setText(t("isisfish.populationStock.abundanceReferenceMonth"));
        $JLabel3.setToolTipText(t("isisfish.populationStock.abundanceReferenceMonth.tip"));
        createFieldPopulationAbundanceReferenceMonth();
        // inline creation of $JLabel4
        $objectMap.put("$JLabel4", $JLabel4 = new JLabel());
        
        $JLabel4.setName("$JLabel4");
        $JLabel4.setText(t("isisfish.populationStock.computeF"));
        createFieldPopulationComputeFOnLandings();
        // inline creation of $Table1
        $objectMap.put("$Table1", $Table1 = new Table());
        
        $Table1.setName("$Table1");
        createSave();
        createCancel();
        // inline creation of $InputContentUI0
        setName("$InputContentUI0");
        
        // registers 15 data bindings
        $registerDefaultBindings();
        $completeSetup();
    }

    private void $registerDefaultBindings() {
        // register 15 data bindings
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_VALIDATOR_BEAN, true ,"bean") {
        
            @Override
            public void processDataBinding() {
                validator.setBean(getBean());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_$JLABEL0_ENABLED, true ,"active") {
        
            @Override
            public void processDataBinding() {
                $JLabel0.setEnabled(isActive());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_$JLABEL1_ENABLED, true ,"active") {
        
            @Override
            public void processDataBinding() {
                $JLabel1.setEnabled(isActive());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_FIELD_POPULATION_FBAR_GROUP_MIN_ENABLED, true ,"active") {
        
            @Override
            public void processDataBinding() {
                fieldPopulationFbarGroupMin.setEnabled(isActive());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_FIELD_POPULATION_FBAR_GROUP_MIN_TEXT, true ,"bean") {
        
            @Override
            public void processDataBinding() {
                if (getBean() != null) {
                    SwingUtil.setText(fieldPopulationFbarGroupMin, String.valueOf(getBean().getFbarGroupMin()));
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_$JLABEL2_ENABLED, true ,"active") {
        
            @Override
            public void processDataBinding() {
                $JLabel2.setEnabled(isActive());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_FIELD_POPULATION_FBAR_GROUP_MAX_ENABLED, true ,"active") {
        
            @Override
            public void processDataBinding() {
                fieldPopulationFbarGroupMax.setEnabled(isActive());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_FIELD_POPULATION_FBAR_GROUP_MAX_TEXT, true ,"bean") {
        
            @Override
            public void processDataBinding() {
                if (getBean() != null) {
                    SwingUtil.setText(fieldPopulationFbarGroupMax, String.valueOf(getBean().getFbarGroupMax()));
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_$JLABEL3_ENABLED, true ,"active") {
        
            @Override
            public void processDataBinding() {
                $JLabel3.setEnabled(isActive());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_FIELD_POPULATION_ABUNDANCE_REFERENCE_MONTH_ENABLED, true ,"active") {
        
            @Override
            public void processDataBinding() {
                fieldPopulationAbundanceReferenceMonth.setEnabled(isActive());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_$JLABEL4_ENABLED, true ,"active") {
        
            @Override
            public void processDataBinding() {
                $JLabel4.setEnabled(isActive());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_FIELD_POPULATION_COMPUTE_FON_LANDINGS_ENABLED, true ,"active") {
        
            @Override
            public void processDataBinding() {
                fieldPopulationComputeFOnLandings.setEnabled(isActive());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_FIELD_POPULATION_COMPUTE_FON_LANDINGS_SELECTED, true ,"bean") {
        
            @Override
            public void processDataBinding() {
                if (getBean() != null) {
                    fieldPopulationComputeFOnLandings.setSelected(getBean().isComputeFOnLandings());
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_SAVE_ENABLED, true, true) {
        
            @Override
            public void applyDataBinding() {
                if (validator != null) {
                    validator.addPropertyChangeListener("valid", this);
                }
                if (validator != null) {
                    validator.addPropertyChangeListener("changed", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (validator != null) {
                    save.setEnabled(validator.isValid() && validator.isChanged());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (validator != null) {
                    validator.removePropertyChangeListener("valid", this);
                }
                if (validator != null) {
                    validator.removePropertyChangeListener("changed", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_CANCEL_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (validator != null) {
                    validator.addPropertyChangeListener("changed", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (validator != null) {
                    cancel.setEnabled(validator.isChanged());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (validator != null) {
                    validator.removePropertyChangeListener("changed", this);
                }
            }
        });
    }

}