package fr.ifremer.isisfish.ui.input.population;

/*
 * #%L
 * ISIS-Fish
 * %%
 * Copyright (C) 1999 - 2015 Ifremer, Codelutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import fr.ifremer.isisfish.entities.Population;
import fr.ifremer.isisfish.entities.PopulationSeasonInfo;
import fr.ifremer.isisfish.ui.input.ChangeModel;
import fr.ifremer.isisfish.ui.input.InputContentUI;
import fr.ifremer.isisfish.ui.widget.IntervalPanel;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.JAXXValidator;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.binding.DefaultJAXXBinding;
import jaxx.runtime.binding.SimpleJAXXObjectBinding;
import jaxx.runtime.swing.Table;
import jaxx.runtime.validator.swing.SwingValidator;
import jaxx.runtime.validator.swing.SwingValidatorUtil;
import jaxx.runtime.validator.swing.meta.Validator;
import jaxx.runtime.validator.swing.meta.ValidatorField;
import jaxx.runtime.validator.swing.ui.ImageValidationUI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.math.matrix.gui.MatrixPanelEditor;
import org.nuiton.math.matrix.gui.MatrixPanelEvent;
import org.nuiton.math.matrix.gui.MatrixPanelListener;
import static org.nuiton.i18n.I18n.t;

public class PopulationSeasonsUI extends InputContentUI<Population> implements JAXXValidator {

    /*-----------------------------------------------------------------------*/
    /*---------------- Constants for all javaBean properties ----------------*/
    /*-----------------------------------------------------------------------*/

    public static final String PROPERTY_BEAN = "bean";
    public static final String PROPERTY_POPULATION_SEASON_INFO = "populationSeasonInfo";

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_CANCEL_ENABLED = "cancel.enabled";
    public static final String BINDING_CHANGE_MODEL_CHANGED = "changeModel.changed";
    public static final String BINDING_CHANGE_MODEL_VALID = "changeModel.valid";
    public static final String BINDING_CREATE_ENABLED = "create.enabled";
    public static final String BINDING_DELETE_ENABLED = "delete.enabled";
    public static final String BINDING_FIELD_POPULATION_SEASON_COMMENT_ENABLED = "fieldPopulationSeasonComment.enabled";
    public static final String BINDING_FIELD_POPULATION_SEASON_COMMENT_TEXT = "fieldPopulationSeasonComment.text";
    public static final String BINDING_FIELD_POPULATION_SEASON_GROUP_CHANGE_ENABLED = "fieldPopulationSeasonGroupChange.enabled";
    public static final String BINDING_FIELD_POPULATION_SEASON_GROUP_CHANGE_SELECTED = "fieldPopulationSeasonGroupChange.selected";
    public static final String BINDING_FIELD_POPULATION_SEASON_GROUP_CHANGE_VISIBLE = "fieldPopulationSeasonGroupChange.visible";
    public static final String BINDING_FIELD_POPULATION_SEASON_INFO_CHOOSER_ENABLED = "fieldPopulationSeasonInfoChooser.enabled";
    public static final String BINDING_FIELD_POPULATION_SEASON_REPRODUCTION_DISTRIBUTION_ENABLED = "fieldPopulationSeasonReproductionDistribution.enabled";
    public static final String BINDING_FIELD_POPULATION_SEASON_REPRODUCTION_DISTRIBUTION_MATRIX = "fieldPopulationSeasonReproductionDistribution.matrix";
    public static final String BINDING_FIELD_POPULATION_SEASON_REPRODUCTION_DISTRIBUTION_VISIBLE = "fieldPopulationSeasonReproductionDistribution.visible";
    public static final String BINDING_FIELD_POPULATION_SEASON_REPRODUCTION_ENABLED = "fieldPopulationSeasonReproduction.enabled";
    public static final String BINDING_FIELD_POPULATION_SEASON_REPRODUCTION_SELECTED = "fieldPopulationSeasonReproduction.selected";
    public static final String BINDING_POPULATION_SEASON_SPECIALIZED_UI_AGE_GROUP_TYPE = "populationSeasonSpecializedUI.ageGroupType";
    public static final String BINDING_POPULATION_SEASON_SPECIALIZED_UI_BEAN = "populationSeasonSpecializedUI.bean";
    public static final String BINDING_POPULATION_SEASON_SPECIALIZED_UI_POPULATION_SEASON_INFO = "populationSeasonSpecializedUI.populationSeasonInfo";
    public static final String BINDING_SAVE_ENABLED = "save.enabled";
    public static final String BINDING_SEASON_INTERVAL_PANEL_ENABLED = "seasonIntervalPanel.enabled";
    public static final String BINDING_VALIDATOR_BEAN = "validator.bean";
    public static final String BINDING_VALIDATOR_SEASON_BEAN = "validatorSeason.bean";

    /*-----------------------------------------------------------------------*/
    /*--------------- Constants for all none public bindings  ---------------*/
    /*-----------------------------------------------------------------------*/

    private static final String BINDING_$JLABEL0_ENABLED = "$JLabel0.enabled";
    private static final String BINDING_$JLABEL1_ENABLED = "$JLabel1.enabled";
    private static final String BINDING_$JLABEL2_ENABLED = "$JLabel2.enabled";
    private static final String BINDING_$JLABEL2_VISIBLE = "$JLabel2.visible";
    private static final String BINDING_$JLABEL3_ENABLED = "$JLabel3.enabled";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAKVWzW8bRRSfmNhOmpYWQj9QE+G2gYIo66RFXFzaNG7TOnJoqRNUsJA63h3bU9Y705nZZMMB8Sf0yg3uXJC4cUI99MyBC+JfQIgDV8SbXXvX62zXq6wPs+N57/3m9z5m3vz4FypKgS48wZ5nCNdRdECMrVuPHt3vPCGmuk2kKShXTKDgN1NAhTZasMJ1qdCldlObV4fm1TobcOYQZ8y61kTHpDqwiewTohRajluYUlZbobjmcVeMUENSSajf//N34Zn17Q8FhDwO7JbBlco0q8iT2SYqUEuh12GnPVy1sdMDGoI6PeB7Qq/VbSzlJ3hAnqJvULmJShwLAFPoYnaXfQzf3uMKnVppONxVdeYoUN9trCpU6wqDdgUZEPhKKrtU9g2XGlQrGpxx18aKMsd4EE5bBEvmyN0G5z50SaHZDsGOQpeTwGAnqiiRYwiR4Rt8ArbhdJlCaxmBIpsIstzHjmUTodD6kX27F0BEoPN72KYWhtAq9H4syaHAkPuQPKOlx89GixHCyVAx2EMvn43ECybQ7pFtZhFboXdTmdcj1fEUMOsAyklXjjfksvUAO+M65ZUd3LEJpP1czIdA25dpzeVJgzX996IeKqFobmWriTvEXp3c01/VSpdC3UqXEttKSlu9z5jUuTodw4CS7rAN5sVhRlv6dC7HZYtyiKmIgEj7jkOqXhLHfWr1iDJi2of28ldX9f+3srhzVzCXB6k55E6fmF8dcmd5svZbnJgUquRrYu02FLpz1PJtcRzhJLu1luDWhUS3HhIumOWaekUrfpick6sJOflgKuBtKuHK67h6rtAVJnqG41IFPg2w6utBUM/ogdPb/tTnfscCDZFM41oCjRMrWy1TMNtPM5Tr2VhuIlHcaimRPBTmwL+D4wneIZ66JQjWtvXJ03M14fTMSrwHZbIYQ9lwlQqC3AgVSyZ2zKA4tyclsKEiSRK4GEhcItD52ImHpmdETS/qSjNtVBQuLMMV0T7cJx+CKOiQ5yY6pAb0pf+dWfz9lz9/3hy1xbdh79OJqmNdHdoVFAWHi4DqrU8GPRHKwq5uY15ro3kJLplBy19KINYaioEc7PeaNje0uXEPyz5AFMt//Pr8zOPfXkGFTXTMZtjaxFq/geZVX0AUmG15/Oa6z+j4/hyMpzQ3SGJwMUOnfvU6XN+40qGOBem64UEUlhKiEFLpzL/4d7H10/ooEjPA7M2XqkfRKH6BStSxqUP8J8Kw+yc+CRa4JK7Foi6f1Pdn9Pc8H7aBz/3xyyRXi36L0uLHnqs/2GetZ2ZmkDJxdNGnwbyTAWZWwZGC1nI9iEQFq+CiIDeOiqmX7RRW72VgNQcPMIsIInLhTGNyJRPCUz2IPAhpHIzcCNeyxDM41qnVMh1nWjSyMCnvQYsdvn9yOHQc94j/ENg54GlYH2U5AvpRnRMj8X2dC3Na2muZEJ7lRkhLeDaENC8+zs0hG8J3uTmkeXEzQ4WUgkdWLpRpnmRDSPNkI3c+siGkcbibnUMuhDQOzdxxyIaQxuF+bg7ZENI4fJqbQzaENA6t3Bw0wv/o0d5yBRMAAA==";
    private static final Log log = LogFactory.getLog(PopulationSeasonsUI.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    private boolean allComponentsCreated;

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected Population bean;
    protected JButton cancel;
    protected ChangeModel changeModel;
    protected JButton create;
    protected JButton delete;
    protected JTextArea fieldPopulationSeasonComment;
    protected JCheckBox fieldPopulationSeasonGroupChange;
    protected JComboBox<PopulationSeasonInfo> fieldPopulationSeasonInfoChooser;
    protected JCheckBox fieldPopulationSeasonReproduction;
    protected MatrixPanelEditor fieldPopulationSeasonReproductionDistribution;
    protected PopulationSeasonsHandler handler;
    protected PopulationSeasonInfo populationSeasonInfo;
    protected PopulationSeasonSpacializedUI populationSeasonSpecializedUI;
    protected JButton save;
    protected IntervalPanel seasonIntervalPanel;
    @Validator( validatorId = "validator")
    protected SwingValidator<Population> validator;
    protected List<String> validatorIds = new ArrayList<String>();
    @Validator( validatorId = "validatorSeason")
    protected SwingValidator<PopulationSeasonInfo> validatorSeason;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private PopulationSeasonsUI $InputContentUI0 = this;
    private JLabel $JLabel0;
    private JLabel $JLabel1;
    private JLabel $JLabel2;
    private JLabel $JLabel3;
    private JPanel $JPanel0;
    private JPanel $JPanel1;
    private JScrollPane $JScrollPane0;
    private Table $Table0;
    private Table $Table1;
    private Table $Table2;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/

    protected void $afterCompleteSetup() {
            handler.afterInit();
        }
    
        @Override
        public void resetChangeModel() {
            changeModel.setStayChanged(false);
        }
    
        @Override
        public void setLayer(boolean active) {
            super.setLayer(active);
            populationSeasonSpecializedUI.setLayer(active);
        }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public PopulationSeasonsUI(LayoutManager param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public PopulationSeasonsUI(JAXXContext param0, LayoutManager param1, boolean param2) {
        super(param0 ,param1 ,param2);
        $initialize();
    }

    public PopulationSeasonsUI(LayoutManager param0) {
        super(param0);
        $initialize();
    }

    public PopulationSeasonsUI(JAXXContext param0, LayoutManager param1) {
        super(param0 ,param1);
        $initialize();
    }

    public PopulationSeasonsUI() {
        $initialize();
    }

    public PopulationSeasonsUI(JAXXContext param0) {
        super(param0);
        $initialize();
    }

    public PopulationSeasonsUI(boolean param0) {
        super(param0);
        $initialize();
    }

    public PopulationSeasonsUI(JAXXContext param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*-------------------- JAXXValidator implementation  --------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public SwingValidator<?> getValidator(String validatorId) {
        return (SwingValidator<?>) (validatorIds.contains(validatorId) ? getObjectById(validatorId) : null);
    }

    @Override
    public List<String> getValidatorIds() {
        return validatorIds;
    }

    @Override
    public void registerValidatorFields() {
        SwingValidatorUtil.detectValidatorFields(this);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doActionPerformed__on__cancel(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getSaveVerifier().cancel();
    }

    public void doActionPerformed__on__create(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.create();
    }

    public void doActionPerformed__on__delete(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.delete();
    }

    public void doActionPerformed__on__fieldPopulationSeasonGroupChange(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.seasonGroupChanged();
    }

    public void doActionPerformed__on__fieldPopulationSeasonReproduction(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getPopulationSeasonInfo().setReproduction(fieldPopulationSeasonReproduction.isSelected());
    }

    public void doActionPerformed__on__save(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.save();validator.setChanged(false);validatorSeason.setChanged(false);
    }

    public void doItemStateChanged__on__fieldPopulationSeasonInfoChooser(ItemEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.seasonChanged();
    }

    public void doKeyReleased__on__fieldPopulationSeasonComment(KeyEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getBean().setSeasonsComment(fieldPopulationSeasonComment.getText());
    }

    public void doMatrixChanged__on__fieldPopulationSeasonReproductionDistribution(MatrixPanelEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.populationSeasonReproductionDistributionMatrixChanged(event);
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public Population getBean() {
        return bean;
    }

    public JButton getCancel() {
        return cancel;
    }

    public ChangeModel getChangeModel() {
        return changeModel;
    }

    public JButton getCreate() {
        return create;
    }

    public JButton getDelete() {
        return delete;
    }

    public JTextArea getFieldPopulationSeasonComment() {
        return fieldPopulationSeasonComment;
    }

    public JCheckBox getFieldPopulationSeasonGroupChange() {
        return fieldPopulationSeasonGroupChange;
    }

    public JComboBox<PopulationSeasonInfo> getFieldPopulationSeasonInfoChooser() {
        return fieldPopulationSeasonInfoChooser;
    }

    public JCheckBox getFieldPopulationSeasonReproduction() {
        return fieldPopulationSeasonReproduction;
    }

    public MatrixPanelEditor getFieldPopulationSeasonReproductionDistribution() {
        return fieldPopulationSeasonReproductionDistribution;
    }

    public PopulationSeasonsHandler getHandler() {
        return handler;
    }

    public PopulationSeasonInfo getPopulationSeasonInfo() {
        return populationSeasonInfo;
    }

    public PopulationSeasonSpacializedUI getPopulationSeasonSpecializedUI() {
        return populationSeasonSpecializedUI;
    }

    public JButton getSave() {
        return save;
    }

    public IntervalPanel getSeasonIntervalPanel() {
        return seasonIntervalPanel;
    }

    public SwingValidator<Population> getValidator() {
        return validator;
    }

    public SwingValidator<PopulationSeasonInfo> getValidatorSeason() {
        return validatorSeason;
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public mutator methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public void setBean(Population bean) {
        Population oldValue = this.bean;
        this.bean = bean;
        firePropertyChange(PROPERTY_BEAN, oldValue, bean);
    }

    public void setPopulationSeasonInfo(PopulationSeasonInfo populationSeasonInfo) {
        PopulationSeasonInfo oldValue = this.populationSeasonInfo;
        this.populationSeasonInfo = populationSeasonInfo;
        firePropertyChange(PROPERTY_POPULATION_SEASON_INFO, oldValue, populationSeasonInfo);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected JLabel get$JLabel0() {
        return $JLabel0;
    }

    protected JLabel get$JLabel1() {
        return $JLabel1;
    }

    protected JLabel get$JLabel2() {
        return $JLabel2;
    }

    protected JLabel get$JLabel3() {
        return $JLabel3;
    }

    protected JPanel get$JPanel0() {
        return $JPanel0;
    }

    protected JPanel get$JPanel1() {
        return $JPanel1;
    }

    protected JScrollPane get$JScrollPane0() {
        return $JScrollPane0;
    }

    protected Table get$Table0() {
        return $Table0;
    }

    protected Table get$Table1() {
        return $Table1;
    }

    protected Table get$Table2() {
        return $Table2;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToBody() {
        if (!allComponentsCreated) {
            return;
        }
        body.add($Table0);
    }

    protected void addChildrenToValidator() {
        if (!allComponentsCreated) {
            return;
        }
        validator.setUiClass(ImageValidationUI.class);
    }

    protected void addChildrenToValidatorSeason() {
        if (!allComponentsCreated) {
            return;
        }
        validatorSeason.setUiClass(ImageValidationUI.class);
        validatorSeason.setParentValidator(getValidator());
    }

    protected void createBean() {
        $objectMap.put("bean", bean = null);
    }

    @Override
    protected void createBody() {
        super.createBody();
        body.setName("body");
    }

    protected void createCancel() {
        $objectMap.put("cancel", cancel = new JButton());
        
        cancel.setName("cancel");
        cancel.setText(t("isisfish.common.cancel"));
        cancel.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__cancel"));
    }

    protected void createChangeModel() {
        $objectMap.put("changeModel", changeModel = new ChangeModel());
    }

    protected void createCreate() {
        $objectMap.put("create", create = new JButton());
        
        create.setName("create");
        create.setText(t("isisfish.common.new"));
        create.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__create"));
    }

    protected void createDelete() {
        $objectMap.put("delete", delete = new JButton());
        
        delete.setName("delete");
        delete.setText(t("isisfish.common.remove"));
        delete.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__delete"));
    }

    protected void createFieldPopulationSeasonComment() {
        $objectMap.put("fieldPopulationSeasonComment", fieldPopulationSeasonComment = new JTextArea());
        
        fieldPopulationSeasonComment.setName("fieldPopulationSeasonComment");
        fieldPopulationSeasonComment.setColumns(15);
        fieldPopulationSeasonComment.setLineWrap(true);
        fieldPopulationSeasonComment.setWrapStyleWord(true);
        fieldPopulationSeasonComment.addKeyListener(JAXXUtil.getEventListener(KeyListener.class, "keyReleased", this, "doKeyReleased__on__fieldPopulationSeasonComment"));
    }

    protected void createFieldPopulationSeasonGroupChange() {
        $objectMap.put("fieldPopulationSeasonGroupChange", fieldPopulationSeasonGroupChange = new JCheckBox());
        
        fieldPopulationSeasonGroupChange.setName("fieldPopulationSeasonGroupChange");
        fieldPopulationSeasonGroupChange.setText(t("isisfish.populationSeasons.changeGroup"));
        fieldPopulationSeasonGroupChange.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__fieldPopulationSeasonGroupChange"));
        fieldPopulationSeasonGroupChange.putClientProperty("sensitivityBean", PopulationSeasonInfo.class);
        fieldPopulationSeasonGroupChange.putClientProperty("sensitivityMethod", "GroupChange");
    }

    protected void createFieldPopulationSeasonInfoChooser() {
        $objectMap.put("fieldPopulationSeasonInfoChooser", fieldPopulationSeasonInfoChooser = new JComboBox<PopulationSeasonInfo>());
        
        fieldPopulationSeasonInfoChooser.setName("fieldPopulationSeasonInfoChooser");
        fieldPopulationSeasonInfoChooser.addItemListener(JAXXUtil.getEventListener(ItemListener.class, "itemStateChanged", this, "doItemStateChanged__on__fieldPopulationSeasonInfoChooser"));
    }

    protected void createFieldPopulationSeasonReproduction() {
        $objectMap.put("fieldPopulationSeasonReproduction", fieldPopulationSeasonReproduction = new JCheckBox());
        
        fieldPopulationSeasonReproduction.setName("fieldPopulationSeasonReproduction");
        fieldPopulationSeasonReproduction.setText(t("isisfish.populationSeasons.Reproduction"));
        fieldPopulationSeasonReproduction.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__fieldPopulationSeasonReproduction"));
    }

    protected void createFieldPopulationSeasonReproductionDistribution() {
        $objectMap.put("fieldPopulationSeasonReproductionDistribution", fieldPopulationSeasonReproductionDistribution = new MatrixPanelEditor());
        
        fieldPopulationSeasonReproductionDistribution.setName("fieldPopulationSeasonReproductionDistribution");
        fieldPopulationSeasonReproductionDistribution.addMatrixPanelListener(JAXXUtil.getEventListener(MatrixPanelListener.class, "matrixChanged", this, "doMatrixChanged__on__fieldPopulationSeasonReproductionDistribution"));
        fieldPopulationSeasonReproductionDistribution.putClientProperty("sensitivityBean", PopulationSeasonInfo.class);
        fieldPopulationSeasonReproductionDistribution.putClientProperty("sensitivityMethod", "ReproductionDistribution");
    }

    protected void createHandler() {
        $objectMap.put("handler", handler = new PopulationSeasonsHandler(this));
    }

    protected void createPopulationSeasonInfo() {
        $objectMap.put("populationSeasonInfo", populationSeasonInfo = null);
    }

    protected void createPopulationSeasonSpecializedUI() {
        $objectMap.put("populationSeasonSpecializedUI", populationSeasonSpecializedUI = new PopulationSeasonSpacializedUI(this));
        
        populationSeasonSpecializedUI.setName("populationSeasonSpecializedUI");
    }

    protected void createSave() {
        $objectMap.put("save", save = new JButton());
        
        save.setName("save");
        save.setText(t("isisfish.common.save"));
        save.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__save"));
    }

    protected void createSeasonIntervalPanel() {
        $objectMap.put("seasonIntervalPanel", seasonIntervalPanel = new IntervalPanel());
        
        seasonIntervalPanel.setName("seasonIntervalPanel");
    }

    protected void createValidator() {
        $objectMap.put("validator", validator = SwingValidator.newValidator(Population.class, "seasons"));
    }

    protected void createValidatorSeason() {
        $objectMap.put("validatorSeason", validatorSeason = SwingValidator.newValidator(PopulationSeasonInfo.class, "population"));
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        addChildrenToValidator();
        addChildrenToValidatorSeason();
        addChildrenToBody();
        // inline complete setup of $Table0
        $Table0.add($Table1, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add($Table2, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        // inline complete setup of $Table1
        $Table1.add($JLabel0, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add(fieldPopulationSeasonInfoChooser, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add($JLabel1, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 13, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add(SwingUtil.boxComponentWithJxLayer(seasonIntervalPanel), new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add($JPanel0, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add(SwingUtil.boxComponentWithJxLayer(fieldPopulationSeasonGroupChange), new GridBagConstraints(1, 2, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add(populationSeasonSpecializedUI, new GridBagConstraints(0, 3, 2, 1, 1.0, 0.6, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add($JPanel1, new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 10, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add(SwingUtil.boxComponentWithJxLayer(fieldPopulationSeasonReproduction), new GridBagConstraints(1, 4, 1, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add($JLabel2, new GridBagConstraints(0, 5, 1, 1, 0.0, 0.0, 13, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add(SwingUtil.boxComponentWithJxLayer(fieldPopulationSeasonReproductionDistribution), new GridBagConstraints(1, 5, 1, 1, 1.0, 0.2, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add($JLabel3, new GridBagConstraints(0, 6, 1, 1, 0.0, 0.0, 13, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add($JScrollPane0, new GridBagConstraints(1, 6, 1, 1, 1.0, 0.1, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        // inline complete setup of $JScrollPane0
        $JScrollPane0.getViewport().add(SwingUtil.boxComponentWithJxLayer(fieldPopulationSeasonComment));
        // inline complete setup of $Table2
        $Table2.add(SwingUtil.boxComponentWithJxLayer(save), new GridBagConstraints(0, 0, 1, 1, 0.5, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table2.add(SwingUtil.boxComponentWithJxLayer(cancel), new GridBagConstraints(1, 0, 1, 1, 0.5, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table2.add(SwingUtil.boxComponentWithJxLayer(create), new GridBagConstraints(0, 1, 1, 1, 0.5, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table2.add(SwingUtil.boxComponentWithJxLayer(delete), new GridBagConstraints(1, 1, 1, 1, 0.5, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        
        // apply 28 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
        
        // apply 1 property setters
        fieldPopulationSeasonInfoChooser.setRenderer(new PopulationSeasonInfoComboRenderer());
        // late initializer
        // register 2 validator(s)
        validatorIds = SwingValidatorUtil.detectValidators(this);
        SwingValidatorUtil.installUI(this);
        
        $afterCompleteSetup();
    }

    private void $initialize() {
        if (allComponentsCreated) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        $objectMap.put("$InputContentUI0", $InputContentUI0);
        createBean();
        createPopulationSeasonInfo();
        createHandler();
        createValidator();
        createValidatorSeason();
        createChangeModel();
        // inline creation of $Table0
        $objectMap.put("$Table0", $Table0 = new Table());
        
        $Table0.setName("$Table0");
        // inline creation of $Table1
        $objectMap.put("$Table1", $Table1 = new Table());
        
        $Table1.setName("$Table1");
        // inline creation of $JLabel0
        $objectMap.put("$JLabel0", $JLabel0 = new JLabel());
        
        $JLabel0.setName("$JLabel0");
        $JLabel0.setText(t("isisfish.populationSeasons.selectSeason"));
        createFieldPopulationSeasonInfoChooser();
        // inline creation of $JLabel1
        $objectMap.put("$JLabel1", $JLabel1 = new JLabel());
        
        $JLabel1.setName("$JLabel1");
        $JLabel1.setText(t("isisfish.common.season"));
        createSeasonIntervalPanel();
        // inline creation of $JPanel0
        $objectMap.put("$JPanel0", $JPanel0 = new JPanel());
        
        $JPanel0.setName("$JPanel0");
        createFieldPopulationSeasonGroupChange();
        createPopulationSeasonSpecializedUI();
        // inline creation of $JPanel1
        $objectMap.put("$JPanel1", $JPanel1 = new JPanel());
        
        $JPanel1.setName("$JPanel1");
        createFieldPopulationSeasonReproduction();
        // inline creation of $JLabel2
        $objectMap.put("$JLabel2", $JLabel2 = new JLabel());
        
        $JLabel2.setName("$JLabel2");
        $JLabel2.setText(t("isisfish.populationSeasons.distributionSpawning"));
        createFieldPopulationSeasonReproductionDistribution();
        // inline creation of $JLabel3
        $objectMap.put("$JLabel3", $JLabel3 = new JLabel());
        
        $JLabel3.setName("$JLabel3");
        $JLabel3.setText(t("isisfish.populationSeasons.comments"));
        // inline creation of $JScrollPane0
        $objectMap.put("$JScrollPane0", $JScrollPane0 = new JScrollPane());
        
        $JScrollPane0.setName("$JScrollPane0");
        createFieldPopulationSeasonComment();
        // inline creation of $Table2
        $objectMap.put("$Table2", $Table2 = new Table());
        
        $Table2.setName("$Table2");
        createSave();
        createCancel();
        createCreate();
        createDelete();
        // inline creation of $InputContentUI0
        setName("$InputContentUI0");
        
        // registers 28 data bindings
        $registerDefaultBindings();
        $completeSetup();
    }

    private void $registerDefaultBindings() {
        // register 28 data bindings
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_VALIDATOR_BEAN, true ,"bean") {
        
            @Override
            public void processDataBinding() {
                validator.setBean(getBean());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_VALIDATOR_SEASON_BEAN, true ,"populationSeasonInfo") {
        
            @Override
            public void processDataBinding() {
                validatorSeason.setBean(getPopulationSeasonInfo());
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_CHANGE_MODEL_CHANGED, true, true) {
        
            @Override
            public void applyDataBinding() {
                if (validator != null) {
                    validator.addPropertyChangeListener("changed", this);
                }
                if (validatorSeason != null) {
                    validatorSeason.addPropertyChangeListener("changed", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (validator != null && validatorSeason != null) {
                    changeModel.setChanged(validator.isChanged() || validatorSeason.isChanged());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (validator != null) {
                    validator.removePropertyChangeListener("changed", this);
                }
                if (validatorSeason != null) {
                    validatorSeason.removePropertyChangeListener("changed", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_CHANGE_MODEL_VALID, true, true) {
        
            @Override
            public void applyDataBinding() {
                if (validator != null) {
                    validator.addPropertyChangeListener("valid", this);
                }
                if (validatorSeason != null) {
                    validatorSeason.addPropertyChangeListener("valid", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (validator != null && validatorSeason != null) {
                    changeModel.setValid(validator.isValid() && validatorSeason.isValid());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (validator != null) {
                    validator.removePropertyChangeListener("valid", this);
                }
                if (validatorSeason != null) {
                    validatorSeason.removePropertyChangeListener("valid", this);
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_$JLABEL0_ENABLED, true ,"active") {
        
            @Override
            public void processDataBinding() {
                $JLabel0.setEnabled(isActive());
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_FIELD_POPULATION_SEASON_INFO_CHOOSER_ENABLED, true, true) {
        
            @Override
            public void applyDataBinding() {
                addPropertyChangeListener("active", this);
                addPropertyChangeListener("sensitivity", this);
                if (changeModel != null) {
                    changeModel.addPropertyChangeListener("changed", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (changeModel != null) {
                    fieldPopulationSeasonInfoChooser.setEnabled(isActive() && (isSensitivity() || !changeModel.isChanged() ) );
                }
            }
        
            @Override
            public void removeDataBinding() {
                removePropertyChangeListener("active", this);
                removePropertyChangeListener("sensitivity", this);
                if (changeModel != null) {
                    changeModel.removePropertyChangeListener("changed", this);
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_$JLABEL1_ENABLED, true ,"populationSeasonInfo") {
        
            @Override
            public void processDataBinding() {
                $JLabel1.setEnabled(getPopulationSeasonInfo() != null);
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_SEASON_INTERVAL_PANEL_ENABLED, true ,"populationSeasonInfo") {
        
            @Override
            public void processDataBinding() {
                seasonIntervalPanel.setEnabled(getPopulationSeasonInfo() != null);
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_FIELD_POPULATION_SEASON_GROUP_CHANGE_ENABLED, true ,"populationSeasonInfo") {
        
            @Override
            public void processDataBinding() {
                fieldPopulationSeasonGroupChange.setEnabled(getPopulationSeasonInfo() != null);
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_FIELD_POPULATION_SEASON_GROUP_CHANGE_SELECTED, true, true) {
        
            @Override
            public void applyDataBinding() {
                addPropertyChangeListener("populationSeasonInfo", this);
                if (getPopulationSeasonInfo() != null) {
                    getPopulationSeasonInfo().addPropertyChangeListener("groupChange", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (getPopulationSeasonInfo() != null) {
                    fieldPopulationSeasonGroupChange.setSelected(getPopulationSeasonInfo().isGroupChange());
                }
            }
        
            @Override
            public void removeDataBinding() {
                removePropertyChangeListener("populationSeasonInfo", this);
                if (getPopulationSeasonInfo() != null) {
                    getPopulationSeasonInfo().removePropertyChangeListener("groupChange", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_FIELD_POPULATION_SEASON_GROUP_CHANGE_VISIBLE, true, true) {
        
            @Override
            public void applyDataBinding() {
                addPropertyChangeListener("populationSeasonInfo", this);
                if (getPopulationSeasonInfo() != null) {
                    getPopulationSeasonInfo().addPropertyChangeListener("population", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (getPopulationSeasonInfo() != null && getPopulationSeasonInfo().getPopulation() != null && getPopulationSeasonInfo().getPopulation().getSpecies() != null) {
                    fieldPopulationSeasonGroupChange.setVisible(handler.isAgeGroupType(getPopulationSeasonInfo().getPopulation().getSpecies().isAgeGroupType()));
                }
            }
        
            @Override
            public void removeDataBinding() {
                removePropertyChangeListener("populationSeasonInfo", this);
                if (getPopulationSeasonInfo() != null) {
                    getPopulationSeasonInfo().removePropertyChangeListener("population", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_POPULATION_SEASON_SPECIALIZED_UI_AGE_GROUP_TYPE, true, true) {
        
            @Override
            public void applyDataBinding() {
                addPropertyChangeListener("populationSeasonInfo", this);
                if (getPopulationSeasonInfo() != null) {
                    getPopulationSeasonInfo().addPropertyChangeListener("population", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (getPopulationSeasonInfo() != null && getPopulationSeasonInfo().getPopulation() != null && getPopulationSeasonInfo().getPopulation().getSpecies() != null) {
                    populationSeasonSpecializedUI.setAgeGroupType(handler.isAgeGroupType(!getPopulationSeasonInfo().getPopulation().getSpecies().isAgeGroupType()));
                }
            }
        
            @Override
            public void removeDataBinding() {
                removePropertyChangeListener("populationSeasonInfo", this);
                if (getPopulationSeasonInfo() != null) {
                    getPopulationSeasonInfo().removePropertyChangeListener("population", this);
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_POPULATION_SEASON_SPECIALIZED_UI_BEAN, true ,"bean") {
        
            @Override
            public void processDataBinding() {
                populationSeasonSpecializedUI.setBean(getBean());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_POPULATION_SEASON_SPECIALIZED_UI_POPULATION_SEASON_INFO, true ,"populationSeasonInfo") {
        
            @Override
            public void processDataBinding() {
                populationSeasonSpecializedUI.setPopulationSeasonInfo(getPopulationSeasonInfo());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_FIELD_POPULATION_SEASON_REPRODUCTION_ENABLED, true ,"populationSeasonInfo") {
        
            @Override
            public void processDataBinding() {
                fieldPopulationSeasonReproduction.setEnabled(getPopulationSeasonInfo() != null);
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_FIELD_POPULATION_SEASON_REPRODUCTION_SELECTED, true, true) {
        
            @Override
            public void applyDataBinding() {
                addPropertyChangeListener("populationSeasonInfo", this);
                if (getPopulationSeasonInfo() != null) {
                    getPopulationSeasonInfo().addPropertyChangeListener("reproduction", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (getPopulationSeasonInfo() != null) {
                    fieldPopulationSeasonReproduction.setSelected(getPopulationSeasonInfo().isReproduction());
                }
            }
        
            @Override
            public void removeDataBinding() {
                removePropertyChangeListener("populationSeasonInfo", this);
                if (getPopulationSeasonInfo() != null) {
                    getPopulationSeasonInfo().removePropertyChangeListener("reproduction", this);
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_$JLABEL2_ENABLED, true ,"populationSeasonInfo") {
        
            @Override
            public void processDataBinding() {
                $JLabel2.setEnabled(getPopulationSeasonInfo() != null);
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_$JLABEL2_VISIBLE, true, true) {
        
            @Override
            public void applyDataBinding() {
                addPropertyChangeListener("populationSeasonInfo", this);
                if (getPopulationSeasonInfo() != null) {
                    getPopulationSeasonInfo().addPropertyChangeListener("reproduction", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (getPopulationSeasonInfo() != null) {
                    $JLabel2.setVisible(getPopulationSeasonInfo().isReproduction());
                }
            }
        
            @Override
            public void removeDataBinding() {
                removePropertyChangeListener("populationSeasonInfo", this);
                if (getPopulationSeasonInfo() != null) {
                    getPopulationSeasonInfo().removePropertyChangeListener("reproduction", this);
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_FIELD_POPULATION_SEASON_REPRODUCTION_DISTRIBUTION_ENABLED, true ,"populationSeasonInfo") {
        
            @Override
            public void processDataBinding() {
                fieldPopulationSeasonReproductionDistribution.setEnabled(getPopulationSeasonInfo() != null);
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_FIELD_POPULATION_SEASON_REPRODUCTION_DISTRIBUTION_MATRIX, true, true) {
        
            @Override
            public void applyDataBinding() {
                addPropertyChangeListener("populationSeasonInfo", this);
                if (getPopulationSeasonInfo() != null) {
                    getPopulationSeasonInfo().addPropertyChangeListener("reproductionDistribution", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (getPopulationSeasonInfo() != null && getPopulationSeasonInfo().getReproductionDistribution() != null) {
                    fieldPopulationSeasonReproductionDistribution.setMatrix(getPopulationSeasonInfo() == null ? null : getPopulationSeasonInfo().getReproductionDistribution().copy());
                }
            }
        
            @Override
            public void removeDataBinding() {
                removePropertyChangeListener("populationSeasonInfo", this);
                if (getPopulationSeasonInfo() != null) {
                    getPopulationSeasonInfo().removePropertyChangeListener("reproductionDistribution", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_FIELD_POPULATION_SEASON_REPRODUCTION_DISTRIBUTION_VISIBLE, true, true) {
        
            @Override
            public void applyDataBinding() {
                addPropertyChangeListener("populationSeasonInfo", this);
                if (getPopulationSeasonInfo() != null) {
                    getPopulationSeasonInfo().addPropertyChangeListener("reproduction", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (getPopulationSeasonInfo() != null) {
                    fieldPopulationSeasonReproductionDistribution.setVisible(getPopulationSeasonInfo().isReproduction());
                }
            }
        
            @Override
            public void removeDataBinding() {
                removePropertyChangeListener("populationSeasonInfo", this);
                if (getPopulationSeasonInfo() != null) {
                    getPopulationSeasonInfo().removePropertyChangeListener("reproduction", this);
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_$JLABEL3_ENABLED, true ,"populationSeasonInfo") {
        
            @Override
            public void processDataBinding() {
                $JLabel3.setEnabled(getPopulationSeasonInfo() != null);
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_FIELD_POPULATION_SEASON_COMMENT_ENABLED, true ,"populationSeasonInfo") {
        
            @Override
            public void processDataBinding() {
                fieldPopulationSeasonComment.setEnabled(getPopulationSeasonInfo() != null);
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_FIELD_POPULATION_SEASON_COMMENT_TEXT, true ,"bean") {
        
            @Override
            public void processDataBinding() {
                if (getBean() != null) {
                    SwingUtil.setText(fieldPopulationSeasonComment, jaxx.runtime.SwingUtil.getStringValue(getBean().getSeasonsComment()));
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_SAVE_ENABLED, true, true) {
        
            @Override
            public void applyDataBinding() {
                if (changeModel != null) {
                    changeModel.addPropertyChangeListener("valid", this);
                }
                if (changeModel != null) {
                    changeModel.addPropertyChangeListener("changed", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (changeModel != null) {
                    save.setEnabled(changeModel.isValid() && changeModel.isChanged());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (changeModel != null) {
                    changeModel.removePropertyChangeListener("valid", this);
                }
                if (changeModel != null) {
                    changeModel.removePropertyChangeListener("changed", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_CANCEL_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (changeModel != null) {
                    changeModel.addPropertyChangeListener("changed", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (changeModel != null) {
                    cancel.setEnabled(changeModel.isChanged());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (changeModel != null) {
                    changeModel.removePropertyChangeListener("changed", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_CREATE_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (changeModel != null) {
                    changeModel.addPropertyChangeListener("changed", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (changeModel != null) {
                    create.setEnabled(!changeModel.isChanged());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (changeModel != null) {
                    changeModel.removePropertyChangeListener("changed", this);
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_DELETE_ENABLED, true ,"populationSeasonInfo") {
        
            @Override
            public void processDataBinding() {
                delete.setEnabled(getPopulationSeasonInfo() != null);
            }
        });
    }

}