package fr.ifremer.isisfish.ui.input.population;

/*
 * #%L
 * ISIS-Fish
 * %%
 * Copyright (C) 1999 - 2015 Ifremer, Codelutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import fr.ifremer.isisfish.entities.Population;
import fr.ifremer.isisfish.entities.PopulationGroup;
import fr.ifremer.isisfish.entities.PopulationSeasonInfo;
import fr.ifremer.isisfish.entities.Zone;
import fr.ifremer.isisfish.ui.input.InputContentUI;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.binding.SimpleJAXXObjectBinding;
import jaxx.runtime.swing.Table;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.math.matrix.gui.MatrixPanelEditor;
import org.nuiton.math.matrix.gui.MatrixPanelEvent;
import org.nuiton.math.matrix.gui.MatrixPanelListener;
import static org.nuiton.i18n.I18n.t;

public class PopulationMigrationImmigrationUI extends InputContentUI<Population> {

    /*-----------------------------------------------------------------------*/
    /*---------------- Constants for all javaBean properties ----------------*/
    /*-----------------------------------------------------------------------*/

    public static final String PROPERTY_BEAN = "bean";
    public static final String PROPERTY_POP_INFO = "popInfo";

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_FIELD_POPULATION_MIGRATION_IMMIGRATION_ARRIVAL_ZONE_CHOOSER_ENABLED = "fieldPopulationMigrationImmigrationArrivalZoneChooser.enabled";
    public static final String BINDING_FIELD_POPULATION_MIGRATION_IMMIGRATION_COEFFICIENT_ENABLED = "fieldPopulationMigrationImmigrationCoefficient.enabled";
    public static final String BINDING_FIELD_POPULATION_MIGRATION_IMMIGRATION_GROUP_CHOOSER_ENABLED = "fieldPopulationMigrationImmigrationGroupChooser.enabled";
    public static final String BINDING_POPULATION_MIGRATION_IMMIGRATION_TABLE_ENABLED = "populationMigrationImmigrationTable.enabled";
    public static final String BINDING_REMOVE_ENABLED = "remove.enabled";

    /*-----------------------------------------------------------------------*/
    /*--------------- Constants for all none public bindings  ---------------*/
    /*-----------------------------------------------------------------------*/

    private static final String BINDING_$JLABEL0_ENABLED = "$JLabel0.enabled";
    private static final String BINDING_$JLABEL1_ENABLED = "$JLabel1.enabled";
    private static final String BINDING_$JLABEL2_ENABLED = "$JLabel2.enabled";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAK1VS28TMRB20zcFWqhaiiiilEoVEjgtiAMqj5ZAaaoEEKVS1Vxwuk7iamMb21uWC+In8BPgzgWJGyfEgTMHLoi/gBAHroix81zYpiuFHLxez8w333hmv7z5jvq1Qmd3SRhiFXDDqhSvr2xt3S/u0h1zm+odxaQRCtV+PSmUKqARr3muDTpXyNnwdD08nRFVKTjlbdFLOXRIm2c+1RVKjUGnoxE7Wqc3mualUAaqgdokFYf66ueP1EvvxesUQqEEdmNQysxBUa1K+nIoxTyDjkOmPZL2CS8DDcV4GfgesWcZn2h9j1TpE/QcDebQgCQKwAyaTV6yw3DxoTRobC7LZWAyghtw38wuGLRWUpiVFK1SeGqmS0xXcMAws45YChn4xDDB8YPmNs/Kym2y1Wpju5mV0uUZMKivSAk3aD4OGdIyw6hug2sFDkK6LC8JgxYTxm5QooEHxLShVAj3fKoMyv+f2tZqeO0FCu8ZdM42KcT6KfQMrz8gnPptLOYekaJP4YanIjNR83Y26znRDBiaW8+RIvUX/gZ2p9ZpqumbLjHqe51Z31UikJmKENpexUQEEiamKG6JMIraYLBo309HbThBxoygpRLbYW5GJyMJH9HQrFqE+IyXYjJeSZBxRSm2R/xtmP56pTZ45p8krjcL9v1E1NZLPPgExyNcbwXGCB71Oyc78nDtNOiCUGXMAwbhuEpMxS6KhbgMM5d3W0fkjgceKppgAKZU7LmRwHWLQqcikwM6hVs61RKSngLqVwEcw6gV/pW2h2CqidrUX6JmAZ319+T4l/ff3q02lGwUck/EurYJMSiMVELCcDGberQmY4FhfjpP5FIBDWvqg4o7lZ6OIbZRNwM5yHfMhmMbjteIrgBE/+DXDx8nH3/uRalVdMgXxFsl1j+Lhk1FwS0I3wvlzWXH6PDTISvBlht8e5TbhkBnj17ziCEzRcY96O2NEG5hOuYWmlSKw59+jW+8XW7cRA8wO7mve+s2+rfRAOM+49Spel2wY1V8RGoaeKIlzHFS3WOf07IuJ1fdej2u1D4DXxYoxrVa9hliYMyKgaFQqw1acUXYXSYhpj2+aZfleIQzXSPMJkK4a5e1bhA6cZjrGmG+6yqSIXTicD45wj4cLnZdRTKETlUsJJjzETvdROWFV/sv3IfMwVAHkbnc9YVYhD8CP9Oc2goAAA==";
    private static final Log log = LogFactory.getLog(PopulationMigrationImmigrationUI.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    private boolean allComponentsCreated;

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected JButton add;
    protected Population bean;
    protected JComboBox<Zone> fieldPopulationMigrationImmigrationArrivalZoneChooser;
    protected JTextField fieldPopulationMigrationImmigrationCoefficient;
    protected JComboBox<PopulationGroup> fieldPopulationMigrationImmigrationGroupChooser;
    protected PopulationMigrationImmigrationHandler handler;
    protected PopulationSeasonInfo popInfo;
    protected MatrixPanelEditor populationMigrationImmigrationTable;
    protected JButton remove;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private PopulationMigrationImmigrationUI $InputContentUI0 = this;
    private JLabel $JLabel0;
    private JLabel $JLabel1;
    private JLabel $JLabel2;
    private JPanel $JPanel0;
    private Table $Table0;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/

    protected void $afterCompleteSetup() {
            handler.afterInit();
        }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public PopulationMigrationImmigrationUI(LayoutManager param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public PopulationMigrationImmigrationUI(JAXXContext param0, LayoutManager param1, boolean param2) {
        super(param0 ,param1 ,param2);
        $initialize();
    }

    public PopulationMigrationImmigrationUI(LayoutManager param0) {
        super(param0);
        $initialize();
    }

    public PopulationMigrationImmigrationUI(JAXXContext param0, LayoutManager param1) {
        super(param0 ,param1);
        $initialize();
    }

    public PopulationMigrationImmigrationUI() {
        $initialize();
    }

    public PopulationMigrationImmigrationUI(JAXXContext param0) {
        super(param0);
        $initialize();
    }

    public PopulationMigrationImmigrationUI(boolean param0) {
        super(param0);
        $initialize();
    }

    public PopulationMigrationImmigrationUI(JAXXContext param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doActionPerformed__on__add(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.add();
    }

    public void doActionPerformed__on__fieldPopulationMigrationImmigrationArrivalZoneChooser(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.setAddButton();
    }

    public void doActionPerformed__on__fieldPopulationMigrationImmigrationGroupChooser(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.setAddButton();
    }

    public void doActionPerformed__on__remove(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.remove();
    }

    public void doKeyReleased__on__fieldPopulationMigrationImmigrationCoefficient(KeyEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.setAddButton();
    }

    public void doMatrixChanged__on__populationMigrationImmigrationTable(MatrixPanelEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.populationMigrationImmigrationMatrixChanged(event);
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public JButton getAdd() {
        return add;
    }

    public Population getBean() {
        return bean;
    }

    public JComboBox<Zone> getFieldPopulationMigrationImmigrationArrivalZoneChooser() {
        return fieldPopulationMigrationImmigrationArrivalZoneChooser;
    }

    public JTextField getFieldPopulationMigrationImmigrationCoefficient() {
        return fieldPopulationMigrationImmigrationCoefficient;
    }

    public JComboBox<PopulationGroup> getFieldPopulationMigrationImmigrationGroupChooser() {
        return fieldPopulationMigrationImmigrationGroupChooser;
    }

    public PopulationMigrationImmigrationHandler getHandler() {
        return handler;
    }

    public PopulationSeasonInfo getPopInfo() {
        return popInfo;
    }

    public MatrixPanelEditor getPopulationMigrationImmigrationTable() {
        return populationMigrationImmigrationTable;
    }

    public JButton getRemove() {
        return remove;
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public mutator methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public void setBean(Population bean) {
        Population oldValue = this.bean;
        this.bean = bean;
        firePropertyChange(PROPERTY_BEAN, oldValue, bean);
    }

    public void setPopInfo(PopulationSeasonInfo popInfo) {
        PopulationSeasonInfo oldValue = this.popInfo;
        this.popInfo = popInfo;
        firePropertyChange(PROPERTY_POP_INFO, oldValue, popInfo);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected JLabel get$JLabel0() {
        return $JLabel0;
    }

    protected JLabel get$JLabel1() {
        return $JLabel1;
    }

    protected JLabel get$JLabel2() {
        return $JLabel2;
    }

    protected JPanel get$JPanel0() {
        return $JPanel0;
    }

    protected Table get$Table0() {
        return $Table0;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToBody() {
        if (!allComponentsCreated) {
            return;
        }
        body.add($Table0);
    }

    protected void createAdd() {
        $objectMap.put("add", add = new JButton());
        
        add.setName("add");
        add.setEnabled(false);
        add.setText(t("isisfish.common.add"));
        add.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__add"));
    }

    protected void createBean() {
        $objectMap.put("bean", bean = null);
    }

    @Override
    protected void createBody() {
        super.createBody();
        body.setName("body");
    }

    protected void createFieldPopulationMigrationImmigrationArrivalZoneChooser() {
        $objectMap.put("fieldPopulationMigrationImmigrationArrivalZoneChooser", fieldPopulationMigrationImmigrationArrivalZoneChooser = new JComboBox<Zone>());
        
        fieldPopulationMigrationImmigrationArrivalZoneChooser.setName("fieldPopulationMigrationImmigrationArrivalZoneChooser");
        fieldPopulationMigrationImmigrationArrivalZoneChooser.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__fieldPopulationMigrationImmigrationArrivalZoneChooser"));
    }

    protected void createFieldPopulationMigrationImmigrationCoefficient() {
        $objectMap.put("fieldPopulationMigrationImmigrationCoefficient", fieldPopulationMigrationImmigrationCoefficient = new JTextField());
        
        fieldPopulationMigrationImmigrationCoefficient.setName("fieldPopulationMigrationImmigrationCoefficient");
        fieldPopulationMigrationImmigrationCoefficient.setColumns(15);
        fieldPopulationMigrationImmigrationCoefficient.addKeyListener(JAXXUtil.getEventListener(KeyListener.class, "keyReleased", this, "doKeyReleased__on__fieldPopulationMigrationImmigrationCoefficient"));
    }

    protected void createFieldPopulationMigrationImmigrationGroupChooser() {
        $objectMap.put("fieldPopulationMigrationImmigrationGroupChooser", fieldPopulationMigrationImmigrationGroupChooser = new JComboBox<PopulationGroup>());
        
        fieldPopulationMigrationImmigrationGroupChooser.setName("fieldPopulationMigrationImmigrationGroupChooser");
        fieldPopulationMigrationImmigrationGroupChooser.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__fieldPopulationMigrationImmigrationGroupChooser"));
    }

    protected void createHandler() {
        $objectMap.put("handler", handler = new PopulationMigrationImmigrationHandler(this));
    }

    protected void createPopInfo() {
        $objectMap.put("popInfo", popInfo = null);
    }

    protected void createPopulationMigrationImmigrationTable() {
        $objectMap.put("populationMigrationImmigrationTable", populationMigrationImmigrationTable = new MatrixPanelEditor());
        
        populationMigrationImmigrationTable.setName("populationMigrationImmigrationTable");
        populationMigrationImmigrationTable.setLinearModel(true);
        populationMigrationImmigrationTable.addMatrixPanelListener(JAXXUtil.getEventListener(MatrixPanelListener.class, "matrixChanged", this, "doMatrixChanged__on__populationMigrationImmigrationTable"));
    }

    protected void createRemove() {
        $objectMap.put("remove", remove = new JButton());
        
        remove.setName("remove");
        remove.setText(t("isisfish.common.remove"));
        remove.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__remove"));
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        addChildrenToBody();
        // inline complete setup of $Table0
        $Table0.add($JLabel0, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(fieldPopulationMigrationImmigrationGroupChooser, new GridBagConstraints(1, 0, 1, 1, 0.5, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add($JLabel1, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(fieldPopulationMigrationImmigrationCoefficient, new GridBagConstraints(3, 0, 1, 1, 0.5, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add($JLabel2, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(fieldPopulationMigrationImmigrationArrivalZoneChooser, new GridBagConstraints(1, 1, 1, 1, 0.5, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add($JPanel0, new GridBagConstraints(2, 1, 2, 1, 0.5, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(add, new GridBagConstraints(0, 2, 4, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(populationMigrationImmigrationTable, new GridBagConstraints(0, 3, 4, 1, 1.0, 1.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(remove, new GridBagConstraints(0, 4, 4, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        
        // apply 8 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
        
        $afterCompleteSetup();
    }

    private void $initialize() {
        if (allComponentsCreated) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        $objectMap.put("$InputContentUI0", $InputContentUI0);
        createBean();
        createPopInfo();
        createHandler();
        // inline creation of $Table0
        $objectMap.put("$Table0", $Table0 = new Table());
        
        $Table0.setName("$Table0");
        // inline creation of $JLabel0
        $objectMap.put("$JLabel0", $JLabel0 = new JLabel());
        
        $JLabel0.setName("$JLabel0");
        $JLabel0.setText(t("isisfish.common.populationGroup"));
        createFieldPopulationMigrationImmigrationGroupChooser();
        // inline creation of $JLabel1
        $objectMap.put("$JLabel1", $JLabel1 = new JLabel());
        
        $JLabel1.setName("$JLabel1");
        $JLabel1.setText(t("isisfish.populationMigrationImmigration.coefficient"));
        createFieldPopulationMigrationImmigrationCoefficient();
        // inline creation of $JLabel2
        $objectMap.put("$JLabel2", $JLabel2 = new JLabel());
        
        $JLabel2.setName("$JLabel2");
        $JLabel2.setText(t("isisfish.populationMigrationImmigration.arrivalZone"));
        createFieldPopulationMigrationImmigrationArrivalZoneChooser();
        // inline creation of $JPanel0
        $objectMap.put("$JPanel0", $JPanel0 = new JPanel());
        
        $JPanel0.setName("$JPanel0");
        createAdd();
        createPopulationMigrationImmigrationTable();
        createRemove();
        // inline creation of $InputContentUI0
        setName("$InputContentUI0");
        
        // registers 8 data bindings
        $registerDefaultBindings();
        $completeSetup();
    }

    private void $registerDefaultBindings() {
        // register 8 data bindings
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_$JLABEL0_ENABLED, true ,"active") {
        
            @Override
            public void processDataBinding() {
                $JLabel0.setEnabled(isActive());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_FIELD_POPULATION_MIGRATION_IMMIGRATION_GROUP_CHOOSER_ENABLED, true ,"active") {
        
            @Override
            public void processDataBinding() {
                fieldPopulationMigrationImmigrationGroupChooser.setEnabled(isActive());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_$JLABEL1_ENABLED, true ,"active") {
        
            @Override
            public void processDataBinding() {
                $JLabel1.setEnabled(isActive());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_FIELD_POPULATION_MIGRATION_IMMIGRATION_COEFFICIENT_ENABLED, true ,"active") {
        
            @Override
            public void processDataBinding() {
                fieldPopulationMigrationImmigrationCoefficient.setEnabled(isActive());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_$JLABEL2_ENABLED, true ,"active") {
        
            @Override
            public void processDataBinding() {
                $JLabel2.setEnabled(isActive());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_FIELD_POPULATION_MIGRATION_IMMIGRATION_ARRIVAL_ZONE_CHOOSER_ENABLED, true ,"active") {
        
            @Override
            public void processDataBinding() {
                fieldPopulationMigrationImmigrationArrivalZoneChooser.setEnabled(isActive());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_POPULATION_MIGRATION_IMMIGRATION_TABLE_ENABLED, true ,"active") {
        
            @Override
            public void processDataBinding() {
                populationMigrationImmigrationTable.setEnabled(isActive());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_REMOVE_ENABLED, true ,"active") {
        
            @Override
            public void processDataBinding() {
                remove.setEnabled(isActive());
            }
        });
    }

}