package fr.ifremer.isisfish.ui.input.gear;

/*
 * #%L
 * ISIS-Fish
 * %%
 * Copyright (C) 1999 - 2015 Ifremer, Codelutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import fr.ifremer.isisfish.entities.Gear;
import fr.ifremer.isisfish.entities.Population;
import fr.ifremer.isisfish.ui.input.ChangeModel;
import fr.ifremer.isisfish.ui.input.InputContentUI;
import fr.ifremer.isisfish.ui.input.equation.InputOneEquationUI;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.JAXXValidator;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.binding.DefaultJAXXBinding;
import jaxx.runtime.binding.SimpleJAXXObjectBinding;
import jaxx.runtime.swing.Table;
import jaxx.runtime.validator.swing.SwingValidator;
import jaxx.runtime.validator.swing.SwingValidatorUtil;
import jaxx.runtime.validator.swing.meta.Validator;
import jaxx.runtime.validator.swing.meta.ValidatorField;
import jaxx.runtime.validator.swing.ui.ImageValidationUI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import static org.nuiton.i18n.I18n.t;

public class SelectivityUI extends InputContentUI<Gear> implements JAXXValidator {

    /*-----------------------------------------------------------------------*/
    /*---------------- Constants for all javaBean properties ----------------*/
    /*-----------------------------------------------------------------------*/

    public static final String PROPERTY_BEAN = "bean";
    public static final String PROPERTY_POPULATION = "population";

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_ADD_SELECTIVITY_BUTTON_ENABLED = "addSelectivityButton.enabled";
    public static final String BINDING_CANCEL_ENABLED = "cancel.enabled";
    public static final String BINDING_CHANGE_MODEL_CHANGED = "changeModel.changed";
    public static final String BINDING_CHANGE_MODEL_VALID = "changeModel.valid";
    public static final String BINDING_FIELD_SELECTIVITY_POPULATION_ENABLED = "fieldSelectivityPopulation.enabled";
    public static final String BINDING_SAVE_ENABLED = "save.enabled";
    public static final String BINDING_SELECTIVITY_EQUATION_ACTIVE = "selectivityEquation.active";
    public static final String BINDING_SELECTIVITY_EQUATION_BEAN = "selectivityEquation.bean";
    public static final String BINDING_SELECTIVITY_TABLE_ENABLED = "selectivityTable.enabled";
    public static final String BINDING_VALIDATOR_BEAN = "validator.bean";

    /*-----------------------------------------------------------------------*/
    /*--------------- Constants for all none public bindings  ---------------*/
    /*-----------------------------------------------------------------------*/

    private static final String BINDING_$JLABEL0_ENABLED = "$JLabel0.enabled";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAKVVTY8bNRj2hk3S7LZ0afpJS7VLIxWBmBTBAbSlLQ1sNyFLVw1bVYQDTsZJXDm2a3uysz0gfgI/odx7QeLGCXHgzIEL4i8gxIEr4vVMMh+76XRo9uDJ+n2fx4+f13799E9U1AptPMS+7yiPGzomTuujBw/u9h6SvvmY6L6i0giFwr+lAip00aobzWuDrnTbFl6fwusNMZaCE55Ab7bRijYHjOgRIcag19KIvtb1ThTe9KWnZqyRqHmsT/7+q/Ct+813BYR8CeqqsJX156HinSy3UYG6Bp2ClSa4zjAfggxF+RD0nrBzDYa1/gyPySP0NSq3UUliBWQGvZ5/ywFHgPelQWu1JpeeaQhuIH2vec2g+kA5dKDImMBXUz2geuR41KE20RkSrJwOYVANOqHmYK8pZUBXMmi5RzA3aGMeAbBTQ4l27gBBDFmRQnoMGwoC0NVM4G6UGcPLI8xdRpRB7/0v1dshLCaqTDCjLgajDHorVbIo4Oh9KIXTseP92WTMsNoHLUOyI1zCDHojU04jTk26J9wDqL4ttD9drLWLeTKnXPsc9xiBKp1PiQyzg5jNvHgY8I79d90Ol6PQsVqrjXuEXTu8ZjBrkzai3FcHlDA3YeBuomxnUmg4ez1xW/hpgqqOsZ888qbI9zNdItM8JziidzmZAfeaafLT2E1qu+0ZY9mrKV3hbBp4otbq9JVgzNoMPpxLIeJQGrWW2Evg7mEDozrUY4m1NtVmKlLwoPSw4OUk7mhGXPhzYJKYkCO7tGEnLW9Z4wmJ5uN6l/qY98PCziIKXUwdI2h8Ttz44s601EVF5cE0nLvu0V55D0Jhlzx/qEtawiD679nqbz/+8cPWrDWehrXPzE1NdHZoWVIJCdeb2qVPhn3RM5TVd7Dc7KJKWImg7V+aI6wzDYM4WO8VC3cs3NnGegQUxfLvP/189qtfX0KFLbTCBHa3sM1voooZKXBBMNeXN28Fio7vH4NxzWqDexXedujWL1+HRoDXe5S7UMQbPrhwaY4LkZRe5Zd/qp3vb82cWAJlF56ZHrtR/AKVKGeUk+CZmL4Ac5+FVamJ54q408/r/Uv2e0FOj1gjGO/M22ox6IA23PI9+/k0UG1/7eQmKRNuL0UWTS0HzbIhPjx3p66HTqxjA+9jzzPkxoty2un7Gaqu5lBVwvZOkgyWN/Pszb6eC3IU+ww/frwgycmBUGO4iQ1syFCoA5v45YvS2enuwgxZFXp7YQ35GLI0vJvD1ooS+9uEDkcmQ8rziSIpz2D4YGE78jFk2bG5sIZ8DFkaPlxYg2X4D7n/WMaRDAAA";
    private static final Log log = LogFactory.getLog(SelectivityUI.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    private boolean allComponentsCreated;

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected JButton addSelectivityButton;
    protected Gear bean;
    protected JButton cancel;
    protected ChangeModel changeModel;
    protected JComboBox<Population> fieldSelectivityPopulation;
    protected SelectivityHandler handler;
    protected Population population;
    protected JButton removeSelectivityButton;
    protected JButton save;
    protected InputOneEquationUI selectivityEquation;
    protected JTable selectivityTable;
    @Validator( validatorId = "validator")
    protected SwingValidator<Gear> validator;
    protected List<String> validatorIds = new ArrayList<String>();

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private SelectivityUI $InputContentUI0 = this;
    private JLabel $JLabel0;
    private JScrollPane $JScrollPane0;
    private ListSelectionModel $ListSelectionModel0;
    private Table $Table0;
    private Table $Table1;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/

    protected void $afterCompleteSetup() {
            handler.afterInit();
        }
    
        @Override
        public void resetChangeModel() {
            changeModel.setStayChanged(false);
        }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public SelectivityUI(LayoutManager param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public SelectivityUI(JAXXContext param0, LayoutManager param1, boolean param2) {
        super(param0 ,param1 ,param2);
        $initialize();
    }

    public SelectivityUI(LayoutManager param0) {
        super(param0);
        $initialize();
    }

    public SelectivityUI(JAXXContext param0, LayoutManager param1) {
        super(param0 ,param1);
        $initialize();
    }

    public SelectivityUI() {
        $initialize();
    }

    public SelectivityUI(JAXXContext param0) {
        super(param0);
        $initialize();
    }

    public SelectivityUI(boolean param0) {
        super(param0);
        $initialize();
    }

    public SelectivityUI(JAXXContext param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*-------------------- JAXXValidator implementation  --------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public SwingValidator<?> getValidator(String validatorId) {
        return (SwingValidator<?>) (validatorIds.contains(validatorId) ? getObjectById(validatorId) : null);
    }

    @Override
    public List<String> getValidatorIds() {
        return validatorIds;
    }

    @Override
    public void registerValidatorFields() {
        SwingValidatorUtil.detectValidatorFields(this);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doActionPerformed__on__addSelectivityButton(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.addSelectivity();
    }

    public void doActionPerformed__on__cancel(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getSaveVerifier().cancel();
    }

    public void doActionPerformed__on__removeSelectivityButton(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.removeSelectivity();
    }

    public void doActionPerformed__on__save(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getSaveVerifier().save();validator.setChanged(false);changeModel.setStayChanged(false);
    }

    public void doItemStateChanged__on__fieldSelectivityPopulation(ItemEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.selectivityChanged();
    }

    public void doValueChanged__on__$ListSelectionModel0(ListSelectionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        removeSelectivityButton.setEnabled(isActive() && selectivityTable.getSelectedRow() != -1);
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public JButton getAddSelectivityButton() {
        return addSelectivityButton;
    }

    public Gear getBean() {
        return bean;
    }

    public JButton getCancel() {
        return cancel;
    }

    public ChangeModel getChangeModel() {
        return changeModel;
    }

    public JComboBox<Population> getFieldSelectivityPopulation() {
        return fieldSelectivityPopulation;
    }

    public SelectivityHandler getHandler() {
        return handler;
    }

    public Population getPopulation() {
        return population;
    }

    public JButton getRemoveSelectivityButton() {
        return removeSelectivityButton;
    }

    public JButton getSave() {
        return save;
    }

    public InputOneEquationUI getSelectivityEquation() {
        return selectivityEquation;
    }

    public JTable getSelectivityTable() {
        return selectivityTable;
    }

    public SwingValidator<Gear> getValidator() {
        return validator;
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public mutator methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public void setBean(Gear bean) {
        Gear oldValue = this.bean;
        this.bean = bean;
        firePropertyChange(PROPERTY_BEAN, oldValue, bean);
    }

    public void setPopulation(Population population) {
        Population oldValue = this.population;
        this.population = population;
        firePropertyChange(PROPERTY_POPULATION, oldValue, population);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected JLabel get$JLabel0() {
        return $JLabel0;
    }

    protected JScrollPane get$JScrollPane0() {
        return $JScrollPane0;
    }

    protected ListSelectionModel get$ListSelectionModel0() {
        return $ListSelectionModel0;
    }

    protected Table get$Table0() {
        return $Table0;
    }

    protected Table get$Table1() {
        return $Table1;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToBody() {
        if (!allComponentsCreated) {
            return;
        }
        body.add($Table0);
    }

    protected void addChildrenToValidator() {
        if (!allComponentsCreated) {
            return;
        }
        validator.setUiClass(ImageValidationUI.class);
    }

    protected void createAddSelectivityButton() {
        $objectMap.put("addSelectivityButton", addSelectivityButton = new JButton());
        
        addSelectivityButton.setName("addSelectivityButton");
        addSelectivityButton.setText(t("isisfish.common.add"));
        addSelectivityButton.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__addSelectivityButton"));
    }

    protected void createBean() {
        $objectMap.put("bean", bean = null);
    }

    @Override
    protected void createBody() {
        super.createBody();
        body.setName("body");
    }

    protected void createCancel() {
        $objectMap.put("cancel", cancel = new JButton());
        
        cancel.setName("cancel");
        cancel.setText(t("isisfish.common.cancel"));
        cancel.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__cancel"));
    }

    protected void createChangeModel() {
        $objectMap.put("changeModel", changeModel = new ChangeModel());
    }

    protected void createFieldSelectivityPopulation() {
        $objectMap.put("fieldSelectivityPopulation", fieldSelectivityPopulation = new JComboBox<Population>());
        
        fieldSelectivityPopulation.setName("fieldSelectivityPopulation");
        fieldSelectivityPopulation.addItemListener(JAXXUtil.getEventListener(ItemListener.class, "itemStateChanged", this, "doItemStateChanged__on__fieldSelectivityPopulation"));
    }

    protected void createHandler() {
        $objectMap.put("handler", handler = new SelectivityHandler(this));
    }

    protected void createPopulation() {
        $objectMap.put("population", population = null);
    }

    protected void createRemoveSelectivityButton() {
        $objectMap.put("removeSelectivityButton", removeSelectivityButton = new JButton());
        
        removeSelectivityButton.setName("removeSelectivityButton");
        removeSelectivityButton.setEnabled(false);
        removeSelectivityButton.setText(t("isisfish.common.remove"));
        removeSelectivityButton.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__removeSelectivityButton"));
    }

    protected void createSave() {
        $objectMap.put("save", save = new JButton());
        
        save.setName("save");
        save.setText(t("isisfish.common.save"));
        save.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__save"));
    }

    protected void createSelectivityEquation() {
        $objectMap.put("selectivityEquation", selectivityEquation = new InputOneEquationUI(this));
        
        selectivityEquation.setName("selectivityEquation");
        selectivityEquation.setFormuleCategory("Selectivity");
        selectivityEquation.setText(t("isisfish.selectivity.equation"));
    }

    protected void createSelectivityTable() {
        $objectMap.put("selectivityTable", selectivityTable = new JTable());
        
        selectivityTable.setName("selectivityTable");
        selectivityTable.setRowHeight(24);
    }

    protected void createValidator() {
        $objectMap.put("validator", validator = SwingValidator.newValidator(Gear.class, "selectivity"));
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        addChildrenToValidator();
        addChildrenToBody();
        // inline complete setup of $Table0
        $Table0.add($Table1, new GridBagConstraints(0, 0, 2, 1, 1.0, 1.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(SwingUtil.boxComponentWithJxLayer(save), new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(SwingUtil.boxComponentWithJxLayer(cancel), new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        // inline complete setup of $Table1
        $Table1.add(SwingUtil.boxComponentWithJxLayer($JLabel0), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 13, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add(SwingUtil.boxComponentWithJxLayer(fieldSelectivityPopulation), new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add(SwingUtil.boxComponentWithJxLayer(selectivityEquation), new GridBagConstraints(0, 1, 2, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        $Table1.add(SwingUtil.boxComponentWithJxLayer(addSelectivityButton), new GridBagConstraints(0, 2, 2, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add($JScrollPane0, new GridBagConstraints(0, 3, 2, 1, 1.0, 1.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add(SwingUtil.boxComponentWithJxLayer(removeSelectivityButton), new GridBagConstraints(0, 4, 2, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        // inline complete setup of $JScrollPane0
        $JScrollPane0.getViewport().add(SwingUtil.boxComponentWithJxLayer(selectivityTable));
        
        // apply 11 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
        
        // apply 1 property setters
        selectivityEquation.setClazz(fr.ifremer.isisfish.equation.SelectivityEquation.class);
        // late initializer
        // register 1 validator(s)
        validatorIds = SwingValidatorUtil.detectValidators(this);
        SwingValidatorUtil.installUI(this);
        
        $afterCompleteSetup();
    }

    private void $initialize() {
        if (allComponentsCreated) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        $objectMap.put("$InputContentUI0", $InputContentUI0);
        createBean();
        createPopulation();
        createHandler();
        createValidator();
        createChangeModel();
        // inline creation of $Table0
        $objectMap.put("$Table0", $Table0 = new Table());
        
        $Table0.setName("$Table0");
        // inline creation of $Table1
        $objectMap.put("$Table1", $Table1 = new Table());
        
        $Table1.setName("$Table1");
        // inline creation of $JLabel0
        $objectMap.put("$JLabel0", $JLabel0 = new JLabel());
        
        $JLabel0.setName("$JLabel0");
        $JLabel0.setText(t("isisfish.selectivity.selectPopulation"));
        createFieldSelectivityPopulation();
        createSelectivityEquation();
        createAddSelectivityButton();
        // inline creation of $JScrollPane0
        $objectMap.put("$JScrollPane0", $JScrollPane0 = new JScrollPane());
        
        $JScrollPane0.setName("$JScrollPane0");
        createSelectivityTable();
        // inline creation of $ListSelectionModel0
        $objectMap.put("$ListSelectionModel0", $ListSelectionModel0 = selectivityTable.getSelectionModel());
        
        $ListSelectionModel0.addListSelectionListener(JAXXUtil.getEventListener(ListSelectionListener.class, "valueChanged", this, "doValueChanged__on__$ListSelectionModel0"));
        createRemoveSelectivityButton();
        createSave();
        createCancel();
        // inline creation of $InputContentUI0
        setName("$InputContentUI0");
        
        // registers 11 data bindings
        $registerDefaultBindings();
        $completeSetup();
    }

    private void $registerDefaultBindings() {
        // register 11 data bindings
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_VALIDATOR_BEAN, true ,"bean") {
        
            @Override
            public void processDataBinding() {
                validator.setBean(getBean());
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_CHANGE_MODEL_CHANGED, true) {
        
            @Override
            public void applyDataBinding() {
                if (validator != null) {
                    validator.addPropertyChangeListener("changed", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (validator != null) {
                    changeModel.setChanged(validator.isChanged());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (validator != null) {
                    validator.removePropertyChangeListener("changed", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_CHANGE_MODEL_VALID, true) {
        
            @Override
            public void applyDataBinding() {
                if (validator != null) {
                    validator.addPropertyChangeListener("valid", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (validator != null) {
                    changeModel.setValid(validator.isValid());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (validator != null) {
                    validator.removePropertyChangeListener("valid", this);
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_$JLABEL0_ENABLED, true ,"active") {
        
            @Override
            public void processDataBinding() {
                $JLabel0.setEnabled(isActive());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_FIELD_SELECTIVITY_POPULATION_ENABLED, true ,"active") {
        
            @Override
            public void processDataBinding() {
                fieldSelectivityPopulation.setEnabled(isActive());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_SELECTIVITY_EQUATION_ACTIVE, true ,"population") {
        
            @Override
            public void processDataBinding() {
                selectivityEquation.setActive(getPopulation() != null);
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_SELECTIVITY_EQUATION_BEAN, true ,"bean") {
        
            @Override
            public void processDataBinding() {
                selectivityEquation.setBean(getBean());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_ADD_SELECTIVITY_BUTTON_ENABLED, true ,"population") {
        
            @Override
            public void processDataBinding() {
                addSelectivityButton.setEnabled(getPopulation() != null);
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_SELECTIVITY_TABLE_ENABLED, true ,"active") {
        
            @Override
            public void processDataBinding() {
                selectivityTable.setEnabled(isActive());
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_SAVE_ENABLED, true, true) {
        
            @Override
            public void applyDataBinding() {
                if (changeModel != null) {
                    changeModel.addPropertyChangeListener("valid", this);
                }
                if (changeModel != null) {
                    changeModel.addPropertyChangeListener("changed", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (changeModel != null) {
                    save.setEnabled(changeModel.isValid() && changeModel.isChanged());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (changeModel != null) {
                    changeModel.removePropertyChangeListener("valid", this);
                }
                if (changeModel != null) {
                    changeModel.removePropertyChangeListener("changed", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_CANCEL_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (changeModel != null) {
                    changeModel.addPropertyChangeListener("changed", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (changeModel != null) {
                    cancel.setEnabled(changeModel.isChanged());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (changeModel != null) {
                    changeModel.removePropertyChangeListener("changed", this);
                }
            }
        });
    }

}