package fr.ifremer.isisfish.ui.input.gear;

/*
 * #%L
 * ISIS-Fish
 * %%
 * Copyright (C) 1999 - 2015 Ifremer, Codelutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import fr.ifremer.isisfish.entities.Gear;
import fr.ifremer.isisfish.ui.input.InputContentUI;
import java.awt.BorderLayout;
import java.awt.LayoutManager;
import javax.swing.JTabbedPane;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.binding.SimpleJAXXObjectBinding;
import jaxx.runtime.swing.TabInfo;
import jaxx.runtime.swing.TabInfoPropertyChangeListener;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import static org.nuiton.i18n.I18n.t;

public class GearUI extends InputContentUI<fr.ifremer.isisfish.entities.Gear> {

    /*-----------------------------------------------------------------------*/
    /*---------------- Constants for all javaBean properties ----------------*/
    /*-----------------------------------------------------------------------*/

    public static final String PROPERTY_BEAN = "bean";

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_GEAR_TAB_UI_ACTIVE = "gearTabUI.active";
    public static final String BINDING_GEAR_TAB_UI_BEAN = "gearTabUI.bean";
    public static final String BINDING_GEAR_TAB_UI_SENSITIVITY = "gearTabUI.sensitivity";
    public static final String BINDING_SELECTIVITY_UI_ACTIVE = "selectivityUI.active";
    public static final String BINDING_SELECTIVITY_UI_BEAN = "selectivityUI.bean";
    public static final String BINDING_SELECTIVITY_UI_SENSITIVITY = "selectivityUI.sensitivity";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAKVUPW8TQRAdm9jBCYGQKCEBIyWQIhKwFyhojCAoKMSR+RAmUoQb1rl1vNF5b9ndS84N4ifwE6CnQaKjQhTUFDSIv4AQBS1idu34gxzEUlzsWTPvvZmdm3dvvkNGK5jfoXFMVCQMbzCyfntz80F1h22ZO0xvKS5NqKD1S6UhXYFRvxPXBi5WSpbuteneStiQoWCih10owYg2zYDpOmPGwPl+xpbWXrmTLsQyUvuqnaaSVF/9/JF+6b94nQaIJXaXw6vMHcbq3mSoBGnuG5jASrvUC6jYxjYUF9vY75iNrQRU6/u0wZ7BcxguQVZShWIGLgx+Zafh+LE0ML5QFDIyK6EwCN8oLhlYrCnCa4o1GD411zWu6yTihFsg2WZUkbt4bBSldDpZA0NVRoWB+SQmynLDmXakLmW4ToUfMGXgymD11lr43qKh38Rp2cHERO/hnMj6QypY0FPF0h/TqoEzfTAMVZlvwRY40cHn2viNooFLg/Xl0JY+1VEZ0yzAbeW73DStkne4UrmX0a+WW8ASRVEL8d2c7dum1mXaWXmQcNUG5jCh4FwfERecdBe8u4GpCmRUhGEDM5WDnniEqZYbZv5ygxV02d/Tk1/ef3u3um+BLNaeSoT2OBhXU6pQ4jJwW/pUa/8jwwPvHpWFChrJjcfZO5/QWLmdxuaw3mlLJ5ZO1qiuo0Rm+OuHj9NPPx+D9CqMBCH1V6nFFyFn6gqnEAZ+LG8tu45O7B3Hc9z2ZiBL7VvBGZ284VND56pc+Dj0mzEOIZ8whE4n1dynX5Plt8v7g0hhY7P/hHeHkXkCWS4CLpj7GrSNnuj+UalZ5IddQydZPGWfs7K9HYvuvJx0U+dhm/XiyD6WXNP237WBNUY1E5q31vhIUjZM/qOQH0jh+pEVCoco/AGUoeiAsAYAAA==";
    private static final Log log = LogFactory.getLog(GearUI.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    private boolean allComponentsCreated;

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected Gear bean;
    protected JTabbedPane gearTab;
    protected GearTabUI gearTabUI;
    protected GearHandler handler;
    protected SelectivityUI selectivityUI;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private GearUI $InputContentUI0 = this;
    private TabInfo $TabInfo0;
    private TabInfo $TabInfo1;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/

    protected void $afterCompleteSetup() {
            handler.afterInit();
        }
    
        @Override
        public void setLayer(boolean active) {
            super.setLayer(active);
            gearTabUI.setLayer(active);
            selectivityUI.setLayer(active);
        }
        
        @Override
        public void resetChangeModel() {
            gearTabUI.resetChangeModel();
            selectivityUI.resetChangeModel();
        }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public GearUI(LayoutManager param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public GearUI(JAXXContext param0, LayoutManager param1, boolean param2) {
        super(param0 ,param1 ,param2);
        $initialize();
    }

    public GearUI(LayoutManager param0) {
        super(param0);
        $initialize();
    }

    public GearUI(JAXXContext param0, LayoutManager param1) {
        super(param0 ,param1);
        $initialize();
    }

    public GearUI() {
        $initialize();
    }

    public GearUI(JAXXContext param0) {
        super(param0);
        $initialize();
    }

    public GearUI(boolean param0) {
        super(param0);
        $initialize();
    }

    public GearUI(JAXXContext param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public Gear getBean() {
        return bean;
    }

    public JTabbedPane getGearTab() {
        return gearTab;
    }

    public GearTabUI getGearTabUI() {
        return gearTabUI;
    }

    public GearHandler getHandler() {
        return handler;
    }

    public SelectivityUI getSelectivityUI() {
        return selectivityUI;
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public mutator methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public void setBean(Gear bean) {
        Gear oldValue = this.bean;
        this.bean = bean;
        firePropertyChange(PROPERTY_BEAN, oldValue, bean);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected TabInfo get$TabInfo0() {
        return $TabInfo0;
    }

    protected TabInfo get$TabInfo1() {
        return $TabInfo1;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToBody() {
        if (!allComponentsCreated) {
            return;
        }
        body.add(gearTab, BorderLayout.CENTER);
    }

    protected void addChildrenToGearTab() {
        if (!allComponentsCreated) {
            return;
        }
        gearTab.add(gearTabUI);
        gearTab.add(selectivityUI);
        $TabInfo0.addPropertyChangeListener(new TabInfoPropertyChangeListener(gearTab, 0));
        gearTab.setTitleAt(0, t("isisfish.gear.title"));
        $TabInfo1.addPropertyChangeListener(new TabInfoPropertyChangeListener(gearTab, 1));
        gearTab.setTitleAt(1, t("isisfish.selectivity.title"));
    }

    protected void createBean() {
        $objectMap.put("bean", bean = null);
    }

    @Override
    protected void createBody() {
        super.createBody();
        body.setName("body");
    }

    protected void createGearTab() {
        $objectMap.put("gearTab", gearTab = new JTabbedPane());
        
        gearTab.setName("gearTab");
    }

    protected void createGearTabUI() {
        $objectMap.put("gearTabUI", gearTabUI = new GearTabUI(this));
        
        gearTabUI.setName("gearTabUI");
    }

    protected void createHandler() {
        $objectMap.put("handler", handler = new GearHandler(this));
    }

    protected void createSelectivityUI() {
        $objectMap.put("selectivityUI", selectivityUI = new SelectivityUI(this));
        
        selectivityUI.setName("selectivityUI");
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        addChildrenToBody();
        addChildrenToGearTab();
        
        // apply 6 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
        
        $afterCompleteSetup();
    }

    private void $initialize() {
        if (allComponentsCreated) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        $objectMap.put("$InputContentUI0", $InputContentUI0);
        createBean();
        createHandler();
        createGearTab();
        createGearTabUI();
        createSelectivityUI();
        // inline creation of $TabInfo0
        $objectMap.put("$TabInfo0", $TabInfo0 = new TabInfo());
        
        $TabInfo0.setTitle(t("isisfish.gear.title"));
        // inline creation of $TabInfo1
        $objectMap.put("$TabInfo1", $TabInfo1 = new TabInfo());
        
        $TabInfo1.setTitle(t("isisfish.selectivity.title"));
        // inline creation of $InputContentUI0
        setName("$InputContentUI0");
        
        // registers 6 data bindings
        $registerDefaultBindings();
        $completeSetup();
    }

    private void $registerDefaultBindings() {
        // register 6 data bindings
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_GEAR_TAB_UI_ACTIVE, true ,"active") {
        
            @Override
            public void processDataBinding() {
                gearTabUI.setActive(isActive());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_GEAR_TAB_UI_BEAN, true ,"bean") {
        
            @Override
            public void processDataBinding() {
                gearTabUI.setBean(getBean());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_GEAR_TAB_UI_SENSITIVITY, true ,"sensitivity") {
        
            @Override
            public void processDataBinding() {
                gearTabUI.setSensitivity(isSensitivity());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_SELECTIVITY_UI_ACTIVE, true ,"active") {
        
            @Override
            public void processDataBinding() {
                selectivityUI.setActive(isActive());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_SELECTIVITY_UI_BEAN, true ,"bean") {
        
            @Override
            public void processDataBinding() {
                selectivityUI.setBean(getBean());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_SELECTIVITY_UI_SENSITIVITY, true ,"sensitivity") {
        
            @Override
            public void processDataBinding() {
                selectivityUI.setSensitivity(isSensitivity());
            }
        });
    }

}