package fr.ifremer.isisfish.ui.input;

/*
 * #%L
 * ISIS-Fish
 * %%
 * Copyright (C) 1999 - 2015 Ifremer, Codelutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import fr.ifremer.isisfish.ui.NavigationUI;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JSplitPane;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.text.Document;
import javax.swing.tree.DefaultTreeSelectionModel;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.binding.DefaultJAXXBinding;
import jaxx.runtime.binding.SimpleJAXXObjectBinding;
import jaxx.runtime.swing.Table;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdesktop.swingx.JXComboBox;
import static org.nuiton.i18n.I18n.t;

public class InputUI extends NavigationUI {

    /*-----------------------------------------------------------------------*/
    /*---------------- Constants for all javaBean properties ----------------*/
    /*-----------------------------------------------------------------------*/

    public static final String PROPERTY_REGION_LOADED = "regionLoaded";

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_BUTTON_NEW_REGION_ENABLED = "buttonNewRegion.enabled";
    public static final String BINDING_MENU_REGION_COPY_ENABLED = "menuRegionCopy.enabled";
    public static final String BINDING_MENU_REGION_EXPORT_ENABLED = "menuRegionExport.enabled";

    /*-----------------------------------------------------------------------*/
    /*--------------- Constants for all none public bindings  ---------------*/
    /*-----------------------------------------------------------------------*/

    private static final String BINDING_$JMENU_ITEM1_ENABLED = "$JMenuItem1.enabled";
    private static final String BINDING_$JMENU_ITEM2_ENABLED = "$JMenuItem2.enabled";
    private static final String BINDING_$JMENU_ITEM3_ENABLED = "$JMenuItem3.enabled";
    private static final String BINDING_$JMENU_ITEM4_ENABLED = "$JMenuItem4.enabled";
    private static final String BINDING_$JMENU_ITEM5_ENABLED = "$JMenuItem5.enabled";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAK1XTW/cRBieLPloPttuSNpCKCEEQUFxmpYWQUqbjzbKrjahZNMSWAkxu57dndT2mPE46+SAkPgD/AS4c0Hixglx6BkhJITgJyDEgSvinfGuvc46XksmByeZ93meeeadj3fmmz/RkMPRS4fY8zTuWoKaRCuuHxy8Vz0kNXGfODVObcE48n8GcihXQeN60O4I9HKlJOnLbfryJjNtZhGri71aQmOOODaI0yRECPRClFFznOVyEF71bJd3VANTcapf/f1X7kv9869zCHk2uFuAocz3Y4UjGSyhHNUFykNPR3jZwFYDbHBqNcDvpGzbNLDj7GKTfIo+QyMlNGxjDmICLaQfstJQfM8WaGpxFx/RBhaUWY8K1wVarHON1jkxCfx2qFOnTlNzqUYt2xVaQX4fFWxbKQwLNNLElm4QLtC1/sRtHxuyJzhpQMclhnUCA78ox6jJcWsbjBkEWyF00CSWK9CzEuJpTguyohV3oG0DcwkZDZBjErmnhNuSEbxE5QPwhRBcgJxxyOVMD6UgiCnxMwFt9jRtj1jtaXkuihxfDCSux4S7+n/gSaEYzFSI2WT2cQxiYrFYJrAWMEw0zOFsZARB5ExjKzGSI35Yeb4UzVkX80bAfC0ufDMm3O1VdfzKmfQ3Y+htXyvJvm4FzBuRjm2DiofYIr1J6kSia+ncYlE2GoDPR/CqVYJuB9h8nRJD33S53JKd9XeV8YZ2COfTE8Fsn+xpxQPYoFW2wTxJfTtQGBWckEB5NRqcBPs1zgyj7f9S1H8QkvB7AetFuQ0JP/b97IN+mRhwksI/O0wnhkCvd+tIA9p9UseuIXrB4W682CN7eqvJNgle75q5fVw1pPXLkTPRJ6hYdMRTKqG7pNVJZnTK9okntiRCwosB63zVFYJZXbTpCG1DhaOc6RrmuoGPmSsewnlbozY22jwNt4S2CeGSCocpyKuDTWY8oASzdrtnAa0EscdhEh2VXd9mCVflbERXmWqU6INwjQTddity9Hwkp1DBtLCChSVmoIKGuAvNMAmV3qK3ByG/3F0+Ve6koIr+Ozv9y/e/f7fVqXFL0PdMLLSrREPtsTmzoUxQ2fV5v8C5ghrLO9heraBRPxWqfs/FGCu3w2AO+vPrhKRr29hpgsTQyG8//Dj7yU/PoNwWGjOgnmxhiS/AnmpyyAIzdM++t6YcTbTOwfeC9AZ1RcAygrzfoZZBLTKPBVRcWELkrgdpmItJQ+ClOvr0n+nyt2udVAyAtStnwsN0DH2Ehv3eVMFv1/LYAj9uO8TVWViz46r4gPw9a7eXpq6+zd6xyuZD+XniqSJoKMvyL0vFrmRWmOurAKcAFErY6XqCzNXMRtIpnMARc0fHAs9XqaXDhrsbrzaf2U86hRP5+SJeYSGzh3QKSR5ezewhu8K1zKN4I7OHdApJHpYye0inkORhJbOH7Ao3M4/iVmYP/RWgYOn0iOqEl1hNvZQS5N5KIZeHt9k+c2tNuPLDk6hz88mgOM44hVvn/2Fu2L8HJeT8nTSGTGpR0zXL9IRklBoy5d0zQeTdVGvg5wSFtRQ2BjsPvDNym0Zj0um+TycYepBqSH8kKGynmSTOmHgMj/XkBZhGapSz1jahjabIKDQVSVHStKdRmwjU9lgrk7N+B9H7mQ+idApJy/iDVAq/ZlZI8vBh+kyekYdKinkdq8PDbkndhDMqTTfh6DwBNWysG7RhmXCMJgyvv2S/aU6nkJTij0HhP9+IexIpFQAA";
    private static final Log log = LogFactory.getLog(InputUI.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    private boolean allComponentsCreated;

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected JButton buttonNewRegion;
    protected CardLayout cardlayoutPrincipal;
    protected JXComboBox fieldCurrentRegion;
    protected JTextField fieldNewRegion;
    protected JTree fisheryRegionTree;
    protected DefaultTreeSelectionModel fisheryRegionTreeSelectionModel;
    protected InputHandler handler;
    protected JPanel inputPane;
    protected JPanel inputPanePrincipal;
    protected JMenuBar menu;
    protected JMenu menuRegion;
    protected JMenuItem menuRegionCopy;
    protected JMenuItem menuRegionExport;
    protected JMenuItem menuRegionImport;
    protected JMenuItem menuRegionImportRename;
    protected Boolean regionLoaded;
    protected JLabel selectRegionLabel;
    protected JPanel treePanel;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private JMenu $JMenu0;
    private JMenu $JMenu1;
    private JMenuItem $JMenuItem0;
    private JMenuItem $JMenuItem1;
    private JMenuItem $JMenuItem2;
    private JMenuItem $JMenuItem3;
    private JMenuItem $JMenuItem4;
    private JMenuItem $JMenuItem5;
    private JPanel $JPanel0;
    private JPanel $JPanel1;
    private JScrollPane $JScrollPane0;
    private JSeparator $JSeparator0;
    private JSeparator $JSeparator1;
    private JSplitPane $JSplitPane0;
    private InputUI $NavigationUI0 = this;
    private Table $Table0;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/

    protected void $afterCompleteSetup() {
                handler.afterInit();
            }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public InputUI(LayoutManager param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public InputUI(JAXXContext param0, LayoutManager param1, boolean param2) {
        super(param0 ,param1 ,param2);
        $initialize();
    }

    public InputUI(LayoutManager param0) {
        super(param0);
        $initialize();
    }

    public InputUI(JAXXContext param0, LayoutManager param1) {
        super(param0 ,param1);
        $initialize();
    }

    public InputUI() {
        $initialize();
    }

    public InputUI(JAXXContext param0) {
        super(param0);
        $initialize();
    }

    public InputUI(boolean param0) {
        super(param0);
        $initialize();
    }

    public InputUI(JAXXContext param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doActionPerformed__on__$JMenuItem0(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.importRegionFromSimulation();
    }

    public void doActionPerformed__on__$JMenuItem1(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.removeRegion(false);
    }

    public void doActionPerformed__on__$JMenuItem2(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.commitRegionInCVS();
    }

    public void doActionPerformed__on__$JMenuItem3(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.commitRegionInCVS();
    }

    public void doActionPerformed__on__$JMenuItem4(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.removeRegion(true);
    }

    public void doActionPerformed__on__$JMenuItem5(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.exportRegionSensitivityFactors();
    }

    public void doActionPerformed__on__buttonNewRegion(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.createNewRegion();
    }

    public void doActionPerformed__on__menuRegionCopy(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.copyRegion();
    }

    public void doActionPerformed__on__menuRegionExport(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.exportRegion();
    }

    public void doActionPerformed__on__menuRegionImport(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.importRegion();
    }

    public void doActionPerformed__on__menuRegionImportRename(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.importRegionAndRename();
    }

    public void doItemStateChanged__on__fieldCurrentRegion(ItemEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.regionChange(event);
    }

    public void doValueChanged__on__fisheryRegionTree(TreeSelectionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.nodeSelectionChanged(event);
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public JButton getButtonNewRegion() {
        return buttonNewRegion;
    }

    public CardLayout getCardlayoutPrincipal() {
        return cardlayoutPrincipal;
    }

    public JXComboBox getFieldCurrentRegion() {
        return fieldCurrentRegion;
    }

    public JTextField getFieldNewRegion() {
        return fieldNewRegion;
    }

    public JTree getFisheryRegionTree() {
        return fisheryRegionTree;
    }

    public DefaultTreeSelectionModel getFisheryRegionTreeSelectionModel() {
        return fisheryRegionTreeSelectionModel;
    }

    public InputHandler getHandler() {
        return handler;
    }

    public JPanel getInputPane() {
        return inputPane;
    }

    public JPanel getInputPanePrincipal() {
        return inputPanePrincipal;
    }

    public JMenuBar getMenu() {
        return menu;
    }

    public JMenu getMenuRegion() {
        return menuRegion;
    }

    public JMenuItem getMenuRegionCopy() {
        return menuRegionCopy;
    }

    public JMenuItem getMenuRegionExport() {
        return menuRegionExport;
    }

    public JMenuItem getMenuRegionImport() {
        return menuRegionImport;
    }

    public JMenuItem getMenuRegionImportRename() {
        return menuRegionImportRename;
    }

    public Boolean getRegionLoaded() {
        return regionLoaded;
    }

    public JLabel getSelectRegionLabel() {
        return selectRegionLabel;
    }

    public JPanel getTreePanel() {
        return treePanel;
    }

    public Boolean isRegionLoaded() {
        return regionLoaded !=null && regionLoaded;
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public mutator methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public void setRegionLoaded(Boolean regionLoaded) {
        Boolean oldValue = this.regionLoaded;
        this.regionLoaded = regionLoaded;
        firePropertyChange(PROPERTY_REGION_LOADED, oldValue, regionLoaded);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected JMenu get$JMenu0() {
        return $JMenu0;
    }

    protected JMenu get$JMenu1() {
        return $JMenu1;
    }

    protected JMenuItem get$JMenuItem0() {
        return $JMenuItem0;
    }

    protected JMenuItem get$JMenuItem1() {
        return $JMenuItem1;
    }

    protected JMenuItem get$JMenuItem2() {
        return $JMenuItem2;
    }

    protected JMenuItem get$JMenuItem3() {
        return $JMenuItem3;
    }

    protected JMenuItem get$JMenuItem4() {
        return $JMenuItem4;
    }

    protected JMenuItem get$JMenuItem5() {
        return $JMenuItem5;
    }

    protected JPanel get$JPanel0() {
        return $JPanel0;
    }

    protected JPanel get$JPanel1() {
        return $JPanel1;
    }

    protected JScrollPane get$JScrollPane0() {
        return $JScrollPane0;
    }

    protected JSeparator get$JSeparator0() {
        return $JSeparator0;
    }

    protected JSeparator get$JSeparator1() {
        return $JSeparator1;
    }

    protected JSplitPane get$JSplitPane0() {
        return $JSplitPane0;
    }

    protected Table get$Table0() {
        return $Table0;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToInputPanePrincipal() {
        if (!allComponentsCreated) {
            return;
        }
        inputPanePrincipal.add($JPanel1, "none");
        inputPanePrincipal.add(inputPane, "normale");
    }

    protected void addChildrenToMenu() {
        if (!allComponentsCreated) {
            return;
        }
        menu.add(menuRegion);
        menu.add($JMenu0);
        menu.add($JMenu1);
    }

    protected void addChildrenToMenuRegion() {
        if (!allComponentsCreated) {
            return;
        }
        menuRegion.add(menuRegionImport);
        menuRegion.add(menuRegionImportRename);
        menuRegion.add($JMenuItem0);
        menuRegion.add(menuRegionExport);
        menuRegion.add(menuRegionCopy);
        menuRegion.add($JSeparator0);
        menuRegion.add($JMenuItem1);
    }

    protected void addChildrenToTreePanel() {
        if (!allComponentsCreated) {
            return;
        }
        treePanel.add($JScrollPane0, BorderLayout.CENTER);
    }

    protected void createButtonNewRegion() {
        $objectMap.put("buttonNewRegion", buttonNewRegion = new JButton());
        
        buttonNewRegion.setName("buttonNewRegion");
        buttonNewRegion.setText(t("isisfish.input.createNewRegion"));
        buttonNewRegion.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__buttonNewRegion"));
    }

    protected void createCardlayoutPrincipal() {
        $objectMap.put("cardlayoutPrincipal", cardlayoutPrincipal = new CardLayout());
    }

    protected void createFieldCurrentRegion() {
        $objectMap.put("fieldCurrentRegion", fieldCurrentRegion = new JXComboBox());
        
        fieldCurrentRegion.setName("fieldCurrentRegion");
        fieldCurrentRegion.addItemListener(JAXXUtil.getEventListener(ItemListener.class, "itemStateChanged", this, "doItemStateChanged__on__fieldCurrentRegion"));
    }

    protected void createFieldNewRegion() {
        $objectMap.put("fieldNewRegion", fieldNewRegion = new JTextField());
        
        fieldNewRegion.setName("fieldNewRegion");
        fieldNewRegion.setColumns(15);
    }

    protected void createFisheryRegionTree() {
        $objectMap.put("fisheryRegionTree", fisheryRegionTree = new JTree());
        
        fisheryRegionTree.setName("fisheryRegionTree");
        fisheryRegionTree.setRootVisible(true);
        fisheryRegionTree.setRowHeight(0);
        fisheryRegionTree.setSelectionRow(0);
        fisheryRegionTree.addTreeSelectionListener(JAXXUtil.getEventListener(TreeSelectionListener.class, "valueChanged", this, "doValueChanged__on__fisheryRegionTree"));
    }

    protected void createFisheryRegionTreeSelectionModel() {
        $objectMap.put("fisheryRegionTreeSelectionModel", fisheryRegionTreeSelectionModel = new DefaultTreeSelectionModel());
    }

    protected void createHandler() {
        $objectMap.put("handler", handler = new InputHandler(this));
    }

    protected void createInputPane() {
        $objectMap.put("inputPane", inputPane = new JPanel());
        
        inputPane.setName("inputPane");
        inputPane.setLayout(new BorderLayout());
    }

    protected void createInputPanePrincipal() {
        $objectMap.put("inputPanePrincipal", inputPanePrincipal = new JPanel());
        
        inputPanePrincipal.setName("inputPanePrincipal");
        inputPanePrincipal.setLayout(getCardlayoutPrincipal());
    }

    protected void createMenu() {
        $objectMap.put("menu", menu = new JMenuBar());
        
        menu.setName("menu");
    }

    protected void createMenuRegion() {
        $objectMap.put("menuRegion", menuRegion = new JMenu());
        
        menuRegion.setName("menuRegion");
        menuRegion.setText(t("isisfish.common.region"));
    }

    protected void createMenuRegionCopy() {
        $objectMap.put("menuRegionCopy", menuRegionCopy = new JMenuItem());
        
        menuRegionCopy.setName("menuRegionCopy");
        menuRegionCopy.setText(t("isisfish.input.menu.copyRegion"));
        menuRegionCopy.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__menuRegionCopy"));
    }

    protected void createMenuRegionExport() {
        $objectMap.put("menuRegionExport", menuRegionExport = new JMenuItem());
        
        menuRegionExport.setName("menuRegionExport");
        menuRegionExport.setText(t("isisfish.input.menu.exportRegion"));
        menuRegionExport.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__menuRegionExport"));
    }

    protected void createMenuRegionImport() {
        $objectMap.put("menuRegionImport", menuRegionImport = new JMenuItem());
        
        menuRegionImport.setName("menuRegionImport");
        menuRegionImport.setText(t("isisfish.input.menu.importRegion"));
        menuRegionImport.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__menuRegionImport"));
    }

    protected void createMenuRegionImportRename() {
        $objectMap.put("menuRegionImportRename", menuRegionImportRename = new JMenuItem());
        
        menuRegionImportRename.setName("menuRegionImportRename");
        menuRegionImportRename.setText(t("isisfish.input.menu.importRenameRegion"));
        menuRegionImportRename.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__menuRegionImportRename"));
    }

    protected void createRegionLoaded() {
        $objectMap.put("regionLoaded", regionLoaded = false);
    }

    protected void createSelectRegionLabel() {
        $objectMap.put("selectRegionLabel", selectRegionLabel = new JLabel());
        
        selectRegionLabel.setName("selectRegionLabel");
        selectRegionLabel.setEnabled(false);
        if (selectRegionLabel.getFont() != null) {
            selectRegionLabel.setFont(selectRegionLabel.getFont().deriveFont(selectRegionLabel.getFont().getStyle() | Font.ITALIC));
        }
        selectRegionLabel.setText(t("isisfish.input.selectRegion"));
    }

    protected void createTreePanel() {
        $objectMap.put("treePanel", treePanel = new JPanel());
        
        treePanel.setName("treePanel");
        treePanel.setLayout(new BorderLayout());
        treePanel.setName("treePanel");
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        // inline complete setup of $NavigationUI0
        add(menu, BorderLayout.NORTH);
        add($JSplitPane0, BorderLayout.CENTER);
        addChildrenToMenu();
        addChildrenToMenuRegion();
        // inline complete setup of $JMenu0
        $JMenu0.add($JMenuItem2);
        $JMenu0.add($JMenuItem3);
        $JMenu0.add($JSeparator1);
        $JMenu0.add($JMenuItem4);
        // inline complete setup of $JMenu1
        $JMenu1.add($JMenuItem5);
        // inline complete setup of $JSplitPane0
        $JSplitPane0.add($JPanel0, JSplitPane.LEFT);
        $JSplitPane0.add(inputPanePrincipal, JSplitPane.RIGHT);
        // inline complete setup of $JPanel0
        $JPanel0.add(fieldCurrentRegion, BorderLayout.NORTH);
        $JPanel0.add(treePanel, BorderLayout.CENTER);
        $JPanel0.add($Table0, BorderLayout.SOUTH);
        addChildrenToTreePanel();
        // inline complete setup of $JScrollPane0
        $JScrollPane0.getViewport().add(fisheryRegionTree);
        // inline complete setup of $Table0
        $Table0.add(fieldNewRegion, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(buttonNewRegion, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        addChildrenToInputPanePrincipal();
        // inline complete setup of $JPanel1
        $JPanel1.add(selectRegionLabel, BorderLayout.CENTER);
        
        // apply 8 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
        
        // apply 12 property setters
        $JPanel0.setMinimumSize(new java.awt.Dimension(0,0));
        fieldCurrentRegion.setModel(new fr.ifremer.isisfish.ui.models.common.GenericComboModel<String>(fr.ifremer.isisfish.datastore.RegionStorage.getRegionNames()));
        fisheryRegionTreeSelectionModel.setSelectionMode(javax.swing.tree.TreeSelectionModel.SINGLE_TREE_SELECTION);
        fisheryRegionTree.setModel(new javax.swing.tree.DefaultTreeModel(null));
        fisheryRegionTree.setSelectionModel(fisheryRegionTreeSelectionModel);
        inputPanePrincipal.setMinimumSize(new java.awt.Dimension(0,0));
        selectRegionLabel.setHorizontalAlignment(JLabel.CENTER);
        $afterCompleteSetup();
    }

    private void $initialize() {
        if (allComponentsCreated) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        $objectMap.put("$NavigationUI0", $NavigationUI0);
        createHandler();
        createRegionLoaded();
        createMenu();
        createMenuRegion();
        createMenuRegionImport();
        createMenuRegionImportRename();
        // inline creation of $JMenuItem0
        $objectMap.put("$JMenuItem0", $JMenuItem0 = new JMenuItem());
        
        $JMenuItem0.setName("$JMenuItem0");
        $JMenuItem0.setEnabled(false);
        $JMenuItem0.setText(t("isisfish.input.menu.importRegionSimulation"));
        $JMenuItem0.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__$JMenuItem0"));
        createMenuRegionExport();
        createMenuRegionCopy();
        // inline creation of $JSeparator0
        $objectMap.put("$JSeparator0", $JSeparator0 = new JSeparator());
        
        $JSeparator0.setName("$JSeparator0");
        // inline creation of $JMenuItem1
        $objectMap.put("$JMenuItem1", $JMenuItem1 = new JMenuItem());
        
        $JMenuItem1.setName("$JMenuItem1");
        $JMenuItem1.setText(t("isisfish.input.menu.removeLocaly"));
        $JMenuItem1.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__$JMenuItem1"));
        // inline creation of $JMenu0
        $objectMap.put("$JMenu0", $JMenu0 = new JMenu());
        
        $JMenu0.setName("$JMenu0");
        $JMenu0.setText(t("isisfish.input.menu.server"));
        // inline creation of $JMenuItem2
        $objectMap.put("$JMenuItem2", $JMenuItem2 = new JMenuItem());
        
        $JMenuItem2.setName("$JMenuItem2");
        $JMenuItem2.setText(t("isisfish.input.menu.addRegion"));
        $JMenuItem2.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__$JMenuItem2"));
        // inline creation of $JMenuItem3
        $objectMap.put("$JMenuItem3", $JMenuItem3 = new JMenuItem());
        
        $JMenuItem3.setName("$JMenuItem3");
        $JMenuItem3.setText(t("isisfish.input.menu.commit"));
        $JMenuItem3.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__$JMenuItem3"));
        // inline creation of $JSeparator1
        $objectMap.put("$JSeparator1", $JSeparator1 = new JSeparator());
        
        $JSeparator1.setName("$JSeparator1");
        // inline creation of $JMenuItem4
        $objectMap.put("$JMenuItem4", $JMenuItem4 = new JMenuItem());
        
        $JMenuItem4.setName("$JMenuItem4");
        $JMenuItem4.setText(t("isisfish.input.menu.removeLocalyRemotely"));
        $JMenuItem4.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__$JMenuItem4"));
        // inline creation of $JMenu1
        $objectMap.put("$JMenu1", $JMenu1 = new JMenu());
        
        $JMenu1.setName("$JMenu1");
        $JMenu1.setText(t("isisfish.input.menu.sensitivity"));
        // inline creation of $JMenuItem5
        $objectMap.put("$JMenuItem5", $JMenuItem5 = new JMenuItem());
        
        $JMenuItem5.setName("$JMenuItem5");
        $JMenuItem5.setText(t("isisfish.input.menu.sensitivity.export"));
        $JMenuItem5.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__$JMenuItem5"));
        // inline creation of $JSplitPane0
        $objectMap.put("$JSplitPane0", $JSplitPane0 = new JSplitPane());
        
        $JSplitPane0.setName("$JSplitPane0");
        $JSplitPane0.setDividerLocation(200);
        $JSplitPane0.setOneTouchExpandable(true);
        $JSplitPane0.setOrientation(1);
        // inline creation of $JPanel0
        $objectMap.put("$JPanel0", $JPanel0 = new JPanel());
        
        $JPanel0.setName("$JPanel0");
        $JPanel0.setLayout(new BorderLayout());
        createFieldCurrentRegion();
        createTreePanel();
        // inline creation of $JScrollPane0
        $objectMap.put("$JScrollPane0", $JScrollPane0 = new JScrollPane());
        
        $JScrollPane0.setName("$JScrollPane0");
        createFisheryRegionTreeSelectionModel();
        createFisheryRegionTree();
        // inline creation of $Table0
        $objectMap.put("$Table0", $Table0 = new Table());
        
        $Table0.setName("$Table0");
        createFieldNewRegion();
        createButtonNewRegion();
        createCardlayoutPrincipal();
        createInputPanePrincipal();
        // inline creation of $JPanel1
        $objectMap.put("$JPanel1", $JPanel1 = new JPanel());
        
        $JPanel1.setName("$JPanel1");
        $JPanel1.setLayout(new BorderLayout());
        createSelectRegionLabel();
        createInputPane();
        // inline creation of $NavigationUI0
        setName("$NavigationUI0");
        
        // registers 8 data bindings
        $registerDefaultBindings();
        $completeSetup();
    }

    private void $registerDefaultBindings() {
        // register 8 data bindings
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_MENU_REGION_EXPORT_ENABLED, true ,"regionLoaded") {
        
            @Override
            public void processDataBinding() {
                menuRegionExport.setEnabled(isRegionLoaded());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_MENU_REGION_COPY_ENABLED, true ,"regionLoaded") {
        
            @Override
            public void processDataBinding() {
                menuRegionCopy.setEnabled(isRegionLoaded());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_$JMENU_ITEM1_ENABLED, true ,"regionLoaded") {
        
            @Override
            public void processDataBinding() {
                $JMenuItem1.setEnabled(isRegionLoaded());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_$JMENU_ITEM2_ENABLED, true ,"regionLoaded") {
        
            @Override
            public void processDataBinding() {
                $JMenuItem2.setEnabled(isRegionLoaded());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_$JMENU_ITEM3_ENABLED, true ,"regionLoaded") {
        
            @Override
            public void processDataBinding() {
                $JMenuItem3.setEnabled(isRegionLoaded());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_$JMENU_ITEM4_ENABLED, true ,"regionLoaded") {
        
            @Override
            public void processDataBinding() {
                $JMenuItem4.setEnabled(isRegionLoaded());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_$JMENU_ITEM5_ENABLED, true ,"regionLoaded") {
        
            @Override
            public void processDataBinding() {
                $JMenuItem5.setEnabled(isRegionLoaded());
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_BUTTON_NEW_REGION_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (getFieldNewRegion() != null) {
                    $bindingSources.put("getFieldNewRegion().getDocument()", getFieldNewRegion().getDocument());
                    getFieldNewRegion().getDocument().addDocumentListener( JAXXUtil.getEventListener(DocumentListener.class, this, "$pr$u0"));
                    getFieldNewRegion().addPropertyChangeListener("document", JAXXUtil.getDataBindingUpdateListener(fr.ifremer.isisfish.ui.input.InputUI.this, BINDING_BUTTON_NEW_REGION_ENABLED));
                }
            }
        
            @Override
            public void processDataBinding() {
                if (getFieldNewRegion() != null && getFieldNewRegion().getText() != null) {
                    buttonNewRegion.setEnabled(getFieldNewRegion().getText().length() > 0);
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (getFieldNewRegion() != null) {
                    Document $target = (Document) $bindingSources.remove("getFieldNewRegion().getDocument()");
                    if ($target != null) {
                        $target.removeDocumentListener( JAXXUtil.getEventListener(DocumentListener.class, this, "$pr$u0"));
                    }
                    getFieldNewRegion().removePropertyChangeListener("document", JAXXUtil.getDataBindingUpdateListener(fr.ifremer.isisfish.ui.input.InputUI.this, BINDING_BUTTON_NEW_REGION_ENABLED));
                }
            }
        
            public void $pr$u0(DocumentEvent event) {
                if (log.isDebugEnabled()) {
                    log.debug(event);
                }
                propertyChange(null);
            }
        });
    }

}