/*
 * #%L
 * IsisFish
 * 
 * $Id: SimulationPlan.java 4159 2014-12-16 08:58:42Z bpoussin $
 * $HeadURL: http://svn.codelutin.com/isis-fish/trunk/src/main/java/fr/ifremer/isisfish/simulator/SimulationPlan.java $
 * %%
 * Copyright (C) 2011 Ifremer, Code Lutin, Chatellier Eric
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

package fr.ifremer.isisfish.simulator;

import fr.ifremer.isisfish.datastore.SimulationStorage;

/**
 * Simulation plan.
 * 
 * Replace old {@code AnalysePlan}.
 *
 * @author poussin
 * @version $Revision: 4159 $
 *
 * Last update: $Date: 2014-12-16 09:58:42 +0100 (mar., 16 déc. 2014) $
 * by : $Author: bpoussin $
 */
public interface SimulationPlan {

    /**
     * Return plan necessary Results.
     * 
     * @return the necessaryResult name
     */
    public String[] getNecessaryResult();

    /**
     * Return plan description.
     * 
     * @return plan description
     * @throws Exception
     */
    public String getDescription() throws Exception;

    /**
     * Use only once before first simulation.
     * 
     * You can modified Param for all simulation or put value in context.values.
     * 
     * @param context plan context
     * @throws Exception
     */
    public void init(SimulationPlanContext context) throws Exception;

    /**
     * Call before each simulation.
     * 
     * @param context plan context
     * @param nextSimulation storage used for next simulation
     * @return true if we must do next simulation, false to stop plan
     * @throws Exception
     */
    public boolean beforeSimulation(SimulationPlanContext context,
            SimulationStorage nextSimulation) throws Exception;

    /**
     * Call after each simulation.
     * 
     * @param context plan context
     * @param lastSimulation storage used for simulation
     * @return true if we must do next simulation, false to stop plan
     * @throws Exception
     */
    public boolean afterSimulation(SimulationPlanContext context,
            SimulationStorage lastSimulation) throws Exception;

}
