/*
 * #%L
 * IsisFish
 * 
 * $Id: Export.java 4166 2014-12-19 18:40:04Z bpoussin $
 * $HeadURL: http://svn.codelutin.com/isis-fish/trunk/src/main/java/fr/ifremer/isisfish/export/Export.java $
 * %%
 * Copyright (C) 2006 - 2010 Ifremer, Code Lutin, Cédric Pineau, Benjamin Poussin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

package fr.ifremer.isisfish.export;

import java.io.Writer;

import fr.ifremer.isisfish.datastore.SimulationStorage;

/**
 * Interface que doivent implanter les classes d'export de resultats pour les
 * export qui ne peuvent pas etre fait pas de temps par pas de temps
 * 
 * Le nom du fichier d'export qui sera utilisé sera le basé sur le nom de la
 * classe d'export
 * 
 * Created: 22 janv. 2006 21:12:58
 *
 * @author poussin
 * @version $Revision: 4166 $
 *
 * Last update: $Date: 2014-12-19 19:40:04 +0100 (ven., 19 déc. 2014) $
 * by : $Author: bpoussin $
 */
public interface Export extends ExportInfo {

    /**
     * Exporte les resultat apres la simulation.
     * 
     * @param simulation la simulation dont on souhaite exporter les resultats
     * @param out la sortie sur lequel il faut ecrire l'export
     * @throws Exception if export fail
     */
    public void export(SimulationStorage simulation, Writer out)
            throws Exception;

}
