package fr.ifremer.isisfish.entities;

/*
 * #%L
 * ISIS-Fish
 * %%
 * Copyright (C) 1999 - 2015 Ifremer, Codelutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import fr.ifremer.isisfish.types.Month;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Generated;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.nuiton.math.matrix.MatrixND;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.framework.TopiaContextImplementor;
import org.nuiton.topia.persistence.EntityVisitor;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.persistence.TopiaEntityAbstract;

@Generated(value = "org.nuiton.topia.generator.EntityTransformer", date = "Wed Jun 24 10:15:37 CEST 2015")
public abstract class StrategyMonthInfoAbstract extends TopiaEntityAbstract implements StrategyMonthInfo {

    /**
     * Nom de l'attribut en BD : month
     */
    protected Month month;

    /**
     * Nom de l'attribut en BD : minInactivityDays
     */
    protected double minInactivityDays;

    /**
     * <p>Nombre de Trip par mois. Le nombre de jour d'inactivite et le nombre la duree d'un trip doivent &ecirc;tre coh&eacute;rent pour le mois</p>
     * 
     * Nom de l'attribut en BD : numberOfTrips
     */
    protected double numberOfTrips;

    /**
     * Nom de l'attribut en BD : proportionMetier
     */
    protected MatrixND proportionMetier;

    /**
     * Nom de l'attribut en BD : tripType
     */
    protected TripType tripType;

    /**
     * Nom de l'attribut en BD : strategy
     */
    protected Strategy strategy;

    private static final long serialVersionUID = 3979040644498940979L;

    @Override
    public void update() throws TopiaException {
        ((TopiaContextImplementor)getTopiaContext()).getDAO(StrategyMonthInfo.class).update(this);
}

    @Override
    public void delete() throws TopiaException {
        ((TopiaContextImplementor)getTopiaContext()).getDAO(StrategyMonthInfo.class).delete(this);
}

    @Override
    public void accept(EntityVisitor visitor) throws TopiaException {
        visitor.start(this);
        accept0(visitor);
        visitor.end(this);
    }

    protected void accept0(EntityVisitor visitor) throws TopiaException {
        visitor.visit(this, PROPERTY_MONTH, Month.class, month);
        visitor.visit(this, PROPERTY_MIN_INACTIVITY_DAYS, double.class, minInactivityDays);
        visitor.visit(this, PROPERTY_NUMBER_OF_TRIPS, double.class, numberOfTrips);
        visitor.visit(this, PROPERTY_PROPORTION_METIER, MatrixND.class, proportionMetier);
        visitor.visit(this, PROPERTY_TRIP_TYPE, TripType.class, tripType);
        visitor.visit(this, PROPERTY_STRATEGY, Strategy.class, strategy);
    }

    @Override
    public void setMonth(Month month) {
        Month oldValue = this.month;
        fireOnPreWrite(PROPERTY_MONTH, oldValue, month);
        this.month = month;
        fireOnPostWrite(PROPERTY_MONTH, oldValue, month);
    }

    @Override
    public Month getMonth() {
        Month result = this.month;

        return result;
    }

    @Override
    public void setMinInactivityDays(double minInactivityDays) {
        double oldValue = this.minInactivityDays;
        fireOnPreWrite(PROPERTY_MIN_INACTIVITY_DAYS, oldValue, minInactivityDays);
        this.minInactivityDays = minInactivityDays;
        fireOnPostWrite(PROPERTY_MIN_INACTIVITY_DAYS, oldValue, minInactivityDays);
    }

    @Override
    public double getMinInactivityDays() {
        double result = this.minInactivityDays;

        return result;
    }

    @Override
    public void setNumberOfTrips(double numberOfTrips) {
        double oldValue = this.numberOfTrips;
        fireOnPreWrite(PROPERTY_NUMBER_OF_TRIPS, oldValue, numberOfTrips);
        this.numberOfTrips = numberOfTrips;
        fireOnPostWrite(PROPERTY_NUMBER_OF_TRIPS, oldValue, numberOfTrips);
    }

    @Override
    public double getNumberOfTrips() {
        double result = this.numberOfTrips;

        return result;
    }

    @Override
    public void setProportionMetier(MatrixND proportionMetier) {
        MatrixND oldValue = this.proportionMetier;
        fireOnPreWrite(PROPERTY_PROPORTION_METIER, oldValue, proportionMetier);
        this.proportionMetier = proportionMetier;
        fireOnPostWrite(PROPERTY_PROPORTION_METIER, oldValue, proportionMetier);
    }

    @Override
    public MatrixND getProportionMetier() {
        MatrixND result = this.proportionMetier;

        return result;
    }

    @Override
    public void setTripType(TripType tripType) {
        TripType oldValue = this.tripType;
        fireOnPreWrite(PROPERTY_TRIP_TYPE, oldValue, tripType);
        this.tripType = tripType;
        fireOnPostWrite(PROPERTY_TRIP_TYPE, oldValue, tripType);
    }

    @Override
    public TripType getTripType() {
        TripType result = this.tripType;

        return result;
    }

    @Override
    public void setStrategy(Strategy strategy) {
        Strategy oldValue = this.strategy;
        fireOnPreWrite(PROPERTY_STRATEGY, oldValue, strategy);
        this.strategy = strategy;
        fireOnPostWrite(PROPERTY_STRATEGY, oldValue, strategy);
    }

    @Override
    public Strategy getStrategy() {
        Strategy result = this.strategy;

        return result;
    }

    @Override
    public List<TopiaEntity> getAggregate() throws TopiaException {
        List<TopiaEntity> tmp = new ArrayList<TopiaEntity>();

        // pour tous les attributs rechecher les composites et les class d'asso
        // on les ajoute dans tmp

        // on refait un tour sur chaque entity de tmp pour recuperer leur
        // composite
        List<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity entity : tmp) {
            result.add(entity);
            result.addAll(entity.getAggregate());
        }
        return result;
    }

    @Override
    public List<TopiaEntity> getComposite() throws TopiaException {
        List<TopiaEntity> tmp = new ArrayList<TopiaEntity>();

        // pour tous les attributs rechecher les composites et les class d'asso
        // on les ajoute dans tmp

        // on refait un tour sur chaque entity de tmp pour recuperer leur
        // composite
        List<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity entity : tmp) {
            if (entity != null) {
                result.add(entity);
                result.addAll(entity.getComposite());
            }
        }
        return result;
    }

    @Override
    public String toString() {
        String result = new ToStringBuilder(this).
            append(PROPERTY_MONTH, this.month).
            append(PROPERTY_MIN_INACTIVITY_DAYS, this.minInactivityDays).
            append(PROPERTY_NUMBER_OF_TRIPS, this.numberOfTrips).
            append(PROPERTY_PROPORTION_METIER, this.proportionMetier).
            append(PROPERTY_TRIP_TYPE, this.tripType).
         toString();
        return result;
    }

} //StrategyMonthInfoAbstract
