/*
 * #%L
 * IsisFish
 * 
 * $Id: IsisFishRuntimeException.java 4156 2014-12-09 11:27:18Z echatellier $
 * $HeadURL: http://svn.codelutin.com/isis-fish/trunk/src/main/java/fr/ifremer/isisfish/IsisFishRuntimeException.java $
 * %%
 * Copyright (C) 2006 - 2011 Ifremer, Code Lutin, Cédric Pineau, Benjamin Poussin, Chatellier Eric
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

package fr.ifremer.isisfish;

/**
 * Isis runtime exception.
 * 
 * @author poussin
 */
public class IsisFishRuntimeException extends RuntimeException {

    /** serialVersionUID. */
    private static final long serialVersionUID = 3388901195563202616L;

    /**
     * Constructor with message.
     * 
     * @param message message
     */
    public IsisFishRuntimeException(String message) {
        super(message);
    }

    /**
     * Constructor with message and cause.
     * 
     * @param message message
     * @param cause cause
     */
    public IsisFishRuntimeException(String message, Throwable cause) {
        super(message, cause);
    }
}
