/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.isisfish.ui.simulator.filter;

import fr.ifremer.isisfish.simulator.SimulationMeta;
import fr.ifremer.isisfish.simulator.SimulationProperties;
import fr.ifremer.isisfish.ui.simulator.filter.SimulationFilterDialog;
import fr.ifremer.isisfish.ui.widget.filter.FilterModel;
import java.io.IOException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.TreeMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;

public class SimulationFilterUtil {
    private static Log log = LogFactory.getLog(SimulationFilterUtil.class);

    public static String selectSimulation(List<String> names) throws ParseException, IOException {
        if (names.isEmpty()) {
            return null;
        }
        FilterModel<SimulationProperties, String> model = SimulationFilterUtil.createFilterModel(names);
        return SimulationFilterUtil.selectSimulation(model);
    }

    public static String selectSimulation(FilterModel<SimulationProperties, String> model) throws ParseException, IOException {
        if (model == null) {
            return null;
        }
        SimulationFilterDialog ui = new SimulationFilterDialog(model, I18n.t((String)"isisfish.filter.select.simulation", (Object[])new Object[0]), I18n.t((String)"isisfish.filter.select", (Object[])new Object[0]));
        log.info((Object)("ui used " + ui.getClass()));
        Object result = ui.obtainSelectResult();
        log.info((Object)("simulation selected " + (String)result));
        return result;
    }

    public static List<String> filterSimulation(List<String> names) throws ParseException, IOException {
        if (names.isEmpty()) {
            return Collections.emptyList();
        }
        FilterModel<SimulationProperties, String> model = SimulationFilterUtil.createFilterModel(names);
        return SimulationFilterUtil.filterSimulation(model);
    }

    public static List<String> filterSimulation(FilterModel<SimulationProperties, String> model) throws ParseException, IOException {
        if (model == null) {
            return Collections.emptyList();
        }
        ArrayList<SimulationProperties> oldResult = new ArrayList<SimulationProperties>(model.getFiltered());
        SimulationFilterDialog ui = new SimulationFilterDialog(model, I18n.t((String)"isisfish.filter.simulation", (Object[])new Object[0]), I18n.t((String)"isisfish.filter.apply", (Object[])new Object[0]));
        log.info((Object)("ui used " + ui.getClass()));
        List<String> result = ui.obtainFilterResult();
        if (result.isEmpty()) {
            model.setFiltered(oldResult);
            result = model.getFilteredResult();
            log.info((Object)("simulation filtered no result, push back old result " + result.size()));
        } else {
            log.info((Object)("simulation filtered " + result.size()));
        }
        return result;
    }

    public static FilterModel<SimulationProperties, String> createFilterModel(List<String> names) throws ParseException, IOException {
        ArrayList<SimulationProperties> original = new ArrayList<SimulationProperties>();
        for (String name : names) {
            SimulationProperties properties = new SimulationProperties(name);
            original.add(properties);
        }
        TreeMap paramModels = new TreeMap();
        for (SimulationMeta meta : SimulationMeta.values()) {
            paramModels.put(meta.name(), meta.createParamModel());
        }
        return new FilterModel<SimulationProperties, String>(original, paramModels){

            @Override
            public String convertToResult(SimulationProperties item) {
                return item.getName();
            }
        };
    }

    protected SimulationFilterUtil() {
    }
}

