/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.isisfish.ui.script.action;

import java.awt.event.ActionEvent;
import java.io.File;
import javax.swing.AbstractAction;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JTextField;
import org.nuiton.i18n.I18n;

public class ChooseFileAction
extends AbstractAction {
    private static final long serialVersionUID = -5004217809548352109L;
    protected JTextField file;
    protected JDialog dialog;

    public ChooseFileAction(JDialog dialog, JTextField file) {
        super("...");
        this.dialog = dialog;
        this.file = file;
    }

    public File getDestination() {
        return new File(this.file.getText());
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        File dir = new File(this.file.getText());
        String name = "";
        if (dir.isFile() || !dir.exists()) {
            name = dir.getName();
            dir = dir.getParentFile();
        }
        JFileChooser chooser = new JFileChooser(dir);
        chooser.setFileSelectionMode(1);
        int ret = chooser.showDialog(this.dialog, I18n.t((String)"isisfish.message.choose.archive", (Object[])new Object[0]));
        if (ret == 0) {
            String path;
            File newFile = chooser.getSelectedFile();
            if (newFile.isFile()) {
                path = newFile.getAbsolutePath();
            } else {
                path = newFile.getAbsolutePath();
                if (!"".equals(name)) {
                    path = path + File.separator + name;
                }
            }
            this.file.setText(path);
        }
    }
}

