/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.isisfish.datastore;

import fr.ifremer.isisfish.IsisFishException;
import fr.ifremer.isisfish.datastore.CodeSourceStorage;
import fr.ifremer.isisfish.datastore.ExportStorage;
import fr.ifremer.isisfish.datastore.ResultStorage;
import fr.ifremer.isisfish.datastore.SimulationStorage;
import fr.ifremer.isisfish.entities.Population;
import fr.ifremer.isisfish.export.Export;
import fr.ifremer.isisfish.export.SensitivityExport;
import fr.ifremer.isisfish.rule.Rule;
import fr.ifremer.isisfish.simulator.Objective;
import fr.ifremer.isisfish.simulator.Optimization;
import fr.ifremer.isisfish.simulator.SimulationContext;
import fr.ifremer.isisfish.simulator.SimulationException;
import fr.ifremer.isisfish.simulator.SimulationPlan;
import fr.ifremer.isisfish.simulator.SimulationResultGetter;
import fr.ifremer.isisfish.types.Month;
import fr.ifremer.isisfish.types.TimeStep;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;
import org.nuiton.math.matrix.MatrixFactory;
import org.nuiton.math.matrix.MatrixIterator;
import org.nuiton.math.matrix.MatrixND;
import org.nuiton.topia.TopiaContext;
import org.nuiton.util.ArrayUtil;
import org.nuiton.util.HashList;

public class ResultStorageInMemory
implements SimulationResultGetter,
ResultStorage {
    private static Log log = LogFactory.getLog(ResultStorageInMemory.class);
    public static final String MAX_TIME_STEP = "ResultStorageInMemory.maxTimeStep";
    protected int maxTimeStep = 12;
    protected SimulationStorage simulation = null;
    LinkedHashMap<TimeStep, Map<String, MatrixND>> data = new LinkedHashMap<TimeStep, Map<String, MatrixND>>(){
        private static final long serialVersionUID = 1L;

        @Override
        protected boolean removeEldestEntry(Map.Entry eldest) {
            return this.size() > ResultStorageInMemory.this.maxTimeStep;
        }
    };
    LinkedHashMap<TimeStep, List<Rule>> rules = new LinkedHashMap<TimeStep, List<Rule>>(){
        private static final long serialVersionUID = 1L;

        @Override
        protected boolean removeEldestEntry(Map.Entry eldest) {
            return this.size() > ResultStorageInMemory.this.maxTimeStep;
        }
    };
    protected transient Set<String> enabledResult = null;

    public ResultStorageInMemory(SimulationStorage simulation) {
        this.simulation = simulation;
        this.maxTimeStep = Integer.parseInt(simulation.getParameter().getTagValue().get(MAX_TIME_STEP));
    }

    @Override
    public void delete() {
        this.data.clear();
    }

    @Override
    public void close() {
    }

    @Override
    public boolean isEnabled(String name) {
        name = name.trim();
        if (this.enabledResult == null) {
            Optimization optimization;
            Objective objective;
            List<SimulationPlan> plans;
            List<Rule> rules;
            List<SensitivityExport> sensitivityExports;
            this.enabledResult = new HashSet<String>();
            Collection<String> resultEnabled = this.simulation.getParameter().getResultEnabled();
            this.enabledResult.addAll(resultEnabled);
            List<String> exportNames = this.simulation.getParameter().getExportNames();
            if (exportNames != null) {
                for (String exportName : exportNames) {
                    ExportStorage storage = ExportStorage.getExport(exportName, new CodeSourceStorage.Location[0]);
                    try {
                        Export export = (Export)storage.getNewInstance();
                        for (String resultName : export.getNecessaryResult()) {
                            this.enabledResult.add(resultName);
                        }
                    }
                    catch (IsisFishException eee) {
                        if (!log.isWarnEnabled()) continue;
                        log.warn((Object)I18n.t((String)"isisfish.error.instanciate.export", (Object[])new Object[]{exportName}), (Throwable)eee);
                    }
                }
            }
            if ((sensitivityExports = this.simulation.getParameter().getSensitivityExport()) != null) {
                for (SensitivityExport sensitivityExport : sensitivityExports) {
                    for (String resultName : sensitivityExport.getNecessaryResult()) {
                        this.enabledResult.add(resultName);
                    }
                }
            }
            if ((rules = this.simulation.getParameter().getRules()) != null) {
                for (Rule rule : rules) {
                    for (String resultName : rule.getNecessaryResult()) {
                        this.enabledResult.add(resultName);
                    }
                }
            }
            if ((plans = this.simulation.getParameter().getSimulationPlans()) != null) {
                for (SimulationPlan plan : plans) {
                    for (String resultName : plan.getNecessaryResult()) {
                        this.enabledResult.add(resultName);
                    }
                }
            }
            if ((objective = this.simulation.getParameter().getObjective()) != null) {
                for (String resultName : objective.getNecessaryResult()) {
                    this.enabledResult.add(resultName);
                }
            }
            if ((optimization = this.simulation.getParameter().getOptimization()) != null) {
                for (String resultName : optimization.getNecessaryResult()) {
                    this.enabledResult.add(resultName);
                }
            }
            log.info((Object)("Enabled result: " + this.enabledResult));
        }
        boolean result = this.enabledResult.contains(name);
        return result;
    }

    @Override
    public void addResult(TimeStep step, MatrixND mat) throws IsisFishException {
        this.addResult(false, step, mat.getName(), mat);
    }

    @Override
    public void addResult(TimeStep step, Population pop, MatrixND mat) throws IsisFishException {
        this.addResult(false, step, mat.getName(), pop, mat);
    }

    @Override
    public void addResult(boolean force, TimeStep step, MatrixND mat) throws IsisFishException {
        this.addResult(force, step, mat.getName(), mat);
    }

    @Override
    public void addResult(boolean force, TimeStep step, Population pop, MatrixND mat) throws IsisFishException {
        this.addResult(force, step, mat.getName(), pop, mat);
    }

    @Override
    public void addResult(TimeStep step, String name, Population pop, MatrixND mat) throws IsisFishException {
        this.addResult(false, step, name, pop, mat);
    }

    @Override
    public void addResult(TimeStep step, String name, MatrixND mat) throws IsisFishException {
        this.addResult(false, step, name, mat);
    }

    @Override
    public void addResult(boolean force, TimeStep step, String name, Population pop, MatrixND mat) throws IsisFishException {
        if (force || this.isEnabled(name)) {
            this.doAddResult(step, name + " " + pop, mat);
        }
    }

    @Override
    public void addResult(boolean force, TimeStep step, String name, MatrixND mat) throws IsisFishException {
        if (force || this.isEnabled(name)) {
            this.doAddResult(step, name, mat);
        }
    }

    protected void doAddResult(TimeStep step, String name, MatrixND mat) throws IsisFishException {
        for (int i = 0; i < mat.getDimCount(); ++i) {
            if (!mat.getSemantic(i).contains(null)) continue;
            throw new SimulationException("Erreur le r\u00e9sultat que vous souhaitez enregistrer n'a pas d'information convenable pour la dimension: " + i + " " + mat.getDimensionName(i));
        }
        MatrixND newMat = mat.copy();
        Map<String, MatrixND> mats = this.data.get(step);
        if (mats == null) {
            mats = new HashMap<String, MatrixND>();
            this.data.put(step, mats);
        }
        mats.put(name, newMat);
    }

    @Override
    public void addActiveRule(TimeStep step, Rule rule) throws IsisFishException {
        List<Rule> list = this.rules.get(step);
        if (list == null) {
            list = new LinkedList<Rule>();
            this.rules.put(step, list);
        }
        list.add(rule);
    }

    @Override
    public List<String> getResultName() {
        HashSet<String> result = new HashSet<String>();
        for (Map<String, MatrixND> mats : this.data.values()) {
            result.addAll(mats.keySet());
        }
        return new ArrayList<String>(result);
    }

    @Override
    public MatrixND getMatrix(TimeStep step, Population pop, String name) {
        String newName = name + " " + pop;
        return this.getMatrix(step, newName);
    }

    @Override
    public MatrixND getMatrix(TimeStep step, String name) {
        MatrixND result = null;
        Map<String, MatrixND> mats = this.data.get(step);
        if (mats != null) {
            result = mats.get(name);
        }
        return result;
    }

    @Override
    public MatrixND getMatrix(TimeStep step, String name, TopiaContext tx) {
        return this.getMatrix(step, name);
    }

    @Override
    public MatrixND getMatrix(Population pop, String name) {
        String newName = name + " " + pop;
        return this.getMatrix(newName);
    }

    @Override
    public MatrixND getMatrix(Population pop, String name, TopiaContext tx) {
        String newName = name + " " + pop;
        return this.getMatrix(newName, tx);
    }

    @Override
    public MatrixND getMatrix(String name) {
        MatrixND result = null;
        ArrayList<TimeStep> steps = new ArrayList<TimeStep>();
        LinkedHashMap<TimeStep, MatrixND> mats = new LinkedHashMap<TimeStep, MatrixND>();
        MatrixND matExample = null;
        for (Map.Entry<TimeStep, Map<String, MatrixND>> e : this.data.entrySet()) {
            TimeStep ts = e.getKey();
            MatrixND matrixND = e.getValue().get(name);
            if (matrixND == null) continue;
            steps.add(ts);
            mats.put(ts, matrixND);
            matExample = matrixND;
        }
        if (mats.size() > 0) {
            String[] dimNames = new String[1 + matExample.getDimCount()];
            dimNames[0] = I18n.t((String)"isisfish.common.date", (Object[])new Object[0]);
            for (int i = 1; i < dimNames.length; ++i) {
                dimNames[i] = matExample.getDimensionName(i - 1);
            }
            List[] sem = new List[1 + matExample.getDimCount()];
            sem[0] = steps;
            for (int i = 1; i < sem.length; ++i) {
                sem[i] = new HashList();
            }
            for (MatrixND matrixND : mats.values()) {
                if (log.isTraceEnabled()) {
                    log.trace((Object)("Ajout de la semantics: " + Arrays.asList(matrixND.getSemantics())));
                }
                for (int s = 0; s < matrixND.getDimCount(); ++s) {
                    sem[s + 1].addAll(matrixND.getSemantic(s));
                }
            }
            if (log.isTraceEnabled()) {
                log.trace((Object)("La semantique final est: " + Arrays.asList(sem)));
            }
            result = MatrixFactory.getInstance().create(name, sem, dimNames);
            for (Map.Entry entry : mats.entrySet()) {
                TimeStep d = (TimeStep)entry.getKey();
                MatrixND mat = (MatrixND)entry.getValue();
                MatrixND submat = result.getSubMatrix(0, (Object)d, 1);
                MatrixIterator mi = mat.iterator();
                while (mi.next()) {
                    submat.setValue(ArrayUtil.concat((Object[][])new Object[][]{{d}, mi.getSemanticsCoordinates()}), mi.getValue());
                }
            }
        }
        return result;
    }

    @Override
    public MatrixND getMatrix(String name, TopiaContext tx) {
        return this.getMatrix(name);
    }

    @Override
    public TimeStep getLastStep() {
        int monthNumber = this.simulation.getParameter().getNumberOfYear() * Month.NUMBER_OF_MONTH;
        TimeStep result = new TimeStep(monthNumber - 1);
        return result;
    }

    @Override
    public void addResult(SimulationContext context, TimeStep step, String name, MatrixND mat) throws IsisFishException {
        this.doAddResult(step, name, mat);
    }

    @Override
    public MatrixND getMatrix(SimulationContext context, TimeStep step, String name) {
        MatrixND result = this.getMatrix(step, name);
        return result;
    }

    @Override
    public MatrixND getMatrix(SimulationContext context, String name) {
        MatrixND result = this.getMatrix(name);
        return result;
    }

    @Override
    public void afterSimulation(SimulationContext context) {
    }

    @Override
    public void beforeSimulation(SimulationContext context) {
    }
}

