package fr.ifremer.isisfish.ui.simulator;

import fr.ifremer.isisfish.datastore.RegionStorage;
import fr.ifremer.isisfish.datastore.StorageChangeEvent;
import fr.ifremer.isisfish.datastore.StorageChangeListener;
import fr.ifremer.isisfish.datastore.StorageException;
import fr.ifremer.isisfish.entities.FisheryRegion;
import fr.ifremer.isisfish.entities.Population;
import fr.ifremer.isisfish.entities.Strategy;
import fr.ifremer.isisfish.simulator.launcher.SimulationJob;
import fr.ifremer.isisfish.simulator.launcher.SimulationService;
import fr.ifremer.isisfish.simulator.launcher.SimulationServiceListener;
import fr.ifremer.isisfish.simulator.launcher.SimulatorLauncher;
import fr.ifremer.isisfish.ui.SimulationUI;
import fr.ifremer.isisfish.ui.WelcomePanelUI;
import fr.ifremer.isisfish.ui.WelcomeTabUI;
import fr.ifremer.isisfish.ui.models.common.GenericComboModel;
import fr.ifremer.isisfish.ui.sensitivity.SensitivityUI;
import fr.ifremer.isisfish.ui.widget.FilterableComboBox;
import java.awt.CardLayout;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.IOException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.BorderFactory;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.text.Document;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.binding.DefaultJAXXBinding;
import jaxx.runtime.binding.SimpleJAXXObjectBinding;
import jaxx.runtime.context.DefaultJAXXContext;
import jaxx.runtime.swing.TabInfo;
import jaxx.runtime.swing.TabInfoPropertyChangeListener;
import jaxx.runtime.swing.Table;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.topia.TopiaContext;
import org.nuiton.topia.TopiaException;
import static org.nuiton.i18n.I18n.t;

public class ParamsUI extends Table implements JAXXObject {

    /*-----------------------------------------------------------------------*/
    /*---------------- Constants for all javaBean properties ----------------*/
    /*-----------------------------------------------------------------------*/

    public static final String PROPERTY_REGION_STORAGE = "regionStorage";
    public static final String PROPERTY_SENSITIVITY = "sensitivity";

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_ADD_RULE_FACTOR_BUTTON_ENABLED = "addRuleFactorButton.enabled";
    public static final String BINDING_ADD_RULE_FACTOR_BUTTON_VISIBLE = "addRuleFactorButton.visible";
    public static final String BINDING_BUTTON_SIMUL_PARAMS_SIMULATE_ENABLED = "buttonSimulParamsSimulate.enabled";
    public static final String BINDING_COMBO_SEL_LAUNCHER_MODEL = "comboSelLauncher.model";
    public static final String BINDING_FIELD_SIMUL_PARAMS_DESC_TEXT = "fieldSimulParamsDesc.text";
    public static final String BINDING_FIELD_SIMUL_PARAMS_NB_ANNEES_TEXT = "fieldSimulParamsNbAnnees.text";
    public static final String BINDING_FIELD_SIMUL_USE_OPTIMIZATION_ENABLED = "fieldSimulUseOptimization.enabled";
    public static final String BINDING_FIELD_SIMUL_USE_OPTIMIZATION_SELECTED = "fieldSimulUseOptimization.selected";
    public static final String BINDING_FIELD_SIMUL_USE_OPTIMIZATION_VISIBLE = "fieldSimulUseOptimization.visible";
    public static final String BINDING_FIELD_SIMUL_USE_SIMULATION_PLAN_ENABLED = "fieldSimulUseSimulationPlan.enabled";
    public static final String BINDING_FIELD_SIMUL_USE_SIMULATION_PLAN_SELECTED = "fieldSimulUseSimulationPlan.selected";
    public static final String BINDING_FIELD_SIMUL_USE_SIMULATION_PLAN_VISIBLE = "fieldSimulUseSimulationPlan.visible";
    public static final String BINDING_FIELD_USE_SIMUL_PRE_SCRIPTS_SELECTED = "fieldUseSimulPreScripts.selected";
    public static final String BINDING_FIELD_USE_SIMUL_PRE_SCRIPTS_VISIBLE = "fieldUseSimulPreScripts.visible";
    public static final String BINDING_LBL_NAME_TEXT = "lblName.text";
    public static final String BINDING_LIST_SIMUL_PARAMS_POPULATIONS_ENABLED = "listSimulParamsPopulations.enabled";
    public static final String BINDING_LIST_SIMUL_PARAMS_POPULATIONS_SELECTION_MODEL = "listSimulParamsPopulations.selectionModel";
    public static final String BINDING_LIST_SIMUL_PARAMS_STRATEGIES_ENABLED = "listSimulParamsStrategies.enabled";
    public static final String BINDING_LIST_SIMUL_PARAMS_STRATEGIES_SELECTION_MODEL = "listSimulParamsStrategies.selectionModel";
    public static final String BINDING_PARAMETERS_TABBED_PANE_ENABLED = "parametersTabbedPane.enabled";
    public static final String BINDING_POPULATION_EFFECTIVES_TABBED_PANE_ENABLED = "populationEffectivesTabbedPane.enabled";
    public static final String BINDING_RULE_CHOOSER_ACTIVE = "ruleChooser.active";
    public static final String BINDING_RULE_CHOOSER_SHOW_FACTOR_COLUMN = "ruleChooser.showFactorColumn";
    public static final String BINDING_SAVE_SIMUL_ENABLED = "saveSimul.enabled";
    public static final String BINDING_SENSITIVITY_ONLY_KEEP_FIRST_RESULT_CHECK_BOX_ENABLED = "sensitivityOnlyKeepFirstResultCheckBox.enabled";
    public static final String BINDING_SENSITIVITY_ONLY_KEEP_FIRST_RESULT_CHECK_BOX_SELECTED = "sensitivityOnlyKeepFirstResultCheckBox.selected";
    public static final String BINDING_SENSITIVITY_ONLY_KEEP_FIRST_RESULT_CHECK_BOX_VISIBLE = "sensitivityOnlyKeepFirstResultCheckBox.visible";

    /*-----------------------------------------------------------------------*/
    /*--------------- Constants for all none public bindings  ---------------*/
    /*-----------------------------------------------------------------------*/

    private static final String BINDING_$JLABEL4_ENABLED = "$JLabel4.enabled";
    private static final String BINDING_$JLABEL5_ENABLED = "$JLabel5.enabled";
    private static final String BINDING_$JLABEL6_ENABLED = "$JLabel6.enabled";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "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";
    public static final String PROPERTY$DOCUMENT0 = "$Document0";
    public static final String PROPERTY$DOCUMENT1 = "$Document1";
    public static final String PROPERTY$DOCUMENT2 = "$Document2";
    private static final Log log = LogFactory.getLog(ParamsUI.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    protected List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?, ?> $previousValues = new HashMap<Object, Object>();
    private boolean allComponentsCreated;
    protected final JAXXContext delegateContext = new DefaultJAXXContext();

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected JButton addRuleFactorButton;
    protected JButton buttonSimulParamsSimulate;
    protected JComboBox comboSelLauncher;
    protected JTextArea fieldSimulParamsDesc;
    protected JTextField fieldSimulParamsName;
    protected JTextField fieldSimulParamsNbAnnees;
    protected JComboBox<String> fieldSimulParamsRegion;
    protected FilterableComboBox fieldSimulParamsSelect;
    protected JCheckBox fieldSimulUseOptimization;
    protected JCheckBox fieldSimulUseSimulationPlan;
    protected JCheckBox fieldUseSimulPreScripts;
    protected JLabel lblName;
    protected JList listSimulParamsPopulations;
    protected JList listSimulParamsStrategies;
    protected JTabbedPane parametersTabbedPane;
    protected JPanel populationEffectivesPanel;
    protected JTabbedPane populationEffectivesTabbedPane;
    protected RegionStorage regionStorage;
    protected RuleChooser ruleChooser;
    protected JButton saveSimul;
    protected Boolean sensitivity;
    protected JCheckBox sensitivityOnlyKeepFirstResultCheckBox;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private Document $Document0;
    private Document $Document1;
    private Document $Document2;
    private JLabel $JLabel0;
    private JLabel $JLabel1;
    private JLabel $JLabel2;
    private JLabel $JLabel3;
    private JLabel $JLabel4;
    private JLabel $JLabel5;
    private JLabel $JLabel6;
    private JLabel $JLabel7;
    private JPanel $JPanel0;
    private JScrollPane $JScrollPane0;
    private JScrollPane $JScrollPane1;
    private JScrollPane $JScrollPane2;
    private JSeparator $JSeparator0;
    private TabInfo $TabInfo0;
    private TabInfo $TabInfo1;
    private ParamsUI $Table0 = this;
    private Table $Table1;
    private Table $Table2;
    private Table $Table3;
    private Table $Table4;
    private Table $Table5;
    private Table $Table6;
    private Table $Table7;
    private Table $Table8;
    private Table $Table9;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/

    // instances variables déclaration
    SimulationServiceListener simulationListener;
    StorageChangeListener regionStorageListener;
    SimulAction simulAction;
    
    
    public void refresh() {
        if (simulAction.getSimulationStorage() != null) {
            fieldSimulParamsName.setText(simulAction.getSimulationStorage().getName());
        }
        fieldSimulParamsDesc.setText(simulAction.getSimulationParameter().getDescription());
        setListSimulParamsStrategiesItems();
        setListSimulParamsPopulationsItems();
    }
    
    /**
     * Called on user region selection change.
     */
    protected void regionChange() {
        // le premier item est " " pour ne pas avoir de selection par defaut
        final String selected = fieldSimulParamsRegion.getSelectedItem().toString();
        if (log.isDebugEnabled()) {
            log.debug(" selected " + selected);
        }
        if(selected != null && !selected.trim().isEmpty()) {
            getParentContainer(WelcomePanelUI.class).setStatusMessage(t("isisfish.message.loading.region"));
            SwingUtilities.invokeLater(new Runnable() {
                @Override
                public void run() {
                    simulAction.regionChange(ParamsUI.this, selected);
                    refresh();
                    setSensitivityTabRegion();
                    getParentContainer(WelcomePanelUI.class).setStatusMessage(t("isisfish.message.region.loaded"));
                }
            });
        }
    }
    
    protected void initSimulationParams() {
        if (!isSensitivity()){
            // prescript
            String preScript = simulAction.getSimulationParameter().getPreScript();
            fieldUseSimulPreScripts.setSelected(preScript != null && !preScript.isEmpty());
            getParentContainer(SimulUI.class).getPreScriptUI().getFieldSimulPreScript().setText(preScript);
    
            // simulation plan
            fieldSimulUseSimulationPlan.setSelected(simulAction.getSimulationParameter().getUseSimulationPlan());
            getParentContainer(SimulUI.class).getSensUI().refresh();
    
            // optimization
            fieldSimulUseOptimization.setSelected(simulAction.getSimulationParameter().getUseOptimization());
            getParentContainer(SimulUI.class).getOptimizationUI().refresh();
    
        }
    }
    
    protected void setSensitivityTabRegion() {
        if (isSensitivity()) {
            try {
                // FIXME this transaction in never closed
                // and can't be closed because used in 
                TopiaContext tx = simulAction.getRegionStorage().getStorage().beginTransaction();
                FisheryRegion fisheryRegion = RegionStorage.getFisheryRegion(tx);
                getParentContainer(SensitivityUI.class).getSensitivityTabUI().setFisheryRegion(fisheryRegion);
                getParentContainer(SensitivityUI.class).getSensitivityTabUI().setTreeModel();
            } catch (StorageException ex) {
                if (log.isErrorEnabled()) {
                    log.error("Can't reload factors", ex);
                }
            } catch (TopiaException ex) {
                if (log.isErrorEnabled()) {
                    log.error("Can't reload factors", ex);
                }
            }
        }
    }
    protected void initSensitivityParams() {
        if (isSensitivity()) {
            getParentContainer(SensitivityUI.class).getSensitivityChooserUI().refreshSelectedSensitivityAnalysis();
            getParentContainer(SensitivityUI.class).getSensitivityTabUI().setFactorModel();
            getParentContainer(SensitivityUI.class).getSensitivityChooserUI().setSensitivityExportListModel();
            sensitivityOnlyKeepFirstResultCheckBox.setSelected(simulAction.getSimulationParameter().isSensitivityAnalysisOnlyKeepFirst());
        }
    }
    
    public void setSimulationParameter(SimulAction simulAction){
       simulAction.setSimulationParameter(simulAction.getSimulationParameter());
    }
    
    protected void loadOldSimulation() {
        final String selected = fieldSimulParamsSelect.getSelectedItem().toString();
        // le premier item est " " pour ne pas avoir de selection par defaut
        if (selected != null && !selected.equals(" ")) {
            getParentContainer(WelcomePanelUI.class).setStatusMessage(t("isisfish.message.loading.old.simulation"));
            SwingUtilities.invokeLater(new Runnable() {
                @Override
                public void run() {
                    simulAction.loadOldSimulation(selected);
                    //refresh();
                    fieldSimulParamsRegion.setSelectedItem(getContextValue(SimulAction.class).getSimulationParameter().getRegionName());
                    // mise a jour des années
                    fieldSimulParamsNbAnnees.setText(String.valueOf(simulAction.getNumberOfYear()));
                    initSimulationParams();
                    initSensitivityParams();
    
                    // regles
                    ruleChooser.setRulesList(simulAction.getSimulationParameter().getRules());
    
                    getParentContainer(WelcomePanelUI.class).setStatusMessage(t("isisfish.message.old.simulation.loaded"));
                }
            });
        }
    }
    
    /**
     * Lance la simulation.
     */
    protected void launchSimulation() {
    
        if (!isSensitivity()) {
            simulAction.launchSimulation(fieldSimulParamsName.getText(), (SimulatorLauncher)comboSelLauncher.getSelectedItem());
        }
        else {
            simulAction.launchSimulationWithSensibility(fieldSimulParamsName.getText(), (SimulatorLauncher)comboSelLauncher.getSelectedItem());
        }
        
        // dans le cas d'une fenetre independante, il n'y a pas de ParentContainer
        WelcomeTabUI parent = getParentContainer(WelcomeTabUI.class);
        if (parent != null) {
            parent.setQueueTabSelection();
        }
    }
    protected void enablePreScript() {
        simulAction.getSimulationParameter().setUsePreScript(fieldUseSimulPreScripts.isSelected());
        SimulationUI simulationUI = getParentContainer(SimulationUI.class);
        simulationUI.setEnabledPrescriptTab(fieldUseSimulPreScripts.isSelected());
    }
    protected void enableSimulationPlan() {
        simulAction.getSimulationParameter().setUseSimulationPlan(fieldSimulUseSimulationPlan.isSelected());
        SimulationUI simulationUI = getParentContainer(SimulationUI.class);
        simulationUI.setEnabledSimulationPlanTab(fieldSimulUseSimulationPlan.isSelected());
    }
    
    protected void enableOptimization() {
        simulAction.getSimulationParameter().setUseOptimization(fieldSimulUseOptimization.isSelected());
        SimulationUI simulationUI = getParentContainer(SimulationUI.class);
        simulationUI.setEnabledOptimizationTab(fieldSimulUseOptimization.isSelected());
    }
    
    protected void setListSimulParamsStrategiesItems() {
        List<Strategy> strategiesSelected = simulAction.getSimulationParameter().getStrategies();
        DefaultListModel listSimulParamsStrategiesModel = new DefaultListModel();
        java.util.List<Strategy> strategies = simulAction.getStrategies();
        for (Strategy s : strategies){
            listSimulParamsStrategiesModel.addElement(s);
        }
        listSimulParamsStrategies.setModel(listSimulParamsStrategiesModel);
        if (listSimulParamsStrategiesModel.size() != 0) {
            for (Strategy s : strategiesSelected){
                int index = listSimulParamsStrategiesModel.indexOf(s);
                listSimulParamsStrategies.addSelectionInterval(index, index);
            }
            //strategySelected();
        }
    }
    protected void setListSimulParamsPopulationsItems(){
        List<Population> populationsSelected = simulAction.getSimulationParameter().getPopulations();
        DefaultListModel listSimulParamsPopulationsModel = new DefaultListModel();
        List<Population> populations = simulAction.getPopulations();
        for (Population p : populations){
            listSimulParamsPopulationsModel.addElement(p);
        }
        listSimulParamsPopulations.setModel(listSimulParamsPopulationsModel);
        if (listSimulParamsPopulationsModel.size() != 0) {
            for (Population p : populationsSelected) {
                int index = listSimulParamsPopulationsModel.indexOf(p);
                listSimulParamsPopulations.addSelectionInterval(index, index);
            }
            //simulAction.populationSelected(this);
        }
    }
    
    protected void strategySelected(){
        simulAction.setStrategies(listSimulParamsStrategies.getSelectedValues());
    }
    
    protected void selectFilter() {
        try {
            java.util.List<String> simulationsNames = fr.ifremer.isisfish.ui.simulator.filter.SimulationFilterUtil.filterSimulation(simulAction.getOldSimulationItem());
            // TODO add " " to not triger event (need to be fixed)
            simulationsNames.add(0, " ");
            simulAction.setOldSimulatorNames(simulationsNames);
            fieldSimulParamsSelect.setModel(getSimulParamsSelectModel(false));
        } catch (ParseException ex) {
            if (log.isErrorEnabled()) {
                log.error("Can't select simulation filter", ex);
            }
        } catch (IOException ex) {
            if (log.isErrorEnabled()) {
                log.error("Can't select simulation filter", ex);
            }
        }
    }
    
    protected ComboBoxModel getSimulParamsSelectModel() {
        return getSimulParamsSelectModel(false);
    }
    
    protected ComboBoxModel<String> getSimulParamsSelectModel(boolean force) {
        List<String> items = simulAction.getFilteredOldSimulatorNames(force);
        GenericComboModel<String> result = new GenericComboModel<String>(items);
        return result;
    }
    
    protected void resetFilter(){
        simulAction.resetOldSimulatorNames();
        fieldSimulParamsSelect.setModel(getSimulParamsSelectModel(false));
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public ParamsUI() {
        $initialize();
    }

    public ParamsUI(JAXXContext parentContext) {
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------- JAXXObject implementation ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).applyDataBinding();
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String, Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public JAXXBinding getDataBinding(String bindingId) {
        return $bindings.get(bindingId);
    }

    @Override
    public JAXXBinding[] getDataBindings() {
        return $bindings.values().toArray(new JAXXBinding[$bindings.size()]);
    }

    @Override
    public Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && $activeBindings.contains($binding)) { 
            return;
        }
        $activeBindings.add($binding);
        try {
            if (allComponentsCreated && $bindings.containsKey($binding)) {
                getDataBinding($binding).processDataBinding();
            }
        } finally {
            $activeBindings.remove($binding);
        }
    }

    @Override
    public void processDataBinding(String $binding) {
        processDataBinding($binding, false);
    }

    @Override
    public void registerDataBinding(JAXXBinding binding) {
        $bindings.put(binding.getId(), binding);
    }

    @Override
    public void removeDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).removeDataBinding();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- JAXXContext implementation  ---------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return SwingUtil.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return SwingUtil.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doActionPerformed__on__addRuleFactorButton(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        simulAction.addFactorWithComponent(this, ruleChooser);
    }

    public void doActionPerformed__on__buttonSimulParamsSimulate(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        launchSimulation();
    }

    public void doActionPerformed__on__fieldSimulParamsRegion(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        regionChange();
    }

    public void doActionPerformed__on__fieldSimulParamsSelect(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        loadOldSimulation();
    }

    public void doActionPerformed__on__saveSimul(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getParentContainer(fr.ifremer.isisfish.ui.SimulationUI.class).saveSimulation();
    }

    public void doInsertUpdate__on__$Document0(DocumentEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        simulAction.setName(fieldSimulParamsName.getText());
    }

    public void doInsertUpdate__on__$Document1(DocumentEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        simulAction.getSimulationParameter().setDescription(fieldSimulParamsDesc.getText());
    }

    public void doInsertUpdate__on__$Document2(DocumentEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        simulAction.setNumberOfYear(fieldSimulParamsNbAnnees.getText());
    }

    public void doItemStateChanged__on__fieldSimulUseOptimization(ItemEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        enableOptimization();
    }

    public void doItemStateChanged__on__fieldSimulUseSimulationPlan(ItemEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        enableSimulationPlan();
    }

    public void doItemStateChanged__on__fieldUseSimulPreScripts(ItemEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        enablePreScript();
    }

    public void doItemStateChanged__on__sensitivityOnlyKeepFirstResultCheckBox(ItemEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        simulAction.getSimulationParameter().setSensitivityAnalysisOnlyKeepFirst(sensitivityOnlyKeepFirstResultCheckBox.isSelected());
    }

    public void doRemoveUpdate__on__$Document0(DocumentEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        simulAction.setName(fieldSimulParamsName.getText());
    }

    public void doRemoveUpdate__on__$Document1(DocumentEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        simulAction.getSimulationParameter().setDescription(fieldSimulParamsDesc.getText());
    }

    public void doRemoveUpdate__on__$Document2(DocumentEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        simulAction.setNumberOfYear(fieldSimulParamsNbAnnees.getText());
    }

    public void doValueChanged__on__listSimulParamsPopulations(ListSelectionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        simulAction.populationSelected(this);
    }

    public void doValueChanged__on__listSimulParamsStrategies(ListSelectionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        strategySelected();
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public JButton getAddRuleFactorButton() {
        return addRuleFactorButton;
    }

    public JButton getButtonSimulParamsSimulate() {
        return buttonSimulParamsSimulate;
    }

    public JComboBox getComboSelLauncher() {
        return comboSelLauncher;
    }

    public JTextArea getFieldSimulParamsDesc() {
        return fieldSimulParamsDesc;
    }

    public JTextField getFieldSimulParamsName() {
        return fieldSimulParamsName;
    }

    public JTextField getFieldSimulParamsNbAnnees() {
        return fieldSimulParamsNbAnnees;
    }

    public JComboBox<String> getFieldSimulParamsRegion() {
        return fieldSimulParamsRegion;
    }

    public FilterableComboBox getFieldSimulParamsSelect() {
        return fieldSimulParamsSelect;
    }

    public JCheckBox getFieldSimulUseOptimization() {
        return fieldSimulUseOptimization;
    }

    public JCheckBox getFieldSimulUseSimulationPlan() {
        return fieldSimulUseSimulationPlan;
    }

    public JCheckBox getFieldUseSimulPreScripts() {
        return fieldUseSimulPreScripts;
    }

    public JLabel getLblName() {
        return lblName;
    }

    public JList getListSimulParamsPopulations() {
        return listSimulParamsPopulations;
    }

    public JList getListSimulParamsStrategies() {
        return listSimulParamsStrategies;
    }

    public JTabbedPane getParametersTabbedPane() {
        return parametersTabbedPane;
    }

    public JPanel getPopulationEffectivesPanel() {
        return populationEffectivesPanel;
    }

    public JTabbedPane getPopulationEffectivesTabbedPane() {
        return populationEffectivesTabbedPane;
    }

    public RegionStorage getRegionStorage() {
        return regionStorage;
    }

    public RuleChooser getRuleChooser() {
        return ruleChooser;
    }

    public JButton getSaveSimul() {
        return saveSimul;
    }

    public Boolean getSensitivity() {
        return sensitivity;
    }

    public JCheckBox getSensitivityOnlyKeepFirstResultCheckBox() {
        return sensitivityOnlyKeepFirstResultCheckBox;
    }

    public Boolean isSensitivity() {
        return sensitivity !=null && sensitivity;
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public mutator methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public void set$Document0(Document $Document0) {
        Document oldValue = this.$Document0;
        this.$Document0 = $Document0;
        firePropertyChange(PROPERTY$DOCUMENT0, oldValue, $Document0);
    }

    public void set$Document1(Document $Document1) {
        Document oldValue = this.$Document1;
        this.$Document1 = $Document1;
        firePropertyChange(PROPERTY$DOCUMENT1, oldValue, $Document1);
    }

    public void set$Document2(Document $Document2) {
        Document oldValue = this.$Document2;
        this.$Document2 = $Document2;
        firePropertyChange(PROPERTY$DOCUMENT2, oldValue, $Document2);
    }

    public void setRegionStorage(RegionStorage regionStorage) {
        RegionStorage oldValue = this.regionStorage;
        this.regionStorage = regionStorage;
        firePropertyChange(PROPERTY_REGION_STORAGE, oldValue, regionStorage);
    }

    public void setSensitivity(Boolean sensitivity) {
        Boolean oldValue = this.sensitivity;
        this.sensitivity = sensitivity;
        firePropertyChange(PROPERTY_SENSITIVITY, oldValue, sensitivity);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected Document get$Document0() {
        return $Document0;
    }

    protected Document get$Document1() {
        return $Document1;
    }

    protected Document get$Document2() {
        return $Document2;
    }

    protected JLabel get$JLabel0() {
        return $JLabel0;
    }

    protected JLabel get$JLabel1() {
        return $JLabel1;
    }

    protected JLabel get$JLabel2() {
        return $JLabel2;
    }

    protected JLabel get$JLabel3() {
        return $JLabel3;
    }

    protected JLabel get$JLabel4() {
        return $JLabel4;
    }

    protected JLabel get$JLabel5() {
        return $JLabel5;
    }

    protected JLabel get$JLabel6() {
        return $JLabel6;
    }

    protected JLabel get$JLabel7() {
        return $JLabel7;
    }

    protected JPanel get$JPanel0() {
        return $JPanel0;
    }

    protected JScrollPane get$JScrollPane0() {
        return $JScrollPane0;
    }

    protected JScrollPane get$JScrollPane1() {
        return $JScrollPane1;
    }

    protected JScrollPane get$JScrollPane2() {
        return $JScrollPane2;
    }

    protected JSeparator get$JSeparator0() {
        return $JSeparator0;
    }

    protected TabInfo get$TabInfo0() {
        return $TabInfo0;
    }

    protected TabInfo get$TabInfo1() {
        return $TabInfo1;
    }

    protected Table get$Table1() {
        return $Table1;
    }

    protected Table get$Table2() {
        return $Table2;
    }

    protected Table get$Table3() {
        return $Table3;
    }

    protected Table get$Table4() {
        return $Table4;
    }

    protected Table get$Table5() {
        return $Table5;
    }

    protected Table get$Table6() {
        return $Table6;
    }

    protected Table get$Table7() {
        return $Table7;
    }

    protected Table get$Table8() {
        return $Table8;
    }

    protected Table get$Table9() {
        return $Table9;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToParametersTabbedPane() {
        if (!allComponentsCreated) {
            return;
        }
        parametersTabbedPane.add($Table6);
        parametersTabbedPane.add($Table7);
        $TabInfo0.addPropertyChangeListener(new TabInfoPropertyChangeListener(parametersTabbedPane, 0));
        $TabInfo1.addPropertyChangeListener(new TabInfoPropertyChangeListener(parametersTabbedPane, 1));
    }

    protected void addChildrenToPopulationEffectivesPanel() {
        if (!allComponentsCreated) {
            return;
        }
        populationEffectivesPanel.add($JLabel6, "default");
        populationEffectivesPanel.add(populationEffectivesTabbedPane, "specific");
    }

    protected void createAddRuleFactorButton() {
        $objectMap.put("addRuleFactorButton", addRuleFactorButton = new JButton());
        
        addRuleFactorButton.setName("addRuleFactorButton");
        addRuleFactorButton.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__addRuleFactorButton"));
    }

    protected void createButtonSimulParamsSimulate() {
        $objectMap.put("buttonSimulParamsSimulate", buttonSimulParamsSimulate = new JButton());
        
        buttonSimulParamsSimulate.setName("buttonSimulParamsSimulate");
        buttonSimulParamsSimulate.setText(t("isisfish.common.simulate"));
        buttonSimulParamsSimulate.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__buttonSimulParamsSimulate"));
    }

    protected void createComboSelLauncher() {
        $objectMap.put("comboSelLauncher", comboSelLauncher = new JComboBox());
        
        comboSelLauncher.setName("comboSelLauncher");
    }

    protected void createFieldSimulParamsDesc() {
        $objectMap.put("fieldSimulParamsDesc", fieldSimulParamsDesc = new JTextArea());
        
        fieldSimulParamsDesc.setName("fieldSimulParamsDesc");
        fieldSimulParamsDesc.setColumns(15);
        fieldSimulParamsDesc.setLineWrap(true);
        fieldSimulParamsDesc.setWrapStyleWord(true);
    }

    protected void createFieldSimulParamsName() {
        $objectMap.put("fieldSimulParamsName", fieldSimulParamsName = new JTextField());
        
        fieldSimulParamsName.setName("fieldSimulParamsName");
        fieldSimulParamsName.setColumns(15);
    }

    protected void createFieldSimulParamsNbAnnees() {
        $objectMap.put("fieldSimulParamsNbAnnees", fieldSimulParamsNbAnnees = new JTextField());
        
        fieldSimulParamsNbAnnees.setName("fieldSimulParamsNbAnnees");
        fieldSimulParamsNbAnnees.setColumns(15);
    }

    protected void createFieldSimulParamsRegion() {
        $objectMap.put("fieldSimulParamsRegion", fieldSimulParamsRegion = new JComboBox<String>());
        
        fieldSimulParamsRegion.setName("fieldSimulParamsRegion");
        fieldSimulParamsRegion.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__fieldSimulParamsRegion"));
    }

    protected void createFieldSimulParamsSelect() {
        $objectMap.put("fieldSimulParamsSelect", fieldSimulParamsSelect = new FilterableComboBox());
        
        fieldSimulParamsSelect.setName("fieldSimulParamsSelect");
        fieldSimulParamsSelect.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__fieldSimulParamsSelect"));
    }

    protected void createFieldSimulUseOptimization() {
        $objectMap.put("fieldSimulUseOptimization", fieldSimulUseOptimization = new JCheckBox());
        
        fieldSimulUseOptimization.setName("fieldSimulUseOptimization");
        fieldSimulUseOptimization.setText(t("isisfish.params.useOptimization"));
        fieldSimulUseOptimization.addItemListener(JAXXUtil.getEventListener(ItemListener.class, "itemStateChanged", this, "doItemStateChanged__on__fieldSimulUseOptimization"));
    }

    protected void createFieldSimulUseSimulationPlan() {
        $objectMap.put("fieldSimulUseSimulationPlan", fieldSimulUseSimulationPlan = new JCheckBox());
        
        fieldSimulUseSimulationPlan.setName("fieldSimulUseSimulationPlan");
        fieldSimulUseSimulationPlan.setText(t("isisfish.params.useSimulationPlan"));
        fieldSimulUseSimulationPlan.addItemListener(JAXXUtil.getEventListener(ItemListener.class, "itemStateChanged", this, "doItemStateChanged__on__fieldSimulUseSimulationPlan"));
    }

    protected void createFieldUseSimulPreScripts() {
        $objectMap.put("fieldUseSimulPreScripts", fieldUseSimulPreScripts = new JCheckBox());
        
        fieldUseSimulPreScripts.setName("fieldUseSimulPreScripts");
        fieldUseSimulPreScripts.setText(t("isisfish.params.usePreSimulationScript"));
        fieldUseSimulPreScripts.addItemListener(JAXXUtil.getEventListener(ItemListener.class, "itemStateChanged", this, "doItemStateChanged__on__fieldUseSimulPreScripts"));
    }

    protected void createLblName() {
        $objectMap.put("lblName", lblName = new JLabel());
        
        lblName.setName("lblName");
    }

    protected void createListSimulParamsPopulations() {
        $objectMap.put("listSimulParamsPopulations", listSimulParamsPopulations = new JList());
        
        listSimulParamsPopulations.setName("listSimulParamsPopulations");
        listSimulParamsPopulations.addListSelectionListener(JAXXUtil.getEventListener(ListSelectionListener.class, "valueChanged", this, "doValueChanged__on__listSimulParamsPopulations"));
    }

    protected void createListSimulParamsStrategies() {
        $objectMap.put("listSimulParamsStrategies", listSimulParamsStrategies = new JList());
        
        listSimulParamsStrategies.setName("listSimulParamsStrategies");
        listSimulParamsStrategies.addListSelectionListener(JAXXUtil.getEventListener(ListSelectionListener.class, "valueChanged", this, "doValueChanged__on__listSimulParamsStrategies"));
    }

    protected void createParametersTabbedPane() {
        $objectMap.put("parametersTabbedPane", parametersTabbedPane = new JTabbedPane());
        
        parametersTabbedPane.setName("parametersTabbedPane");
    }

    protected void createPopulationEffectivesPanel() {
        $objectMap.put("populationEffectivesPanel", populationEffectivesPanel = new JPanel());
        
        populationEffectivesPanel.setName("populationEffectivesPanel");
        populationEffectivesPanel.setLayout(new CardLayout());
    }

    protected void createPopulationEffectivesTabbedPane() {
        $objectMap.put("populationEffectivesTabbedPane", populationEffectivesTabbedPane = new JTabbedPane());
        
        populationEffectivesTabbedPane.setName("populationEffectivesTabbedPane");
    }

    protected void createRegionStorage() {
        $objectMap.put("regionStorage", regionStorage = null);
    }

    protected void createRuleChooser() {
        $objectMap.put("ruleChooser", ruleChooser = new RuleChooser(this));
        
        ruleChooser.setName("ruleChooser");
    }

    protected void createSaveSimul() {
        $objectMap.put("saveSimul", saveSimul = new JButton());
        
        saveSimul.setName("saveSimul");
        saveSimul.setText(t("isisfish.simulation.menu.save"));
        saveSimul.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__saveSimul"));
    }

    protected void createSensitivity() {
        $objectMap.put("sensitivity", sensitivity = false);
    }

    protected void createSensitivityOnlyKeepFirstResultCheckBox() {
        $objectMap.put("sensitivityOnlyKeepFirstResultCheckBox", sensitivityOnlyKeepFirstResultCheckBox = new JCheckBox());
        
        sensitivityOnlyKeepFirstResultCheckBox.setName("sensitivityOnlyKeepFirstResultCheckBox");
        sensitivityOnlyKeepFirstResultCheckBox.setText(t("isisfish.params.sensitivityOnlyKeepFirstResult"));
        sensitivityOnlyKeepFirstResultCheckBox.addItemListener(JAXXUtil.getEventListener(ItemListener.class, "itemStateChanged", this, "doItemStateChanged__on__sensitivityOnlyKeepFirstResultCheckBox"));
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        // inline complete setup of $Table0
        add($Table1, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        add($JSeparator0, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 3, 0, 3), 0, 0));
        add($Table2, new GridBagConstraints(0, 2, 1, 1, 1.0, 1.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        add($Table8, new GridBagConstraints(0, 3, 1, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        add($Table9, new GridBagConstraints(0, 4, 1, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        // inline complete setup of $Table1
        $Table1.add($JLabel0, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add(fieldSimulParamsSelect, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        // inline complete setup of $Table2
        $Table2.add($Table3, new GridBagConstraints(0, 0, 2, 1, 0.5, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table2.add($Table4, new GridBagConstraints(2, 0, 2, 1, 0.5, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table2.add($JLabel2, new GridBagConstraints(0, 1, 4, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table2.add($JScrollPane0, new GridBagConstraints(0, 2, 4, 1, 1.0, 0.3, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table2.add($Table5, new GridBagConstraints(0, 3, 2, 1, 0.5, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table2.add($JPanel0, new GridBagConstraints(2, 3, 2, 1, 0.5, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table2.add(parametersTabbedPane, new GridBagConstraints(0, 4, 4, 1, 1.0, 0.6, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        // inline complete setup of $Table3
        $Table3.add(lblName, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table3.add(fieldSimulParamsName, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        // inline complete setup of $Table4
        $Table4.add($JLabel1, new GridBagConstraints(0, 0, 2, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table4.add(fieldSimulParamsRegion, new GridBagConstraints(2, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        // inline complete setup of $JScrollPane0
        $JScrollPane0.getViewport().add(fieldSimulParamsDesc);
        // inline complete setup of $Table5
        $Table5.add($JLabel3, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table5.add(fieldSimulParamsNbAnnees, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        addChildrenToParametersTabbedPane();
        // inline complete setup of $Table6
        $Table6.add($JLabel4, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table6.add($JLabel5, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table6.add($JScrollPane1, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table6.add($JScrollPane2, new GridBagConstraints(1, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table6.add(populationEffectivesPanel, new GridBagConstraints(0, 2, 2, 1, 0.0, 1.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        // inline complete setup of $JScrollPane1
        $JScrollPane1.getViewport().add(listSimulParamsStrategies);
        // inline complete setup of $JScrollPane2
        $JScrollPane2.getViewport().add(listSimulParamsPopulations);
        addChildrenToPopulationEffectivesPanel();
        // inline complete setup of $Table7
        $Table7.add(ruleChooser, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table7.add(addRuleFactorButton, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 11, 0, new Insets(3, 3, 3, 3), 0, 0));
        // inline complete setup of $Table8
        $Table8.add(fieldUseSimulPreScripts, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table8.add(fieldSimulUseSimulationPlan, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table8.add(fieldSimulUseOptimization, new GridBagConstraints(2, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table8.add(sensitivityOnlyKeepFirstResultCheckBox, new GridBagConstraints(3, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        // inline complete setup of $Table9
        $Table9.add($JLabel7, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table9.add(comboSelLauncher, new GridBagConstraints(1, 0, 1, 1, 0.4, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table9.add(buttonSimulParamsSimulate, new GridBagConstraints(2, 0, 1, 1, 0.4, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table9.add(saveSimul, new GridBagConstraints(3, 0, 1, 1, 0.2, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        
        // apply 30 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
        
        // apply 14 property setters
        fieldSimulParamsSelect.setModel(getSimulParamsSelectModel());
        lblName.setMinimumSize(new Dimension(195,25));
        lblName.setPreferredSize(new Dimension(195,25));
        fieldSimulParamsRegion.setModel(new fr.ifremer.isisfish.ui.models.common.GenericComboModel<String>(fr.ifremer.isisfish.datastore.RegionStorage.getRegionNames()));
        fieldSimulParamsRegion.setSelectedItem(getContextValue(SimulAction.class).getSimulationParameter().getRegionName());
        $JLabel3.setMinimumSize(new Dimension(140,25));
        $JLabel3.setPreferredSize(new Dimension(140,25));
        $TabInfo0.setTitle(t("isisfish.params.stategiesAndPopulations"));
        listSimulParamsStrategies.setSelectionMode(javax.swing.ListSelectionModel.MULTIPLE_INTERVAL_SELECTION);
        listSimulParamsPopulations.setSelectionMode(javax.swing.ListSelectionModel.MULTIPLE_INTERVAL_SELECTION);
        $JLabel6.setBorder(BorderFactory.createEtchedBorder());
        $TabInfo1.setTitle(t("isisfish.params.rules"));
        addRuleFactorButton.setIcon(SwingUtil.createImageIcon("building_add.png"));
    }

    private void $initialize() {
        if (allComponentsCreated) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        $objectMap.put("$Table0", $Table0);
        createRegionStorage();
        createSensitivity();
        simulAction = getContextValue(SimulAction.class);
        // inline creation of $Table1
        $objectMap.put("$Table1", $Table1 = new Table());
        
        $Table1.setName("$Table1");
        // inline creation of $JLabel0
        $objectMap.put("$JLabel0", $JLabel0 = new JLabel());
        
        $JLabel0.setName("$JLabel0");
        $JLabel0.setText(t("isisfish.params.loadOldSimulation"));
        createFieldSimulParamsSelect();
        // inline creation of $JSeparator0
        $objectMap.put("$JSeparator0", $JSeparator0 = new JSeparator());
        
        $JSeparator0.setName("$JSeparator0");
        // inline creation of $Table2
        $objectMap.put("$Table2", $Table2 = new Table());
        
        $Table2.setName("$Table2");
        // inline creation of $Table3
        $objectMap.put("$Table3", $Table3 = new Table());
        
        $Table3.setName("$Table3");
        createLblName();
        createFieldSimulParamsName();
        // inline creation of $Document0
        $objectMap.put("$Document0", $Document0 = fieldSimulParamsName.getDocument());
        
        $Document0.addDocumentListener(JAXXUtil.getEventListener(DocumentListener.class, "insertUpdate", this, "doInsertUpdate__on__$Document0"));
        $Document0.addDocumentListener(JAXXUtil.getEventListener(DocumentListener.class, "removeUpdate", this, "doRemoveUpdate__on__$Document0"));
        // inline creation of $Table4
        $objectMap.put("$Table4", $Table4 = new Table());
        
        $Table4.setName("$Table4");
        // inline creation of $JLabel1
        $objectMap.put("$JLabel1", $JLabel1 = new JLabel());
        
        $JLabel1.setName("$JLabel1");
        $JLabel1.setText(t("isisfish.common.region"));
        createFieldSimulParamsRegion();
        // inline creation of $JLabel2
        $objectMap.put("$JLabel2", $JLabel2 = new JLabel());
        
        $JLabel2.setName("$JLabel2");
        $JLabel2.setText(t("isisfish.params.description"));
        // inline creation of $JScrollPane0
        $objectMap.put("$JScrollPane0", $JScrollPane0 = new JScrollPane());
        
        $JScrollPane0.setName("$JScrollPane0");
        createFieldSimulParamsDesc();
        // inline creation of $Document1
        $objectMap.put("$Document1", $Document1 = fieldSimulParamsDesc.getDocument());
        
        $Document1.addDocumentListener(JAXXUtil.getEventListener(DocumentListener.class, "insertUpdate", this, "doInsertUpdate__on__$Document1"));
        $Document1.addDocumentListener(JAXXUtil.getEventListener(DocumentListener.class, "removeUpdate", this, "doRemoveUpdate__on__$Document1"));
        // inline creation of $Table5
        $objectMap.put("$Table5", $Table5 = new Table());
        
        $Table5.setName("$Table5");
        // inline creation of $JLabel3
        $objectMap.put("$JLabel3", $JLabel3 = new JLabel());
        
        $JLabel3.setName("$JLabel3");
        $JLabel3.setText(t("isisfish.params.numberYear"));
        createFieldSimulParamsNbAnnees();
        // inline creation of $Document2
        $objectMap.put("$Document2", $Document2 = fieldSimulParamsNbAnnees.getDocument());
        
        $Document2.addDocumentListener(JAXXUtil.getEventListener(DocumentListener.class, "insertUpdate", this, "doInsertUpdate__on__$Document2"));
        $Document2.addDocumentListener(JAXXUtil.getEventListener(DocumentListener.class, "removeUpdate", this, "doRemoveUpdate__on__$Document2"));
        // inline creation of $JPanel0
        $objectMap.put("$JPanel0", $JPanel0 = new JPanel());
        
        $JPanel0.setName("$JPanel0");
        createParametersTabbedPane();
        // inline creation of $Table6
        $objectMap.put("$Table6", $Table6 = new Table());
        
        $Table6.setName("$Table6");
        // inline creation of $JLabel4
        $objectMap.put("$JLabel4", $JLabel4 = new JLabel());
        
        $JLabel4.setName("$JLabel4");
        $JLabel4.setText(t("isisfish.common.strategies"));
        // inline creation of $JLabel5
        $objectMap.put("$JLabel5", $JLabel5 = new JLabel());
        
        $JLabel5.setName("$JLabel5");
        $JLabel5.setText(t("isisfish.common.populations"));
        // inline creation of $JScrollPane1
        $objectMap.put("$JScrollPane1", $JScrollPane1 = new JScrollPane());
        
        $JScrollPane1.setName("$JScrollPane1");
        createListSimulParamsStrategies();
        // inline creation of $JScrollPane2
        $objectMap.put("$JScrollPane2", $JScrollPane2 = new JScrollPane());
        
        $JScrollPane2.setName("$JScrollPane2");
        createListSimulParamsPopulations();
        createPopulationEffectivesPanel();
        // inline creation of $JLabel6
        $objectMap.put("$JLabel6", $JLabel6 = new JLabel());
        
        $JLabel6.setName("$JLabel6");
        if ($JLabel6.getFont() != null) {
            $JLabel6.setFont($JLabel6.getFont().deriveFont($JLabel6.getFont().getStyle() | Font.ITALIC));
        }
        $JLabel6.setHorizontalAlignment(0);
        $JLabel6.setText(t("isisfish.params.nopopulation"));
        createPopulationEffectivesTabbedPane();
        // inline creation of $Table7
        $objectMap.put("$Table7", $Table7 = new Table());
        
        $Table7.setName("$Table7");
        createRuleChooser();
        createAddRuleFactorButton();
        // inline creation of $Table8
        $objectMap.put("$Table8", $Table8 = new Table());
        
        $Table8.setName("$Table8");
        createFieldUseSimulPreScripts();
        createFieldSimulUseSimulationPlan();
        createFieldSimulUseOptimization();
        createSensitivityOnlyKeepFirstResultCheckBox();
        // inline creation of $Table9
        $objectMap.put("$Table9", $Table9 = new Table());
        
        $Table9.setName("$Table9");
        // inline creation of $JLabel7
        $objectMap.put("$JLabel7", $JLabel7 = new JLabel());
        
        $JLabel7.setName("$JLabel7");
        $JLabel7.setText(t("isisfish.params.simulationLauncher"));
        createComboSelLauncher();
        createButtonSimulParamsSimulate();
        createSaveSimul();
        // inline creation of $TabInfo0
        $objectMap.put("$TabInfo0", $TabInfo0 = new TabInfo());
        // inline creation of $TabInfo1
        $objectMap.put("$TabInfo1", $TabInfo1 = new TabInfo());
        // inline creation of $Table0
        setName("$Table0");
        
        regionStorageListener = new StorageChangeListener() {
            @Override
            public void versionDataChanged(StorageChangeEvent e) {
                GenericComboModel<String> model = new GenericComboModel<String>(fr.ifremer.isisfish.datastore.RegionStorage.getRegionNames());
                fieldSimulParamsRegion.setModel(model);
            }
        };RegionStorage.addStorageChangeListener(regionStorageListener);simulationListener = new SimulationServiceListener() {
            @Override
            public void simulationStart(SimulationService simService, SimulationJob job) {
            
            }
        
            @Override
            public void simulationStop(SimulationService simService, SimulationJob job) {
                GenericComboModel<String> model = (GenericComboModel)fieldSimulParamsSelect.getModel();
                model.addElement(job.getId());
            }
        
            @Override
            public void clearJobDone(SimulationService simService) {
            
            }
        };SimulationService.getService().addSimulationServiceListener(simulationListener);// la gestion des regles est maintenant independante de SimulAction
        // il faut faire la lié aux parametres de simulations
        simulAction.getSimulationParameter().setRules(ruleChooser.getRulesList());// registers 30 data bindings
        $registerDefaultBindings();
        $completeSetup();
    }

    private void $registerDefaultBindings() {
        // register 30 data bindings
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_LBL_NAME_TEXT, true ,"sensitivity") {
        
            @Override
            public void processDataBinding() {
                lblName.setText(isSensitivity() ? t("isisfish.params.sensitivityName") : t("isisfish.params.simulationName"));
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_FIELD_SIMUL_PARAMS_DESC_TEXT, true ,"simulAction") {
        
            @Override
            public void processDataBinding() {
                if (simulAction != null && simulAction.getSimulationParameter() != null) {
                    SwingUtil.setText(fieldSimulParamsDesc, simulAction.getSimulationParameter().getDescription());
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_FIELD_SIMUL_PARAMS_NB_ANNEES_TEXT, true ,"simulAction") {
        
            @Override
            public void processDataBinding() {
                if (simulAction != null && simulAction.getSimulationParameter() != null) {
                    SwingUtil.setText(fieldSimulParamsNbAnnees, String.valueOf(simulAction.getSimulationParameter().getNumberOfYear()));
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_PARAMETERS_TABBED_PANE_ENABLED, true ,"regionStorage") {
        
            @Override
            public void processDataBinding() {
                parametersTabbedPane.setEnabled(getRegionStorage() != null);
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_$JLABEL4_ENABLED, true ,"regionStorage") {
        
            @Override
            public void processDataBinding() {
                $JLabel4.setEnabled(getRegionStorage() != null);
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_$JLABEL5_ENABLED, true ,"regionStorage") {
        
            @Override
            public void processDataBinding() {
                $JLabel5.setEnabled(getRegionStorage() != null);
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_LIST_SIMUL_PARAMS_STRATEGIES_ENABLED, true ,"regionStorage") {
        
            @Override
            public void processDataBinding() {
                listSimulParamsStrategies.setEnabled(getRegionStorage() != null);
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_LIST_SIMUL_PARAMS_STRATEGIES_SELECTION_MODEL, true, true) {
        
            @Override
            public void applyDataBinding() {
                if (listSimulParamsStrategies != null) {
                    listSimulParamsStrategies.addPropertyChangeListener("selectionModel", this);
                }
                if (listSimulParamsStrategies != null) {
                    listSimulParamsStrategies.addPropertyChangeListener("model", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (listSimulParamsStrategies != null) {
                    listSimulParamsStrategies.setSelectionModel(new jaxx.runtime.swing.OneClicListSelectionModel(listSimulParamsStrategies.getSelectionModel(), listSimulParamsStrategies.getModel()));
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (listSimulParamsStrategies != null) {
                    listSimulParamsStrategies.removePropertyChangeListener("selectionModel", this);
                }
                if (listSimulParamsStrategies != null) {
                    listSimulParamsStrategies.removePropertyChangeListener("model", this);
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_LIST_SIMUL_PARAMS_POPULATIONS_ENABLED, true ,"regionStorage") {
        
            @Override
            public void processDataBinding() {
                listSimulParamsPopulations.setEnabled(getRegionStorage() != null);
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_LIST_SIMUL_PARAMS_POPULATIONS_SELECTION_MODEL, true, true) {
        
            @Override
            public void applyDataBinding() {
                if (listSimulParamsPopulations != null) {
                    listSimulParamsPopulations.addPropertyChangeListener("selectionModel", this);
                }
                if (listSimulParamsPopulations != null) {
                    listSimulParamsPopulations.addPropertyChangeListener("model", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (listSimulParamsPopulations != null) {
                    listSimulParamsPopulations.setSelectionModel(new jaxx.runtime.swing.OneClicListSelectionModel(listSimulParamsPopulations.getSelectionModel(), listSimulParamsPopulations.getModel()));
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (listSimulParamsPopulations != null) {
                    listSimulParamsPopulations.removePropertyChangeListener("selectionModel", this);
                }
                if (listSimulParamsPopulations != null) {
                    listSimulParamsPopulations.removePropertyChangeListener("model", this);
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_$JLABEL6_ENABLED, true ,"regionStorage") {
        
            @Override
            public void processDataBinding() {
                $JLabel6.setEnabled(getRegionStorage() != null);
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_POPULATION_EFFECTIVES_TABBED_PANE_ENABLED, true ,"regionStorage") {
        
            @Override
            public void processDataBinding() {
                populationEffectivesTabbedPane.setEnabled(getRegionStorage() != null);
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_RULE_CHOOSER_ACTIVE, true ,"regionStorage") {
        
            @Override
            public void processDataBinding() {
                ruleChooser.setActive(getRegionStorage() != null);
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_RULE_CHOOSER_SHOW_FACTOR_COLUMN, true ,"sensitivity") {
        
            @Override
            public void processDataBinding() {
                ruleChooser.setShowFactorColumn(isSensitivity());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_ADD_RULE_FACTOR_BUTTON_ENABLED, true ,"regionStorage") {
        
            @Override
            public void processDataBinding() {
                addRuleFactorButton.setEnabled(getRegionStorage() != null);
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_ADD_RULE_FACTOR_BUTTON_VISIBLE, true ,"sensitivity") {
        
            @Override
            public void processDataBinding() {
                addRuleFactorButton.setVisible(isSensitivity());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_FIELD_USE_SIMUL_PRE_SCRIPTS_SELECTED, true ,"simulAction") {
        
            @Override
            public void processDataBinding() {
                if (simulAction != null && simulAction.getSimulationParameter() != null) {
                    fieldUseSimulPreScripts.setSelected(simulAction.getSimulationParameter().getUsePreScript());
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_FIELD_USE_SIMUL_PRE_SCRIPTS_VISIBLE, true ,"sensitivity") {
        
            @Override
            public void processDataBinding() {
                fieldUseSimulPreScripts.setVisible(!isSensitivity());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_FIELD_SIMUL_USE_SIMULATION_PLAN_ENABLED, true ,"regionStorage") {
        
            @Override
            public void processDataBinding() {
                fieldSimulUseSimulationPlan.setEnabled(getRegionStorage() != null);
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_FIELD_SIMUL_USE_SIMULATION_PLAN_SELECTED, true ,"simulAction") {
        
            @Override
            public void processDataBinding() {
                if (simulAction != null && simulAction.getSimulationParameter() != null) {
                    fieldSimulUseSimulationPlan.setSelected(simulAction.getSimulationParameter().getUseSimulationPlan());
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_FIELD_SIMUL_USE_SIMULATION_PLAN_VISIBLE, true ,"sensitivity") {
        
            @Override
            public void processDataBinding() {
                fieldSimulUseSimulationPlan.setVisible(!isSensitivity());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_FIELD_SIMUL_USE_OPTIMIZATION_ENABLED, true ,"regionStorage") {
        
            @Override
            public void processDataBinding() {
                fieldSimulUseOptimization.setEnabled(getRegionStorage() != null);
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_FIELD_SIMUL_USE_OPTIMIZATION_SELECTED, true ,"simulAction") {
        
            @Override
            public void processDataBinding() {
                if (simulAction != null && simulAction.getSimulationParameter() != null) {
                    fieldSimulUseOptimization.setSelected(simulAction.getSimulationParameter().getUseOptimization());
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_FIELD_SIMUL_USE_OPTIMIZATION_VISIBLE, true ,"sensitivity") {
        
            @Override
            public void processDataBinding() {
                fieldSimulUseOptimization.setVisible(!isSensitivity());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_SENSITIVITY_ONLY_KEEP_FIRST_RESULT_CHECK_BOX_ENABLED, true ,"regionStorage") {
        
            @Override
            public void processDataBinding() {
                sensitivityOnlyKeepFirstResultCheckBox.setEnabled(getRegionStorage() != null);
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_SENSITIVITY_ONLY_KEEP_FIRST_RESULT_CHECK_BOX_SELECTED, true ,"simulAction") {
        
            @Override
            public void processDataBinding() {
                if (simulAction != null && simulAction.getSimulationParameter() != null) {
                    sensitivityOnlyKeepFirstResultCheckBox.setSelected(simulAction.getSimulationParameter().isSensitivityAnalysisOnlyKeepFirst());
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_SENSITIVITY_ONLY_KEEP_FIRST_RESULT_CHECK_BOX_VISIBLE, true ,"sensitivity") {
        
            @Override
            public void processDataBinding() {
                sensitivityOnlyKeepFirstResultCheckBox.setVisible(isSensitivity());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_COMBO_SEL_LAUNCHER_MODEL, true ,"simulAction") {
        
            @Override
            public void processDataBinding() {
                if (simulAction != null && simulAction.getSimulationLauncher() != null) {
                    comboSelLauncher.setModel(new DefaultComboBoxModel(simulAction.getSimulationLauncher().toArray()));
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_BUTTON_SIMUL_PARAMS_SIMULATE_ENABLED, true ,"regionStorage") {
        
            @Override
            public void processDataBinding() {
                buttonSimulParamsSimulate.setEnabled(getRegionStorage() != null);
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_SAVE_SIMUL_ENABLED, true ,"regionStorage") {
        
            @Override
            public void processDataBinding() {
                saveSimul.setEnabled(getRegionStorage() != null);
            }
        });
    }

}