package fr.ifremer.isisfish.ui.input;

import fr.ifremer.isisfish.entities.Equation;
import fr.ifremer.isisfish.entities.Formule;
import fr.ifremer.isisfish.ui.input.formule.FormuleComboModel;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.binding.SimpleJAXXObjectBinding;
import jaxx.runtime.swing.Table;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.topia.TopiaContext;
import org.nuiton.topia.persistence.TopiaEntityContextable;
import org.nuiton.widget.editor.Editor;
import static org.nuiton.i18n.I18n.t;

public class InputOneEquationUI extends InputContentUI<org.nuiton.topia.persistence.TopiaEntityContextable> {

    /*-----------------------------------------------------------------------*/
    /*---------------- Constants for all javaBean properties ----------------*/
    /*-----------------------------------------------------------------------*/

    public static final String PROPERTY_AUTO_SAVE_MODIFICATION = "autoSaveModification";
    public static final String PROPERTY_BEAN = "bean";
    public static final String PROPERTY_BEAN_PROPERTY = "beanProperty";
    public static final String PROPERTY_CLAZZ = "clazz";
    public static final String PROPERTY_FORMULE = "formule";
    public static final String PROPERTY_FORMULE_CATEGORY = "formuleCategory";
    public static final String PROPERTY_SELECTED_EQUATION = "selectedEquation";
    public static final String PROPERTY_TEXT = "text";

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_EDITOR_ENABLED = "editor.enabled";
    public static final String BINDING_FORMULE_COMBO_BOX_ENABLED = "formuleComboBox.enabled";

    /*-----------------------------------------------------------------------*/
    /*--------------- Constants for all none public bindings  ---------------*/
    /*-----------------------------------------------------------------------*/

    private static final String BINDING_$JBUTTON0_ENABLED = "$JButton0.enabled";
    private static final String BINDING_$JBUTTON1_ENABLED = "$JButton1.enabled";
    private static final String BINDING_$JLABEL0_ENABLED = "$JLabel0.enabled";
    private static final String BINDING_$JLABEL0_TEXT = "$JLabel0.text";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAKVVzW8bRRSfuHW++pEU0yqIIkJxoULVOBUgDqlKSYhVW24b4Vaq8IVZ77MzZT2znXnbbHJA/An8CXDngsSNE+LAmQMXxL+AEAeuiDezttebmNQiPux65733e7/3sb/99g9Wtoa98VSkKTeJQjkA3vzoyZOHwVPo4sdgu0bGqA3LfnMlVuqwc+H43CJ7s9Ny4bVheG1bD2KtQE1Eb7bYssWDCOweACJ7rRjRtbbWHps30zgxI9QxqWmoX//1Z+mr8MtvSoylMbGrUCnrL4rKKznbYiUZInuJMj0XtUioPtEwUvWJ7wV3th0Jax+IATxjX7CFFpuPhSEwZNdmL9lj+Pg0RrZabag4wW2tkNwfNzaQ1XqGy56BAdDdStuTdo8nkkvnyL37QwU7zxKBUqvHjTj2cPPIziKkRGbVUeWOPs/oT3gEIBSyd7Xpc5VI1IqjjqXgMRhKRRy6wB+5kx2qBA88rxRFEEEOct6B7BpNMXjgzi7mtnI3EoeHyFZyDr7g3GOhp80giQBZdVqh4PJKsLyeueWBK8PAbYHQ1+Zo5lULEa0ohKPOILt+YoKRXw7xskhQt8VzuK9D2ZPdIcylvJYtrSMqPg+pVNt+wA1FoCKSh2BohG/5pevSFsiIcmc7wI95Ts5Fhwe0eS5Tyu0+DY03d4WCaKJx1UduDgS/VtjpzNvbnOf1ccBitdkSAUQbR4H9qXO6cby5ehDoLZ0iu1wIGZ0Xo4aUbrnHd4qmpWpzK0FaMMpeKUBlx87t1nFvD/V+0Uh1+FZsuOe3i7Z5CGmLDbLXJ1Z6X4Z9QJ6Z+I6/DdkZ9mqheSQ1PJeaXAvmOqxsqB+kZ2ud4+r0CZkyXVo7oksO0Fv/uVL59Yffv6+PxGiZcl+e6jqhpSQScfZiSZd6JVOiBGVUuy/izQ5byrbcC+3VKcTaQzORo3zZ5rpwfk/YPYIoL/z2409XPvvlDCvV2XKkRVgXzr/BlnDPUBd0FKbxh3c9o/P7i3Rdddxo1qDcrEkfL94OBYr1QKqQBnonpS5cndKFMZVg6ee/K+3v7o46MUfMXvlP97wb5U/ZvFSRVOCFeai5U4X4XGwhCXWurdPUds7db8bDN2rLX+vTSvU66qyNNHG3pift/rVmxHDH905AqM3AYpE+LSEYMKfCeRGT92ZC2CUJuZ3NYl0gfVSCBOHOaRBP4vTBbJzcJfi/CMguCPt5o/dAo1P88ASwzVMX5BD+BTp2mg9bCQAA";
    private static final Log log = LogFactory.getLog(InputOneEquationUI.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    private boolean allComponentsCreated;

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected Boolean autoSaveModification;
    protected TopiaEntityContextable bean;
    protected String beanProperty;
    protected Class clazz;
    protected Editor editor;
    protected Formule formule;
    protected String formuleCategory;
    protected JComboBox formuleComboBox;
    protected Equation selectedEquation;
    protected String text;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private InputOneEquationUI $InputContentUI0 = this;
    private JButton $JButton0;
    private JButton $JButton1;
    private JLabel $JLabel0;
    private JPanel $JPanel0;
    private Table $Table0;
    private Table $Table1;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/

    protected DocumentListener listener;
    
    
    protected void $afterCompleteSetup() {
        addPropertyChangeListener(PROPERTY_BEAN, new PropertyChangeListener() {
            public void propertyChange(PropertyChangeEvent evt) {
                if (evt.getNewValue() == null) {
                    formuleComboBox.setModel(new DefaultComboBoxModel());
                    try {
                        File nullFile = org.nuiton.util.FileUtil.getTempFile("", ".java");
                        editor.open(nullFile);
                        editor.setEnabled(false); // editor is replaced at each launch
                    } catch (IOException e) {
                        if (log.isErrorEnabled()) {
                            log.error("Error on property change", e);
                        }
                    }
                }
                if (evt.getNewValue() != null) {
                    // chatellier 20090526 : force refresh in bean change ?
                    refresh();
                }
            }
        });
    
        if (listener == null) {
            listener = new DocumentListener() {
                @Override
                public void insertUpdate(DocumentEvent e) {
                    setEquation();
                }
                @Override
                public void removeUpdate(DocumentEvent e) {
                    setEquation();
                }
                @Override
                public void changedUpdate(DocumentEvent e) {
                }
            };
        }
        setComboModel();
    }
    
    /**
     * Get equation on entity.
     */
    protected Equation getEquation() {
        Equation result = null;
        try {
            // can be null in some uis
            // content is managed by caller, can do anythings here
            if (bean != null && beanProperty != null) {
                String localBeanProperty = StringUtils.capitalize(beanProperty);
                Method m = bean.getClass().getMethod("get" + localBeanProperty);
                result = (Equation)m.invoke(bean);
            }
        } catch (Exception e) {
            if (log.isErrorEnabled()) {
                log.error("Can't get equation", e);
            }
        }
        return result;
    }
    
    /**
     * Call setXXXContent on topia entity (convention).
     */
    protected void setEquation() {
        try {
            // can be null in some uis
            // content is managed by caller, can do anythings here
            if (bean != null && beanProperty != null) {
                if (log.isDebugEnabled()) {
                    log.debug("Saving equation content (" + bean.getClass().getSimpleName() +
                        "#" + beanProperty + ")");
                }
                String localBeanProperty = StringUtils.capitalize(beanProperty);
                Method m = bean.getClass().getMethod("set" + localBeanProperty + "Content", String.class);
                m.invoke(bean, editor.getText());
            }
            else {
                if (log.isDebugEnabled()) {
                    log.debug("No bean property defined, skipping content saving");
                }
            }
        } catch (Exception e) {
            if (log.isErrorEnabled()) {
                log.error("Can't set equation content", e);
            }
        }
    }
    
    public void refresh() {
    
        // TODO binding don't work
        if (getText() == null) {
            setText(t("isisfish.common.equation"));    
        }
    
        editor.getCurrentEditor().removeDocumentListener(listener);
        try {
            File equationContentFile = org.nuiton.util.FileUtil.getTempFile("", ".java");
            editor.open(equationContentFile);
            editor.setEnabled(isActive());
        } catch (IOException ex) {
            if (log.isErrorEnabled()) {
                log.error("Can't refresh editor", ex);
            }
        }
        if (formuleCategory != null) {
            // chatellier 20090526 (change to get combo selected on this equation)
            selectedEquation = getEquation();
            setComboModel();
            setFormule((Formule)formuleComboBox.getSelectedItem());
            setEditorText();
        }
    
        // utilisee lors de l'edition des equations dans l'interface de sensibilité
        // le contenu de l'equation ne doit pas automatiquement
        // etre sauvé dans l'entité (pas de sens pour un facteur discret de type equation)
        if (autoSaveModification) {
            editor.getCurrentEditor().addDocumentListener(listener);
        }
    }
    
    protected void setComboModel() {
        if (getBean() !=  null){
            TopiaContext isisContext = ((org.nuiton.topia.persistence.TopiaEntityAbstract)getBean()).getTopiaContext();
            java.util.List<Formule> formules = null;
            if (formuleCategory != null) {
                formules = getAction().getFormules(isisContext, formuleCategory);
                FormuleComboModel formulesModel = new FormuleComboModel(formules);
                formuleComboBox.setModel(formulesModel);
                // fix default selection
                formuleComboBox.setSelectedItem(selectedEquation);
            }
        }
    }
    protected void saveModel() {
        getContextValue(InputAction.class).saveAsModel(formuleCategory, "Java", editor.getText());
        setComboModel();
        setInfoText(t("isisfish.message.saveModel.finished"));
    }
    
    /**
     * Open external editor, with equation documentation.
     */
    protected void openEditor() {
        Formule e = (Formule)formuleComboBox.getSelectedItem();
        if (e != null) {
            getContextValue(InputAction.class).openEditor(this, e.getCategory(), e.getName(), clazz, e.getContent(), editor);
        }
        else {
            getContextValue(InputAction.class).openEditor(this, formuleCategory, "new", clazz, editor.getText(), editor);
        }
    }
    protected void setEditorText() {
        if (getFormule() != null) {
            editor.setText(getFormule().getContent());
        }
        else {
            try {
                File nullFile = org.nuiton.util.FileUtil.getTempFile("", ".java");
                editor.open(nullFile);
            } catch (IOException e) {
                if (log.isErrorEnabled()) {
                  log.error("Open editor", e);
                }
            }
        }
    }
    
    /**
     * New formule selected, replace content.
     */
    protected void formuleChanged() {
        Formule selectedFormule = (Formule)formuleComboBox.getSelectedItem();
        setFormule(selectedFormule);
        setEditorText();
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public InputOneEquationUI(LayoutManager param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public InputOneEquationUI(JAXXContext param0, LayoutManager param1, boolean param2) {
        super(param0 ,param1 ,param2);
        $initialize();
    }

    public InputOneEquationUI() {
        $initialize();
    }

    public InputOneEquationUI(JAXXContext param0) {
        super(param0);
        $initialize();
    }

    public InputOneEquationUI(LayoutManager param0) {
        super(param0);
        $initialize();
    }

    public InputOneEquationUI(JAXXContext param0, LayoutManager param1) {
        super(param0 ,param1);
        $initialize();
    }

    public InputOneEquationUI(boolean param0) {
        super(param0);
        $initialize();
    }

    public InputOneEquationUI(JAXXContext param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doActionPerformed__on__$JButton0(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        saveModel();
    }

    public void doActionPerformed__on__$JButton1(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        openEditor();
    }

    public void doActionPerformed__on__formuleComboBox(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        formuleChanged();
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public Boolean getAutoSaveModification() {
        return autoSaveModification;
    }

    public TopiaEntityContextable getBean() {
        return bean;
    }

    public String getBeanProperty() {
        return beanProperty;
    }

    public Class getClazz() {
        return clazz;
    }

    public Editor getEditor() {
        return editor;
    }

    public Formule getFormule() {
        return formule;
    }

    public String getFormuleCategory() {
        return formuleCategory;
    }

    public JComboBox getFormuleComboBox() {
        return formuleComboBox;
    }

    public Equation getSelectedEquation() {
        return selectedEquation;
    }

    public String getText() {
        return text;
    }

    public Boolean isAutoSaveModification() {
        return autoSaveModification !=null && autoSaveModification;
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public mutator methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public void setAutoSaveModification(Boolean autoSaveModification) {
        Boolean oldValue = this.autoSaveModification;
        this.autoSaveModification = autoSaveModification;
        firePropertyChange(PROPERTY_AUTO_SAVE_MODIFICATION, oldValue, autoSaveModification);
    }

    public void setBean(TopiaEntityContextable bean) {
        TopiaEntityContextable oldValue = this.bean;
        this.bean = bean;
        firePropertyChange(PROPERTY_BEAN, oldValue, bean);
    }

    public void setBeanProperty(String beanProperty) {
        String oldValue = this.beanProperty;
        this.beanProperty = beanProperty;
        firePropertyChange(PROPERTY_BEAN_PROPERTY, oldValue, beanProperty);
    }

    public void setClazz(Class clazz) {
        Class oldValue = this.clazz;
        this.clazz = clazz;
        firePropertyChange(PROPERTY_CLAZZ, oldValue, clazz);
    }

    public void setFormule(Formule formule) {
        Formule oldValue = this.formule;
        this.formule = formule;
        firePropertyChange(PROPERTY_FORMULE, oldValue, formule);
    }

    public void setFormuleCategory(String formuleCategory) {
        String oldValue = this.formuleCategory;
        this.formuleCategory = formuleCategory;
        firePropertyChange(PROPERTY_FORMULE_CATEGORY, oldValue, formuleCategory);
    }

    public void setSelectedEquation(Equation selectedEquation) {
        Equation oldValue = this.selectedEquation;
        this.selectedEquation = selectedEquation;
        firePropertyChange(PROPERTY_SELECTED_EQUATION, oldValue, selectedEquation);
    }

    public void setText(String text) {
        String oldValue = this.text;
        this.text = text;
        firePropertyChange(PROPERTY_TEXT, oldValue, text);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected JButton get$JButton0() {
        return $JButton0;
    }

    protected JButton get$JButton1() {
        return $JButton1;
    }

    protected JLabel get$JLabel0() {
        return $JLabel0;
    }

    protected JPanel get$JPanel0() {
        return $JPanel0;
    }

    protected Table get$Table0() {
        return $Table0;
    }

    protected Table get$Table1() {
        return $Table1;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToBody() {
        if (!allComponentsCreated) {
            return;
        }
        body.add($Table0);
    }

    protected void createAutoSaveModification() {
        $objectMap.put("autoSaveModification", autoSaveModification = true);
    }

    protected void createBean() {
        $objectMap.put("bean", bean = null);
    }

    protected void createBeanProperty() {
        $objectMap.put("beanProperty", beanProperty = null);
    }

    @Override
    protected void createBody() {
        super.createBody();
        body.setName("body");
    }

    protected void createClazz() {
        $objectMap.put("clazz", clazz = null);
    }

    protected void createEditor() {
        $objectMap.put("editor", editor = new Editor());
        
        editor.setName("editor");
        editor.setAskIfNotSaved(false);
    }

    protected void createFormule() {
        $objectMap.put("formule", formule = null);
    }

    protected void createFormuleCategory() {
        $objectMap.put("formuleCategory", formuleCategory = null);
    }

    protected void createFormuleComboBox() {
        $objectMap.put("formuleComboBox", formuleComboBox = new JComboBox());
        
        formuleComboBox.setName("formuleComboBox");
        formuleComboBox.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__formuleComboBox"));
    }

    protected void createSelectedEquation() {
        $objectMap.put("selectedEquation", selectedEquation = null);
    }

    protected void createText() {
        $objectMap.put("text", text = null);
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        addChildrenToBody();
        // inline complete setup of $Table0
        $Table0.add($JLabel0, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 13, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(formuleComboBox, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add($Table1, new GridBagConstraints(0, 1, 1, 1, 0.0, 1.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(editor, new GridBagConstraints(1, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        // inline complete setup of $Table1
        $Table1.add($JButton0, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add($JButton1, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add($JPanel0, new GridBagConstraints(0, 2, 1, 1, 0.0, 1.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        
        // apply 6 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
        
        // apply 1 property setters
        formuleComboBox.setRenderer(new fr.ifremer.isisfish.ui.input.formule.FormuleComboRenderer());
        $afterCompleteSetup();
    }

    private void $initialize() {
        if (allComponentsCreated) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        $objectMap.put("$InputContentUI0", $InputContentUI0);
        createText();
        createBean();
        createBeanProperty();
        createClazz();
        createFormule();
        createFormuleCategory();
        createSelectedEquation();
        createAutoSaveModification();
        listener = null;
        // inline creation of $Table0
        $objectMap.put("$Table0", $Table0 = new Table());
        
        $Table0.setName("$Table0");
        // inline creation of $JLabel0
        $objectMap.put("$JLabel0", $JLabel0 = new JLabel());
        
        $JLabel0.setName("$JLabel0");
        createFormuleComboBox();
        // inline creation of $Table1
        $objectMap.put("$Table1", $Table1 = new Table());
        
        $Table1.setName("$Table1");
        // inline creation of $JButton0
        $objectMap.put("$JButton0", $JButton0 = new JButton());
        
        $JButton0.setName("$JButton0");
        $JButton0.setText(t("isisfish.common.saveModel"));
        $JButton0.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__$JButton0"));
        // inline creation of $JButton1
        $objectMap.put("$JButton1", $JButton1 = new JButton());
        
        $JButton1.setName("$JButton1");
        $JButton1.setText(t("isisfish.common.openEditor"));
        $JButton1.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__$JButton1"));
        // inline creation of $JPanel0
        $objectMap.put("$JPanel0", $JPanel0 = new JPanel());
        
        $JPanel0.setName("$JPanel0");
        createEditor();
        // inline creation of $InputContentUI0
        setName("$InputContentUI0");
        
        // registers 6 data bindings
        $registerDefaultBindings();
        $completeSetup();
    }

    private void $registerDefaultBindings() {
        // register 6 data bindings
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_$JLABEL0_ENABLED, true ,"active") {
        
            @Override
            public void processDataBinding() {
                $JLabel0.setEnabled(isActive());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_$JLABEL0_TEXT, true ,"text") {
        
            @Override
            public void processDataBinding() {
                $JLabel0.setText(t(getText()));
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_FORMULE_COMBO_BOX_ENABLED, true ,"active") {
        
            @Override
            public void processDataBinding() {
                formuleComboBox.setEnabled(isActive());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_$JBUTTON0_ENABLED, true ,"active") {
        
            @Override
            public void processDataBinding() {
                $JButton0.setEnabled(isActive() && formuleCategory != null);
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_$JBUTTON1_ENABLED, true ,"active") {
        
            @Override
            public void processDataBinding() {
                $JButton1.setEnabled(isActive() && clazz != null && formuleCategory != null);
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_EDITOR_ENABLED, true ,"active") {
        
            @Override
            public void processDataBinding() {
                editor.setEnabled(isActive());
            }
        });
    }

}