package fr.ifremer.isisfish.ui.input;

import fr.ifremer.isisfish.entities.Gear;
import java.awt.BorderLayout;
import java.awt.LayoutManager;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JTabbedPane;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.binding.SimpleJAXXObjectBinding;
import jaxx.runtime.swing.TabInfo;
import jaxx.runtime.swing.TabInfoPropertyChangeListener;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import static org.nuiton.i18n.I18n.n;
import static org.nuiton.i18n.I18n.t;

public class GearUI extends InputContentUI<fr.ifremer.isisfish.entities.Gear> {

    /*-----------------------------------------------------------------------*/
    /*---------------- Constants for all javaBean properties ----------------*/
    /*-----------------------------------------------------------------------*/

    public static final String PROPERTY_BEAN = "bean";

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_GEAR_TAB_UI_ACTIVE = "gearTabUI.active";
    public static final String BINDING_GEAR_TAB_UI_BEAN = "gearTabUI.bean";
    public static final String BINDING_GEAR_TAB_UI_SENSITIVITY = "gearTabUI.sensitivity";
    public static final String BINDING_SELECTIVITY_UI_ACTIVE = "selectivityUI.active";
    public static final String BINDING_SELECTIVITY_UI_BEAN = "selectivityUI.bean";
    public static final String BINDING_SELECTIVITY_UI_SENSITIVITY = "selectivityUI.sensitivity";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAKVTPW8TQRAdm9iOY0JCIkwCiZRAQOLrDKJBMoIgI4MjQxDGUoQb1r61vdF5b9ndS84N4ifwE6CnQaKjQhTUFDSIv4AQBS1i9uz4gxyxpbi4tWbeezsz++btD4gpCavbxPct6XHNWtTauLO1tVndpjV9l6qaZEK7Ejq/SBSiFUjZvbjScLZSNPRMl57JuS3hcsoH2NkiTCnddqhqUqo1LA8zakplSr101hee3FPtFRWm+vrXz+gr++WbKIAvsLpJbGVlFKvfyUQRoszWMIc37ZCMQ3gDy5CMN7DeaRPLOUSph6RFn8MLSBQhLohEMQ1nxm850Aj4vtAwu1bgwtM5l2uElwtXcX51abG6pC2Kp2KqzlTT8pjFDNC6R4ksF4QIJOIaJqqUcA2rYSRUZJpRFZAGKa7dxjZNR76ldrFBa+MR4dTpYxINpDwhVQ0nh2AYqlLbgA1wpodPdvHlgobzIxsIgIY51xOYVtRBh7EdpttG5OKBIqVB8LBQcg3VC7zu4ihPDT1+p4VuVuwnXDOBZUxIOD1ERD9afT/2DROpQEx6GNawUNlv4ceY6ph34R/zGsEg+yc9//XD9/f5PcfG8e4TodCBhUMnCekKKs3bapjp2NXTzMk8ICJbgWRnlsE2LoUUVuqmsTi877ihW4Zu3SeqiRKxxLePn9LPvhyBaB6mHJfYeWLwBUjqpsQpuI7ti9vrQUVHdyfxO2tq0xAn5lVwRsdu2kSTlSrjNg79lo9DWAoZQq+SavLz7/nSu/W9QUSwsMX/wvvDiD2FOOMO4zRY3u5ehi5rSijq2W5//8I2MmLOtOi641zwvRDWabB3JnvZ98xxJSja/MuMrZFSlCvWsfGhpEz40gEKi2MpXD+0wo0RCn8B6sgTiV8GAAA=";
    private static final Log log = LogFactory.getLog(GearUI.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    private boolean allComponentsCreated;

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected Gear bean;
    protected JTabbedPane gearTab;
    protected GearTabUI gearTabUI;
    protected SelectivityUI selectivityUI;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private GearUI $InputContentUI0 = this;
    private TabInfo $TabInfo0;
    private TabInfo $TabInfo1;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/

    protected void $afterCompleteSetup() {
        setButtonTitle(t("isisfish.input.continueMetiers"));
        setNextPath(n("isisfish.input.tree.metiers"));
        
        addPropertyChangeListener(PROPERTY_BEAN, new PropertyChangeListener() {
            public void propertyChange(PropertyChangeEvent evt) {
                if (evt.getNewValue() == null) {
    
                }
                if (evt.getNewValue() != null) {
                    //getVerifier().addCurrentPanel(gearTabUI, selectivityUI);
                }
            }
        });
        
        // install change listener
        // (depends on sensitivity can't be done on constructor)
        installChangeListener(gearTab);
    }
    
    /*public void refresh() {
        //getVerifier().addCurrentPanel(gearTabUI, selectivityUI);
    }*/
    
    @Override
    public void setLayer(boolean active) {
        super.setLayer(active);
        gearTabUI.setLayer(active);
        selectivityUI.setLayer(active);
    }
    
    @Override
    public void resetChangeModel() {
        gearTabUI.resetChangeModel();
        selectivityUI.resetChangeModel();
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public GearUI(LayoutManager param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public GearUI(JAXXContext param0, LayoutManager param1, boolean param2) {
        super(param0 ,param1 ,param2);
        $initialize();
    }

    public GearUI() {
        $initialize();
    }

    public GearUI(JAXXContext param0) {
        super(param0);
        $initialize();
    }

    public GearUI(LayoutManager param0) {
        super(param0);
        $initialize();
    }

    public GearUI(JAXXContext param0, LayoutManager param1) {
        super(param0 ,param1);
        $initialize();
    }

    public GearUI(boolean param0) {
        super(param0);
        $initialize();
    }

    public GearUI(JAXXContext param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public Gear getBean() {
        return bean;
    }

    public JTabbedPane getGearTab() {
        return gearTab;
    }

    public GearTabUI getGearTabUI() {
        return gearTabUI;
    }

    public SelectivityUI getSelectivityUI() {
        return selectivityUI;
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public mutator methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public void setBean(Gear bean) {
        Gear oldValue = this.bean;
        this.bean = bean;
        firePropertyChange(PROPERTY_BEAN, oldValue, bean);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected TabInfo get$TabInfo0() {
        return $TabInfo0;
    }

    protected TabInfo get$TabInfo1() {
        return $TabInfo1;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToBody() {
        if (!allComponentsCreated) {
            return;
        }
        body.add(gearTab, BorderLayout.CENTER);
    }

    protected void addChildrenToGearTab() {
        if (!allComponentsCreated) {
            return;
        }
        gearTab.add(gearTabUI);
        gearTab.add(selectivityUI);
        $TabInfo0.addPropertyChangeListener(new TabInfoPropertyChangeListener(gearTab, 0));
        gearTab.setTitleAt(0, t("isisfish.gear.title"));
        $TabInfo1.addPropertyChangeListener(new TabInfoPropertyChangeListener(gearTab, 1));
        gearTab.setTitleAt(1, t("isisfish.selectivity.title"));
    }

    protected void createBean() {
        $objectMap.put("bean", bean = null);
    }

    @Override
    protected void createBody() {
        super.createBody();
        body.setName("body");
    }

    protected void createGearTab() {
        $objectMap.put("gearTab", gearTab = new JTabbedPane());
        
        gearTab.setName("gearTab");
    }

    protected void createGearTabUI() {
        $objectMap.put("gearTabUI", gearTabUI = new GearTabUI(this));
        
        gearTabUI.setName("gearTabUI");
    }

    protected void createSelectivityUI() {
        $objectMap.put("selectivityUI", selectivityUI = new SelectivityUI(this));
        
        selectivityUI.setName("selectivityUI");
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        addChildrenToBody();
        addChildrenToGearTab();
        
        // apply 6 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
        
        $afterCompleteSetup();
    }

    private void $initialize() {
        if (allComponentsCreated) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        $objectMap.put("$InputContentUI0", $InputContentUI0);
        createBean();
        createGearTab();
        createGearTabUI();
        createSelectivityUI();
        // inline creation of $TabInfo0
        $objectMap.put("$TabInfo0", $TabInfo0 = new TabInfo());
        
        $TabInfo0.setTitle(t("isisfish.gear.title"));
        // inline creation of $TabInfo1
        $objectMap.put("$TabInfo1", $TabInfo1 = new TabInfo());
        
        $TabInfo1.setTitle(t("isisfish.selectivity.title"));
        // inline creation of $InputContentUI0
        setName("$InputContentUI0");
        
        // registers 6 data bindings
        $registerDefaultBindings();
        $completeSetup();
    }

    private void $registerDefaultBindings() {
        // register 6 data bindings
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_GEAR_TAB_UI_ACTIVE, true ,"active") {
        
            @Override
            public void processDataBinding() {
                gearTabUI.setActive(isActive());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_GEAR_TAB_UI_BEAN, true ,"bean") {
        
            @Override
            public void processDataBinding() {
                gearTabUI.setBean(getBean());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_GEAR_TAB_UI_SENSITIVITY, true ,"sensitivity") {
        
            @Override
            public void processDataBinding() {
                gearTabUI.setSensitivity(isSensitivity());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_SELECTIVITY_UI_ACTIVE, true ,"active") {
        
            @Override
            public void processDataBinding() {
                selectivityUI.setActive(isActive());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_SELECTIVITY_UI_BEAN, true ,"bean") {
        
            @Override
            public void processDataBinding() {
                selectivityUI.setBean(getBean());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_SELECTIVITY_UI_SENSITIVITY, true ,"sensitivity") {
        
            @Override
            public void processDataBinding() {
                selectivityUI.setSensitivity(isSensitivity());
            }
        });
    }

}