/*
 * Decompiled with CFR 0.152.
 */
package cryptix.jce.provider.rsa;

import cryptix.jce.provider.asn.AsnBitString;
import cryptix.jce.provider.asn.AsnInputStream;
import cryptix.jce.provider.asn.AsnInteger;
import cryptix.jce.provider.asn.AsnObject;
import cryptix.jce.provider.asn.AsnSequence;
import cryptix.jce.provider.rsa.RSAPrivateCrtKeyCryptix;
import cryptix.jce.provider.rsa.RSAPrivateKeyCryptix;
import cryptix.jce.provider.rsa.RSAPublicKeyCryptix;
import cryptix.jce.provider.rsa.RSAPublicKeyImpl;
import java.io.IOException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyFactorySpi;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.KeySpec;
import java.security.spec.RSAPrivateCrtKeySpec;
import java.security.spec.RSAPrivateKeySpec;
import java.security.spec.RSAPublicKeySpec;
import java.security.spec.X509EncodedKeySpec;

public final class RSAKeyFactory
extends KeyFactorySpi {
    private PrivateKey decodePrivateKey(X509EncodedKeySpec keySpec) throws InvalidKeySpecException {
        throw new RuntimeException("NYI");
    }

    private PublicKey decodePublicKey(X509EncodedKeySpec keySpec) throws InvalidKeySpecException {
        try {
            AsnInputStream ais = new AsnInputStream(keySpec.getEncoded());
            AsnSequence seq = (AsnSequence)ais.read();
            if (seq.size() != 2) {
                throw new InvalidKeySpecException("First SEQUENCE has " + seq.size() + " elements.");
            }
            AsnObject uh = seq.get(0);
            System.out.println(uh);
            AsnBitString bs = (AsnBitString)seq.get(1);
            ais = new AsnInputStream(bs.toByteArray());
            seq = (AsnSequence)ais.read();
            if (seq.size() != 2) {
                throw new InvalidKeySpecException("Second SEQUENCE has " + seq.size() + " elements.");
            }
            AsnInteger n = (AsnInteger)seq.get(0);
            AsnInteger e = (AsnInteger)seq.get(1);
            return new RSAPublicKeyImpl(n.toBigInteger(), e.toBigInteger());
        }
        catch (ClassCastException e) {
            throw new InvalidKeySpecException("Unexpected ASN.1 type detected: " + e.getMessage());
        }
        catch (IOException iOException) {
            throw new InvalidKeySpecException("Could not parse key.");
        }
    }

    protected PrivateKey engineGeneratePrivate(KeySpec keySpec) throws InvalidKeySpecException {
        if (keySpec instanceof RSAPrivateCrtKeySpec) {
            RSAPrivateCrtKeySpec s = (RSAPrivateCrtKeySpec)keySpec;
            return new RSAPrivateCrtKeyCryptix(s.getModulus(), s.getPublicExponent(), s.getPrivateExponent(), s.getPrimeP(), s.getPrimeQ(), s.getPrimeExponentP(), s.getPrimeExponentQ(), s.getCrtCoefficient());
        }
        if (keySpec instanceof RSAPrivateKeySpec) {
            RSAPrivateKeySpec s = (RSAPrivateKeySpec)keySpec;
            return new RSAPrivateKeyCryptix(s.getModulus(), s.getPrivateExponent());
        }
        if (keySpec instanceof X509EncodedKeySpec) {
            return this.decodePrivateKey((X509EncodedKeySpec)keySpec);
        }
        throw new InvalidKeySpecException(String.valueOf(this.getClass().getName()) + ".engineGeneratePrivate: " + "KeySpec of type " + keySpec.getClass() + " not supported.");
    }

    protected PublicKey engineGeneratePublic(KeySpec keySpec) throws InvalidKeySpecException {
        if (keySpec instanceof RSAPublicKeySpec) {
            RSAPublicKeySpec s = (RSAPublicKeySpec)keySpec;
            return new RSAPublicKeyCryptix(s.getModulus(), s.getPublicExponent());
        }
        if (keySpec instanceof X509EncodedKeySpec) {
            PublicKey tmp = this.decodePublicKey((X509EncodedKeySpec)keySpec);
            X509EncodedKeySpec ks = new X509EncodedKeySpec(tmp.getEncoded());
            return this.decodePublicKey(ks);
        }
        throw new InvalidKeySpecException(String.valueOf(this.getClass().getName()) + ".engineGeneratePublic: " + "KeySpec type " + keySpec.getClass() + " not supported.");
    }

    protected KeySpec engineGetKeySpec(Key key, Class keySpec) throws InvalidKeySpecException {
        throw new RuntimeException("NYI");
    }

    protected Key engineTranslateKey(Key key) throws InvalidKeyException {
        throw new RuntimeException("NYI");
    }
}

