/*
 * Decompiled with CFR 0.152.
 */
package com.orientimport.easyfck.services;

import com.orientimport.easyfck.services.FckEditorService;
import com.orientimport.easyfck.util.Tapestry5VersionUtil;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.servlet.ServletContext;
import org.apache.tapestry5.Asset;
import org.apache.tapestry5.ioc.Resource;
import org.apache.tapestry5.ioc.annotations.Symbol;
import org.apache.tapestry5.ioc.services.SymbolSource;
import org.slf4j.Logger;

public class FckEditorServiceImpl
implements FckEditorService {
    private static final String NEW_LINE = System.getProperty("line.separator");
    private final Logger logger;
    private final Map<String, String> savedConfigurations;
    private final String editorBasePath;
    private final String commonConfiguration;
    private final String applicationContext;

    public FckEditorServiceImpl(Logger logger, SymbolSource symbolSource, ServletContext servletContext, @Symbol(value="com.orientimport.easyfckeditor.fckeditor-context") String location, @Symbol(value="tapestry.version") String t5Version, @Symbol(value="tapestry.application-version") String applicationVersion) {
        this.logger = logger;
        this.savedConfigurations = new ConcurrentHashMap<String, String>();
        String applCtx = "";
        try {
            applCtx = symbolSource.valueForSymbol("com.orientimport.easyfckeditor.application-context");
        }
        catch (RuntimeException re) {
            try {
                String context = servletContext.getContextPath();
                applCtx = context + "/";
            }
            catch (Throwable throwable) {
                applCtx = "/";
            }
        }
        this.applicationContext = applCtx;
        this.editorBasePath = Tapestry5VersionUtil.getTapestryVersion(t5Version) < 52 ? this.applicationContext + "assets/" + location + "/fckeditor/" : this.applicationContext + "assets/" + applicationVersion + "/" + location + "/fckeditor/";
        StringBuilder bldr = new StringBuilder();
        bldr.append("FCKConfig.ImageUploadURL='fckeditor';");
        bldr.append(NEW_LINE);
        bldr.append("FCKConfig.ImageBrowserURL='../filemanager/browser/default/browser.html?Type=Image&Connector=fckeditor';");
        bldr.append(NEW_LINE);
        bldr.append("FCKConfig.FlashUploadURL='fckeditor';");
        bldr.append(NEW_LINE);
        bldr.append("FCKConfig.FlashBrowserURL='../filemanager/browser/default/browser.html?Type=Flash&Connector=fckeditor';");
        bldr.append(NEW_LINE);
        bldr.append("FCKConfig.LinkUploadURL='fckeditor';");
        bldr.append(NEW_LINE);
        bldr.append("FCKConfig.LinkBrowserURL='../filemanager/browser/default/browser.html?Connector=fckeditor';");
        bldr.append(NEW_LINE);
        this.commonConfiguration = bldr.toString();
    }

    public String getEditorBasePath() {
        return this.editorBasePath;
    }

    public void persistEditorConfiguration(Asset asset) {
        String key = this.getEditorConfigurationKey(asset);
        if (!this.savedConfigurations.containsKey(key)) {
            this.savedConfigurations.put(key, this.getConfigurationAsString(asset));
        }
    }

    public void persistEditorConfiguration(Asset asset, String skinConfiguration) {
        String key = this.getEditorConfigurationKey(asset);
        if (!this.savedConfigurations.containsKey(key)) {
            String conf = this.getConfigurationAsString(asset);
            conf = conf + NEW_LINE;
            conf = conf + "FCKConfig.SkinPath = '";
            if (!this.applicationContext.equals("/")) {
                conf = conf + this.applicationContext.substring(0, this.applicationContext.length() - 1);
            }
            conf = conf + skinConfiguration + "';";
            this.savedConfigurations.put(key, conf);
        }
    }

    public String getEditorConfigurationKey(Asset asset) {
        return asset.getResource().getPath();
    }

    public String getEditorConfiguration(String configurationKey) {
        if (!this.savedConfigurations.containsKey(configurationKey)) {
            return "";
        }
        return this.savedConfigurations.get(configurationKey);
    }

    public String getApplicationContext() {
        return this.applicationContext;
    }

    private String getConfigurationAsString(Asset configuration) {
        String conf = this.parseResourceToString(configuration.getResource());
        String result = this.commonConfiguration + conf;
        return result;
    }

    private String parseResourceToString(Resource resource) {
        InputStream is = null;
        StringBuilder sb = new StringBuilder();
        try {
            is = resource.openStream();
            InputStreamReader r = new InputStreamReader(is);
            BufferedReader br = new BufferedReader(r);
            String line = null;
            while ((line = br.readLine()) != null) {
                sb.append(line);
                sb.append(NEW_LINE);
            }
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
        finally {
            try {
                is.close();
            }
            catch (Exception ex) {}
        }
        return sb.toString();
    }
}

