/*
 * Decompiled with CFR 0.152.
 */
package com.orientimport.easyfck.connector;

import com.orientimport.easyfck.services.FckEditorConnector;
import com.orientimport.easyfck.util.LegacyT5ServiceHelper;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletContext;
import net.fckeditor.connector.Connector;
import net.fckeditor.connector.exception.FolderAlreadyExistsException;
import net.fckeditor.connector.exception.InvalidCurrentFolderException;
import net.fckeditor.connector.exception.InvalidNewFolderNameException;
import net.fckeditor.connector.exception.ReadException;
import net.fckeditor.connector.exception.WriteException;
import net.fckeditor.connector.impl.LocalConnector;
import net.fckeditor.handlers.ResourceType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FckEditorConnectorBridge
implements Connector {
    private LocalConnector defaultImplementation;
    private FckEditorConnector editorConnector;

    public void createFolder(ResourceType type, String currentFolder, String newFolder) throws InvalidCurrentFolderException, InvalidNewFolderNameException, FolderAlreadyExistsException, WriteException {
        if (this.editorConnector != null) {
            this.editorConnector.createFolder(type, currentFolder, newFolder);
        } else {
            this.defaultImplementation.createFolder(type, currentFolder, newFolder);
        }
    }

    public String fileUpload(ResourceType type, String currentFolder, String fileName, InputStream inputStream) throws InvalidCurrentFolderException, WriteException {
        if (this.editorConnector != null) {
            return this.editorConnector.fileUpload(type, currentFolder, fileName, inputStream);
        }
        return this.defaultImplementation.fileUpload(type, currentFolder, fileName, inputStream);
    }

    public List<Map<String, Object>> getFiles(ResourceType type, String currentFolder) throws InvalidCurrentFolderException, ReadException {
        if (this.editorConnector != null) {
            return this.editorConnector.getFiles(type, currentFolder);
        }
        return this.defaultImplementation.getFiles(type, currentFolder);
    }

    public List<String> getFolders(ResourceType type, String currentFolder) throws InvalidCurrentFolderException, ReadException {
        if (this.editorConnector != null) {
            return this.editorConnector.getFolders(type, currentFolder);
        }
        return this.defaultImplementation.getFolders(type, currentFolder);
    }

    public void init(ServletContext servletContext) throws Exception {
        this.defaultImplementation = new LocalConnector();
        this.defaultImplementation.init(servletContext);
        this.editorConnector = LegacyT5ServiceHelper.getService(FckEditorConnector.class, servletContext);
    }
}

