/*
 * Decompiled with CFR 0.152.
 */
package com.mxgraph.swing.handler;

import com.mxgraph.model.mxGeometry;
import com.mxgraph.model.mxIGraphModel;
import com.mxgraph.swing.handler.mxCellMarker;
import com.mxgraph.swing.handler.mxConnectPreview;
import com.mxgraph.swing.mxGraphComponent;
import com.mxgraph.swing.util.mxMouseAdapter;
import com.mxgraph.util.mxConstants;
import com.mxgraph.util.mxEventObject;
import com.mxgraph.util.mxEventSource;
import com.mxgraph.util.mxPoint;
import com.mxgraph.util.mxRectangle;
import com.mxgraph.view.mxCellState;
import com.mxgraph.view.mxGraph;
import com.mxgraph.view.mxGraphView;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.ImageIcon;
import javax.swing.JOptionPane;

public class mxConnectionHandler
extends mxMouseAdapter {
    private static final long serialVersionUID = -2543899557644889853L;
    public static Cursor CONNECT_CURSOR = new Cursor(12);
    protected mxGraphComponent graphComponent;
    protected mxEventSource eventSource = new mxEventSource(this);
    protected mxConnectPreview connectPreview;
    protected ImageIcon connectIcon = null;
    protected int handleSize = mxConstants.CONNECT_HANDLE_SIZE;
    protected boolean handleEnabled = mxConstants.CONNECT_HANDLE_ENABLED;
    protected boolean select = true;
    protected boolean createTarget = false;
    protected boolean keepOnTop = true;
    protected boolean enabled = true;
    protected transient Point first;
    protected transient Rectangle bounds;
    protected transient mxCellState source;
    protected transient mxCellMarker marker;
    protected transient String error;
    protected transient mxEventSource.mxIEventListener resetHandler = new mxEventSource.mxIEventListener(){

        @Override
        public void invoke(Object object, mxEventObject mxEventObject2) {
            mxConnectionHandler.this.reset();
        }
    };

    public mxConnectionHandler(mxGraphComponent mxGraphComponent2) {
        this.graphComponent = mxGraphComponent2;
        mxGraphComponent2.addListener("afterPaint", new mxEventSource.mxIEventListener(){

            @Override
            public void invoke(Object object, mxEventObject mxEventObject2) {
                Graphics graphics = (Graphics)mxEventObject2.getProperty("g");
                mxConnectionHandler.this.paint(graphics);
            }
        });
        this.connectPreview = this.createConnectPreview();
        mxGraphComponent.mxGraphControl mxGraphControl2 = mxGraphComponent2.getGraphControl();
        mxGraphControl2.addMouseListener(this);
        mxGraphControl2.addMouseMotionListener(this);
        this.addGraphListeners(mxGraphComponent2.getGraph());
        mxGraphComponent2.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if (propertyChangeEvent.getPropertyName().equals("graph")) {
                    mxConnectionHandler.this.removeGraphListeners((mxGraph)propertyChangeEvent.getOldValue());
                    mxConnectionHandler.this.addGraphListeners((mxGraph)propertyChangeEvent.getNewValue());
                }
            }
        });
        this.marker = new mxCellMarker(mxGraphComponent2){
            private static final long serialVersionUID = 103433247310526381L;

            @Override
            protected Object getCell(MouseEvent mouseEvent) {
                Object object = super.getCell(mouseEvent);
                if (mxConnectionHandler.this.isConnecting()) {
                    if (mxConnectionHandler.this.source != null) {
                        mxConnectionHandler.this.error = mxConnectionHandler.this.validateConnection(mxConnectionHandler.this.source.getCell(), object);
                        if (mxConnectionHandler.this.error != null && mxConnectionHandler.this.error.length() == 0) {
                            object = null;
                            if (mxConnectionHandler.this.createTarget) {
                                mxConnectionHandler.this.error = null;
                            }
                        }
                    }
                } else if (!mxConnectionHandler.this.isValidSource(object)) {
                    object = null;
                }
                return object;
            }

            @Override
            protected boolean isValidState(mxCellState mxCellState2) {
                if (mxConnectionHandler.this.isConnecting()) {
                    return mxConnectionHandler.this.error == null;
                }
                return super.isValidState(mxCellState2);
            }

            @Override
            protected Color getMarkerColor(MouseEvent mouseEvent, mxCellState mxCellState2, boolean bl) {
                return mxConnectionHandler.this.isHighlighting() || mxConnectionHandler.this.isConnecting() ? super.getMarkerColor(mouseEvent, mxCellState2, bl) : null;
            }

            @Override
            protected boolean intersects(mxCellState mxCellState2, MouseEvent mouseEvent) {
                if (!mxConnectionHandler.this.isHighlighting() || mxConnectionHandler.this.isConnecting()) {
                    return true;
                }
                return super.intersects(mxCellState2, mouseEvent);
            }
        };
        this.marker.setHotspotEnabled(true);
    }

    protected void addGraphListeners(mxGraph mxGraph2) {
        if (mxGraph2 != null) {
            mxGraphView mxGraphView2 = mxGraph2.getView();
            mxGraphView2.addListener("scale", this.resetHandler);
            mxGraphView2.addListener("translate", this.resetHandler);
            mxGraphView2.addListener("scaleAndTranslate", this.resetHandler);
            mxGraph2.getModel().addListener("change", this.resetHandler);
        }
    }

    protected void removeGraphListeners(mxGraph mxGraph2) {
        if (mxGraph2 != null) {
            mxGraphView mxGraphView2 = mxGraph2.getView();
            mxGraphView2.removeListener(this.resetHandler, "scale");
            mxGraphView2.removeListener(this.resetHandler, "translate");
            mxGraphView2.removeListener(this.resetHandler, "scaleAndTranslate");
            mxGraph2.getModel().removeListener(this.resetHandler, "change");
        }
    }

    protected mxConnectPreview createConnectPreview() {
        return new mxConnectPreview(this.graphComponent);
    }

    public mxConnectPreview getConnectPreview() {
        return this.connectPreview;
    }

    public void setConnectPreview(mxConnectPreview mxConnectPreview2) {
        this.connectPreview = mxConnectPreview2;
    }

    public boolean isConnecting() {
        return this.connectPreview.isActive();
    }

    public boolean isHighlighting() {
        return this.connectIcon == null && !this.handleEnabled;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean bl) {
        this.enabled = bl;
    }

    public boolean isKeepOnTop() {
        return this.keepOnTop;
    }

    public void setKeepOnTop(boolean bl) {
        this.keepOnTop = bl;
    }

    public void setConnectIcon(ImageIcon imageIcon) {
        this.connectIcon = imageIcon;
    }

    public ImageIcon getConnecIcon() {
        return this.connectIcon;
    }

    public void setHandleEnabled(boolean bl) {
        this.handleEnabled = bl;
    }

    public boolean isHandleEnabled() {
        return this.handleEnabled;
    }

    public void setHandleSize(int n) {
        this.handleSize = n;
    }

    public int getHandleSize() {
        return this.handleSize;
    }

    public mxCellMarker getMarker() {
        return this.marker;
    }

    public void setMarker(mxCellMarker mxCellMarker2) {
        this.marker = mxCellMarker2;
    }

    public void setCreateTarget(boolean bl) {
        this.createTarget = bl;
    }

    public boolean isCreateTarget() {
        return this.createTarget;
    }

    public void setSelect(boolean bl) {
        this.select = bl;
    }

    public boolean isSelect() {
        return this.select;
    }

    public void reset() {
        this.connectPreview.stop(false);
        this.setBounds(null);
        this.marker.reset();
        this.source = null;
        this.first = null;
        this.error = null;
    }

    public Object createTargetVertex(MouseEvent mouseEvent, Object object) {
        mxGraph mxGraph2 = this.graphComponent.getGraph();
        Object object2 = mxGraph2.cloneCells(new Object[]{object})[0];
        mxIGraphModel mxIGraphModel2 = mxGraph2.getModel();
        mxGeometry mxGeometry2 = mxIGraphModel2.getGeometry(object2);
        if (mxGeometry2 != null) {
            mxPoint mxPoint2 = this.graphComponent.getPointForEvent(mouseEvent);
            mxGeometry2.setX(mxGraph2.snap(mxPoint2.getX() - mxGeometry2.getWidth() / 2.0));
            mxGeometry2.setY(mxGraph2.snap(mxPoint2.getY() - mxGeometry2.getHeight() / 2.0));
        }
        return object2;
    }

    public boolean isValidSource(Object object) {
        return this.graphComponent.getGraph().isValidSource(object);
    }

    public boolean isValidTarget(Object object) {
        return true;
    }

    public String validateConnection(Object object, Object object2) {
        if (object2 == null && this.createTarget) {
            return null;
        }
        if (!this.isValidTarget(object2)) {
            return "";
        }
        return this.graphComponent.getGraph().getEdgeValidationError(this.connectPreview.getPreviewState().getCell(), object, object2);
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        if (!this.graphComponent.isForceMarqueeEvent(mouseEvent) && !this.graphComponent.isPanningEvent(mouseEvent) && !mouseEvent.isPopupTrigger() && this.graphComponent.isEnabled() && this.isEnabled() && !mouseEvent.isConsumed() && (this.isHighlighting() && this.marker.hasValidState() || !this.isHighlighting() && this.bounds != null && this.bounds.contains(mouseEvent.getPoint()))) {
            this.start(mouseEvent, this.marker.getValidState());
            mouseEvent.consume();
        }
    }

    public void start(MouseEvent mouseEvent, mxCellState mxCellState2) {
        this.first = mouseEvent.getPoint();
        this.connectPreview.start(mouseEvent, mxCellState2, "");
    }

    @Override
    public void mouseMoved(MouseEvent mouseEvent) {
        this.mouseDragged(mouseEvent);
        if (this.isHighlighting() && !this.marker.hasValidState()) {
            this.source = null;
        }
        if (!this.isHighlighting() && this.source != null) {
            int n = this.handleSize;
            int n2 = this.handleSize;
            if (this.connectIcon != null) {
                n = this.connectIcon.getIconWidth();
                n2 = this.connectIcon.getIconHeight();
            }
            int n3 = (int)this.source.getCenterX() - n / 2;
            int n4 = (int)this.source.getCenterY() - n2 / 2;
            if (this.graphComponent.getGraph().isSwimlane(this.source.getCell())) {
                mxRectangle mxRectangle2 = this.graphComponent.getGraph().getStartSize(this.source.getCell());
                if (mxRectangle2.getWidth() > 0.0) {
                    n3 = (int)(this.source.getX() + mxRectangle2.getWidth() / 2.0 - (double)(n / 2));
                } else {
                    n4 = (int)(this.source.getY() + mxRectangle2.getHeight() / 2.0 - (double)(n2 / 2));
                }
            }
            this.setBounds(new Rectangle(n3, n4, n, n2));
        } else {
            this.setBounds(null);
        }
        if (this.source != null && (this.bounds == null || this.bounds.contains(mouseEvent.getPoint()))) {
            this.graphComponent.getGraphControl().setCursor(CONNECT_CURSOR);
            mouseEvent.consume();
        }
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
        if (!mouseEvent.isConsumed() && this.graphComponent.isEnabled() && this.isEnabled() && (mouseEvent.getButton() == 0 || this.connectPreview.isActive())) {
            mxCellState mxCellState2 = this.marker.process(mouseEvent);
            if (this.connectPreview.isActive()) {
                this.connectPreview.update(mouseEvent, this.marker.getValidState(), mouseEvent.getX(), mouseEvent.getY());
                this.setBounds(null);
                mouseEvent.consume();
            } else {
                this.source = mxCellState2;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        if (this.error != null) {
            if (this.error.length() > 0) {
                JOptionPane.showMessageDialog(this.graphComponent, this.error);
            }
        } else if (this.first != null) {
            mxGraph mxGraph2 = this.graphComponent.getGraph();
            double d = this.first.getX() - (double)mouseEvent.getX();
            double d2 = this.first.getY() - (double)mouseEvent.getY();
            if (this.connectPreview.isActive() && (this.marker.hasValidState() || this.isCreateTarget() || mxGraph2.isAllowDanglingEdges())) {
                mxGraph2.getModel().beginUpdate();
                try {
                    Object object;
                    Object object2 = null;
                    if (!this.marker.hasValidState() && this.isCreateTarget()) {
                        mxCellState mxCellState2;
                        object = this.createTargetVertex(mouseEvent, this.source.getCell());
                        object2 = mxGraph2.getDropTarget(new Object[]{object}, mouseEvent.getPoint(), this.graphComponent.getCellAt(mouseEvent.getX(), mouseEvent.getY()));
                        if (object != null) {
                            if (object2 == null || !mxGraph2.getModel().isEdge(object2)) {
                                mxCellState2 = mxGraph2.getView().getState(object2);
                                if (mxCellState2 != null) {
                                    mxGeometry mxGeometry2 = mxGraph2.getModel().getGeometry(object);
                                    mxPoint mxPoint2 = mxCellState2.getOrigin();
                                    mxGeometry2.setX(mxGeometry2.getX() - mxPoint2.getX());
                                    mxGeometry2.setY(mxGeometry2.getY() - mxPoint2.getY());
                                }
                            } else {
                                object2 = mxGraph2.getDefaultParent();
                            }
                            mxGraph2.addCells(new Object[]{object}, object2);
                        }
                        mxCellState2 = mxGraph2.getView().getState(object, true);
                        this.connectPreview.update(mouseEvent, mxCellState2, mouseEvent.getX(), mouseEvent.getY());
                    }
                    if ((object = this.connectPreview.stop(this.graphComponent.isSignificant(d, d2), mouseEvent)) != null) {
                        this.graphComponent.getGraph().setSelectionCell(object);
                        this.eventSource.fireEvent(new mxEventObject("connect", "cell", object, "event", mouseEvent, "target", object2));
                    }
                    mouseEvent.consume();
                }
                finally {
                    mxGraph2.getModel().endUpdate();
                }
            }
        }
        this.reset();
    }

    public void setBounds(Rectangle rectangle) {
        if (this.bounds == null && rectangle != null || this.bounds != null && rectangle == null || this.bounds != null && rectangle != null && !this.bounds.equals(rectangle)) {
            Rectangle rectangle2 = this.bounds;
            if (rectangle2 != null) {
                if (rectangle != null) {
                    rectangle2.add(rectangle);
                }
            } else {
                rectangle2 = rectangle;
            }
            this.bounds = rectangle;
            if (rectangle2 != null) {
                this.graphComponent.getGraphControl().repaint(rectangle2);
            }
        }
    }

    public void addListener(String string, mxEventSource.mxIEventListener mxIEventListener2) {
        this.eventSource.addListener(string, mxIEventListener2);
    }

    public void removeListener(mxEventSource.mxIEventListener mxIEventListener2) {
        this.eventSource.removeListener(mxIEventListener2);
    }

    public void removeListener(mxEventSource.mxIEventListener mxIEventListener2, String string) {
        this.eventSource.removeListener(mxIEventListener2, string);
    }

    public void paint(Graphics graphics) {
        if (this.bounds != null) {
            if (this.connectIcon != null) {
                graphics.drawImage(this.connectIcon.getImage(), this.bounds.x, this.bounds.y, this.bounds.width, this.bounds.height, null);
            } else if (this.handleEnabled) {
                graphics.setColor(Color.BLACK);
                graphics.draw3DRect(this.bounds.x, this.bounds.y, this.bounds.width - 1, this.bounds.height - 1, true);
                graphics.setColor(Color.GREEN);
                graphics.fill3DRect(this.bounds.x + 1, this.bounds.y + 1, this.bounds.width - 2, this.bounds.height - 2, true);
                graphics.setColor(Color.BLUE);
                graphics.drawRect(this.bounds.x + this.bounds.width / 2 - 1, this.bounds.y + this.bounds.height / 2 - 1, 1, 1);
            }
        }
    }
}

