/*
 * Decompiled with CFR 0.152.
 */
package com.formos.tapestry.testify.internal;

import com.formos.tapestry.testify.internal.PerTestDataStore;
import com.formos.tapestry.testify.internal.PerTestServiceCreator;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import org.apache.tapestry5.ioc.ObjectCreator;
import org.apache.tapestry5.ioc.ServiceLifecycle;
import org.apache.tapestry5.ioc.ServiceResources;
import org.apache.tapestry5.ioc.services.Builtin;
import org.apache.tapestry5.ioc.services.ClassFab;
import org.apache.tapestry5.ioc.services.ClassFactory;
import org.apache.tapestry5.ioc.services.MethodSignature;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PerTestServiceLifecycle
implements ServiceLifecycle {
    private static final String PER_TEST_METHOD_NAME = "_perTestInstance";
    private final PerTestDataStore perTestManager;
    private final ClassFactory classFactory;

    public PerTestServiceLifecycle(@Builtin PerTestDataStore perTestManager, @Builtin ClassFactory classFactory) {
        this.perTestManager = perTestManager;
        this.classFactory = classFactory;
    }

    public boolean isSingleton() {
        return false;
    }

    public Object createService(ServiceResources resources, ObjectCreator creator) {
        Class<?> proxyClass = this.createProxyClass(resources);
        PerTestServiceCreator perTestCreator = new PerTestServiceCreator(this.perTestManager, creator);
        try {
            Constructor<?> ctor = proxyClass.getConstructors()[0];
            return ctor.newInstance(perTestCreator);
        }
        catch (InvocationTargetException ex) {
            throw new RuntimeException(ex.getCause());
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    private Class<?> createProxyClass(ServiceResources resources) {
        Class serviceInterface = resources.getServiceInterface();
        ClassFab cf = this.classFactory.newClass(serviceInterface);
        cf.addField("_creator", 18, ObjectCreator.class);
        cf.addConstructor(new Class[]{ObjectCreator.class}, null, "_creator = $1;");
        String body = String.format("return (%s) _creator.createObject();", serviceInterface.getName());
        MethodSignature sig = new MethodSignature(serviceInterface, PER_TEST_METHOD_NAME, null, null);
        cf.addMethod(2, sig, body);
        String toString = String.format("<PerTest Proxy for %s(%s)>", resources.getServiceId(), serviceInterface.getName());
        cf.proxyMethodsToDelegate(serviceInterface, "_perTestInstance()", toString);
        return cf.createClass();
    }
}

