/*
 * Decompiled with CFR 0.152.
 */
package com.formos.tapestry.testify.internal;

import com.formos.tapestry.testify.internal.ObjectsForComponentsStore;
import java.lang.annotation.Annotation;
import org.apache.tapestry5.annotations.Service;
import org.apache.tapestry5.ioc.AnnotationProvider;
import org.apache.tapestry5.ioc.ObjectLocator;
import org.apache.tapestry5.ioc.annotations.Inject;
import org.apache.tapestry5.ioc.annotations.Symbol;
import org.apache.tapestry5.ioc.annotations.Value;
import org.apache.tapestry5.ioc.services.FieldValueConduit;
import org.apache.tapestry5.ioc.services.MasterObjectProvider;
import org.apache.tapestry5.model.MutableComponentModel;
import org.apache.tapestry5.services.ClassTransformation;
import org.apache.tapestry5.services.InjectionProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ForComponentsInjectionProvider
implements InjectionProvider {
    private final ObjectsForComponentsStore objectStore;
    private final MasterObjectProvider masterObjectProvider;
    private final ObjectLocator locator;

    public ForComponentsInjectionProvider(MasterObjectProvider masterObjectProvider, ObjectLocator locator, ObjectsForComponentsStore objectStore) {
        assert (objectStore != null);
        assert (masterObjectProvider != null);
        assert (locator != null);
        this.objectStore = objectStore;
        this.masterObjectProvider = masterObjectProvider;
        this.locator = locator;
    }

    public boolean provideInjection(String fieldName, final Class fieldType, ObjectLocator locator, ClassTransformation transformation, MutableComponentModel componentModel) {
        if (ForComponentsInjectionProvider.canHandle(fieldName, transformation)) {
            Service service = (Service)transformation.getField(fieldName).getAnnotation(Service.class);
            final String serviceId = service == null ? "" : service.value();
            final Object valueInjectedByTapestry = this.findTapestrysInjectedValue(fieldName, fieldType, transformation);
            transformation.getField(fieldName).replaceAccess(new FieldValueConduit(){

                public void set(Object newValue) {
                    throw new RuntimeException("Field is read-only");
                }

                public Object get() {
                    Object testDouble = ForComponentsInjectionProvider.this.objectStore.get(fieldType, serviceId);
                    return testDouble == null ? valueInjectedByTapestry : testDouble;
                }
            });
            return true;
        }
        return false;
    }

    public static boolean canHandle(String fieldName, ClassTransformation transformation) {
        return transformation.getField(fieldName).getAnnotation(Inject.class) != null && transformation.getField(fieldName).getAnnotation(Symbol.class) == null && transformation.getField(fieldName).getAnnotation(Value.class) == null;
    }

    private Object findTapestrysInjectedValue(final String fieldName, Class<?> fieldType, final ClassTransformation transformation) {
        try {
            AnnotationProvider annotationProvider = new AnnotationProvider(){

                public <T extends Annotation> T getAnnotation(Class<T> annotationClass) {
                    return (T)transformation.getField(fieldName).getAnnotation(annotationClass);
                }
            };
            Object result = this.masterObjectProvider.provide(fieldType, annotationProvider, this.locator, false);
            if (result == null) {
                result = this.locator.getService(fieldType);
            }
            return result;
        }
        catch (RuntimeException e) {
            return null;
        }
    }
}

