/*
 * Decompiled with CFR 0.152.
 */
package com.formos.tapestry.testify.core;

import com.formos.tapestry.testify.core.ForComponents;
import com.formos.tapestry.testify.internal.AccessObjectFromField;
import com.formos.tapestry.testify.internal.ObjectsForComponentsStore;
import com.formos.tapestry.testify.internal.PerTestDataStore;
import com.formos.tapestry.testify.internal.TestifyModule;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import org.apache.tapestry5.internal.test.TestableRequest;
import org.apache.tapestry5.internal.test.TestableResponse;
import org.apache.tapestry5.ioc.AnnotationProvider;
import org.apache.tapestry5.ioc.Registry;
import org.apache.tapestry5.ioc.annotations.Inject;
import org.apache.tapestry5.ioc.internal.services.AccessableObjectAnnotationProvider;
import org.apache.tapestry5.services.Request;
import org.apache.tapestry5.services.RequestHandler;
import org.apache.tapestry5.services.Response;
import org.apache.tapestry5.services.Session;
import org.apache.tapestry5.test.PageTester;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TapestryTester
extends PageTester {
    private final TestableRequest request;
    private final TestableResponse response;
    private final RequestHandler requestHandler;

    public TapestryTester(String appPackage, String appName, String contextPath, Class<?> ... moduleClasses) {
        super(appPackage, appName, contextPath, (Class[])TapestryTester.addTestify(moduleClasses));
        Registry registry = this.getRegistry();
        this.request = (TestableRequest)registry.getService(TestableRequest.class);
        this.response = (TestableResponse)registry.getService(TestableResponse.class);
        this.requestHandler = (RequestHandler)registry.getService("RequestHandler", RequestHandler.class);
    }

    public TapestryTester(String appPackage, Class<?> ... moduleClasses) {
        this(appPackage, "app", "src/main/webapp", moduleClasses);
    }

    private static Class<?>[] addTestify(Class<?>[] moduleClasses) {
        Class[] result = new Class[moduleClasses.length + 1];
        result[0] = TestifyModule.class;
        System.arraycopy(moduleClasses, 0, result, 1, moduleClasses.length);
        return result;
    }

    public <T> T getService(String id, Class<T> serviceInterface) {
        assert (id != null);
        assert (serviceInterface != null);
        return (T)this.getRegistry().getService(id, serviceInterface);
    }

    public <T> T autobuild(Class<T> clazz) {
        return (T)this.getRegistry().autobuild(clazz);
    }

    public void endTest() {
        ((PerTestDataStore)this.getService(PerTestDataStore.class)).cleanup();
        this.clearSession();
    }

    private void clearSession() {
        Session session = this.request.getSession(false);
        if (session != null) {
            for (String name : session.getAttributeNames()) {
                session.setAttribute(name, null);
            }
        }
    }

    public void injectInto(Object object) {
        assert (object != null);
        this.processFieldsAnnotatedWith(object, Inject.class, new FieldInjector());
    }

    public void collectForComponentsFrom(Object object) {
        assert (object != null);
        this.processFieldsAnnotatedWith(object, ForComponents.class, new TestObjectCollector());
    }

    public TestableResponse renderResponse(String path) {
        assert (path.startsWith("/"));
        try {
            this.request.clear().setPath(path);
            this.response.clear();
            boolean handled = this.requestHandler.service((Request)this.request, (Response)this.response);
            if (!handled) {
                throw new RuntimeException(String.format("Request was not handled: '%s' may not be a valid path.", path));
            }
            return this.response;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void processFieldsAnnotatedWith(Object object, Class<? extends Annotation> annotation, FieldProcessor processor) {
        Class<?> asType = object.getClass();
        while (!asType.equals(Object.class)) {
            for (Field field : asType.getDeclaredFields()) {
                if (field.getAnnotation(annotation) == null) continue;
                this.processField(object, processor, field);
            }
            asType = asType.getSuperclass();
        }
    }

    private void processField(Object object, FieldProcessor processor, Field field) {
        try {
            field.setAccessible(true);
            processor.process(object, field);
        }
        catch (IllegalArgumentException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    private class TestObjectCollector
    implements FieldProcessor {
        private TestObjectCollector() {
        }

        public void process(Object object, Field field) {
            AccessObjectFromField accessor = new AccessObjectFromField(object, field);
            String id = field.getAnnotation(ForComponents.class).value();
            ((ObjectsForComponentsStore)TapestryTester.this.getService(ObjectsForComponentsStore.class)).put(accessor, id);
        }
    }

    private final class FieldInjector
    implements FieldProcessor {
        private FieldInjector() {
        }

        public void process(Object object, Field field) throws IllegalArgumentException, IllegalAccessException {
            Class<?> type = field.getType();
            Object value = TapestryTester.this.getRegistry().getObject(type, (AnnotationProvider)new AccessableObjectAnnotationProvider((AccessibleObject)field));
            field.set(object, value);
        }
    }

    private static interface FieldProcessor {
        public void process(Object var1, Field var2) throws IllegalAccessException;
    }
}

