package com.formos.tapestry.testify.internal;

import org.apache.tapestry5.internal.services.DefaultInjectionProvider;
import org.apache.tapestry5.ioc.ObjectLocator;
import org.apache.tapestry5.ioc.services.MasterObjectProvider;
import org.apache.tapestry5.model.MutableComponentModel;
import org.apache.tapestry5.services.ClassTransformation;
import org.apache.tapestry5.services.InjectionProvider;

/**
 * An {@link InjectionProvider} that replaces the usual default provider.
 */
public class TestifyDefaultInjectionProvider implements InjectionProvider {
    private final DefaultInjectionProvider defaultInjectionProvider;

    public TestifyDefaultInjectionProvider(MasterObjectProvider masterObjectProvider, ObjectLocator locator) {
        defaultInjectionProvider = new DefaultInjectionProvider(masterObjectProvider, locator);
    }
    
    @SuppressWarnings("unchecked")
    public boolean provideInjection(String fieldName, Class fieldType, ObjectLocator locator, ClassTransformation transformation, MutableComponentModel componentModel) {
        if (ForComponentsInjectionProvider.canHandle(fieldName, transformation)) {
            return false;            
        } else {
            return defaultInjectionProvider.provideInjection(fieldName, fieldType, locator, transformation, componentModel);
        }
    }

}
