package com.formos.tapestry.testify.internal;

import org.apache.tapestry5.annotations.Service;
import org.apache.tapestry5.internal.services.CommonResourcesInjectionProvider;
import org.apache.tapestry5.ioc.ObjectLocator;
import org.apache.tapestry5.model.MutableComponentModel;
import org.apache.tapestry5.services.ClassTransformation;

public class TestifyCommonResourcesInjectionProvider extends CommonResourcesInjectionProvider {

    @SuppressWarnings("unchecked")
    @Override
    public boolean provideInjection(String fieldName, Class fieldType, ObjectLocator locator, ClassTransformation transformation, MutableComponentModel componentModel) {
        if (transformation.getField(fieldName).getAnnotation(Service.class) != null) {
            return false;
        } else {
            return super.provideInjection(fieldName, fieldType, locator, transformation, componentModel);
        }
    }

}
