package com.formos.tapestry.testify.internal;

import java.lang.annotation.Annotation;

import org.apache.tapestry5.annotations.Service;
import org.apache.tapestry5.ioc.AnnotationProvider;
import org.apache.tapestry5.ioc.ObjectLocator;
import org.apache.tapestry5.ioc.annotations.Inject;
import org.apache.tapestry5.ioc.annotations.Symbol;
import org.apache.tapestry5.ioc.annotations.Value;
import org.apache.tapestry5.ioc.services.FieldValueConduit;
import org.apache.tapestry5.ioc.services.MasterObjectProvider;
import org.apache.tapestry5.model.MutableComponentModel;
import org.apache.tapestry5.services.ClassTransformation;
import org.apache.tapestry5.services.InjectionProvider;

public class ForComponentsInjectionProvider implements InjectionProvider {
    private final ObjectsForComponentsStore objectStore;
    private final MasterObjectProvider masterObjectProvider;
    private final ObjectLocator locator;


    public ForComponentsInjectionProvider(
            MasterObjectProvider masterObjectProvider, ObjectLocator locator,
            ObjectsForComponentsStore objectStore) {
        assert objectStore != null;
        assert masterObjectProvider != null;
        assert locator != null;

        this.objectStore = objectStore;
        this.masterObjectProvider = masterObjectProvider;
        this.locator = locator;
    }


    @SuppressWarnings("unchecked")
    public boolean provideInjection(String fieldName, final Class fieldType, ObjectLocator locator, ClassTransformation transformation, MutableComponentModel componentModel) {
        if (canHandle(fieldName, transformation)) {
            Service service = transformation.getField(fieldName).getAnnotation(Service.class);
            final String serviceId = service == null ? ObjectsForComponentsStore.NO_ID : service.value();
            final Object valueInjectedByTapestry = findTapestrysInjectedValue(fieldName, fieldType, transformation);
                        
            transformation.getField(fieldName).replaceAccess(new FieldValueConduit() {                
                public void set(Object newValue) {
                    throw new RuntimeException("Field is read-only");                    
                }
                
                public Object get() {
                    Object testDouble = objectStore.get(fieldType, serviceId);
                    return testDouble == null ? valueInjectedByTapestry : testDouble;
                }
            });
            return true;
        }
        return false;
    }


    public static boolean canHandle(String fieldName, ClassTransformation transformation) {
        return transformation.getField(fieldName).getAnnotation(Inject.class) != null &&
               transformation.getField(fieldName).getAnnotation(Symbol.class) == null &&
               transformation.getField(fieldName).getAnnotation(Value.class) == null;
    }


    private Object findTapestrysInjectedValue(final String fieldName, Class<?> fieldType, final ClassTransformation transformation) {
        try {
            AnnotationProvider annotationProvider = new AnnotationProvider() {
                public <T extends Annotation> T getAnnotation(Class<T> annotationClass) {
                    return transformation.getField(fieldName).getAnnotation(annotationClass);
                }
            };


            Object result = masterObjectProvider.provide(fieldType, annotationProvider, this.locator, false);
            if (result == null) {
                result = this.locator.getService(fieldType);
            }
            return result;
        } catch (RuntimeException e) {
            // We get this exception if we try to find a service that does not exist
            return null;
        }
    }
}
