/*
 * Decompiled with CFR 0.152.
 */
package com.formos.tapestry.testify.internal;

import com.formos.tapestry.testify.internal.ObjectsForComponentsStore;
import java.lang.annotation.Annotation;
import org.apache.tapestry5.annotations.Service;
import org.apache.tapestry5.ioc.AnnotationProvider;
import org.apache.tapestry5.ioc.ObjectLocator;
import org.apache.tapestry5.ioc.annotations.Inject;
import org.apache.tapestry5.ioc.annotations.Symbol;
import org.apache.tapestry5.ioc.annotations.Value;
import org.apache.tapestry5.ioc.services.MasterObjectProvider;
import org.apache.tapestry5.model.MutableComponentModel;
import org.apache.tapestry5.services.ClassTransformation;
import org.apache.tapestry5.services.InjectionProvider;
import org.apache.tapestry5.services.TransformMethodSignature;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ForComponentsInjectionProvider
implements InjectionProvider {
    private final ObjectsForComponentsStore objectStore;
    private final MasterObjectProvider masterObjectProvider;
    private final ObjectLocator locator;

    public ForComponentsInjectionProvider(MasterObjectProvider masterObjectProvider, ObjectLocator locator, ObjectsForComponentsStore objectStore) {
        assert (objectStore != null);
        assert (masterObjectProvider != null);
        assert (locator != null);
        this.objectStore = objectStore;
        this.masterObjectProvider = masterObjectProvider;
        this.locator = locator;
    }

    public boolean provideInjection(String fieldName, Class fieldType, ObjectLocator locator, ClassTransformation transformation, MutableComponentModel componentModel) {
        if (ForComponentsInjectionProvider.canHandle(fieldName, transformation)) {
            String body;
            Service service = (Service)transformation.getFieldAnnotation(fieldName, Service.class);
            String serviceId = service == null ? "" : service.value();
            String objectStoreField = transformation.addInjectedField(ObjectsForComponentsStore.class, "testObjectStore", (Object)this.objectStore);
            String fieldTypeName = fieldType.getName();
            Object inject = this.findRealInjectedValue(fieldName, fieldType, transformation);
            if (inject == null) {
                body = String.format("{ return (%s)%s.get(%s.class, \"%s\"); }", fieldTypeName, objectStoreField, fieldTypeName, serviceId);
            } else {
                String nonTestFieldName = transformation.addInjectedField(fieldType, "nonTest" + fieldName, inject);
                body = String.format("{ Object testDouble = %s.get(%s.class, \"%s\");\n  return testDouble == null ? %s : (%s)testDouble;}", objectStoreField, fieldTypeName, serviceId, nonTestFieldName, fieldTypeName);
            }
            String testifyGetterMethod = "testifyGet" + fieldName;
            TransformMethodSignature sig = new TransformMethodSignature(2, fieldTypeName, testifyGetterMethod, null, null);
            transformation.addMethod(sig, body);
            transformation.replaceReadAccess(fieldName, testifyGetterMethod);
            return true;
        }
        return false;
    }

    public static boolean canHandle(String fieldName, ClassTransformation transformation) {
        return transformation.getFieldAnnotation(fieldName, Inject.class) != null && transformation.getFieldAnnotation(fieldName, Symbol.class) == null && transformation.getFieldAnnotation(fieldName, Value.class) == null;
    }

    private Object findRealInjectedValue(final String fieldName, Class<?> fieldType, final ClassTransformation transformation) {
        try {
            AnnotationProvider annotationProvider = new AnnotationProvider(){

                public <T extends Annotation> T getAnnotation(Class<T> annotationClass) {
                    return (T)transformation.getFieldAnnotation(fieldName, annotationClass);
                }
            };
            Object result = this.masterObjectProvider.provide(fieldType, annotationProvider, this.locator, false);
            if (result == null) {
                result = this.locator.getService(fieldType);
            }
            return result;
        }
        catch (RuntimeException e) {
            return null;
        }
    }
}

