package com.formos.tapestry.testify.internal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import com.formos.tapestry.testify.core.ForComponents;

/**
 * Simple implementation of {@link ObjectsForComponentsStore}.
 */
public class SimpleObjectsForComponentsStore implements ObjectsForComponentsStore {

    private final Map<String, ObjectAccessor> accessorsById = new HashMap<String, ObjectAccessor>();
    private final Collection<ObjectAccessor> accessors = new ArrayList<ObjectAccessor>();

    public void put(ObjectAccessor objectAccessor, String id) {
        if (!NO_ID.equals(id)) {
            accessorsById.put(id, objectAccessor);
        }
        accessors.add(objectAccessor);
    }


    public <T> T get(Class<T> type, String id) {
        if (NO_ID.equals(id)) {
            return getByType(type);
        } else {
            ObjectAccessor accessor = accessorsById.get(id);
            return accessor == null ? null : type.cast(accessor.get());
        }
    }


	private <T> T getByType(Class<T> type) {
		List<T> candidates = new ArrayList<T>(1);
		for (ObjectAccessor accessor : accessors) {
			Object object = accessor.get();
		    if (type.isInstance(object)) {
		        candidates.add(type.cast(object));
		    }
		}
		if (candidates.size() > 1) {
		    throw new RuntimeException("Found more than one object marked as @"+ForComponents.class.getSimpleName()+" of type " + type.getName());
		}
		return candidates.isEmpty() ? null : candidates.get(0);
	}

}
