package com.formos.tapestry.testify.internal;

import org.apache.tapestry5.ioc.ObjectCreator;

import com.formos.tapestry.testify.core.TestifyConstants;

/**
 * Creates services with a {@link TestifyConstants#PERTEST} scope.
 */
public class PerTestServiceCreator implements ObjectCreator {
    private final PerTestDataStore perTestDataStore;
    private final ObjectCreator delegate;


    public PerTestServiceCreator(PerTestDataStore perTestDataStore, ObjectCreator delegate) {
        this.perTestDataStore = perTestDataStore;
        this.delegate = delegate;
    }


    /**
     * For each test, the first call will use the delegate {@link org.apache.tapestry5.ioc.ObjectCreator}
     * to create an instance, and later calls will reuse the same per-test instance. The instance is
     * stored in the {@link PerTestDataStore} and will be released at the end of the test.
     */
    public Object createObject() {
        // Use the ObjectCreator instance as the key. it will be unique.

        Object perTestInstance = perTestDataStore.get(delegate);

        if (perTestInstance == null) {
            perTestInstance = delegate.createObject();
            perTestDataStore.put(delegate, perTestInstance);
        }

        return perTestInstance;
    }
}
