/*
 * Decompiled with CFR 0.152.
 */
package com.browseengine.bobo.facets.data;

import com.browseengine.bobo.facets.data.TermNumberList;
import it.unimi.dsi.fastutil.shorts.ShortArrayList;
import java.text.DecimalFormat;
import java.util.Arrays;
import java.util.List;
import org.apache.log4j.Logger;

public class TermShortList
extends TermNumberList<Short> {
    private static Logger log = Logger.getLogger(TermShortList.class);
    private short[] _elements = null;
    private short sanity = (short)-1;
    private boolean withDummy = true;

    private static short parse(String s) {
        if (s == null || s.length() == 0) {
            return 0;
        }
        return Short.parseShort(s);
    }

    public TermShortList() {
    }

    public TermShortList(String formatString) {
        super(formatString);
    }

    public TermShortList(int capacity, String formatString) {
        super(capacity, formatString);
    }

    @Override
    public boolean add(String o) {
        short item;
        if (this._innerList.size() == 0 && o != null) {
            this.withDummy = false;
        }
        if (this.sanity >= (item = TermShortList.parse(o))) {
            throw new RuntimeException("Values need to be added in ascending order and we only support non-negative numbers. Previous value: " + this.sanity + " adding value: " + item);
        }
        if (this._innerList.size() > 0 || !this.withDummy) {
            this.sanity = item;
        }
        return ((ShortArrayList)this._innerList).add(item);
    }

    @Override
    public void clear() {
        super.clear();
    }

    @Override
    public String get(int index) {
        DecimalFormat formatter = (DecimalFormat)this._formatter.get();
        if (formatter == null) {
            return String.valueOf(this._elements[index]);
        }
        return formatter.format(this._elements[index]);
    }

    public short getPrimitiveValue(int index) {
        if (index < this._elements.length) {
            return this._elements[index];
        }
        return -1;
    }

    @Override
    protected List<?> buildPrimitiveList(int capacity) {
        this._type = Short.class;
        return capacity > 0 ? new ShortArrayList(capacity) : new ShortArrayList();
    }

    @Override
    public int indexOf(Object o) {
        if (this.withDummy) {
            if (o == null) {
                return -1;
            }
            short val = TermShortList.parse(String.valueOf(o));
            return Arrays.binarySearch(this._elements, 1, this._elements.length, val);
        }
        short val = TermShortList.parse(String.valueOf(o));
        return Arrays.binarySearch(this._elements, val);
    }

    public int indexOf(Short val) {
        if (this.withDummy) {
            if (val == null) {
                return -1;
            }
            return Arrays.binarySearch(this._elements, 1, this._elements.length, val);
        }
        return Arrays.binarySearch(this._elements, val);
    }

    public int indexOf(short val) {
        if (this.withDummy) {
            return Arrays.binarySearch(this._elements, 1, this._elements.length, val);
        }
        return Arrays.binarySearch(this._elements, val);
    }

    @Override
    public int indexOfWithType(Short val) {
        if (this.withDummy) {
            if (val == null) {
                return -1;
            }
            return Arrays.binarySearch(this._elements, 1, this._elements.length, val);
        }
        return Arrays.binarySearch(this._elements, val);
    }

    @Override
    public int indexOfWithType(short val) {
        if (this.withDummy) {
            return Arrays.binarySearch(this._elements, 1, this._elements.length, val);
        }
        return Arrays.binarySearch(this._elements, val);
    }

    @Override
    public void seal() {
        ((ShortArrayList)this._innerList).trim();
        this._elements = ((ShortArrayList)this._innerList).elements();
    }

    @Override
    protected Object parseString(String o) {
        return TermShortList.parse(o);
    }

    public boolean contains(short val) {
        if (this.withDummy) {
            return Arrays.binarySearch(this._elements, 1, this._elements.length, val) >= 0;
        }
        return Arrays.binarySearch(this._elements, val) >= 0;
    }

    @Override
    public boolean containsWithType(Short val) {
        if (this.withDummy) {
            if (val == null) {
                return false;
            }
            return Arrays.binarySearch(this._elements, 1, this._elements.length, val) >= 0;
        }
        return Arrays.binarySearch(this._elements, val) >= 0;
    }

    @Override
    public boolean containsWithType(short val) {
        if (this.withDummy) {
            return Arrays.binarySearch(this._elements, 1, this._elements.length, val) >= 0;
        }
        return Arrays.binarySearch(this._elements, val) >= 0;
    }
}

