/*
 * Decompiled with CFR 0.152.
 */
package com.browseengine.bobo.util;

import com.browseengine.bobo.util.BigSegmentedArray;
import java.util.Arrays;
import org.apache.lucene.util.BitVector;
import org.apache.lucene.util.OpenBitSet;

public class BigShortArray
extends BigSegmentedArray {
    private static final long serialVersionUID = 1L;
    private short[][] _array;
    private static final int BLOCK_SIZE = 2048;
    private static final int SHIFT_SIZE = 11;
    private static final int MASK = 2047;

    public BigShortArray(int size) {
        super(size);
        this._array = new short[this._numrows][];
        for (int i = 0; i < this._numrows; ++i) {
            this._array[i] = new short[2048];
        }
    }

    @Override
    public final void add(int docId, int val) {
        this._array[docId >> 11][docId & 0x7FF] = (byte)val;
    }

    @Override
    public final int get(int docId) {
        return this._array[docId >> 11][docId & 0x7FF];
    }

    @Override
    public final int findValue(int val, int docId, int maxId) {
        do {
            if (this._array[docId >> 11][docId & 0x7FF] != val) continue;
            return docId;
        } while (docId++ < maxId);
        return Integer.MAX_VALUE;
    }

    @Override
    public final int findValues(OpenBitSet bitset, int docId, int maxId) {
        do {
            if (!bitset.fastGet((int)this._array[docId >> 11][docId & 0x7FF])) continue;
            return docId;
        } while (docId++ < maxId);
        return Integer.MAX_VALUE;
    }

    @Override
    public final int findValues(BitVector bitset, int docId, int maxId) {
        do {
            if (!bitset.get((int)this._array[docId >> 11][docId & 0x7FF])) continue;
            return docId;
        } while (docId++ < maxId);
        return Integer.MAX_VALUE;
    }

    @Override
    public final int findValueRange(int minVal, int maxVal, int docId, int maxId) {
        do {
            short val;
            if ((val = this._array[docId >> 11][docId & 0x7FF]) < minVal || val > maxVal) continue;
            return docId;
        } while (docId++ < maxId);
        return Integer.MAX_VALUE;
    }

    @Override
    public final int findBits(int bits, int docId, int maxId) {
        do {
            if ((this._array[docId >> 11][docId & 0x7FF] & bits) == 0) continue;
            return docId;
        } while (docId++ < maxId);
        return Integer.MAX_VALUE;
    }

    @Override
    public final void fill(int val) {
        short shortVal = (short)val;
        for (short[] block : this._array) {
            Arrays.fill(block, shortVal);
        }
    }

    @Override
    public void ensureCapacity(int size) {
        int newNumrows = (size >> 11) + 1;
        if (newNumrows > this._array.length) {
            short[][] newArray = new short[newNumrows][];
            System.arraycopy(this._array, 0, newArray, 0, this._array.length);
            for (int i = this._array.length; i < newNumrows; ++i) {
                newArray[i] = new short[2048];
            }
            this._array = newArray;
        }
        this._numrows = newNumrows;
    }

    @Override
    final int getBlockSize() {
        return 2048;
    }

    @Override
    final int getShiftSize() {
        return 11;
    }

    @Override
    public int maxValue() {
        return Short.MAX_VALUE;
    }
}

