/*
 * Decompiled with CFR 0.152.
 */
package com.browseengine.bobo.util;

import com.browseengine.bobo.facets.data.TermValueList;
import com.browseengine.bobo.query.scoring.FacetTermScoringFunction;
import com.browseengine.bobo.util.BigIntArray;
import com.browseengine.bobo.util.BigIntBuffer;
import java.util.Arrays;
import java.util.Comparator;
import org.apache.lucene.util.BitVector;

public final class BigNestedIntArray {
    public static final int MAX_ITEMS = 1024;
    private static final int MAX_SLOTS = 1024;
    private static final int SLOTID_MASK = 1023;
    private static final int PAGEID_SHIFT = 10;
    private static final int COUNT_MASK = 2047;
    private static final int VALIDX_SHIFT = 11;
    private static final int ROUNDING = 255;
    private static final int MISSING = Integer.MIN_VALUE;
    private static final int[] MISSING_PAGE = new int[1024];
    private int _maxItems = 1024;
    private int[][] _list;
    private int _size;
    private static final String[] EMPTY;

    public void setMaxItems(int maxItems) {
        this._maxItems = Math.min(maxItems, 1024);
    }

    public int getMaxItems() {
        return this._maxItems;
    }

    public final void load(int size, Loader loader) throws Exception {
        this._size = size;
        loader.initialize(size, this._list);
        if (size > 0) {
            loader.load();
        }
        this._list = loader.finish();
    }

    public int size() {
        return this._size;
    }

    public final int getData(int id, int idx, int defaultValue) {
        int[] page = this._list[id >> 10];
        if (page == null) {
            return defaultValue;
        }
        int val = page[id & 0x3FF];
        if (val >= 0) {
            return val;
        }
        if (val == Integer.MIN_VALUE) {
            return defaultValue;
        }
        return page[idx - (val >>= 11)];
    }

    public final int getData(int id, int[] buf) {
        int[] page = this._list[id >> 10];
        if (page == null) {
            return 0;
        }
        int val = page[id & 0x3FF];
        if (val >= 0) {
            buf[0] = val;
            return 1;
        }
        if (val == Integer.MIN_VALUE) {
            return 0;
        }
        int num = val & 0x7FF;
        System.arraycopy(page, -(val >>= 11), buf, 0, num);
        return num;
    }

    public final String[] getTranslatedData(int id, TermValueList valarray) {
        int[] page = this._list[id >> 10];
        if (page == null) {
            return EMPTY;
        }
        int val = page[id & 0x3FF];
        if (val >= 0) {
            return new String[]{valarray.get(val)};
        }
        if (val == Integer.MIN_VALUE) {
            return EMPTY;
        }
        int num = val & 0x7FF;
        val >>= 11;
        String[] ret = new String[num];
        for (int i = 0; i < num; ++i) {
            ret[i] = valarray.get(page[i - val]);
        }
        return ret;
    }

    public final Object[] getRawData(int id, TermValueList valarray) {
        int[] page = this._list[id >> 10];
        if (page == null) {
            return EMPTY;
        }
        int val = page[id & 0x3FF];
        if (val >= 0) {
            return new Object[]{valarray.getRawValue(val)};
        }
        if (val == Integer.MIN_VALUE) {
            return EMPTY;
        }
        int num = val & 0x7FF;
        val >>= 11;
        Object[] ret = new Object[num];
        for (int i = 0; i < num; ++i) {
            ret[i] = valarray.getRawValue(page[i - val]);
        }
        return ret;
    }

    public final float getScores(int id, int[] freqs, float[] boosts, FacetTermScoringFunction function) {
        function.clearScores();
        int[] page = this._list[id >> 10];
        int val = page[id & 0x3FF];
        if (val >= 0) {
            return function.score(freqs[val], boosts[val]);
        }
        int num = val & 0x7FF;
        val >>= 11;
        for (int i = 0; i < num; ++i) {
            int idx = page[i - val];
            function.scoreAndCollect(freqs[idx], boosts[idx]);
        }
        return function.getCurrentScore();
    }

    public final int compare(int i, int j) {
        int[] page1 = this._list[i >> 10];
        int[] page2 = this._list[j >> 10];
        if (page1 == null) {
            if (page2 == null) {
                return 0;
            }
            return -1;
        }
        if (page2 == null) {
            return 1;
        }
        int val1 = page1[i & 0x3FF];
        int val2 = page2[j & 0x3FF];
        if (val1 >= 0 && val2 >= 0) {
            return val1 - val2;
        }
        if (val1 >= 0) {
            if (val2 == Integer.MIN_VALUE) {
                return 1;
            }
            int idx = -(val2 >> 11);
            int val = val1 - page2[idx];
            if (val == 0) {
                return -1;
            }
            return val;
        }
        if (val2 >= 0) {
            if (val1 == Integer.MIN_VALUE) {
                return -1;
            }
            int idx = -(val1 >> 11);
            int val = page1[idx] - val2;
            if (val == 0) {
                return 1;
            }
            return val;
        }
        if (val1 == Integer.MIN_VALUE) {
            if (val2 == Integer.MIN_VALUE) {
                return 0;
            }
            return -1;
        }
        if (val2 == Integer.MIN_VALUE) {
            return 1;
        }
        int idx1 = -(val1 >> 11);
        int len1 = val1 & 0x7FF;
        int idx2 = -(val2 >> 11);
        int len2 = val2 & 0x7FF;
        for (int k = 0; k < len1; ++k) {
            if (k >= len2) {
                return 1;
            }
            int compVal = page1[idx1 + k] - page2[idx2 + k];
            if (compVal == 0) continue;
            return compVal;
        }
        if (len1 == len2) {
            return 0;
        }
        return -1;
    }

    public final boolean contains(int id, int value) {
        int[] page = this._list[id >> 10];
        if (page == null) {
            return false;
        }
        int val = page[id & 0x3FF];
        if (val >= 0) {
            return val == value;
        }
        if (val != Integer.MIN_VALUE) {
            int idx = -(val >> 11);
            int end = idx + (val & 0x7FF);
            while (idx < end) {
                if (page[idx++] != value) continue;
                return true;
            }
        }
        return false;
    }

    public final boolean contains(int id, BitVector values) {
        int[] page = this._list[id >> 10];
        if (page == null) {
            return false;
        }
        int val = page[id & 0x3FF];
        if (val >= 0) {
            return values.get(val);
        }
        if (val != Integer.MIN_VALUE) {
            int idx = -(val >> 11);
            int end = idx + (val & 0x7FF);
            while (idx < end) {
                if (!values.get(page[idx++])) continue;
                return true;
            }
        }
        return false;
    }

    public final int findValue(int value, int id, int maxID) {
        int[] page = this._list[id >> 10];
        if (page == null) {
            page = MISSING_PAGE;
        }
        while (true) {
            int val;
            if ((val = page[id & 0x3FF]) >= 0) {
                if (val == value) {
                    return id;
                }
            } else if (val != Integer.MIN_VALUE) {
                int idx = -(val >> 11);
                int end = idx + (val & 0x7FF);
                while (idx < end) {
                    if (page[idx++] != value) continue;
                    return id;
                }
            }
            if (id >= maxID) break;
            if ((++id & 0x3FF) != 0 || (page = this._list[id >> 10]) != null) continue;
            page = MISSING_PAGE;
        }
        return Integer.MAX_VALUE;
    }

    public final int findValues(BitVector values, int id, int maxID) {
        int[] page = this._list[id >> 10];
        if (page == null) {
            page = MISSING_PAGE;
        }
        while (true) {
            int val;
            if ((val = page[id & 0x3FF]) >= 0) {
                if (values.get(val)) {
                    return id;
                }
            } else if (val != Integer.MIN_VALUE) {
                int idx = -(val >> 11);
                int end = idx + (val & 0x7FF);
                while (idx < end) {
                    if (!values.get(page[idx++])) continue;
                    return id;
                }
            }
            if (id >= maxID) break;
            if ((++id & 0x3FF) != 0 || (page = this._list[id >> 10]) != null) continue;
            page = MISSING_PAGE;
        }
        return Integer.MAX_VALUE;
    }

    public final int count(int id, int[] count) {
        int[] page = this._list[id >> 10];
        if (page == null) {
            count[0] = count[0] + 1;
            return 0;
        }
        int val = page[id & 0x3FF];
        if (val >= 0) {
            int n = val;
            count[n] = count[n] + 1;
            return 1;
        }
        if (val != Integer.MIN_VALUE) {
            int idx = -(val >> 11);
            int cnt = val & 0x7FF;
            int end = idx + cnt;
            while (idx < end) {
                int n = page[idx++];
                count[n] = count[n] + 1;
            }
            return cnt;
        }
        count[0] = count[0] + 1;
        return 0;
    }

    public final void countNoReturn(int id, int[] count) {
        int[] page = this._list[id >> 10];
        if (page == null) {
            count[0] = count[0] + 1;
            return;
        }
        int val = page[id & 0x3FF];
        if (val >= 0) {
            int n = val;
            count[n] = count[n] + 1;
            return;
        }
        if (val != Integer.MIN_VALUE) {
            int idx = -(val >> 11);
            int cnt = val & 0x7FF;
            int end = idx + cnt;
            while (idx < end) {
                int n = page[idx++];
                count[n] = count[n] + 1;
            }
            return;
        }
        count[0] = count[0] + 1;
    }

    public final int getNumItems(int id) {
        int[] page = this._list[id >> 10];
        if (page == null) {
            return 0;
        }
        int val = page[id & 0x3FF];
        if (val >= 0) {
            return 1;
        }
        if (val == Integer.MIN_VALUE) {
            return 0;
        }
        return val & 0x7FF;
    }

    public final boolean addData(int id, int data) {
        int[] page = this._list[id >> 10];
        if (page == null) {
            return true;
        }
        int slotId = id & 0x3FF;
        int val = page[slotId];
        if (val == Integer.MIN_VALUE) {
            return true;
        }
        if (val >= 0) {
            page[slotId] = data;
            return true;
        }
        int num = val & 0x7FF;
        if (num >= this._maxItems) {
            return false;
        }
        page[num - (val >>= 11)] = data;
        page[slotId] = val = val << 11 | num + 1;
        return true;
    }

    static {
        Arrays.fill(MISSING_PAGE, Integer.MIN_VALUE);
        EMPTY = new String[0];
    }

    public static final class BufferedLoader
    extends Loader {
        private static int EOD = Integer.MIN_VALUE;
        private static int SEGSIZE = 8;
        private int _size;
        private final BigIntArray _info;
        private BigIntBuffer _buffer;
        private int _maxItems;

        public BufferedLoader(int size, int maxItems, BigIntBuffer buffer) {
            this._size = size;
            this._maxItems = Math.min(maxItems, 1024);
            this._info = new BigIntArray(size << 1);
            this._info.fill(EOD);
            this._buffer = buffer;
        }

        public BufferedLoader(int size) {
            this(size, 1024, new BigIntBuffer());
        }

        public void reset(int size, int maxItems, BigIntBuffer buffer) {
            if (size >= this.capacity()) {
                throw new IllegalArgumentException("unable to change size");
            }
            this._size = size;
            this._maxItems = maxItems;
            this._info.fill(EOD);
            this._buffer = buffer;
        }

        public final boolean add(int id, int val) {
            int ptr = this._info.get(id << 1);
            if (ptr == EOD) {
                this._info.add(id << 1, val);
                return true;
            }
            int cnt = this._info.get((id << 1) + 1);
            if (cnt == EOD) {
                this._info.add((id << 1) + 1, val);
                return true;
            }
            if (ptr >= 0) {
                int firstVal = ptr;
                int secondVal = cnt;
                ptr = this._buffer.alloc(SEGSIZE);
                this._buffer.set(ptr++, EOD);
                this._buffer.set(ptr++, firstVal);
                this._buffer.set(ptr++, secondVal);
                this._buffer.set(ptr++, val);
                cnt = 3;
            } else {
                ptr = -ptr;
                if (cnt >= this._maxItems) {
                    return false;
                }
                if (ptr % SEGSIZE == 0) {
                    int oldPtr = ptr;
                    ptr = this._buffer.alloc(SEGSIZE);
                    this._buffer.set(ptr++, -oldPtr);
                }
                this._buffer.set(ptr++, val);
                ++cnt;
            }
            this._info.add(id << 1, -ptr);
            this._info.add((id << 1) + 1, cnt);
            return true;
        }

        private final int readToBuf(int id, int[] buf) {
            int ptr = this._info.get(id << 1);
            int cnt = this._info.get((id << 1) + 1);
            if (ptr >= 0) {
                int i = 0;
                buf[i++] = ptr;
                if (cnt >= 0) {
                    buf[i++] = cnt;
                }
                return i;
            }
            int i = cnt;
            while (ptr != EOD) {
                int val;
                ptr = -ptr - 1;
                while ((val = this._buffer.get(ptr--)) >= 0) {
                    buf[--i] = val;
                }
                ptr = val;
            }
            if (i > 0) {
                throw new RuntimeException("error reading buffered data back");
            }
            return cnt;
        }

        @Override
        public final void load() {
            int[] buf = new int[1024];
            int size = this._size;
            for (int i = 0; i < size; ++i) {
                int count = this.readToBuf(i, buf);
                if (count <= 0) continue;
                this.add(i, buf, 0, count);
            }
        }

        public final int capacity() {
            return this._info.capacity() >> 1;
        }
    }

    public static abstract class Loader {
        private int[][] _list;
        private int _curPageNo;
        private int[] _curPage;
        private int _curSlot;
        private int _curData;
        private int[][] _reuse;
        private int[] _reuseIdx;
        public int reuseUsage;
        private static Comparator<int[]> COMPARE_ARRAYSIZE = new Comparator<int[]>(){

            @Override
            public int compare(int[] o1, int[] o2) {
                if (o1 == null || o2 == null) {
                    if (o1 != null) {
                        return -1;
                    }
                    if (o2 != null) {
                        return 1;
                    }
                    return 0;
                }
                return o1.length - o2.length;
            }
        };

        private void reclaim(int[][] list) {
            this._reuse = null;
            this._reuseIdx = null;
            this.reuseUsage = 0;
            if (list != null && list.length > 0) {
                int i;
                Arrays.sort(list, COMPARE_ARRAYSIZE);
                for (i = list.length - 1; i >= 0; --i) {
                    if (list[i] == null) continue;
                    this._reuse = list;
                    this._reuseIdx = list[i];
                    break;
                }
                if (this._reuseIdx == null) {
                    return;
                }
                Arrays.fill(this._reuseIdx, -1);
                for (i = 0; i < list.length && list[i] != null; ++i) {
                    int idx = list[i].length - 1;
                    if (idx < 0 || this._reuseIdx[idx] != -1) continue;
                    this._reuseIdx[idx] = i;
                }
            }
        }

        private int[] alloc(int size) {
            int location;
            size += 254;
            size -= size % 255;
            if (this._reuseIdx != null && this._reuseIdx.length >= size && (location = this._reuseIdx[size - 1]) >= 0 && location < this._reuse.length) {
                int[] page = this._reuse[location];
                if (page != null && page.length == size) {
                    int n = size - 1;
                    this._reuseIdx[n] = this._reuseIdx[n] + 1;
                    this._reuse[location] = null;
                    if (page == this._reuseIdx) {
                        for (int i = location; i >= 0; --i) {
                            if (this._reuse[i] == null) continue;
                            this._reuseIdx = this._reuse[i];
                            System.arraycopy(page, 0, this._reuseIdx, 0, this._reuseIdx.length);
                        }
                    }
                    this.reuseUsage += size;
                    return page;
                }
                this._reuseIdx[size - 1] = -1;
            }
            return new int[size];
        }

        public final void initialize(int size, int[][] oldList) {
            this.reclaim(oldList);
            this._list = new int[(size + 1024 - 1) / 1024][];
            this._curPageNo = 0;
            this._curSlot = 0;
            this._curData = 1024;
            this._curPage = new int[2048];
        }

        public final int[][] finish() {
            if (this._list.length > this._curPageNo) {
                while (this._curSlot < 1024) {
                    this._curPage[this._curSlot++] = Integer.MIN_VALUE;
                }
                this._list[this._curPageNo] = this.copyPageTo(this.alloc(this._curData));
            }
            this._reuse = null;
            this._reuseIdx = null;
            return this._list;
        }

        public abstract void load() throws Exception;

        protected final void reserve(int id, int size) {
            int pageNo = id >> 10;
            int slotId = id & 0x3FF;
            if (pageNo != this._curPageNo) {
                if (pageNo < this._curPageNo) {
                    throw new IllegalArgumentException("id is out of order");
                }
                while (this._curSlot < 1024) {
                    this._curPage[this._curSlot++] = Integer.MIN_VALUE;
                }
                this._list[this._curPageNo++] = this.copyPageTo(this.alloc(this._curData));
                this._curSlot = 0;
                this._curData = 1024;
                while (this._curPageNo < pageNo) {
                    this._list[this._curPageNo++] = null;
                }
            } else if (this._curPageNo == pageNo && this._curSlot > slotId) {
                throw new IllegalArgumentException("id is out of order");
            }
            while (this._curSlot < slotId) {
                this._curPage[this._curSlot++] = Integer.MIN_VALUE;
            }
            if (this._curPage.length <= this._curData + size) {
                this._curPage = this.copyPageTo(new int[this._curPage.length + Math.max(this._curPage.length - 1024, size)]);
            }
        }

        protected final void store(int[] data, int off, int len) {
            if (len == 0) {
                this._curPage[this._curSlot] = Integer.MIN_VALUE;
            } else if (len == 1 && data[off] >= 0) {
                this._curPage[this._curSlot] = data[off];
            } else {
                this._curPage[this._curSlot] = -this._curData << 11 | len;
                System.arraycopy(data, off, this._curPage, this._curData, len);
                this._curData += len;
            }
            ++this._curSlot;
        }

        protected void add(int id, int[] data, int off, int len) {
            this.reserve(id, len);
            this.store(data, off, len);
        }

        protected void allocate(int id, int len, boolean nonNegativeIntOnly) {
            this.reserve(id, len);
            if (len == 0) {
                this._curPage[this._curSlot] = Integer.MIN_VALUE;
            } else if (len == 1 && nonNegativeIntOnly) {
                this._curPage[this._curSlot] = 0;
            } else {
                this._curPage[this._curSlot] = -this._curData << 11;
                this._curData += len;
            }
            ++this._curSlot;
        }

        protected int[] copyPageTo(int[] dst) {
            System.arraycopy(this._curPage, 0, dst, 0, this._curData);
            return dst;
        }
    }
}

