/*
 * Decompiled with CFR 0.152.
 */
package com.browseengine.bobo.api;

import com.browseengine.bobo.api.BoboIndexReader;
import com.browseengine.bobo.api.BoboSubBrowser;
import com.browseengine.bobo.api.Browsable;
import com.browseengine.bobo.api.MultiBoboBrowser;
import com.browseengine.bobo.facets.FacetHandler;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.util.ReaderUtil;

public class BoboBrowser
extends MultiBoboBrowser {
    public BoboBrowser(BoboIndexReader reader) throws IOException {
        super(BoboBrowser.createBrowsables(reader));
    }

    public static Browsable[] createBrowsables(BoboIndexReader reader) {
        ArrayList readerList = new ArrayList();
        ReaderUtil.gatherSubReaders(readerList, (IndexReader)reader);
        IndexReader[] subReaders = readerList.toArray(new IndexReader[readerList.size()]);
        if (subReaders == null || subReaders.length == 0) {
            return new Browsable[]{new BoboSubBrowser(reader)};
        }
        Browsable[] subBrowsables = new Browsable[subReaders.length];
        for (int i = 0; i < subReaders.length; ++i) {
            subBrowsables[i] = new BoboSubBrowser((BoboIndexReader)subReaders[i]);
        }
        return subBrowsables;
    }

    public static Browsable[] createBrowsables(List<BoboIndexReader> readerList) {
        ArrayList<Browsable> browsableList = new ArrayList<Browsable>();
        for (BoboIndexReader boboReader : readerList) {
            Browsable[] sub = BoboBrowser.createBrowsables(boboReader);
            browsableList.addAll(Arrays.asList(sub));
        }
        return browsableList.toArray(new Browsable[browsableList.size()]);
    }

    @Override
    public Set<String> getFacetNames() {
        return this._subBrowsers[0].getFacetNames();
    }

    @Override
    public FacetHandler<?> getFacetHandler(String name) {
        return this._subBrowsers[0].getFacetHandler(name);
    }
}

