/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.util.propertyEditor;

import com.bbn.openmap.Environment;
import com.bbn.openmap.I18n;
import com.bbn.openmap.PropertyConsumer;
import com.bbn.openmap.gui.WindowSupport;
import com.bbn.openmap.util.Debug;
import com.bbn.openmap.util.PropUtils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyEditor;
import java.util.Collection;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Inspector
implements ActionListener {
    protected final String defaultEditorClass = "com.bbn.openmap.util.propertyEditor.TextPropertyEditor";
    protected PropertyConsumer propertyConsumer = null;
    protected WindowSupport windowSupport = null;
    public static final String cancelCommand = "cancelCommand";
    public static final String doneCommand = "doneCommand";
    protected Hashtable<String, PropertyEditor> editors = null;
    protected ActionListener actionListener = null;
    protected boolean print = false;
    static I18n i18n = Environment.getI18n();

    public void addActionListener(ActionListener al) {
        this.actionListener = al;
    }

    public Inspector() {
    }

    public Inspector(ActionListener al) {
        this.actionListener = al;
    }

    public void inspectPropertyConsumer(PropertyConsumer propertyConsumer) {
        String prefix = propertyConsumer.getPropertyPrefix();
        if (this.windowSupport != null) {
            this.windowSupport.killWindow();
            this.windowSupport = null;
        }
        JComponent comp = this.createPropertyGUI(propertyConsumer);
        this.windowSupport = new WindowSupport((Component)comp, i18n.get(Inspector.class, "Inspector", "Inspector") + " - " + prefix);
        this.windowSupport.setMaxSize(-1, 500);
        this.windowSupport.displayInWindow();
    }

    public Vector<String> sortKeys(Collection keySet) {
        Vector<String> vector = new Vector<String>(keySet.size());
        block0: for (String key : keySet) {
            int size = vector.size();
            for (int i = 0; i <= size; ++i) {
                if (i == size) {
                    vector.add(key);
                    continue block0;
                }
                int compare = key.compareTo(vector.elementAt(i));
                if (compare >= 0) continue;
                vector.add(i, key);
                continue block0;
            }
        }
        return vector;
    }

    public JComponent createEmbeddedPropertyGUI(PropertyConsumer pc) {
        this.propertyConsumer = pc;
        Properties props = new Properties();
        props = pc.getProperties(props);
        Properties info = new Properties();
        info = pc.getPropertyInfo(info);
        String prefix = pc.getPropertyPrefix();
        return this.createEmbeddedPropertyGUI(prefix, props, info);
    }

    public JComponent createEmbeddedPropertyGUI(String prefix, Properties props, Properties info) {
        Vector<String> sortedKeys;
        String propertyList;
        if (Debug.debugging("inspectordetail")) {
            Debug.output("Inspector creating GUI for " + prefix + "\nPROPERTIES " + props + "\nPROP INFO " + info);
        }
        if ((propertyList = info.getProperty("initProperties")) != null) {
            Vector<String> propertiesToShow = PropUtils.parseSpacedMarkers(propertyList);
            for (int i = 0; i < propertiesToShow.size(); ++i) {
                propertiesToShow.set(i, prefix + "." + propertiesToShow.get(i));
            }
            sortedKeys = propertiesToShow;
        } else {
            sortedKeys = this.sortKeys(props.keySet());
        }
        this.editors = new Hashtable(sortedKeys.size());
        JPanel component = new JPanel();
        component.setLayout(new BorderLayout());
        JPanel propertyPanel = new JPanel();
        GridBagLayout gridbag = new GridBagLayout();
        GridBagConstraints c = new GridBagConstraints();
        c.insets = new Insets(2, 10, 2, 10);
        propertyPanel.setLayout(gridbag);
        int i = 0;
        Iterator<String> i$ = sortedKeys.iterator();
        while (i$.hasNext()) {
            String labelMarker;
            String labelText;
            String editorMarker;
            String editorClass;
            String prop;
            String marker = prop = i$.next();
            if (prefix != null && prop.startsWith(prefix)) {
                marker = prop.substring(prefix.length() + 1);
            }
            if (marker.startsWith(".")) {
                marker = marker.substring(1);
            }
            if ((editorClass = info.getProperty(editorMarker = marker + ".editor")) == null) {
                editorClass = "com.bbn.openmap.util.propertyEditor.TextPropertyEditor";
            }
            Class<?> propertyEditorClass = null;
            PropertyEditor editor = null;
            try {
                propertyEditorClass = Class.forName(editorClass);
                editor = (PropertyEditor)propertyEditorClass.newInstance();
                if (editor instanceof PropertyConsumer) {
                    ((PropertyConsumer)((Object)editor)).setProperties(marker, info);
                }
                this.editors.put(prop, editor);
            }
            catch (Exception e) {
                e.printStackTrace();
                editorClass = null;
            }
            Component editorFace = null;
            editorFace = editor != null && editor.supportsCustomEditor() ? editor.getCustomEditor() : new JLabel(i18n.get(Inspector.class, "Does_not_support_custom_editor", "Does not support custom editor"));
            if (editor != null) {
                Object propVal = props.get(prop);
                if (Debug.debugging("inspector")) {
                    Debug.output("Inspector loading " + prop + "(" + propVal + ")");
                }
                editor.setValue(propVal);
            }
            if ((labelText = info.getProperty(labelMarker = marker + ".label")) == null) {
                labelText = marker;
            }
            JLabel label = new JLabel(labelText + ":");
            label.setHorizontalAlignment(4);
            c.gridx = 0;
            c.gridy = i++;
            c.weightx = 0.0;
            c.fill = 0;
            c.anchor = 13;
            gridbag.setConstraints(label, c);
            propertyPanel.add(label);
            c.gridx = 1;
            c.anchor = 17;
            c.fill = 2;
            c.weightx = 1.0;
            gridbag.setConstraints(editorFace, c);
            propertyPanel.add(editorFace);
            String toolTip = (String)info.get(marker);
            label.setToolTipText(toolTip == null ? i18n.get(Inspector.class, "No_further_information_available", "No further information available.") : toolTip);
        }
        JScrollPane scrollPane = new JScrollPane(propertyPanel, 20, 31);
        scrollPane.setBorder(null);
        scrollPane.setAlignmentY(0.0f);
        component.add((Component)scrollPane, "Center");
        return component;
    }

    public JComponent createPropertyGUI(PropertyConsumer pc) {
        this.propertyConsumer = pc;
        Properties props = new Properties();
        props = pc.getProperties(props);
        Properties info = new Properties();
        info = pc.getPropertyInfo(info);
        String prefix = pc.getPropertyPrefix();
        return this.createPropertyGUI(prefix, props, info);
    }

    public JComponent createPropertyGUI(String prefix, Properties props, Properties info) {
        JComponent component = this.createEmbeddedPropertyGUI(prefix, props, info);
        JButton doneButton = null;
        JButton cancelButton = null;
        JPanel buttons = new JPanel();
        if (this.print) {
            doneButton = new JButton(i18n.get(Inspector.class, "Print", "Print"));
            cancelButton = new JButton(i18n.get(Inspector.class, "Quit", "Quit"));
        } else {
            doneButton = new JButton(i18n.get(Inspector.class, "Ok", "Ok"));
            cancelButton = new JButton(i18n.get(Inspector.class, "Cancel", "Cancel"));
        }
        doneButton.addActionListener(this);
        doneButton.setActionCommand(doneCommand);
        cancelButton.addActionListener(this);
        cancelButton.setActionCommand(cancelCommand);
        buttons.add(doneButton);
        buttons.add(cancelButton);
        component.add((Component)buttons, "South");
        component.validate();
        return component;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String actionCommand = e.getActionCommand();
        String prefix = this.propertyConsumer.getPropertyPrefix();
        if (actionCommand == doneCommand) {
            Properties props = this.collectProperties();
            if (!this.print) {
                if (this.windowSupport != null) {
                    this.windowSupport.killWindow();
                }
                this.propertyConsumer.setProperties(prefix, props);
                if (this.actionListener != null) {
                    this.actionListener.actionPerformed(e);
                }
            } else {
                Set<Map.Entry<Object, Object>> entrySet = props.entrySet();
                for (Map.Entry<Object, Object> next : entrySet) {
                    String val = (String)next.getValue();
                    System.out.println(next.getKey() + "=" + val);
                }
            }
        } else if (actionCommand == cancelCommand) {
            if (this.actionListener != null && this.actionListener != this) {
                this.actionListener.actionPerformed(e);
            }
            this.propertyConsumer = null;
            if (this.windowSupport != null) {
                this.windowSupport.killWindow();
            }
            if (this.print) {
                System.exit(0);
            }
        }
    }

    public void collectAndSetProperties() {
        if (this.propertyConsumer != null) {
            String prefix = this.propertyConsumer.getPropertyPrefix();
            Properties props = this.collectProperties();
            this.propertyConsumer.setProperties(prefix, props);
        }
    }

    public Properties collectProperties() {
        Properties props = new Properties();
        for (String key : this.editors.keySet()) {
            PropertyEditor editor = this.editors.get(key);
            if (editor == null) continue;
            String stuff = editor.getAsText();
            if (stuff != null && stuff.length() > 0) {
                props.put(key, stuff);
            }
            if (!(editor instanceof PropertyConsumer)) continue;
            ((PropertyConsumer)((Object)editor)).getProperties(props);
        }
        return props;
    }

    public void setPrint(boolean p) {
        this.print = p;
    }

    public boolean getPrint() {
        return this.print;
    }

    public WindowSupport getWindowSupport() {
        return this.windowSupport;
    }

    public static void main(String[] args) {
        Debug.init();
        String name = args.length < 1 ? "com.bbn.openmap.layer.shape.ShapeLayer" : args[0];
        PropertyConsumer propertyconsumer = null;
        try {
            Class<?> c = Class.forName(name);
            propertyconsumer = (PropertyConsumer)c.newInstance();
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(1);
        }
        if (propertyconsumer != null) {
            Properties props = new Properties();
            Properties info = new Properties();
            System.out.println("Inspecting " + name);
            String pp = name.substring(name.lastIndexOf(".") + 1);
            propertyconsumer.setPropertyPrefix(pp.toLowerCase());
            props = propertyconsumer.getProperties(props);
            info = propertyconsumer.getPropertyInfo(info);
            Inspector inspector = new Inspector();
            inspector.setPrint(true);
            inspector.addActionListener(inspector);
            inspector.inspectPropertyConsumer(propertyconsumer);
        }
    }
}

