/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;
import org.xml.sax.helpers.XMLReaderFactory;

public abstract class AbstractXmlParser
extends DefaultHandler {
    private final Logger logger = Logger.getLogger("com.bbn.openmap.util.AbstractXmlParser");
    private final StringBuilder charactersCollector = new StringBuilder();
    private String collectCharactersForElement;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean parseXmlResource(File file) {
        Reader reader = null;
        try {
            reader = new BufferedReader(new FileReader(file));
            boolean bl = this.parseXmlResource(file.getPath(), new InputSource(reader));
            return bl;
        }
        catch (FileNotFoundException e) {
            this.logger.warning("Failed to open " + file + ":" + e.getMessage());
            boolean bl = false;
            return bl;
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException e) {}
            }
        }
    }

    public boolean parseXmlResource(Object resourceName, InputSource source) {
        boolean status;
        block9: {
            XMLReader reader;
            source.setEncoding("UTF8");
            try {
                reader = XMLReaderFactory.createXMLReader();
            }
            catch (SAXException e) {
                if (this.logger.isLoggable(Level.SEVERE)) {
                    this.logger.warning("Failed to create reader for " + resourceName + ": " + e.getMessage());
                }
                return false;
            }
            status = false;
            reader.setContentHandler(this);
            reader.setErrorHandler(this);
            try {
                reader.parse(source);
                status = true;
            }
            catch (SAXParseException e) {
                if (this.logger.isLoggable(Level.WARNING)) {
                    this.logger.warning("Failed to parse " + resourceName + " Line: " + e.getLineNumber() + " Col: " + e.getColumnNumber() + ": " + e);
                }
            }
            catch (SAXException e) {
                if (this.logger.isLoggable(Level.WARNING)) {
                    this.logger.warning("Failed to parse " + resourceName + e.getMessage());
                }
            }
            catch (IOException e) {
                if (!this.logger.isLoggable(Level.WARNING)) break block9;
                this.logger.warning("Failed to parse " + resourceName + ":" + e.getMessage());
            }
        }
        return status;
    }

    public void collectCharacters(String expectedElement) {
        this.collectCharactersForElement = expectedElement;
    }

    public String getCollectedCharacters(String expectedElement) {
        if (expectedElement.equals(this.collectCharactersForElement)) {
            String result = this.charactersCollector.toString();
            this.charactersCollector.delete(0, result.length());
            this.collectCharactersForElement = null;
            return result;
        }
        throw new RuntimeException("Expected \"" + expectedElement + "\", found \"" + this.collectCharactersForElement + "\"");
    }

    public void characters(char[] ch, int start, int length) throws SAXException {
        if (this.collectCharactersForElement != null) {
            this.charactersCollector.append(ch, start, length);
        }
    }
}

