/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.tools.drawing;

import com.bbn.openmap.InformationDelegator;
import com.bbn.openmap.MapHandler;
import com.bbn.openmap.gui.GridBagToolBar;
import com.bbn.openmap.gui.OMToolComponent;
import com.bbn.openmap.gui.WindowSupport;
import com.bbn.openmap.omGraphics.GraphicAttributes;
import com.bbn.openmap.omGraphics.geom.NonRegional;
import com.bbn.openmap.tools.drawing.DrawingTool;
import com.bbn.openmap.tools.drawing.DrawingToolRequestor;
import com.bbn.openmap.tools.drawing.EditToolLoader;
import com.bbn.openmap.tools.drawing.OMDrawingTool;
import com.bbn.openmap.util.Debug;
import com.bbn.openmap.util.PaletteHelper;
import com.bbn.openmap.util.PropUtils;
import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Iterator;
import java.util.Properties;
import java.util.Vector;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OMDrawingToolLauncher
extends OMToolComponent
implements ActionListener,
PropertyChangeListener {
    protected DrawingTool drawingTool;
    protected boolean useTextEditToolTitles = false;
    protected GraphicAttributes defaultGraphicAttributes = new GraphicAttributes();
    public int maxHorNumLoaderButtons = -1;
    protected Vector<LoaderHolder> loaders = new Vector();
    protected Vector<DrawingToolRequestor> drawingToolRequestors = new Vector();
    protected DrawingToolRequestor currentRequestor;
    protected String currentCreation;
    protected JComboBox requestors;
    protected JButton createButton;
    protected JPanel panel3;
    public static final String HorizontalNumberOfLoaderButtonsProperty = "horizNumLoaderButtons";
    public static final String UseLoaderTextProperty = "useTextLabels";
    String[] rtc = new String[]{this.i18n.get(OMDrawingToolLauncher.class, "renderingType.LatLon", "Lat/Lon"), this.i18n.get(OMDrawingToolLauncher.class, "renderingType.XY", "X/Y"), this.i18n.get(OMDrawingToolLauncher.class, "renderingType.XYOffset", "X/Y Offset")};
    public static final String CreateCmd = "CREATE";
    public static final String defaultKey = "omdrawingtoollauncher";

    public OMDrawingToolLauncher() {
        this.setWindowSupport(new WindowSupport((Component)this, this.i18n.get(OMDrawingToolLauncher.class, defaultKey, "Drawing Tool Launcher")));
        this.setKey(defaultKey);
        this.defaultGraphicAttributes.setRenderType(1);
        this.defaultGraphicAttributes.setLineType(3);
        this.resetGUI();
    }

    public void setDrawingTool(DrawingTool dt) {
        if (this.drawingTool instanceof OMDrawingTool) {
            ((OMDrawingTool)this.drawingTool).removePropertyChangeListener(this);
        }
        this.drawingTool = dt;
        if (this.drawingTool instanceof OMDrawingTool) {
            ((OMDrawingTool)this.drawingTool).addPropertyChangeListener(this);
        }
    }

    public DrawingTool getDrawingTool() {
        return this.drawingTool;
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        String command = ae.getActionCommand().intern();
        Debug.message("drawingtool", "DrawingToolLauncher.actionPerformed(): " + command);
        if (command == CreateCmd) {
            OMDrawingTool omdt;
            DrawingTool dt = this.getDrawingTool();
            if (dt instanceof OMDrawingTool && (omdt = (OMDrawingTool)dt).isActivated()) {
                omdt.deactivate();
            }
            if (dt != null && this.currentCreation != null && this.currentRequestor != null) {
                GraphicAttributes ga = (GraphicAttributes)this.defaultGraphicAttributes.clone();
                dt.setBehaviorMask(11);
                dt.create(this.currentCreation, ga, this.currentRequestor);
            } else {
                InformationDelegator id;
                StringBuffer sb = new StringBuffer();
                StringBuffer em = new StringBuffer();
                if (dt == null) {
                    sb.append("   No drawing tool is available!\n");
                    em.append(this.i18n.get(OMDrawingToolLauncher.class, "noDrowingTool", "   No drawing tool is available!\n"));
                } else {
                    sb.append("   Drawing tool OK.\n");
                }
                if (this.currentCreation == null) {
                    sb.append("   No valid choice of graphic to create.\n");
                    em.append(this.i18n.get(OMDrawingToolLauncher.class, "noValidChoice", "   No valid choice of graphic to create.\n"));
                } else {
                    sb.append("   Graphic choice OK.\n");
                }
                if (this.currentRequestor == null) {
                    sb.append("   No valid receiver for the created graphic.\n");
                    em.append(this.i18n.get(OMDrawingToolLauncher.class, "noValidReceiver", "   No valid receiver for the created graphic.\n"));
                } else {
                    sb.append("   Graphic receiver OK.\n");
                }
                Debug.output("OMDrawingToolLauncher: Something is not set:\n" + sb.toString());
                MapHandler mapHandler = (MapHandler)this.getBeanContext();
                if (mapHandler != null && (id = (InformationDelegator)mapHandler.get("com.bbn.openmap.InformationDelegator")) != null) {
                    id.displayMessage(this.i18n.get(OMDrawingToolLauncher.class, "problem", "Problem"), this.i18n.get(OMDrawingToolLauncher.class, "problemCreatingGraphic", "Problem creating new graphic:\n") + em.toString());
                }
            }
        }
    }

    public void setRequestor(String aName) {
        if (this.requestors != null) {
            if (aName != null) {
                this.requestors.setSelectedItem(aName);
            } else if (!this.drawingToolRequestors.isEmpty()) {
                this.setRequestor(this.drawingToolRequestors.elementAt(0).getName());
            }
        }
    }

    private void resetCombo() {
        Object oldChoice = null;
        if (this.requestors != null) {
            oldChoice = this.requestors.getSelectedItem();
            ActionListener[] actions = this.requestors.getActionListeners();
            for (int loop = 0; loop < actions.length; ++loop) {
                this.requestors.removeActionListener(actions[loop]);
            }
            this.requestors.removeAllItems();
            for (DrawingToolRequestor requestor : this.drawingToolRequestors) {
                this.requestors.addItem(requestor.getName());
            }
            if (oldChoice != null) {
                this.requestors.setSelectedItem(oldChoice);
            }
            for (int loop = 0; loop < actions.length; ++loop) {
                this.requestors.addActionListener(actions[loop]);
            }
            this.setCurrentRequestor((String)this.requestors.getSelectedItem());
        }
        this.createButton.setEnabled(this.drawingToolRequestors != null && !this.drawingToolRequestors.isEmpty());
    }

    public void resetGUI() {
        this.removeAll();
        JPanel palette = new JPanel();
        palette.setLayout(new BoxLayout(palette, 1));
        palette.setAlignmentX(0.5f);
        palette.setAlignmentY(0.5f);
        String[] requestorNames = new String[this.drawingToolRequestors.size()];
        if (Debug.debugging("omdtl")) {
            Debug.output("Have " + requestorNames.length + " REQUESTORS");
        }
        for (int i = 0; i < requestorNames.length; ++i) {
            requestorNames[i] = this.drawingToolRequestors.elementAt(i).getName();
            if (requestorNames[i] == null) {
                Debug.output("OMDrawingToolLauncher has a requestor that is unnamed.  Please assign a name to the requestor");
                requestorNames[i] = "-- Unnamed --";
            }
            if (!Debug.debugging("omdtl")) continue;
            Debug.output("Adding REQUESTOR " + requestorNames[i] + " to menu");
        }
        Object oldChoice = null;
        if (this.requestors != null) {
            oldChoice = this.requestors.getSelectedItem();
        }
        this.requestors = new JComboBox<String>(requestorNames);
        this.requestors.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                JComboBox jcb = (JComboBox)e.getSource();
                String currentChoice = (String)jcb.getSelectedItem();
                OMDrawingToolLauncher.this.setCurrentRequestor(currentChoice);
            }
        });
        if (requestorNames.length > 0) {
            if (oldChoice == null) {
                this.requestors.setSelectedIndex(0);
            } else {
                this.requestors.setSelectedItem(oldChoice);
            }
        }
        JPanel panel = PaletteHelper.createPaletteJPanel(this.i18n.get(OMDrawingToolLauncher.class, "panelSendTo", "Send To:"));
        panel.add(this.requestors);
        palette.add(panel);
        if (Debug.debugging("omdtl")) {
            Debug.output("Figuring out tools, using names");
        }
        panel = PaletteHelper.createPaletteJPanel(this.i18n.get(OMDrawingToolLauncher.class, "panelGraphicType", "Graphic Type:"));
        panel.add(this.getToolWidgets(this.useTextEditToolTitles));
        palette.add(panel);
        String[] renderTypes = new String[]{this.rtc[0], this.rtc[1], this.rtc[2]};
        JComboBox<String> renderTypeList = new JComboBox<String>(renderTypes);
        renderTypeList.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                JComboBox jcb = (JComboBox)e.getSource();
                String currentChoice = (String)jcb.getSelectedItem();
                if (currentChoice.equals(OMDrawingToolLauncher.this.rtc[2])) {
                    OMDrawingToolLauncher.this.defaultGraphicAttributes.setRenderType(3);
                } else if (currentChoice.equals(OMDrawingToolLauncher.this.rtc[1])) {
                    OMDrawingToolLauncher.this.defaultGraphicAttributes.setRenderType(2);
                } else {
                    OMDrawingToolLauncher.this.defaultGraphicAttributes.setRenderType(1);
                }
            }
        });
        renderTypeList.setSelectedIndex(this.defaultGraphicAttributes.getRenderType() - 1);
        panel = PaletteHelper.createHorizontalPanel(this.i18n.get(OMDrawingToolLauncher.class, "panelGraphicAttributes", "Graphic Attributes:"));
        GridBagLayout gridbag = new GridBagLayout();
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 10;
        panel.setLayout(gridbag);
        String interString = this.i18n.get(OMDrawingToolLauncher.class, "panelRenderingType", "Rendering Type:");
        JPanel panel2 = new JPanel();
        JLabel renderTypeLabel = new JLabel(interString);
        panel2.add(renderTypeLabel);
        panel2.add(renderTypeList);
        this.panel3 = new JPanel();
        this.updateDrawingAttributesGUI();
        gridbag.setConstraints(panel2, c);
        panel.add(panel2);
        gridbag.setConstraints(this.panel3, c);
        panel.add(this.panel3);
        palette.add(panel);
        this.createButton = new JButton(this.i18n.get(OMDrawingToolLauncher.class, "createButton", "Create Graphic"));
        this.createButton.setActionCommand(CreateCmd);
        this.createButton.addActionListener(this);
        JPanel dismissBox = new JPanel();
        JButton dismiss = new JButton(this.i18n.get(OMDrawingToolLauncher.class, "dismiss", "Close"));
        dismissBox.setLayout(new BoxLayout(dismissBox, 0));
        dismissBox.setAlignmentX(0.5f);
        dismissBox.setAlignmentY(1.0f);
        dismissBox.add(this.createButton);
        dismissBox.add(dismiss);
        this.setLayout(new BoxLayout(this, 1));
        this.setAlignmentX(0.5f);
        this.setAlignmentY(1.0f);
        this.add(palette);
        this.add(dismissBox);
        dismiss.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                OMDrawingToolLauncher.this.getWindowSupport().killWindow();
            }
        });
    }

    protected void updateDrawingAttributesGUI() {
        this.panel3.removeAll();
        String interString = this.i18n.get(OMDrawingToolLauncher.class, "panelLineColorTypes", "Line/Colors:");
        JLabel lcLabel = new JLabel(interString);
        this.panel3.add(lcLabel);
        this.panel3.add(this.defaultGraphicAttributes.getGUI());
    }

    protected JComponent getToolWidgets() {
        JPanel iconBar = new JPanel();
        iconBar.setLayout(new GridLayout(2, 4));
        ButtonGroup bg = new ButtonGroup();
        JToggleButton btn = null;
        boolean setFirstButtonSelected = true;
        for (LoaderHolder lh : this.loaders) {
            String pName = lh.prettyName;
            EditToolLoader etl = lh.loader;
            ImageIcon icon = etl.getIcon(this.getEditableClassName(pName));
            btn = new JToggleButton(icon);
            btn.setMargin(new Insets(0, 0, 0, 0));
            btn.setToolTipText(pName);
            btn.setActionCommand(pName);
            btn.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent ae) {
                    OMDrawingToolLauncher.this.setCurrentCreation(ae.getActionCommand());
                }
            });
            if (setFirstButtonSelected) {
                btn.setSelected(true);
                this.setCurrentCreation(pName);
                setFirstButtonSelected = false;
            }
            bg.add(btn);
            iconBar.add(btn);
        }
        return iconBar;
    }

    protected JComponent getToolWidgets(boolean useText) {
        if (useText) {
            Vector<String> editables = new Vector<String>();
            for (LoaderHolder lh : this.loaders) {
                editables.add(lh.prettyName);
            }
            return this.createToolOptionMenu(editables);
        }
        return this.createToolButtonPanel();
    }

    private JComboBox createToolOptionMenu(Vector<String> editables) {
        String[] toolNames = new String[editables.size()];
        for (int i = 0; i < toolNames.length; ++i) {
            toolNames[i] = editables.elementAt(i);
            if (!Debug.debugging("omdtl")) continue;
            Debug.output("Adding TOOL " + toolNames[i] + " to menu");
        }
        JComboBox<String> tools = new JComboBox<String>(toolNames);
        tools.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                JComboBox jcb = (JComboBox)e.getSource();
                String currentChoice = (String)jcb.getSelectedItem();
                OMDrawingToolLauncher.this.setCurrentCreation(currentChoice);
            }
        });
        if (toolNames.length > 0) {
            tools.setSelectedIndex(0);
        }
        return tools;
    }

    private JPanel createToolButtonPanel() {
        JPanel panel = new JPanel();
        GridBagLayout gridbag = new GridBagLayout();
        GridBagConstraints c = new GridBagConstraints();
        c.gridwidth = 0;
        panel.setLayout(gridbag);
        ButtonGroup bg = new ButtonGroup();
        int toolbarCount = 0;
        boolean limitWidth = false;
        if (this.maxHorNumLoaderButtons >= 0) {
            limitWidth = true;
        }
        JToolBar iconBar = null;
        boolean activeSet = false;
        for (LoaderHolder lh : this.loaders) {
            if (toolbarCount == 0) {
                iconBar = new JToolBar();
                iconBar.setFloatable(false);
                gridbag.setConstraints(iconBar, c);
                panel.add(iconBar);
            }
            String pName = lh.prettyName;
            EditToolLoader etl = lh.loader;
            ImageIcon icon = etl.getIcon(this.getEditableClassName(pName));
            JToggleButton btn = new JToggleButton(icon, !activeSet);
            btn.setToolTipText(pName);
            btn.setActionCommand(pName);
            btn.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent ae) {
                    OMDrawingToolLauncher.this.setCurrentCreation(ae.getActionCommand());
                }
            });
            bg.add(btn);
            if (iconBar != null) {
                iconBar.add(btn);
            }
            ++toolbarCount;
            if (!activeSet) {
                this.setCurrentCreation(pName);
                activeSet = true;
            }
            if (!limitWidth || toolbarCount < this.maxHorNumLoaderButtons) continue;
            toolbarCount = 0;
        }
        return panel;
    }

    public void setCurrentRequestor(String name) {
        if (name == null) {
            return;
        }
        for (DrawingToolRequestor dtr : this.drawingToolRequestors) {
            if (!name.equals(dtr.getName())) continue;
            this.currentRequestor = dtr;
            return;
        }
        this.currentRequestor = null;
    }

    public void setCurrentCreation(String name) {
        this.currentCreation = this.getEditableClassName(name);
    }

    public String getEditableClassName(String prettyName) {
        for (LoaderHolder lh : this.loaders) {
            EditToolLoader etl = lh.loader;
            String[] ec = etl.getEditableClasses();
            for (int i = 0; i < ec.length; ++i) {
                if (!prettyName.equals(etl.getPrettyName(ec[i]))) continue;
                this.defaultGraphicAttributes.setEnableFillPaintChoice(!(etl instanceof NonRegional));
                this.updateDrawingAttributesGUI();
                this.panel3.revalidate();
                return ec[i];
            }
        }
        return null;
    }

    @Override
    public void findAndInit(Object someObj) {
        if (someObj instanceof OMDrawingTool) {
            Debug.message("omdtl", "OMDrawingToolLauncher found a DrawingTool.");
            this.setDrawingTool((DrawingTool)someObj);
        }
        if (someObj instanceof DrawingToolRequestor) {
            if (Debug.debugging("omdtl")) {
                Debug.output("OMDrawingToolLauncher found a DrawingToolRequestor - " + ((DrawingToolRequestor)someObj).getName());
            }
            this.drawingToolRequestors.add((DrawingToolRequestor)someObj);
            this.resetCombo();
        }
    }

    @Override
    public void findAndUndo(Object someObj) {
        if (someObj instanceof OMDrawingTool) {
            Debug.message("omdtl", "OMDrawingToolLauncher found a DrawingTool.");
            OMDrawingTool dt = (OMDrawingTool)someObj;
            if (dt == this.getDrawingTool()) {
                this.setDrawingTool(null);
                dt.removePropertyChangeListener(this);
            }
        }
        if (someObj instanceof DrawingToolRequestor) {
            if (Debug.debugging("omdtl")) {
                Debug.output("OMDrawingToolLauncher removing a DrawingToolRequestor - " + ((DrawingToolRequestor)someObj).getName());
            }
            this.drawingToolRequestors.remove((DrawingToolRequestor)someObj);
            if (this.drawingToolRequestors.isEmpty()) {
                this.getWindowSupport().killWindow();
                this.currentRequestor = null;
            }
            this.resetCombo();
            this.setRequestor(null);
        }
    }

    @Override
    public Container getFace() {
        GridBagToolBar jtb = null;
        if (this.getUseAsTool()) {
            jtb = new GridBagToolBar();
            JButton drawingToolButton = new JButton(new ImageIcon(OMDrawingToolLauncher.class.getResource("Drawing.gif"), this.i18n.get(OMDrawingToolLauncher.class, "drawingToolButton", 3, "Drawing Tool Launcher")));
            drawingToolButton.setToolTipText(this.i18n.get(OMDrawingToolLauncher.class, "drawingToolButton", 3, "Drawing Tool Launcher"));
            drawingToolButton.addActionListener(this.getActionListener());
            ((Container)jtb).add(drawingToolButton);
        }
        return jtb;
    }

    public ActionListener getActionListener() {
        return new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MapHandler mh = (MapHandler)OMDrawingToolLauncher.this.getBeanContext();
                Frame frame = null;
                if (mh != null) {
                    frame = mh.get(Frame.class);
                }
                OMDrawingToolLauncher.this.getWindowSupport().displayInWindow(frame, -1, -1, -1, -1);
            }
        };
    }

    public GraphicAttributes getDefaultGraphicAttributes() {
        return this.defaultGraphicAttributes;
    }

    public void setDefaultGraphicAttributes(GraphicAttributes ga) {
        this.defaultGraphicAttributes = ga;
    }

    public void setLoaders(Iterator<EditToolLoader> iterator) {
        this.loaders.clear();
        while (iterator.hasNext()) {
            this.addLoader(iterator.next());
        }
    }

    public Iterator<LoaderHolder> getLoaders() {
        return this.loaders.iterator();
    }

    public void addLoader(EditToolLoader etl) {
        if (etl != null) {
            String[] classNames = etl.getEditableClasses();
            for (int i = 0; i < classNames.length; ++i) {
                this.loaders.add(new LoaderHolder(etl.getPrettyName(classNames[i]), etl));
            }
        }
    }

    public void removeLoader(EditToolLoader etl) {
        if (etl != null) {
            for (LoaderHolder lh : this.loaders) {
                if (lh.loader != etl) continue;
                this.loaders.remove(lh);
            }
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent pce) {
        Object obj;
        if (pce.getPropertyName() == "OMDrawingTool.loaders" && (obj = pce.getNewValue()) instanceof Vector) {
            Vector loaders = (Vector)obj;
            this.setLoaders(loaders.iterator());
            this.resetGUI();
        }
    }

    @Override
    public void setProperties(String prefix, Properties props) {
        super.setProperties(prefix, props);
        prefix = PropUtils.getScopedPropertyPrefix(prefix);
        this.maxHorNumLoaderButtons = PropUtils.intFromProperties(props, prefix + HorizontalNumberOfLoaderButtonsProperty, this.maxHorNumLoaderButtons);
        this.useTextEditToolTitles = PropUtils.booleanFromProperties(props, prefix + UseLoaderTextProperty, this.useTextEditToolTitles);
    }

    @Override
    public Properties getProperties(Properties props) {
        props = super.getProperties(props);
        String prefix = PropUtils.getScopedPropertyPrefix(this);
        props.put(prefix + HorizontalNumberOfLoaderButtonsProperty, Integer.toString(this.maxHorNumLoaderButtons));
        props.put(prefix + UseLoaderTextProperty, new Boolean(this.useTextEditToolTitles).toString());
        return props;
    }

    @Override
    public Properties getPropertyInfo(Properties props) {
        props = super.getPropertyInfo(props);
        String internString = this.i18n.get(OMDrawingToolLauncher.class, HorizontalNumberOfLoaderButtonsProperty, 3, "Number of loader buttons to place horizontally");
        props.put(HorizontalNumberOfLoaderButtonsProperty, internString);
        internString = this.i18n.get(OMDrawingToolLauncher.class, HorizontalNumberOfLoaderButtonsProperty, "# Horizontal Buttons");
        props.put("horizNumLoaderButtons.label", internString);
        internString = this.i18n.get(OMDrawingToolLauncher.class, UseLoaderTextProperty, 3, "Use text popup for loader selection.");
        props.put(UseLoaderTextProperty, internString);
        internString = this.i18n.get(OMDrawingToolLauncher.class, UseLoaderTextProperty, "Use Text For Selection");
        props.put("useTextLabels.label", internString);
        return props;
    }

    public static class LoaderHolder {
        public String prettyName;
        public EditToolLoader loader;

        public LoaderHolder(String pn, EditToolLoader etl) {
            this.prettyName = pn;
            this.loader = etl;
        }
    }
}

