/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.proj;

import com.bbn.openmap.proj.Length;
import com.bbn.openmap.proj.Projection;
import com.bbn.openmap.util.Debug;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Point;
import java.awt.Shape;
import java.awt.geom.GeneralPath;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Proj
implements Projection,
Cloneable,
Serializable {
    public static final transient int MIN_WIDTH = 10;
    public static final transient int MIN_HEIGHT = 10;
    protected int width = 640;
    protected int height = 480;
    protected double minscale = 1.0;
    protected double maxscale;
    protected double scale = this.maxscale = Double.MAX_VALUE;
    protected double centerX;
    protected double centerY;
    protected String projID = null;
    protected double rotationAngle = 0.0;
    protected Length ucuom = null;

    public Proj(Point2D center, float s, int w, int h) {
        if (Debug.debugging("proj")) {
            Debug.output("Proj()");
        }
        this.setParms(center, s, w, h);
        this.projID = null;
    }

    public void setScale(float s) {
        this.scale = s;
        if (this.scale < this.minscale) {
            this.scale = this.minscale;
        } else if (this.scale > this.maxscale) {
            this.scale = this.maxscale;
        }
        this.computeParameters();
        this.projID = null;
    }

    public void setMinScale(float s) {
        if ((double)s > this.maxscale) {
            return;
        }
        this.minscale = s;
        if (this.scale < this.minscale) {
            this.scale = this.minscale;
        }
        this.computeParameters();
        this.projID = null;
    }

    public void setMaxScale(float s) {
        if ((double)s < this.minscale) {
            return;
        }
        this.maxscale = s;
        if (this.scale > this.maxscale) {
            this.scale = this.maxscale;
        }
        this.computeParameters();
        this.projID = null;
    }

    @Override
    public float getScale() {
        return (float)this.scale;
    }

    @Override
    public float getMaxScale() {
        return (float)this.maxscale;
    }

    @Override
    public float getMinScale() {
        return (float)this.minscale;
    }

    public void setCenter(Point2D pt) {
        this.setCenter(pt.getY(), pt.getX());
    }

    public void setCenter(double y, double x) {
        this.centerX = x;
        this.centerY = y;
        this.computeParameters();
        this.projID = null;
    }

    public Point2D getCenter() {
        return this.getCenter(new Point2D.Double());
    }

    @Override
    public <T extends Point2D> T getCenter(T center) {
        center.setLocation(this.centerX, this.centerY);
        return center;
    }

    public void setWidth(int width) {
        this.width = width;
        if (this.width < 10) {
            Debug.message("proj", "Proj.setWidth: width too small!");
            this.width = 10;
        }
        this.computeParameters();
        this.projID = null;
    }

    public void setHeight(int height) {
        this.height = height;
        if (this.height < 10) {
            Debug.message("proj", "Proj.setHeight: height too small!");
            this.height = 10;
        }
        this.computeParameters();
        this.projID = null;
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    @Override
    public int getHeight() {
        return this.height;
    }

    protected void setParms(Point2D center, float scale, int width, int height) {
        this.centerX = center.getX();
        this.centerY = center.getY();
        this.scale = scale;
        this.width = width;
        if (this.width < 10) {
            Debug.message("proj", "Proj.setParms: width too small!");
            this.width = 10;
        }
        this.height = height;
        if (this.height < 10) {
            Debug.message("proj", "Proj.setParms: height too small!");
            this.height = 10;
        }
        this.init();
        if (this.scale < this.minscale) {
            this.scale = this.minscale;
        } else if (this.scale > this.maxscale) {
            this.scale = this.maxscale;
        }
        this.computeParameters();
        this.projID = null;
    }

    protected void init() {
    }

    protected void setProjectionID() {
        this.projID = this.getClass().getName() + ":" + this.scale + ":" + this.centerX + ":" + this.centerY + ":" + this.width + ":" + this.height + ":" + this.rotationAngle;
    }

    @Override
    public String getProjectionID() {
        if (this.projID == null) {
            this.setProjectionID();
        }
        return this.projID;
    }

    protected abstract void computeParameters();

    public String toString() {
        return " center(" + this.centerX + ":" + this.centerY + ") scale=" + this.scale + " maxscale=" + this.maxscale + " minscale=" + this.minscale + " width=" + this.width + " height=" + this.height + "]";
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (this.getClass() != o.getClass()) {
            return false;
        }
        return this.getProjectionID().equals(((Projection)o).getProjectionID());
    }

    public int hashCode() {
        return this.getProjectionID().hashCode();
    }

    @Override
    public Projection makeClone() {
        return (Projection)this.clone();
    }

    public Object clone() {
        try {
            return (Proj)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError();
        }
    }

    @Override
    public Point2D forward(Point2D llp) {
        return this.forward(llp.getY(), llp.getX(), (Point2D)new Point2D.Float());
    }

    @Override
    public Point2D forward(Point2D llp, Point2D pt) {
        return this.forward(llp.getY(), llp.getX(), pt);
    }

    @Override
    public Point2D forward(float lat, float lon) {
        return this.forward((double)lat, (double)lon, (Point2D)new Point2D.Float());
    }

    @Override
    public Point2D forward(float lat, float lon, Point2D pt) {
        return this.forward((double)lat, (double)lon, pt);
    }

    @Override
    public Point2D forward(double lat, double lon) {
        return this.forward(lat, lon, (Point2D)new Point2D.Double());
    }

    @Override
    public abstract Point2D forward(double var1, double var3, Point2D var5);

    @Override
    public <T extends Point2D> T inverse(Point2D point, T llpt) {
        return this.inverse(point.getX(), point.getY(), llpt);
    }

    public Point2D inverse(Point2D point) {
        return this.inverse(point.getX(), point.getY(), new Point2D.Double());
    }

    public Point2D inverse(double x, double y) {
        return this.inverse(x, y, new Point2D.Double());
    }

    @Override
    public abstract <T extends Point2D> T inverse(double var1, double var3, T var5);

    @Override
    public Shape forwardShape(Shape shape) {
        PathIterator pi = shape.getPathIterator(null);
        double[] coords = new double[6];
        Point2D.Double world = new Point2D.Double();
        Point2D.Double world2 = new Point2D.Double();
        Point2D.Double world3 = new Point2D.Double();
        Point screen = new Point();
        Point screen2 = new Point();
        Point screen3 = new Point();
        GeneralPath path = new GeneralPath(0);
        while (!pi.isDone()) {
            int type = pi.currentSegment(coords);
            ((Point2D)world).setLocation(coords[0], coords[1]);
            this.forward(world, screen);
            if (type == 0) {
                path.moveTo(screen.x, screen.y);
            } else if (type == 1) {
                path.lineTo(screen.x, screen.y);
            } else if (type == 4) {
                path.closePath();
            } else {
                ((Point2D)world2).setLocation(coords[2], coords[3]);
                this.forward(world2, screen2);
                if (type == 2) {
                    path.quadTo(screen.x, screen.y, screen2.x, screen2.y);
                } else if (type == 3) {
                    ((Point2D)world3).setLocation(coords[4], coords[5]);
                    this.forward(world3, screen3);
                    path.curveTo(screen.x, screen.y, screen2.x, screen2.y, screen3.x, screen3.y);
                }
            }
            pi.next();
        }
        return path;
    }

    @Override
    public boolean forwardRaw(float[] rawllpts, int rawoff, float[] xcoords, float[] ycoords, boolean[] visible, int copyoff, int copylen) {
        Point temp = new Point();
        int end = copylen + copyoff;
        int i = copyoff;
        int j = rawoff;
        while (i < end) {
            this.forward(rawllpts[j], rawllpts[j + 1], (Point2D)temp);
            xcoords[i] = temp.x;
            ycoords[i] = temp.y;
            visible[i] = true;
            ++i;
            j += 2;
        }
        return true;
    }

    @Override
    public boolean forwardRaw(double[] rawllpts, int rawoff, float[] xcoords, float[] ycoords, boolean[] visible, int copyoff, int copylen) {
        Point temp = new Point();
        int end = copylen + copyoff;
        int i = copyoff;
        int j = rawoff;
        while (i < end) {
            this.forward(rawllpts[j], rawllpts[j + 1], (Point2D)temp);
            xcoords[i] = temp.x;
            ycoords[i] = temp.y;
            visible[i] = true;
            ++i;
            j += 2;
        }
        return true;
    }

    @Override
    public ArrayList<float[]> forwardLine(Point2D ll1, Point2D ll2) {
        double[] rawllpts = new double[]{ll1.getY(), ll1.getX(), ll2.getY(), ll2.getX()};
        return this.forwardPoly(rawllpts, false);
    }

    @Override
    public ArrayList<float[]> forwardRect(Point2D ll1, Point2D ll2) {
        double[] rawllpts = new double[]{ll1.getY(), ll1.getX(), ll1.getY(), ll2.getX(), ll2.getY(), ll2.getX(), ll2.getY(), ll1.getX(), ll1.getY(), ll1.getX()};
        return this.forwardPoly(rawllpts, true);
    }

    @Override
    public ArrayList<float[]> forwardPoly(float[] rawllpts, boolean isFilled) {
        int len = rawllpts.length >> 1;
        if (len < 2) {
            return new ArrayList<float[]>(0);
        }
        Point temp = new Point(0, 0);
        float[] xs = new float[len];
        float[] ys = new float[len];
        this.forward(rawllpts[0], rawllpts[1], (Point2D)temp);
        xs[0] = temp.x;
        ys[0] = temp.y;
        int n = 1;
        int k = 2;
        while (n < len) {
            this.forward(rawllpts[k], rawllpts[k + 1], (Point2D)temp);
            xs[n] = temp.x;
            ys[n] = temp.y;
            ++n;
            k += 2;
        }
        ArrayList<float[]> ret_val = null;
        ret_val = new ArrayList<float[]>(2);
        ret_val.add(xs);
        ret_val.add(ys);
        return ret_val;
    }

    @Override
    public ArrayList<float[]> forwardPoly(double[] rawllpts, boolean isFilled) {
        int len = rawllpts.length >> 1;
        if (len < 2) {
            return new ArrayList<float[]>(0);
        }
        Point temp = new Point(0, 0);
        float[] xs = new float[len];
        float[] ys = new float[len];
        this.forward(rawllpts[0], rawllpts[1], (Point2D)temp);
        xs[0] = temp.x;
        ys[0] = temp.y;
        int n = 1;
        int k = 2;
        while (n < len) {
            this.forward(rawllpts[k], rawllpts[k + 1], (Point2D)temp);
            xs[n] = temp.x;
            ys[n] = temp.y;
            ++n;
            k += 2;
        }
        ArrayList<float[]> ret_val = null;
        ret_val = new ArrayList<float[]>(2);
        ret_val.add(xs);
        ret_val.add(ys);
        return ret_val;
    }

    @Override
    public abstract void pan(float var1, float var2);

    @Override
    public abstract void pan(float var1);

    public final void panNW() {
        this.pan(-45.0f);
    }

    public final void panNW(float c) {
        this.pan(-45.0f);
    }

    public final void panN() {
        this.pan(0.0f);
    }

    public final void panN(float c) {
        this.pan(0.0f);
    }

    public final void panNE() {
        this.pan(45.0f);
    }

    public final void panNE(float c) {
        this.pan(45.0f);
    }

    public final void panE() {
        this.pan(90.0f);
    }

    public final void panE(float c) {
        this.pan(90.0f);
    }

    public final void panSE() {
        this.pan(135.0f);
    }

    public final void panSE(float c) {
        this.pan(135.0f);
    }

    public final void panS() {
        this.pan(180.0f);
    }

    public final void panS(float c) {
        this.pan(180.0f);
    }

    public final void panSW() {
        this.pan(-135.0f);
    }

    public final void panSW(float c) {
        this.pan(-135.0f);
    }

    public final void panW() {
        this.pan(-90.0f);
    }

    public final void panW(float c) {
        this.pan(-90.0f);
    }

    @Override
    public boolean isPlotable(float lat, float lon) {
        return this.isPlotable((double)lat, (double)lon);
    }

    @Override
    public boolean isPlotable(Point2D point) {
        return this.isPlotable(point.getY(), point.getX());
    }

    public void drawBackground(Graphics2D g, Paint paint) {
        g.setPaint(paint);
        this.drawBackground(g);
    }

    public void drawBackground(Graphics g) {
        g.fillRect(0, 0, this.getWidth(), this.getHeight());
    }

    @Override
    public String getName() {
        return "Proj";
    }

    public abstract float getScale(Point2D var1, Point2D var2, Point2D var3, Point2D var4);

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.computeParameters();
        this.projID = null;
    }

    @Override
    public Length getUcuom() {
        return this.ucuom;
    }

    public void setUcuom(Length ucuom) {
        this.ucuom = ucuom;
    }

    public Point2D getUpperLeft() {
        return this.inverse(0.0, 0.0, new Point2D.Double());
    }

    public Point2D getLowerRight() {
        return this.inverse(this.width, this.height, new Point2D.Double());
    }

    @Override
    public double getRotationAngle() {
        return this.rotationAngle;
    }

    public void setRotationAngle(double rotationAngle) {
        this.rotationAngle = rotationAngle;
    }
}

