/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.proj;

import com.bbn.openmap.proj.BasicProjectionLoader;
import com.bbn.openmap.proj.CADRG;
import com.bbn.openmap.proj.Projection;
import com.bbn.openmap.proj.ProjectionException;
import com.bbn.openmap.proj.ProjectionLoader;
import com.bbn.openmap.proj.coords.LatLonPoint;
import com.bbn.openmap.util.Debug;
import com.bbn.openmap.util.PropUtils;
import java.awt.geom.Point2D;
import java.util.Properties;

public class CADRGLoader
extends BasicProjectionLoader
implements ProjectionLoader {
    public CADRGLoader() {
        super(CADRG.class, "CADRG", "Equal-Arc projection for displaying RPF data (CADRG and CIB).");
    }

    public Projection create(Properties props) throws ProjectionException {
        try {
            LatLonPoint llp = this.convertToLLP((Point2D)props.get("CENTER"));
            float scale = PropUtils.floatFromProperties(props, "SCALE", 1.0E7f);
            int height = PropUtils.intFromProperties(props, "HEIGHT", 100);
            int width = PropUtils.intFromProperties(props, "WIDTH", 100);
            return new CADRG(llp, scale, width, height);
        }
        catch (Exception e) {
            if (Debug.debugging("proj")) {
                Debug.output("CADRGLoader: problem creating CADRG projection " + e.getMessage());
            }
            throw new ProjectionException("CADRGLoader: problem creating CADRG projection");
        }
    }
}

