/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.omGraphics.editable;

import com.bbn.openmap.omGraphics.EditableOMGraphic;
import com.bbn.openmap.omGraphics.EditableOMPoly;
import com.bbn.openmap.omGraphics.GrabPoint;
import com.bbn.openmap.omGraphics.editable.EOMGCursors;
import com.bbn.openmap.util.Debug;
import com.bbn.openmap.util.stateMachine.State;
import java.awt.event.MouseEvent;

public class PolyDeleteNodeState
extends State {
    protected EditableOMGraphic graphic;

    public PolyDeleteNodeState(EditableOMPoly eomg) {
        this.graphic = eomg;
    }

    public boolean mouseReleased(MouseEvent e) {
        int index;
        Debug.message("eomg", "GraphicStateMachine|delete node state|mouseReleased");
        GrabPoint mp = this.graphic.getMovingPoint(e);
        if (mp != null && (index = ((EditableOMPoly)this.graphic).whichGrabPoint(mp)) != EditableOMPoly.OFFSET_POINT_INDEX) {
            ((EditableOMPoly)this.graphic).deletePoint(index);
            this.graphic.fireEvent(EOMGCursors.DEFAULT, "", e, 6);
            this.graphic.fireEvent(2);
        }
        this.graphic.getStateMachine().setSelected();
        this.graphic.redraw(e, true);
        return false;
    }

    public boolean mouseMoved(MouseEvent e) {
        Debug.message("eomgdetail", "PolyStateMachine|delete node state|mouseMoved");
        GrabPoint mp = this.graphic.getMovingPoint(e);
        if (mp != null) {
            this.graphic.fireEvent(EOMGCursors.EDIT, this.i18n.get(PolyDeleteNodeState.class, "Click_a_node_to_delete_it.", "Click a node to delete it."), -1);
        } else {
            this.graphic.fireEvent(EOMGCursors.DEFAULT, this.i18n.get(PolyDeleteNodeState.class, "Click_a_node_to_delete_it.", "Click a node to delete it."), -1);
        }
        return false;
    }

    public boolean mouseDragged(MouseEvent e) {
        Debug.message("eomgdetail", "PolyStateMachine|delete node state|mouseDragged");
        if (this.graphic.getGraphic().distance(e.getX(), e.getY()) < 2.0f) {
            this.graphic.fireEvent(EOMGCursors.EDIT, this.i18n.get(PolyDeleteNodeState.class, "Release_over_a_node_to_delete_it.", "Release over a node to delete it."), -1);
        } else {
            this.graphic.fireEvent(EOMGCursors.DEFAULT, this.i18n.get(PolyDeleteNodeState.class, "Release_over_a_node_to_delete_it.", "Release over a node to delete it."), -1);
        }
        return false;
    }
}

