/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.omGraphics;

import com.bbn.openmap.omGraphics.GrabPoint;
import com.bbn.openmap.omGraphics.HorizontalGrabPoint;
import com.bbn.openmap.omGraphics.VerticalGrabPoint;
import com.bbn.openmap.util.Debug;
import java.util.Hashtable;

public class OffsetGrabPoint
extends GrabPoint {
    protected Hashtable<GrabPoint, Offset> offsetPoints = new Hashtable();
    protected boolean overflowLock = false;

    public OffsetGrabPoint(int x, int y) {
        this(x, y, 3);
    }

    public OffsetGrabPoint(int x, int y, int radius) {
        super(x, y, radius);
    }

    public GrabPoint addGrabPoint(GrabPoint gp) {
        if (gp == null) {
            Debug.error("OffsetGrabPoint: adding null grab point!");
            return null;
        }
        if (this.offsetPoints == null) {
            this.offsetPoints = new Hashtable();
        }
        this.offsetPoints.put(gp, new Offset(gp));
        return gp;
    }

    public GrabPoint removeGrabPoint(GrabPoint rgp) {
        Offset offset;
        if (this.offsetPoints != null && (offset = this.offsetPoints.remove(rgp)) != null) {
            return offset.gp;
        }
        return null;
    }

    public void set(int x, int y) {
        super.set(x, y);
    }

    public void setX(int x) {
        super.setX(x);
    }

    public void setY(int y) {
        super.setY(y);
    }

    public void set() {
        this.updateOffsets();
    }

    public synchronized void moveOffsets() {
        if (!this.overflowLock) {
            this.overflowLock = true;
            for (Offset offset : this.offsetPoints.values()) {
                offset.move();
            }
            this.overflowLock = false;
        }
    }

    public synchronized void updateOffsets() {
        if (!this.overflowLock) {
            this.overflowLock = true;
            for (Offset offset : this.offsetPoints.values()) {
                offset.update();
            }
            this.overflowLock = false;
        }
    }

    public void clear() {
        this.offsetPoints.clear();
    }

    protected void finalize() {
        this.offsetPoints.clear();
    }

    public class Offset {
        public GrabPoint gp;
        public int offsetX;
        public int offsetY;

        public Offset(GrabPoint grabPoint) {
            this.gp = grabPoint;
            this.update();
        }

        public void update() {
            this.offsetX = this.gp.getX() - OffsetGrabPoint.this.getX();
            this.offsetY = this.gp.getY() - OffsetGrabPoint.this.getY();
            if (this.gp instanceof OffsetGrabPoint) {
                ((OffsetGrabPoint)this.gp).updateOffsets();
            }
        }

        public void move() {
            int newX = OffsetGrabPoint.this.getX() + this.offsetX;
            int newY = OffsetGrabPoint.this.getY() + this.offsetY;
            if (this.gp instanceof HorizontalGrabPoint) {
                ((HorizontalGrabPoint)this.gp).set(newX, newY, true);
            } else if (this.gp instanceof VerticalGrabPoint) {
                ((VerticalGrabPoint)this.gp).set(newX, newY, true);
            } else {
                this.gp.set(newX, newY);
            }
            if (this.gp instanceof OffsetGrabPoint) {
                ((OffsetGrabPoint)this.gp).moveOffsets();
            }
        }
    }
}

