/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.omGraphics;

import com.bbn.openmap.omGraphics.DrawingAttributes;
import com.bbn.openmap.omGraphics.OMGeometry;
import com.bbn.openmap.omGraphics.OMGraphic;
import com.bbn.openmap.omGraphics.OMGraphicConstants;
import com.bbn.openmap.omGraphics.OMLabeler;
import com.bbn.openmap.omGraphics.SinkGraphic;
import com.bbn.openmap.omGraphics.geom.BasicGeometry;
import com.bbn.openmap.proj.Projection;
import com.bbn.openmap.util.Debug;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Stroke;
import java.awt.TexturePaint;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;

public abstract class OMGraphicAdapter
extends BasicGeometry
implements OMGraphic,
OMGraphicConstants,
Cloneable,
Serializable {
    protected transient Stroke stroke = BASIC_STROKE;
    protected Paint linePaint = Color.black;
    protected Paint mattingPaint = Color.black;
    protected Paint displayPaint = this.linePaint;
    protected Paint fillPaint = clear;
    protected TexturePaint textureMask = null;
    protected Paint selectPaint = Color.black;
    protected boolean selected = false;
    protected boolean showEditablePalette = true;
    protected boolean edgeMatchesFill = false;
    protected int renderType = 0;
    protected int declutterType = 0;
    protected boolean matted = false;
    protected transient boolean hasLabel = false;

    public boolean isClear(Paint paint) {
        return DrawingAttributes.isClear(paint);
    }

    protected OMGraphicAdapter() {
    }

    protected OMGraphicAdapter(int rType, int lType, int dcType) {
        this.setRenderType(rType);
        this.setLineType(lType);
        this.setDeclutterType(dcType);
    }

    public OMGraphicAdapter(int rType, int lType, int dcType, Color lc, Color fc, Color sc) {
        this(rType, lType, dcType);
        this.setLinePaint(lc);
        this.setSelectPaint(sc);
        this.setFillPaint(fc);
    }

    public void setRenderType(int value) {
        if (this.renderType == value) {
            return;
        }
        this.setNeedToRegenerate(true);
        this.renderType = value;
    }

    public int getRenderType() {
        return this.renderType;
    }

    public void setDeclutterType(int value) {
        if (this.declutterType == value) {
            return;
        }
        this.setNeedToRegenerate(true);
        this.declutterType = value;
    }

    public int getDeclutterType() {
        return this.declutterType;
    }

    public void setGraphicsForEdge(Graphics g) {
        if (g instanceof Graphics2D) {
            ((Graphics2D)g).setStroke(this.getStroke());
        }
        this.setGraphicsColor(g, this.getDisplayPaint());
    }

    public void setGraphicsForFill(Graphics g) {
        if (g instanceof Graphics2D) {
            ((Graphics2D)g).setStroke(BASIC_STROKE);
        }
        this.setGraphicsColor(g, this.getFillPaint());
    }

    public void setGraphicsColor(Graphics g, Paint paint) {
        if (g instanceof Graphics2D) {
            ((Graphics2D)g).setPaint(paint);
        } else if (paint instanceof Color) {
            g.setColor((Color)paint);
        }
    }

    public void setLineColor(Color value) {
        this.setLinePaint(value);
    }

    public Color getLineColor() {
        if (this.linePaint instanceof Color) {
            return (Color)this.linePaint;
        }
        return null;
    }

    public void setLinePaint(Paint paint) {
        this.linePaint = paint != null ? paint : Color.black;
        if (!this.selected) {
            this.displayPaint = this.linePaint;
        }
        this.setEdgeMatchesFill();
    }

    public Paint getLinePaint() {
        return this.linePaint;
    }

    public void setSelectColor(Color value) {
        this.setSelectPaint(value);
    }

    public Color getSelectColor() {
        if (this.selectPaint instanceof Color) {
            return (Color)this.selectPaint;
        }
        return null;
    }

    public void setSelectPaint(Paint paint) {
        this.selectPaint = paint != null ? paint : Color.black;
        if (this.selected) {
            this.displayPaint = this.selectPaint;
        }
        this.setEdgeMatchesFill();
    }

    public Paint getSelectPaint() {
        return this.selectPaint;
    }

    public Color getDisplayColor() {
        if (this.displayPaint instanceof Color) {
            return (Color)this.displayPaint;
        }
        return null;
    }

    public Paint getDisplayPaint() {
        return this.displayPaint;
    }

    public void select() {
        this.selected = true;
        this.displayPaint = this.getSelectPaint();
        this.setEdgeMatchesFill();
    }

    public void deselect() {
        this.selected = false;
        this.displayPaint = this.getLinePaint();
        this.setEdgeMatchesFill();
    }

    public boolean isSelected() {
        return this.selected;
    }

    public void setSelected(boolean set) {
        if (set) {
            this.select();
        } else {
            this.deselect();
        }
    }

    public boolean isMatted() {
        return this.matted;
    }

    public void setMatted(boolean set) {
        this.matted = set;
    }

    public void setFillColor(Color value) {
        this.setFillPaint(value);
    }

    public Color getFillColor() {
        if (this.fillPaint instanceof Color) {
            return (Color)this.fillPaint;
        }
        return null;
    }

    public void setFillPaint(Paint paint) {
        if (paint != null) {
            this.fillPaint = paint;
            if (Debug.debugging("omGraphics")) {
                Debug.output("OMGraphic.setFillPaint(): fillPaint= " + this.fillPaint);
            }
        } else {
            this.fillPaint = clear;
            if (Debug.debugging("omGraphics")) {
                Debug.output("OMGraphic.setFillPaint(): fillPaint is clear");
            }
        }
        this.setEdgeMatchesFill();
    }

    public void setTextureMask(TexturePaint texture) {
        this.textureMask = texture;
    }

    public Paint getFillPaint() {
        return this.fillPaint;
    }

    public TexturePaint getTextureMask() {
        return this.textureMask;
    }

    protected void setEdgeMatchesFill() {
        Paint paint = this.getDisplayPaint();
        this.edgeMatchesFill = this.fillPaint instanceof Color && paint instanceof Color && !this.isClear(this.fillPaint) ? ((Color)this.fillPaint).equals((Color)paint) : false;
    }

    public boolean getEdgeMatchesFill() {
        return this.edgeMatchesFill;
    }

    public void setMattingPaint(Paint mPaint) {
        this.mattingPaint = mPaint;
    }

    public Paint getMattingPaint() {
        return this.mattingPaint;
    }

    public void setStroke(Stroke s) {
        this.stroke = s != null ? s : BASIC_STROKE;
    }

    public Stroke getStroke() {
        if (this.stroke == null) {
            this.stroke = BASIC_STROKE;
        }
        return this.stroke;
    }

    public void setShowEditablePalette(boolean set) {
        this.showEditablePalette = set;
    }

    public boolean getShowEditablePalette() {
        return this.showEditablePalette;
    }

    public float normalizeDistanceForLineWidth(float distance) {
        float lineWidth = 1.0f;
        if (this.stroke instanceof BasicStroke) {
            lineWidth = ((BasicStroke)this.stroke).getLineWidth();
        }
        if (lineWidth > 1.0f && (distance -= lineWidth / 2.0f) < 0.0f) {
            distance = 0.0f;
        }
        return distance;
    }

    public abstract boolean generate(Projection var1);

    public void render(Graphics g) {
        this.renderShape(g);
        this.renderLabel(g);
    }

    protected void renderShape(Graphics g) {
        GeneralPath s = this.getShape();
        if (!this.isRenderable(s)) {
            return;
        }
        if (this.matted && g instanceof Graphics2D && this.stroke instanceof BasicStroke) {
            BasicStroke bs = (BasicStroke)this.stroke;
            ((Graphics2D)g).setStroke(new BasicStroke(bs.getLineWidth() + 2.0f, bs.getEndCap(), bs.getLineJoin()));
            this.setGraphicsColor(g, this.mattingPaint);
            this.draw(g, s);
        }
        if (this.shouldRenderFill()) {
            this.setGraphicsForFill(g);
            this.fill(g, s);
            if (this.textureMask != null && this.textureMask != this.fillPaint) {
                this.setGraphicsColor(g, this.textureMask);
                this.fill(g, s);
            }
        }
        if (this.shouldRenderEdge()) {
            this.setGraphicsForEdge(g);
            this.draw(g, s);
        }
    }

    protected void setHasLabel(boolean val) {
        this.hasLabel = val;
    }

    public boolean getHasLabel() {
        return this.hasLabel;
    }

    protected void initLabelingDuringGenerate() {
        this.setHasLabel(this.getAttribute("Label") != null);
    }

    public void setLabelLocation(int[] xpoints, int[] ypoints) {
        this.setLabelLocation(xpoints, ypoints, (Projection)null);
    }

    public void setLabelLocation(float[] xpoints, float[] ypoints) {
        this.setLabelLocation(xpoints, ypoints, null);
    }

    protected void setLabelLocation(int[] xpoints, int[] ypoints, Projection proj) {
        this.hasLabel = false;
        Object obj = this.getAttribute("Label");
        if (obj instanceof OMLabeler) {
            OMLabeler labeler = (OMLabeler)obj;
            if (xpoints != null && ypoints != null) {
                labeler.setLocation(xpoints, ypoints);
                this.hasLabel = true;
            }
            if (proj != null) {
                labeler.evaluateRotationAngle(proj);
            }
        }
    }

    public void setLabelLocation(float[] xpoints, float[] ypoints, Projection proj) {
        int[] xs = new int[xpoints.length];
        int[] ys = new int[ypoints.length];
        for (int i = 0; i < xpoints.length; ++i) {
            xs[i] = (int)xpoints[i];
            ys[i] = (int)ypoints[i];
        }
        this.setLabelLocation(xs, ys, proj);
    }

    public void setLabelLocation(Point2D p) {
        this.setLabelLocation(p, null);
    }

    protected void setLabelLocation(Point2D p, Projection proj) {
        this.hasLabel = false;
        Object obj = this.getAttribute("Label");
        if (obj instanceof OMLabeler) {
            OMLabeler labeler = (OMLabeler)obj;
            if (p != null) {
                labeler.setLocation(p);
                this.hasLabel = true;
            }
            if (proj != null) {
                labeler.evaluateRotationAngle(proj);
            }
        }
    }

    public void setLabelLocation(GeneralPath gp) {
        this.setLabelLocation(gp, null);
    }

    protected void setLabelLocation(GeneralPath gp, Projection proj) {
        this.hasLabel = false;
        Object obj = this.getAttribute("Label");
        if (obj instanceof OMLabeler) {
            OMLabeler labeler = (OMLabeler)obj;
            if (gp != null) {
                labeler.setLocation(gp);
                this.hasLabel = true;
            }
            if (proj != null) {
                labeler.evaluateRotationAngle(proj);
            }
        }
    }

    public void renderLabel(Graphics g) {
        OMLabeler labeler;
        if (this.hasLabel && (labeler = (OMLabeler)this.getAttribute("Label")) != null) {
            labeler.render(g);
        }
    }

    public boolean shouldRenderFill() {
        return !this.isClear(this.getFillPaint());
    }

    public boolean shouldRenderEdge() {
        return !this.isClear(this.getDisplayPaint()) || !this.edgeMatchesFill;
    }

    public float distance(double x, double y) {
        float lDistance;
        OMLabeler labeler;
        float distance = Float.POSITIVE_INFINITY;
        distance = this.shouldRenderFill() ? super.distance(x, y) : super.distanceToEdge(x, y);
        if (distance != Float.POSITIVE_INFINITY) {
            distance = this.normalizeDistanceForLineWidth(distance);
        }
        if (this.hasLabel && (labeler = (OMLabeler)this.getAttribute("Label")) != null && (lDistance = labeler.distance(x, y)) < distance) {
            distance = lDistance;
        }
        return distance;
    }

    public boolean regenerate(Projection proj) {
        boolean ret = false;
        if (proj != null) {
            ret = super.regenerate(proj);
        }
        return ret;
    }

    public boolean hasLineTypeChoice() {
        return true;
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            return SinkGraphic.getSharedInstance();
        }
    }

    private void writeObject(ObjectOutputStream oos) throws IOException {
        oos.defaultWriteObject();
        this.writeStroke(oos, this.stroke, BASIC_STROKE);
    }

    protected void writeStroke(ObjectOutputStream oos, Stroke stroke, Stroke defStroke) throws IOException {
        boolean writeStroke;
        boolean bl = writeStroke = stroke != defStroke && stroke != null;
        if (writeStroke) {
            oos.writeBoolean(true);
            if (stroke instanceof BasicStroke) {
                BasicStroke s = (BasicStroke)stroke;
                oos.writeBoolean(true);
                if (s != null) {
                    oos.writeFloat(s.getLineWidth());
                    oos.writeInt(s.getEndCap());
                    oos.writeInt(s.getLineJoin());
                    oos.writeFloat(s.getMiterLimit());
                    oos.writeObject(s.getDashArray());
                    oos.writeFloat(s.getDashPhase());
                }
            } else if (stroke instanceof Serializable) {
                oos.writeBoolean(false);
                oos.writeObject((Serializable)((Object)stroke));
            }
        } else {
            oos.writeBoolean(false);
        }
    }

    private void readObject(ObjectInputStream ois) throws ClassNotFoundException, IOException {
        ois.defaultReadObject();
        this.stroke = this.readStroke(ois, BASIC_STROKE);
    }

    protected Stroke readStroke(ObjectInputStream ois, Stroke defStroke) throws ClassNotFoundException, IOException {
        Stroke stroke = defStroke;
        boolean streamHasStroke = ois.readBoolean();
        if (streamHasStroke) {
            boolean isBasicStroke = ois.readBoolean();
            if (isBasicStroke) {
                float linewidth = ois.readFloat();
                int endcap = ois.readInt();
                int linejoin = ois.readInt();
                float miterlimit = ois.readFloat();
                float[] dasharray = (float[])ois.readObject();
                float dashphase = ois.readFloat();
                stroke = new BasicStroke(linewidth, endcap, linejoin, miterlimit, dasharray, dashphase);
            } else {
                stroke = (Stroke)ois.readObject();
            }
        }
        return stroke;
    }

    public void restore(OMGeometry source) {
        super.restore(source);
        this.renderType = source.getRenderType();
        if (source instanceof OMGraphic) {
            OMGraphic omgSource = (OMGraphic)source;
            this.declutterType = omgSource.getDeclutterType();
            this.selected = omgSource.isSelected();
            this.showEditablePalette = omgSource.getShowEditablePalette();
            DrawingAttributes.sTransfer(omgSource, this);
        }
    }
}

