/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.layer.vpf;

import com.bbn.openmap.layer.vpf.DcwCrossTileID;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public interface TilingAdapter {
    public int getTileId(List<Object> var1);

    public int getPrimId(List<Object> var1);

    public int getTilePrimId(List<Object> var1);

    public DcwCrossTileID getPrim(List<Object> var1);

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class TiledAdapter
    implements TilingAdapter {
        private final int tilecolumn;
        private final int primcolumn;

        public TiledAdapter(int tilecolumn, int primcolumn) {
            this.tilecolumn = tilecolumn;
            this.primcolumn = primcolumn;
        }

        @Override
        public int getTileId(List<Object> l) {
            return ((Number)l.get(this.tilecolumn)).intValue();
        }

        @Override
        public int getPrimId(List<Object> l) {
            return this.getTilePrimId(l);
        }

        @Override
        public int getTilePrimId(List<Object> l) {
            return ((Number)l.get(this.primcolumn)).intValue();
        }

        @Override
        public DcwCrossTileID getPrim(List<Object> l) {
            return new DcwCrossTileID(this.getPrimId(l), this.getTileId(l), this.getTilePrimId(l));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class CrossTileAdapter
    implements TilingAdapter {
        private final int column;

        public CrossTileAdapter(int column) {
            this.column = column;
        }

        @Override
        public int getTileId(List<Object> l) {
            return this.getPrim(l).nextTileID;
        }

        @Override
        public int getPrimId(List<Object> l) {
            return this.getPrim(l).currentTileKey;
        }

        @Override
        public int getTilePrimId(List<Object> l) {
            return this.getPrim(l).nextTileKey;
        }

        @Override
        public DcwCrossTileID getPrim(List<Object> l) {
            return (DcwCrossTileID)l.get(this.column);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class UntiledAdapter
    implements TilingAdapter {
        private final int column;

        public UntiledAdapter(int column) {
            this.column = column;
        }

        @Override
        public int getTileId(List<Object> l) {
            return -1;
        }

        @Override
        public int getPrimId(List<Object> l) {
            return ((Number)l.get(this.column)).intValue();
        }

        @Override
        public int getTilePrimId(List<Object> l) {
            return ((Number)l.get(this.column)).intValue();
        }

        @Override
        public DcwCrossTileID getPrim(List<Object> l) {
            return new DcwCrossTileID(this.getPrimId(l), -1, this.getTilePrimId(l));
        }
    }
}

