/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.layer.shape;

import com.bbn.openmap.dataAccess.shape.ShapeUtils;
import com.bbn.openmap.layer.shape.ESRIBoundingBox;
import com.bbn.openmap.layer.shape.ESRIPointRecord;
import com.bbn.openmap.layer.shape.ESRIPolygonRecord;
import com.bbn.openmap.layer.shape.ESRIRecord;
import com.bbn.openmap.util.Debug;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.Vector;

public class ShapeFile
extends ShapeUtils {
    public static final int SHAPE_FILE_CODE = 9994;
    public static final int SHAPE_FILE_VERSION = 1000;
    public static final int DEFAULT_RECORD_BUFFER_SIZE = 50000;
    protected RandomAccessFile raf;
    protected byte[] header;
    protected long fileLength;
    protected int fileVersion;
    protected int fileShapeType;
    protected ESRIBoundingBox fileBounds;
    protected byte[] recHdr;
    protected byte[] recBuf;

    public ShapeFile(String name) throws IOException {
        this.raf = new RandomAccessFile(name, "rw");
        this.recHdr = new byte[8];
        this.recBuf = new byte[50000];
        this.initHeader();
    }

    public ShapeFile(File file) throws IOException {
        this(file.getPath());
    }

    protected void initHeader() throws IOException {
        int result = this.raf.read();
        if (result == -1) {
            this.writeHeader();
        }
        this.readHeader();
    }

    protected void writeHeader() throws IOException {
        this.header = new byte[100];
        ShapeFile.writeBEInt(this.header, 0, 9994);
        ShapeFile.writeBEInt(this.header, 24, 50);
        ShapeFile.writeLEInt(this.header, 28, 1000);
        ShapeFile.writeLEInt(this.header, 32, 0);
        ShapeFile.writeLEDouble(this.header, 36, 0.0);
        ShapeFile.writeLEDouble(this.header, 44, 0.0);
        ShapeFile.writeLEDouble(this.header, 52, 0.0);
        ShapeFile.writeLEDouble(this.header, 60, 0.0);
        this.raf.seek(0L);
        this.raf.write(this.header, 0, 100);
    }

    protected void readHeader() throws IOException {
        this.header = new byte[100];
        this.raf.seek(0L);
        this.raf.read(this.header, 0, 100);
        int fileCode = ShapeUtils.readBEInt(this.header, 0);
        if (fileCode != 9994) {
            throw new IOException("Invalid file code, probably not a shape file");
        }
        this.fileVersion = ShapeUtils.readLEInt(this.header, 28);
        if (this.fileVersion != 1000) {
            throw new IOException("Unable to read shape files with version " + this.fileVersion);
        }
        this.fileLength = ShapeUtils.readBEInt(this.header, 24);
        this.fileLength *= 2L;
        this.fileShapeType = ShapeUtils.readLEInt(this.header, 32);
        this.fileBounds = ShapeUtils.readBox(this.header, 36);
    }

    public long getFileLength() {
        return this.fileLength;
    }

    public int getFileVersion() {
        return this.fileVersion;
    }

    public int getShapeType() {
        return this.fileShapeType;
    }

    public void setShapeType(int newShapeType) throws IOException, IllegalArgumentException {
        if (this.fileShapeType != 0) {
            throw new IllegalArgumentException("file already has a valid shape type: " + this.fileShapeType);
        }
        this.fileShapeType = newShapeType;
        long filePtr = this.raf.getFilePointer();
        ShapeFile.writeLEInt(this.header, 32, this.fileShapeType);
        this.raf.seek(0L);
        this.raf.write(this.header, 0, 100);
        this.raf.seek(filePtr);
    }

    public ESRIBoundingBox getBoundingBox() {
        return this.fileBounds;
    }

    public ESRIRecord getNextRecord() throws IOException {
        int result = this.raf.read(this.recHdr, 0, 8);
        if (result == -1) {
            return null;
        }
        int contentLength = ShapeUtils.readBEInt(this.recHdr, 4);
        int bytesToRead = contentLength * 2;
        int fullRecordSize = bytesToRead + 8;
        if (this.recBuf.length < fullRecordSize) {
            if (Debug.debugging("shape")) {
                Debug.output("record size: " + fullRecordSize);
            }
            this.recBuf = new byte[fullRecordSize];
        }
        System.arraycopy(this.recHdr, 0, this.recBuf, 0, 8);
        this.raf.read(this.recBuf, 8, bytesToRead);
        switch (this.fileShapeType) {
            case 0: {
                throw new IOException("Can't parse NULL shape type");
            }
            case 1: {
                return new ESRIPointRecord(this.recBuf, 0);
            }
            case 3: {
                return new ESRIPolygonRecord(this.recBuf, 0);
            }
            case 5: {
                return new ESRIPolygonRecord(this.recBuf, 0);
            }
            case 8: {
                throw new IOException("Multipoint shape not yet implemented");
            }
        }
        throw new IOException("Unknown shape type: " + this.fileShapeType);
    }

    public void add(ESRIRecord r) throws IOException {
        if (r.getShapeType() == this.fileShapeType) {
            this.verifyRecordBuffer(r.getBinaryStoreSize());
            int nBytes = r.write(this.recBuf, 0);
            this.raf.seek(this.raf.length());
            this.raf.write(this.recBuf, 0, nBytes);
        } else {
            Debug.error("ShapeFile.add(): type=" + r.getShapeType() + " does not match file type=" + this.fileShapeType);
        }
    }

    public void close() throws IOException {
        this.raf.close();
        this.raf = null;
    }

    public void verify(boolean repair, boolean verbose) throws IOException {
        ESRIRecord r;
        boolean headerChanged = false;
        long fLen = this.raf.length();
        if (verbose) {
            Debug.output("Checking file length...");
            System.out.flush();
        }
        if (this.fileLength == fLen) {
            if (verbose) {
                Debug.output("correct.");
            }
        } else {
            if (verbose) {
                Debug.output("incorrect (got " + this.fileLength + ", should be " + fLen + ")");
            }
            if (repair) {
                this.fileLength = fLen;
                ShapeFile.writeBEInt(this.header, 24, (int)fLen / 2);
                headerChanged = true;
                if (verbose) {
                    Debug.output("...repaired.");
                }
            }
        }
        this.raf.seek(100L);
        int nRecords = 0;
        Vector<ESRIRecord> v = new Vector<ESRIRecord>();
        ESRIBoundingBox bounds = new ESRIBoundingBox();
        long recStart = this.raf.getFilePointer();
        byte[] intBuf = new byte[4];
        while ((r = this.getNextRecord()) != null) {
            long recEnd = this.raf.getFilePointer();
            v.addElement(r);
            if (r.getRecordNumber() != ++nRecords) {
                ShapeFile.writeBEInt(intBuf, 0, nRecords);
                this.raf.seek(recStart);
                this.raf.write(intBuf, 0, 4);
                this.raf.seek(recEnd);
            }
            if (this.fileShapeType == 0) {
                Debug.output("updating shape type in header.");
                this.fileShapeType = r.getShapeType();
                ShapeFile.writeLEInt(this.header, 32, this.fileShapeType);
                headerChanged = true;
            }
            if (r.getShapeType() != this.fileShapeType) {
                Debug.output("invalid shape type " + r.getShapeType() + ", expecting " + this.fileShapeType);
            }
            bounds.addBounds(r.getBoundingBox());
            recStart = recEnd;
        }
        if (!this.fileBounds.equals(bounds)) {
            Debug.output("adjusting bounds");
            Debug.output("from min: " + this.fileBounds.min);
            Debug.output("to min: " + bounds.min);
            Debug.output("from max: " + this.fileBounds.max);
            Debug.output("to max: " + bounds.max);
            ShapeFile.writeBox(this.header, 36, bounds);
            headerChanged = true;
            this.fileBounds = bounds;
        }
        if (headerChanged) {
            Debug.output("writing changed header");
            this.raf.seek(0L);
            this.raf.write(this.header, 0, 100);
        }
    }

    protected void verifyRecordBuffer(int size) {
        if (this.recBuf.length < size) {
            this.recBuf = new byte[size];
        }
    }

    public static void main(String[] args) throws IOException {
        Debug.init(System.getProperties());
        int argc = args.length;
        if (argc == 1) {
            ShapeFile sf = new ShapeFile(args[0]);
            Debug.output("Shape file: " + args[0]);
            Debug.output("version: " + sf.getFileVersion());
            Debug.output("length: " + sf.getFileLength());
            Debug.output("bounds:");
            Debug.output("\tmin: " + sf.getBoundingBox().min);
            Debug.output("\tmax: " + sf.getBoundingBox().max);
            int nRecords = 0;
            ESRIRecord record = sf.getNextRecord();
            while (record != null) {
                if (record instanceof ESRIPointRecord) {
                    double lat = ((ESRIPointRecord)record).getY();
                    double lon = ((ESRIPointRecord)record).getX();
                    Debug.output("record: " + lat + ", " + lon);
                } else {
                    Debug.output("record: " + record.getClass().getName());
                }
                ++nRecords;
                record = sf.getNextRecord();
            }
            Debug.output("records: " + nRecords);
        } else if ("-a".equals(args[0])) {
            ESRIRecord r;
            String destFile = args[1];
            String srcFile = args[2];
            ShapeFile in = new ShapeFile(srcFile);
            ShapeFile out = new ShapeFile(destFile);
            if (in.getShapeType() != out.getShapeType()) {
                try {
                    out.setShapeType(in.getShapeType());
                }
                catch (IllegalArgumentException e) {
                    Debug.error("Incompatible shape types.");
                    System.exit(1);
                }
            }
            while ((r = in.getNextRecord()) != null) {
                out.add(r);
            }
            out.verify(true, true);
        } else if ("-v".equals(args[0])) {
            String shpFile = args[1];
            ShapeFile s = new ShapeFile(shpFile);
            s.verify(true, true);
        } else {
            Debug.output("Usage:");
            Debug.output("ShapeFile file.shp  -- displays information about file.shp");
            Debug.output("ShapeFile -a dest.shp src.shp  -- appends records from src.shp to dest.shp");
            Debug.output("ShapeFile -v file.shp  -- verifies file.shp");
        }
    }
}

