/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.gui;

import com.bbn.openmap.Environment;
import com.bbn.openmap.I18n;
import com.bbn.openmap.event.CenterListener;
import com.bbn.openmap.event.CenterSupport;
import com.bbn.openmap.proj.coords.LatLonPoint;
import com.bbn.openmap.util.Debug;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.io.Serializable;
import java.text.DecimalFormat;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;

public class CoordPanel
extends JPanel
implements Serializable {
    protected transient JTextField latitude;
    protected transient JTextField longitude;
    protected transient CenterSupport centerDelegate;
    protected I18n i18n = Environment.getI18n();
    protected DecimalFormat df = new DecimalFormat("0.###");

    public CoordPanel() {
        this.centerDelegate = new CenterSupport(this);
        this.makeWidgets();
    }

    public CoordPanel(CenterSupport support) {
        this.centerDelegate = support;
        this.makeWidgets();
    }

    protected void makeWidgets() {
        GridBagLayout gridbag = new GridBagLayout();
        GridBagConstraints c = new GridBagConstraints();
        this.setLayout(gridbag);
        String locText = this.i18n.get(CoordPanel.class, "border", "Decimal Degrees");
        this.setBorder(new TitledBorder(new EtchedBorder(), locText));
        Insets leftInsets = new Insets(0, 10, 0, 10);
        Insets rightInsets = new Insets(0, 0, 0, 10);
        locText = this.i18n.get(CoordPanel.class, "latlabel", "Latitude: ");
        JLabel latlabel = new JLabel(locText);
        c.gridx = 0;
        c.gridy = 0;
        c.fill = 0;
        c.weightx = 0.0;
        c.insets = leftInsets;
        c.anchor = 13;
        gridbag.setConstraints(latlabel, c);
        this.add(latlabel);
        this.latitude = new JTextField(10);
        c.gridx = 1;
        c.gridy = 0;
        c.fill = 2;
        c.weightx = 1.0;
        c.insets = rightInsets;
        gridbag.setConstraints(this.latitude, c);
        this.add(this.latitude);
        locText = this.i18n.get(CoordPanel.class, "lonlabel", "Longitude: ");
        JLabel lonlabel = new JLabel(locText);
        c.gridx = 0;
        c.gridy = 1;
        c.fill = 0;
        c.weightx = 0.0;
        c.insets = leftInsets;
        gridbag.setConstraints(lonlabel, c);
        this.add(lonlabel);
        this.longitude = new JTextField(10);
        c.gridx = 1;
        c.gridy = 1;
        c.fill = 2;
        c.weightx = 1.0;
        c.insets = rightInsets;
        gridbag.setConstraints(this.longitude, c);
        this.add(this.longitude);
    }

    public LatLonPoint getLatLon() {
        double lon;
        double lat;
        try {
            lat = Double.valueOf(this.latitude.getText());
            lon = Double.valueOf(this.longitude.getText());
        }
        catch (NumberFormatException except) {
            Debug.error("CoordPanel.getLatLon(): " + except.toString());
            this.clearTextBoxes();
            return null;
        }
        if (Debug.debugging("coordpanel")) {
            Debug.output("CoordPanel.getLatLon(): lat= " + lat + ", lon= " + lon);
        }
        return new LatLonPoint.Double(lat, lon);
    }

    public void setLatLon(LatLonPoint llpoint) {
        if (llpoint == null) {
            this.clearTextBoxes();
        } else {
            this.latitude.setText("" + llpoint.getY());
            this.longitude.setText("" + llpoint.getX());
        }
    }

    public boolean setCenter() {
        LatLonPoint llp = this.getLatLon();
        if (llp == null) {
            return false;
        }
        if (Debug.debugging("coordpanel")) {
            Debug.output("CoordPanel.setCenter(): " + llp);
        }
        this.centerDelegate.fireCenter(llp.getY(), llp.getX());
        return true;
    }

    protected void clearTextBoxes() {
        this.latitude.setText("");
        this.longitude.setText("");
    }

    public void addCenterListener(CenterListener listener) {
        this.centerDelegate.add(listener);
    }

    public void removeCenterListener(CenterListener listener) {
        this.centerDelegate.remove(listener);
    }
}

